<?php 
/**
 * @param $university
 * @param $hideRecord
 * @param $idealType
 */
switch($university->suggest_type){
    case StudentIdealListCollege::SUGGEST_TYPE_ADVISOR: $iconClass = 'icon-uni'; $title = 'Univariety'; break;
    case StudentIdealListCollege::SUGGEST_TYPE_SPOC: $iconClass = 'icon-spoc'; $title = 'Spoc'; break;
    case StudentIdealListCollege::SUGGEST_TYPE_STUDENT: $iconClass = 'icon-student'; $title = 'Student'; break;
}

$studentIdealList = StudentIdealList::model()->findByPk($university->student_ideal_list_ref_id);
$confirmed = ($studentIdealList->status == StudentIdealList::STATUS_CONFIRMED);
?>
<li class="university" style="<?php echo ($hideRecord)?'display:none;':''; ?>" id="<?php echo $idealType; ?>-university-<?php echo $university->student_ideal_list_college_id; ?>">
<div class="milestone-content-holder ">
		<span class="<?php echo $iconClass; ?>" title="Added by <?php echo $title; ?>">&nbsp;</span>
		<!-- <span><?php //echo ++$i; ?>.</span> -->
		<span class="spacer350"><?php echo $university->university->uni_name; ?></span> 
		<span class="spacer100">
			<?php
			if($university->status == StudentIdealListCollege::STATUS_REVIEWED && !$confirmed):
    	    echo CHtml::ajaxLink('Accept', 
    	                      Yii::app()->createUrl('sms/milestone/acceptUniversity'),
    	                      array ( 
    	                          'type' => 'POST',
    	                          'data' => 'ajax=accept-university&list=' . $university->student_ideal_list_college_id,
    	                          'dataType' => 'json',
    	                          'success' => 'js: function(data){handleRowUpdation("' . $idealType . '", "#' . $idealType . '-university-' . $university->student_ideal_list_college_id . '", data, "replace")}',
    	                          'beforeSend' => 'js:  function(){ $("#ab-' . $university->student_ideal_list_college_id . ' ").next(".ajax-loader").show();}',
    	                          'complete' => 'js:  function(){ $("#ab-' . $university->student_ideal_list_college_id . ' ").next(".ajax-loader").hide();}',
    	                      ),
    	                      array(
    	                          'id' => 'ab-' . $university->student_ideal_list_college_id,
    	                          'live' => false,
    	                          'class' => 'accept-link',
    	                          'title' => 'Accept University'
    	                      )
    	    );
    	endif;
    	if($university->status == StudentIdealListCollege::STATUS_ACCEPTED):
    	?>
    	<span class="green-gradient-small-btn small-text" title="You accepted this university">Accepted</span>
    	<?php
    	endif;
    	if($university->status == StudentIdealListCollege::STATUS_PENDING):
    	?>
    	<span class="blue-gradient-small-btn small-text" title="Univariety is reviewing this university">WIP</span>
    	<?php
    	endif;
    	?>
    	<span class="pad_5 ajax-loader" style="float:none; display:none;">
	    	<img src="<?php echo Yii::app()->params['cbasepath']; ?>/images/9.gif" alt="loading" />
	    </span> &nbsp;
		</span>
		<span class="spacer100">
			<?php
    	if(($university->status == StudentIdealListCollege::STATUS_REVIEWED || $university->status == StudentIdealListCollege::STATUS_ACCEPTED) && !$confirmed):
    	    echo CHtml::ajaxLink('Reject', 
    	                      Yii::app()->createUrl('sms/milestone/rejectUniversity'),
    	                      array ( 
    	                          'type' => 'POST',
    	                          'data' => 'ajax=reject-university&list=' . $university->student_ideal_list_college_id,
    	                          'dataType' => 'json',
    	                          'success' => 'js: function(data){handleRowUpdation("' . $idealType . '", "#' . $idealType . '-university-' . $university->student_ideal_list_college_id . '", data, "remove")}',
    	                          
    	                          'beforeSend' => 'js:  function(){ $("#ar-' . $university->student_ideal_list_college_id . ' ").next(".ajax-loader").show();}',
    	                          'complete' => 'js:  function(){ $("#ar-' . $university->student_ideal_list_college_id . ' ").next(".ajax-loader").hide();}',
    	                      ),
    	                      array(
    	                          'id' => 'ar-' . $university->student_ideal_list_college_id,
    	                          'live' => false,
    	                          'class' => 'reject-link',
    	                          'title' => 'Reject',
    	                      )
    	                      
    	    );
    	    ?>
    	    <span class="pad_5 ajax-loader" style="float:none; display:none;">
    	    	<img src="<?php echo Yii::app()->params['cbasepath']; ?>/images/9.gif" alt="loading" />
    	    </span>
    	    <?php 
    	endif;
    ?>&nbsp;
		</span> 
		<span class="spacer100" style="position:relative;">
		<?php 
	    if($university->status == StudentIdealListCollege::STATUS_REVIEWED && !empty($university->comment)):
	        ?>
	        <a class="comments-link"  href="javascript: void(0);"> &nbsp;</a>
	        <span class="hover_content" style="display:none;" ><?php echo CHtml::encode($university->comment); ?></span>	
	        <?php
    	 endif;
    	?> 
		</span>
		<div class="clear"></div>
	</div>
</li>