<?php
/**
 * Model class for StudentIdealListCollgeLog
 *
 *
 * @author Shiva <shiva.dharana@univariety.com>
 * @version 1.0
 * @package sms.models
 *
 */
Yii::import('application.modules.sms.models.base.BaseStudentIdealListCollegeLog');

class StudentIdealListCollegeLog extends BaseStudentIdealListCollegeLog
{
    public static function model($className=__CLASS__){
        return parent::model($className);
    }
    
    public function rules(){
        return array();
    }
    
    protected function beforeSave(){
        if(parent::beforeSave()){
            $this->added_on = date('Y-m-d H:i:s');
            return true;
        }
        return false;
    }
    
    public function addAuditLog(StudentIdealListCollege $studentIdealListCollege, $deleted = false){
        
        //$old = StudentIdealListCollege::model()->findByPk($studentIdealListCollege->getPrimaryKey());
        //$this->student_ideal_list_ref_id = $studentIdealListCollege->student_ideal_list_ref_id;
        //$this->uni_ref_id = $studentIdealListCollege->uni_ref_id;
        $attributes = $studentIdealListCollege->getAttributes(array(
            'student_ideal_list_ref_id',
            'uni_ref_id',
            'suggest_type',
            'suggested_by',
            'comment',
            'comment_by',
            'status'
        ));
        $attributes['status'] = $deleted ? 'Delete' : $attributes['status'];
        $this->setAttributes($attributes, false);
        
        return $this->save();
    }
}