<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUser is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user".
 *
 * The followings are the available columns in table 'di_user':
 * @property integer $di_user_id
 * @property string $login_ref_id
 * @property integer $di_ref_id
 * @property string $user_type
 * @property string $first_name
 * @property string $last_name
 * @property string $office_number
 * @property string $mobile_number
 * @property integer $is_login_email_sent
 * @property integer $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property DiInvoiceTransaction[] $diInvoiceTransactions
 * @property DiPurchaseProfile[] $diPurchaseProfiles
 * @property LoginMaster $addedBy
 * @property Di $diRef
 * @property LoginMaster $loginRef
 * @property LoginMaster $modifiedBy
 * @property DiUserCounsellorShortlist[] $diUserCounsellorShortlists
 * @property DiUserCounsellorSuggested[] $diUserCounsellorSuggesteds
 * @property DiUserCriteria[] $diUserCriterias
 * @property DiUserCriteriaAlertDate[] $diUserCriteriaAlertDates
 * @property DiUserCriteriaShortlist[] $diUserCriteriaShortlists
 * @property DiUserDepartment[] $diUserDepartments
 * @property DiUserEoi[] $diUserEois
 * @property DiUserEoiLog[] $diUserEoiLogs
 * @property DiUserHotlead[] $diUserHotleads
 * @property DiUserRefund[] $diUserRefunds
 */
class BaseDiUser extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUser the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
  public $email_frequency;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('login_ref_id, di_ref_id, user_type, is_active, added_on, added_by', 'required'),
			array('di_ref_id, is_login_email_sent, is_active', 'numerical', 'integerOnly'=>true),
			array('login_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('user_type', 'length', 'max'=>9),
			array('first_name, last_name', 'length', 'max'=>45),
			array('office_number, mobile_number', 'length', 'max'=>20),
			array('modified_on,timezone_ref_id', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_id, login_ref_id, di_ref_id, user_type, first_name, last_name, office_number, mobile_number, is_login_email_sent, is_active, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diInvoiceTransactions' => array(self::HAS_MANY, 'DiInvoiceTransaction', 'di_user_ref_id'),
			'diPurchaseProfiles' => array(self::HAS_MANY, 'DiPurchaseProfile', 'purchased_by'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'diUserCounsellorShortlists' => array(self::HAS_MANY, 'DiUserCounsellorShortlist', 'di_user_ref_id'),
			'diUserCounsellorSuggesteds' => array(self::HAS_MANY, 'DiUserCounsellorSuggested', 'di_user_ref_id'),
			'diUserCriterias' => array(self::HAS_MANY, 'DiUserCriteria', 'di_user_ref_id'),
			'diUserCriteriaAlertDates' => array(self::HAS_MANY, 'DiUserCriteriaAlertDate', 'di_user_ref_id'),
			'diUserCriteriaShortlists' => array(self::HAS_MANY, 'DiUserCriteriaShortlist', 'di_user_ref_id'),
			'diUserDepartments' => array(self::HAS_MANY, 'DiUserDepartment', 'di_user_ref_id'),
			'diUserEois' => array(self::HAS_MANY, 'DiUserEoi', 'di_user_ref_id'),
			'diUserEoiLogs' => array(self::HAS_MANY, 'DiUserEoiLog', 'di_user_ref_id'),
			'diUserHotleads' => array(self::HAS_MANY, 'DiUserHotlead', 'di_user_ref_id'),
			'diUserRefunds' => array(self::HAS_MANY, 'DiUserRefund', 'di_user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_id' => 'Di User',
			'login_ref_id' => 'Login Ref',
			'di_ref_id' => 'Di Ref',
			'user_type' => 'User Type',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'office_number' => 'Office Number',
			'mobile_number' => 'Mobile Number',
			'is_login_email_sent' => 'Is Login Email Sent',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'timezone_ref_id' => 'Choose Timezone',
			'signature' => 'Upload Signature',
			'email_frequency' => 'Email Frequency',
			'sms_subscribe' => 'SMS',
			'profile_picture' => 'Profile Picture',
			'designation' => 'Designation',
			'title' => 'title',
			'email_frequency_weekly' => 'Weekly',
			'email_frequency_daily' => 'Daily',
			'email_frequency' => 'Email Frequency',
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_id',$this->di_user_id);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('user_type',$this->user_type,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('office_number',$this->office_number,true);
		$criteria->compare('mobile_number',$this->mobile_number,true);
		$criteria->compare('is_login_email_sent',$this->is_login_email_sent);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}