<?php

class PreferencesController extends Controller {

    public function init() {
        parent::init();
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_signup";
    }

    public function actionIndex() {
        $this->setPageTitle(Yii::app()->name ." -  Select Country and Major Preferences");

        if (Yii::app()->session->itemAt('sUserUnivariety') == '') {
            $this->redirect('/app/student/createProfile');
        }
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
        $url_det = LookupUrl::model()->findByPK($user->redirect_url_ref_id);
        if ($url_det) {
            if ($url_det->url == '/app/dashboard') {
                $this->redirect($url_det->url);
            }
        }

        $model = new StudentData('preferences');

        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (!empty($_POST)) {
            $postData = $_POST['StudentData'];
            $criteria = new CDbCriteria;
            $criteria->condition = "user_ref_id = '".$userId."'";
            StudentPreferredCountry::model()->deleteAll($criteria);
            $already_added = array();

            for ($i = 1;$i < 3;$i++) {
                if(($postData['country_pref'.$i]!= "") && !in_array($postData['country_pref'.$i], $already_added)){
                    $obj = new StudentPreferredCountry();
                    $obj->{user_ref_id} = $userId;
                    $obj->{country_ref_id} = $postData['country_pref'.$i];
                    $obj->{preference_order} = $i;
                    $obj->save();
                    $already_added[] = $postData['country_pref'.$i];
                }
            }
            $criticalFields['country'] = 1;

            $criteria = new CDbCriteria;
            $criteria->condition = "user_ref_id = '".$userId."'";
            StudentPreferredDepartment::model()->deleteAll($criteria);

            $dept = $sub_dept = $others_dept = 0;
            for ($i = 1; $i< 3; $i++) {
                $course_id = null;
                $save = true;
                if($postData['dept_pref'.$i]!= ""){
                    if ($postData['other_sub_dept_pref'.$i] != "") {
                        $criteria = new CDbCriteria;
                        $criteria->select = 'course_id';
                        $criteria->condition = " course_name = '".$postData['other_sub_dept_pref'.$i]."' AND user_entered = '0' ";
                        $data = Courses::model()->find($criteria);
                        if ($data) {
                            $course_id = $data->course_id;
                        } else {
                            $obj = new Courses();
                            $obj->course_name = $postData['other_sub_dept_pref'.$i];
                            $obj->main_dept_ref_id = $postData['dept_pref'.$i];
                            $obj->sub_dept_ref_id = ($postData['sub_dept_pref'.$i] != 'others') ? $postData['sub_dept_pref'.$i] : '';
                            $obj->user_entered = '1';
                            $obj->added_on = date('Y-m-d H:i:s');
                            $obj->save(false);

                            $criteria->select = 'course_id';
                            $criteria->condition = " course_name = '".$postData['other_sub_dept_pref'.$i]."' AND user_entered = '1' ";
                            $data = Courses::model()->find($criteria);
                            $course_id = $data->course_id;
                        }
                    }

                    if (($i == 2) && (($dept == $postData['dept_pref2']) && ($sub_dept == $postData['sub_dept_pref2']) && ($others_dept == $postData['other_sub_dept_pref2']))) {
                        $save = false;
                    }
                    if ($save == true) {
                        $obj = new StudentPreferredDepartment();
                        $obj->{user_ref_id} = $userId;
                        $obj->{main_dept_ref_id} = $postData['dept_pref'.$i];
                        $obj->{sub_dept_ref_id} = ($postData['sub_dept_pref'.$i] != 'others') ? $postData['sub_dept_pref'.$i] : '';
                        $obj->{preference_order} = $i;
                        $obj->{course_ref_id} = $course_id;
                        $obj->save(false);

                    }

                    if ($i == 1) {
                        $dept = $postData['dept_pref1'];
                        $sub_dept = $postData['sub_dept_pref1'];
                        $others_dept = $postData['other_sub_dept_pref1'];
                    }
                }
            }
            $criticalFields['intended_subjects'] = 1;
            TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);

            $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_top_colleges',), 1);
            $user->redirect_url_ref_id =$urlDetails[0]['url_id'];
            $user->save(false);
            $this->redirect($urlDetails[0]['url']);
        }

        $dept_list = LookupDepartment::getMainDepartmentList();

        $countriesList = TblCountryMaster::getUnivarietyCountries();
        $countries = CHtml::listData($countriesList,'country_id', 'country_name');
        $allCountryList = TblCountryMaster::getCountryList();
        $uniqueCountryList = array_diff($allCountryList, $countries);
        $countries['Others'] = $uniqueCountryList;

        $prefCountires = $user->getPreferredCountries();
        $keys = array();
        foreach($prefCountires as $pref=>$value) {
            $keys[] = $pref;
        }
        $model->country_pref1 = $keys[0];$model->country_pref2 = $keys[1];

        $prefCourses = $user->getPreferredCourses();
        $keys = array();
        foreach($prefCourses as $prefCourse) {
            $keys[] = $prefCourse;
        }
        $model->dept_pref1 = $keys[0]['main_dept_ref_id'];$model->dept_pref2 = $keys[1]['main_dept_ref_id'];
        $model->sub_dept_pref1 = $keys[0]['sub_dept_ref_id'];$model->sub_dept_pref2 = $keys[1]['sub_dept_ref_id'];
        $model->other_sub_dept_pref1 = $keys[0]['course_ref_id'];$model->other_sub_dept_pref2 = $keys[1]['course_ref_id'];

        $this->render('index', array('user'=>$user, 'model'=>$model, 'dept_list'=>$dept_list, 'countries'=>$countries));
    }

    public function actionGetSubDeptList(){
        $deptId = Yii::app()->request->getQuery('deptId');
        $modelSubDept = LookupDepartment::getSubDepartmentsList($deptId, false);
        $subDeptList = CHtml::listData($modelSubDept,'department_id', 'department_name');
        echo json_encode($subDeptList);
    }

    public function actionSearch(){
        $res = array();
        if (isset($_GET['term'])) {
            $term = $_GET['term'];
            $criteria = new CDbCriteria;
            $criteria->select = '*';
            $criteria->condition = " course_name like '%$term%' AND user_entered = '0' ";
            $criteria->with = array('mainDeptRef'=>array('select'=>'mainDeptRef.department_name', 'joinType'=>'LEFT JOIN' ), 'subDeptRef'=>array('select'=>'subDeptRef.department_name', 'joinType'=>'LEFT JOIN'));
            $criteria->limit = 5;
            $data = Courses::model()->findAll($criteria);

            foreach ($data as $result) {
                $res[] = array(
                    'id'=>$result->course_id,
                    'value'=>$result->course_name,
                    'dept_id'=>$result->main_dept_ref_id,
                    'dept_name'=>$result->mainDeptRef->department_name,
                    'sub_dept_id'=>$result->sub_dept_ref_id,
                    'sub_dept_name'=>$result->subDeptRef->department_name,
                );
            }
        }
        echo CJSON::encode($res);
        Yii::app()->end();
    }

    public function actionEducation () {
        $this->setPageTitle(Yii::app()->name ." -  Provide Your Education Details");

        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
        $url_det = LookupUrl::model()->findByPK($user->redirect_url_ref_id);
        if ($url_det) {
            if ($url_det->url == '/app/dashboard') {
                $this->redirect($url_det->url);
            }
        }

        if (!empty($_POST)) {
            $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
            if ($_POST['marks'] == 'marks') {
                if ($edu_det->student_education_id) {
                    $criteria = new CDbCriteria;
                    $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
                    StudentGradeCount::model()->deleteAll($criteria);

                    $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);
                } else {
                    $edu_obj = new StudentEducation();
                    $edu_obj->user_ref_id = $userId;
                    $edu_obj->class_level = 12;
                    $edu_obj->added_on = date('Y-m-d H:i:s');
                }
                $edu_obj->board_ref_id = $_POST['board'];

                switch($_POST['overall_type']) {
                    case 'grades':
                        $edu_obj->overall_marks = NULL;
                        break;
                    case 'marks':
                        $edu_obj->overall_marks = $_POST['overall_marks'];
                        break;
                    case 'points':
                        $edu_obj->overall_marks = $_POST['overall_points'];
                        break;
                    case 'marks-gpa':
                        $edu_obj->overall_marks = $_POST['overall_marks'];
                        break;
                }
                $edu_obj->save(false);

                if ($_POST['overall_type'] == 'grades') {
                    $edu_det_new = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
                    if ($edu_det_new->student_education_id) {
                        if ($_POST['overall_aa']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 1;$grade_model->grade_count = $_POST['overall_aa'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                        if ($_POST['overall_a']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 2;$grade_model->grade_count = $_POST['overall_a'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($_POST['overall_b']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 3;$grade_model->grade_count = $_POST['overall_b'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($_POST['overall_c']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 4;$grade_model->grade_count = $_POST['overall_c'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($_POST['overall_d']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 5;$grade_model->grade_count = $_POST['overall_d'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                    }
                }
                $criticalFields['board'] = 1;
                $criticalFields['overall_marks'] = 1;
                TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
            }

            $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_ideal_list',), 1);
            $user->redirect_url_ref_id =$urlDetails[0]['url_id'];
            $user->save(false);
            $this->redirect($urlDetails[0]['url']);
        }

        $this->render('education', array());
    }

    public function actionGetOverallAndSubjects() {
        $classLevel = 12;
        $boardId = Yii::app()->request->getQuery('boardId');
        $boardDetails = LookupBoardEquivalent::GetBoardDetails($classLevel, $boardId);

        $overallMax = $boardDetails['overall_max'];
        $overallType = strtolower($boardDetails['overall_type']);


        $content = '<input type="hidden" id="overall_type" name="overall_type" value="'. $overallType.'" rel="'.$classLevel.'"><input type="hidden" id="overall_max" name="overall_max" value="'.$boardDetails['overall_max'].'" rel="'.$classLevel.'">';
        $exp = $classLevel == 12 ? '( Expected )' : '';
        switch ($boardDetails['overall_type']) {
            case 'Marks-GPA':
            {
                $overAll = CHtml::textField('overall_marks', '', array('id' => 'overall_marks', 'maxlength' => 3, 'placeholder' => 'Enter score (max 100)', 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="overall_marks_err" class="errorMessage popup"></div>';
                $html = '<div class="grid_3 left ">Expected Marks</div><div class="left grid_4 relative">'.$overAll.'</div>';
                break;
            }
            case 'Grades':
            {
                $gradeList = range(1, $overallMax);
                $gradeList = array_combine($gradeList, $gradeList);
                $gradeList[0] = 'Count';
                ksort($gradeList);

                $overAll = '<div style="width:130px;margin-right: 0px !important;" class="left grid_2 relative"><label> A* </label> '.CHtml::dropDownList('overall_aa', '', $gradeList, array( 'rel' => 'overall_aa', 'id' => 'overall_aa', 'class'=>'grid_1 gradesdrpdwn', "style"=>"width:95px;"));
                $overAll .= '<div style="display:none; ;" id="overall_aa_err" class="errorMessage popup"></div>'.'</div>';
                $overAll .= '<div style="width:130px;margin-right: 0px !important;" class="left grid_2 relative"><label> A </label> '.CHtml::dropDownList('overall_a', '', $gradeList, array( 'rel' => 'overall_a', 'id' => 'overall_a', 'class'=>'grid_1 gradesdrpdwn', "style"=>"width:95px;")).'</div>';
                $overAll .= '<div style="width:130px;margin-right: 0px !important;" class="left grid_2 relative"><label> B </label> '.CHtml::dropDownList('overall_b', '', $gradeList, array( 'rel' => 'overall_b', 'id' => 'overall_b', 'class'=>'grid_1 gradesdrpdwn', "style"=>"width:95px;")).'</div>';
                $overAll .= '<div style="width:130px;margin-right: 0px !important;" class="left grid_2 relative"><label> C </label> '.CHtml::dropDownList('overall_c', '', $gradeList, array( 'rel' => 'overall_c', 'id' => 'overall_c', 'class'=>'grid_1 gradesdrpdwn', "style"=>"width:95px;")).'</div>';
                $overAll .= '<div style="width:130px;margin-right: 0px !important;" class="left grid_2 relative"><label> D </label> '.CHtml::dropDownList('overall_d', '', $gradeList, array( 'rel' => 'overall_d', 'id' => 'overall_d', 'class'=>'grid_1 gradesdrpdwn', "style"=>"width:95px;")).'</div>';


                $html = '<div class="grid_3 left">Expected Marks</div><div style="margin: 0px !important;" class="left relative">'.$overAll.'</div>';
                break;
            }
            case 'Marks': {
                $overAll = CHtml::textField('overall_marks', '', array('id' => 'overall_marks', 'maxlength' => 3, 'placeholder' => 'Enter score (max 100)', 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="overall_marks_err" class="errorMessage popup"></div>';
                $html = '<div class="grid_3 left">Expected Marks</div><div class="left grid_4 relative">'.$overAll.'</div>';
                break;
            }
            case 'Points':
            {
                $pointsList = range(1, $overallMax);
                $pointsList = array_combine($pointsList, $pointsList);
                arsort($pointsList);

                $overAll = CHtml::dropDownList('overall_points', '', $pointsList, array('empty' => 'Points', 'id' => 'overall_points', 'class' => 'grid_4'));;
                $overAll .= '<div style="display:none" id="overall_points_err" class="errorMessage popup"></div>';

                $html = '<div class="grid_3 left">Expected Marks</div><div class="left grid_4 relative">'.$overAll.'</div>';
                break;
            }
        }
        echo $content.$html;

    }

    public function actionCloseColdUserFlow() {
        if ($_GET['term']) {
            $term = $_GET['term'];
            $_SESSION[$term] = 2;
        }
    }

    public function actionAlerts() {
        $this->setPageTitle(Yii::app()->name ." -  Alert Preferences");

        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
        $url_det = LookupUrl::model()->findByPK($user->redirect_url_ref_id);
        if ($url_det) {
            if ($url_det->url == '/app/dashboard') {
                $this->redirect($url_det->url);
            }
        }

        $model = new StudentData('alerts');
        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
        $saved = 0;
        $send_mail = 0;
        if ($_POST) {
            $saved = 1;
            $contactDetails = array(
                'contact_type_ref_id' => 1,
                'country_code' => $_POST['StudentData']['country_code'],
                'number' => $_POST['StudentData']['phone_number'],
                'user_ref_id' => $user->user_id,
                'is_primary' => 1,
                'added_on' => date('Y-m-d H:i:s'),
                'added_by' => $user->login_ref_id,
                'phone_type' => 'Mobile',
            );
            $studentContactModel = StudentContactNumber::model()->find(array("condition" => "user_ref_id = $user->user_id AND contact_type_ref_id = 1 AND is_primary = 1"));
            if(!$studentContactModel){
                $studentContactModel = new StudentContactNumber();
                $studentContactModel->setAttributes($contactDetails);
                $studentContactModel->added_on = date('Y-m-d H:i:s');
                $studentContactModel->save(false);
            }else{
                $studentContactModel->setAttributes($contactDetails);
                $studentContactModel->added_on = date('Y-m-d H:i:s');
                $studentContactModel->save();
            }
            $criticalFields['phone'] = 1;
            TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);

            if ($_POST['StudentData']['mark_primary'] == '1') {
                if ($_POST['StudentData']['username'] != $user->loginRef->username) {
                    $login_master = LoginMaster::model()->findByPk($user->login_ref_id);
                    $login_master->username = $_POST['StudentData']['username'];
                    $login_master->save(false);

                    $send_mail = 1;
                    //$this->sendConfirmationEmail($user->first_name, $_POST['StudentData']['username']);
                    setFlashMessage('success_notify', 'globalnotifications.profile_email_changed');
                }
            }

            //$urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'corePHP', 'label' => 'dashboard',), 1);
            //$user->redirect_url_ref_id =$urlDetails[0]['url_id'];
            //$user->save(false);
            //$this->redirect($urlDetails[0]['url']);
        }

        $shortListCountByCountry = $top_colleges = array();
        $objShortList = new ShortListEngine();
        $shortListCountByCountry = $objShortList->getShortListCountByCountry();
        if (!count($shortListCountByCountry)) {
            $selected_country = $selected_dept = '';
            $prefCountries = $user->getPreferredCountries();
            $prefCourses = $user->getPreferredCourses();
            foreach($prefCountries as $id=>$country) {
                $country = $id;
                foreach($prefCourses as $id=>$dept) {
                    $depts = $dept['main_dept_ref_id'];

                    $topColleges = DiHelper::getTopCollege(0, 10, $depts, $country);
                    if (count($topColleges) > 0) {
                        $selected_dept = $depts;
                        break;
                    }
                }
            }
        }

        $countryData = Yii::app()->db->createCommand()
            ->from('tbl_country_master as tcm')
            ->select('phone_code, country_name')
            ->where('is_active= "Y" AND country_code <> "" ')
            ->order('country_code ASC')
            ->queryAll();
        $country_list = array();
        foreach ($countryData as $country) {
            $phone_code = $country['phone_code'];
            $country_list[$phone_code] = $country['country_name']." (+$phone_code)";
        }
        $model->username = $user->loginRef->username;
        $studentContactModel = StudentContactNumber::model()->find(array("condition" => "user_ref_id = $user->user_id AND contact_type_ref_id = 1 AND is_primary = 1"));

        $this->render('alerts', array('user'=>$user, 'model'=>$model, 'country_list'=>$country_list, 'shortListCountByCountry' => $shortListCountByCountry, 'topColleges'=>$topColleges, 'selected_country'=>$selected_country, 'selected_dept'=>$selected_dept, 'studentContactModel'=>$studentContactModel, 'send_mail'=>$send_mail,'countryId'=>$country));
    }

    public function actionSendEmail() {
        $this->sendConfirmationEmail($_GET['name'], $_GET['email']);
    }

    public function sendConfirmationEmail($firstName = false, $email = false) {
        $s = empty($_SERVER['HTTPS']) ? '' : ($_SERVER['HTTPS'] == 'on') ? 's' : '';
        $protocol = strtolower($_SERVER['SERVER_PROTOCOL']);
        $protocol =  substr($protocol, 0, strpos($protocol, '/')). $s;
        $port = ($_SERVER['SERVER_PORT'] == '80') ? '' : (':'.$_SERVER['SERVER_PORT']);
        $siteURL = $protocol . '://' . $_SERVER['SERVER_NAME'];

        $msg = $this->renderPartial('confirmationTemplateMail', array('firstName' => $firstName, 'email' => $email, 'siteURL' => $siteURL), true);

        $params = array();
        $params['EmailMessage']['subject'] = 'Registration Confirmation';
        $params['EmailMessage']['body'] = $msg;
        $params['EmailMessage']['type'] = 'Signup';
        $params['EmailMessage']['siteUrl'] = '';
        $params['EmailMessage']['cc'] = '';
        $params['EmailMessage']['toName'] = $firstName;
        $params['EmailMessage']['toEmail'] = $email;
        $params['EmailMessage']['apiKey'] = Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', $url);

        $status = Yii::app()->runController("sms/email/addMessage");
    }

    public function getBestAdmissionChance($cId, $uniId, $onlyHighChance = 1) {
        $userId = Yii::app()->user->sub_id;
        $preferredDeptListData = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($userId);

        if(!$preferredDeptListData) {
            return "<h3>No major chosen</h3><span>Best admission chances</span>";
        }

        Yii::import('application.components.admissionchances.drivers.*');

        $obj = new TestDriver();
        $obj->studentID = $userId;
        $obj->countryID = $cId;
        $obj->universityID = $uniId;
        foreach($preferredDeptListData as $data){
            $obj->departmentID = $data->main_dept_ref_id;
            if($onlyHighChance) {
                $result[$data->main_dept_ref_id] = json_decode($obj->getAdmissionChances())->score;
            } else {
                $result[] = array(
                    'score' => json_decode($obj->getAdmissionChances())->score,
                    'dept_name' => $data->mainDeptRef->department_name,
                    'dept_id' => $data->main_dept_ref_id
                );
            }

        }
        $highestScore = max($result);
        $score = UniversityHelper::displayAdmissionChance($highestScore);
        return str_replace(array('</strong>', '<span>', '</span>'), array('</strong></br>', '<small class="color-gray">', ' Chances</small>'), $score);
    }

    public function actionNextDashboard() {
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);

        $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'corePHP', 'label' => 'dashboard',), 1);
        $user->redirect_url_ref_id =$urlDetails[0]['url_id'];
        $user->save();
        $this->redirect($urlDetails[0]['url']);
    }

    public function actionCitizenship() {
        $this->setPageTitle(Yii::app()->name ." - Select Country and Major Preferences");

        if (Yii::app()->session->itemAt('sUserUnivariety') == '') {
            $this->redirect('/app/student/createProfile');
        }
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
        $url_det = LookupUrl::model()->findByPK($user->redirect_url_ref_id);
        if ($url_det) {
            if ($url_det->url == '/app/dashboard') {
                $this->redirect($url_det->url);
            }
        }

        $model = new StudentData('citizenship');

        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (!empty($_POST)) {
            $postData = $_POST['StudentData'];

            $studentCitizenshipObj = new StudentCitizenship();
            $studentCitizenshipObj->deleteStudentCitizenshipUserId($userId);

            if ($postData['citizenship1']) {
                $studentCitizenshipObj->insertCitizenshipByUserId($userId, $postData['citizenship1']);
            }

            if ($postData['citizenship2']) {
                $studentCitizenshipObj->insertCitizenshipByUserId($userId, $postData['citizenship2']);
            }
            if (($postData['citizenship2']) || ($postData['citizenship1'])) {
                $criticalFields['citizenship'] = 1;
            }

            $criteria = new CDbCriteria;
            $criteria->condition = "user_ref_id = '".$userId."'";
            StudentPreferredCountry::model()->deleteAll($criteria);

            for ($i = 1;$i < 3;$i++) {
                if($postData['country_pref'.$i]!= ""){
                    $obj = new StudentPreferredCountry();
                    $obj->{user_ref_id} = $userId;
                    $obj->{country_ref_id} = $postData['country_pref'.$i];
                    $obj->{preference_order} = $i;
                    $obj->save();
                }
            }
            $criticalFields['country'] = 1;

            $criteria = new CDbCriteria;
            $criteria->condition = "user_ref_id = '".$userId."'";
            StudentPreferredDepartment::model()->deleteAll($criteria);

            $dept = $sub_dept = $others_dept = 0;
            for ($i = 1; $i< 3; $i++) {
                $course_id = null;
                $save = true;
                if($postData['dept_pref'.$i]!= ""){
                    if ($postData['other_sub_dept_pref'.$i] != "") {
                        $criteria = new CDbCriteria;
                        $criteria->select = 'course_id';
                        $criteria->condition = " course_name = '".$postData['other_sub_dept_pref'.$i]."' AND user_entered = '0' ";
                        $data = Courses::model()->find($criteria);
                        if ($data) {
                            $course_id = $data->course_id;
                        } else {
                            $obj = new Courses();
                            $obj->course_name = $postData['other_sub_dept_pref'.$i];
                            $obj->main_dept_ref_id = $postData['dept_pref'.$i];
                            $obj->sub_dept_ref_id = ($postData['sub_dept_pref'.$i] != 'others') ? $postData['sub_dept_pref'.$i] : '';
                            $obj->user_entered = '1';
                            $obj->added_on = date('Y-m-d H:i:s');
                            $obj->save(false);

                            $criteria->select = 'course_id';
                            $criteria->condition = " course_name = '".$postData['other_sub_dept_pref'.$i]."' AND user_entered = '1' ";
                            $data = Courses::model()->find($criteria);
                            $course_id = $data->course_id;
                        }
                    }

                    if (($i == 2) && (($dept == $postData['dept_pref2']) && ($sub_dept == $postData['sub_dept_pref2']) && ($others_dept == $postData['other_sub_dept_pref2']))) {
                        $save = false;
                    }
                    if ($save == true) {
                        $obj = new StudentPreferredDepartment();
                        $obj->{user_ref_id} = $userId;
                        $obj->{main_dept_ref_id} = $postData['dept_pref'.$i];
                        $obj->{sub_dept_ref_id} = ($postData['sub_dept_pref'.$i] != 'others') ? $postData['sub_dept_pref'.$i] : '';
                        $obj->{preference_order} = $i;
                        $obj->{course_ref_id} = $course_id;
                        $obj->save(false);

                    }

                    if ($i == 1) {
                        $dept = $postData['dept_pref1'];
                        $sub_dept = $postData['sub_dept_pref1'];
                        $others_dept = $postData['other_sub_dept_pref1'];
                    }
                }
            }
            $criticalFields['intended_subjects'] = 1;
            TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);

            $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_scholarships',), 1);
            $user->redirect_url_ref_id =$urlDetails[0]['url_id'];
            $user->save(false);
            $this->redirect($urlDetails[0]['url']);
        }

        $dept_list = LookupDepartment::getMainDepartmentList();

        $countriesList = TblCountryMaster::getUnivarietyCountries();
        $countries = CHtml::listData($countriesList,'country_id', 'country_name');
        $allCountryList = TblCountryMaster::getCountryList();
        $uniqueCountryList = array_diff($allCountryList, $countries);
        $countries['Others'] = $uniqueCountryList;

        $prefCountires = $user->getPreferredCountries();
        $keys = array();
        foreach($prefCountires as $pref=>$value) {
            $keys[] = $pref;
        }
        $model->country_pref1 = $keys[0];$model->country_pref2 = $keys[1];

        $prefCourses = $user->getPreferredCourses();
        $keys = array();
        foreach($prefCourses as $prefCourse) {
            $keys[] = $prefCourse;
        }
        $model->dept_pref1 = $keys[0]['main_dept_ref_id'];$model->dept_pref2 = $keys[1]['main_dept_ref_id'];
        $model->sub_dept_pref1 = $keys[0]['sub_dept_ref_id'];$model->sub_dept_pref2 = $keys[1]['sub_dept_ref_id'];
        $model->other_sub_dept_pref1 = $keys[0]['course_ref_id'];$model->other_sub_dept_pref2 = $keys[1]['course_ref_id'];

        //$citizenshipList = CHtml::listData(TblCountryMaster::getActiveCountriesList(), 'country_id', 'country_name');
        $studentCitizenship = StudentCitizenship::getStudentCitizenship($userId);
        $citizenshipList = ScholarshipDestinationCountry::getScholarshipSourceCountryList();
        $counter = 1;
        foreach ($studentCitizenship as $data) {
            $model->{citizenship . $counter} = $data->citizenship_ref_id;
            $counter++;
        }

        $this->render('citizenship', array('user'=>$user, 'model'=>$model, 'dept_list'=>$dept_list, 'countries'=>$countries, 'citizenshipList'=>$citizenshipList));
    }

}