<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniVisitPostSchoolEmail is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_visit_post_school_email".
 *
 * The followings are the available columns in table 'uni_visit_post_school_email':
 * @property string $post_email_id
 * @property string $uni_visit_schedule_school_ref_id
 * @property integer $school_visit_product_ref_id
 * @property string $email_subject
 * @property string $email_message
 * @property string $email_logo_image
 * @property string $email_banner_image
 * @property string $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property UniVisitPostSchoolAttachments[] $uniVisitPostSchoolAttachments
 * @property DiSchoolVisitProduct $schoolVisitProductRef
 * @property LoginMaster $addedBy
 * @property UniVisitScheduleSchool $uniVisitScheduleSchoolRef
 * @property UniVisitPostStudentsInvited[] $uniVisitPostStudentsInviteds
 */
class BaseUniVisitPostSchoolEmail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniVisitPostSchoolEmail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_visit_post_school_email';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_visit_schedule_school_ref_id, school_visit_product_ref_id, email_subject, email_message, added_by, added_on', 'required'),
			array('school_visit_product_ref_id, modified_by', 'numerical', 'integerOnly'=>true),
			array('uni_visit_schedule_school_ref_id, added_by', 'length', 'max'=>10),
			array('email_subject, email_logo_image, email_banner_image', 'length', 'max'=>255),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('post_email_id, uni_visit_schedule_school_ref_id, school_visit_product_ref_id, email_subject, email_message, email_logo_image, email_banner_image, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniVisitPostSchoolAttachments' => array(self::HAS_MANY, 'UniVisitPostSchoolAttachments', 'uni_visit_post_email_ref_id'),
			'schoolVisitProductRef' => array(self::BELONGS_TO, 'DiSchoolVisitProduct', 'school_visit_product_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'uniVisitScheduleSchoolRef' => array(self::BELONGS_TO, 'UniVisitScheduleSchool', 'uni_visit_schedule_school_ref_id'),
			'uniVisitPostStudentsInviteds' => array(self::HAS_MANY, 'UniVisitPostStudentsInvited', 'uni_visit_post_email_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'post_email_id' => 'Post Email',
			'uni_visit_schedule_school_ref_id' => 'Uni Visit Schedule School Ref',
			'school_visit_product_ref_id' => 'School Visit Product Ref',
			'email_subject' => 'Email Subject',
			'email_message' => 'Email Message',
			'email_logo_image' => 'Email Logo Image',
			'email_banner_image' => 'Email Banner Image',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('post_email_id',$this->post_email_id,true);
		$criteria->compare('uni_visit_schedule_school_ref_id',$this->uni_visit_schedule_school_ref_id,true);
		$criteria->compare('school_visit_product_ref_id',$this->school_visit_product_ref_id);
		$criteria->compare('email_subject',$this->email_subject,true);
		$criteria->compare('email_message',$this->email_message,true);
		$criteria->compare('email_logo_image',$this->email_logo_image,true);
		$criteria->compare('email_banner_image',$this->email_banner_image,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}