<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.schoolVisit.base.BaseUniVisitPostStudentsInvited');

class UniVisitPostStudentsInvited extends BaseUniVisitPostStudentsInvited
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

    public function processInterestedStudent($studentID = 0, $schoolVisitProductID = 0, $schoolID = 0){

        Yii::import('application.modules.di.components.*');
        $diAcc = new DiAccount;
        $DiProductForSV = $diAcc->getActiveSchoolVisitProduct($schoolVisitProductID);
        if(!$DiProductForSV) return;

        $diID = $DiProductForSV->di_ref_id;
        $MaxFreeBuy = $DiProductForSV->free_profile_count;

        $loginModel = LoginMaster::model()->with(array('tblUserMasters' => array('select' => 'user_id')) )->find("t.is_email_confirmed='1' AND t.is_class_status_confirmed='1'AND t.is_preference_confirmed='1' AND tblUserMasters.user_id='".$studentID."'");
        // student is a valid profile user
        if(!$loginModel) return;

            $freelyBought= $diAcc->getFreelyBoughtProfilesCount($DiProductForSV->di_school_visit_id, $schoolID);
            // Free profiles count exceeded for school
            if($freelyBought >= $MaxFreeBuy) return;

            // check if profile is already bought
            if(DiStudentSelection::model()->findByAttributes(array('di_ref_id' => $diID,
                'user_ref_id' => $studentID, 'status' => 'Bought'))) return false;

            $origin = 'SchoolVisit';
            $status = 'Bought';
            $diUser = DiUser::model()->findByAttributes(array('di_ref_id' => $diID));

            if (($model = DiStudentSelection::model()->findByAttributes(array(
                'di_ref_id' => $diID, 'user_ref_id' => $studentID))) != null) {

                $model->setAttributes(array(
                    'status'   => $status,
                    'origin'   => $origin,
                    'added_by' => $diUser->di_user_id,
                    'added_on' => date('Y-m-d H:i:s'),
                ), false);
            } else {

                $model = new DiStudentSelection;
                $model->setAttributes(array(
                    'di_ref_id'   => $diID,
                    'user_ref_id' => $studentID,
                    'status'      => $status,
                    'origin'      => $origin,
                    'added_by'    => $diUser->di_user_id,
                    'added_on'    => date('Y-m-d H:i:s'),
                ), false);
            }
            $model->save(false);

            $dssID = $model->di_student_selection_id;
            $svbsModel = new DiSchoolVisitBoughtStudent;
            $svbsModel->setAttributes(array(
                'di_school_visit_product_ref_id' => $DiProductForSV->di_school_visit_id,
                'school_ref_id' => $schoolID,
                'bought_type' => 'free',
                'di_student_selection_ref_id' => $dssID,
            ), false);
            $svbsModel->save(false);

            $model = new DiCashDebit;
            $model->setAttributes(array(
                'di_ref_id' => $diID,
                'user_ref_id' => $studentID,
                'school_visit_product_ref_id' => $DiProductForSV->di_school_visit_id,
                'quantity' => 1,
                'subtotal' => '0.00',
                'added_by' => $loginModel->login_id,
                'added_on' => date('Y-m-d H:i:s'),
            ), false);
            $model->save(false);

    }

    static public function ReadyToBeBoughtProfilesCount($scheduleSchoolID = 0){

        $cdbCriteria = new CDbCriteria;
        $cdbCriteria->join = " INNER JOIN uni_visit_post_school_email uvpse ON uvpse.post_email_id = t.uni_visit_post_email_ref_id";
        $cdbCriteria->join .= " INNER JOIN tbl_user_master tum ON tum.user_id = t.student_ref_id";
        $cdbCriteria->join .= " INNER JOIN login_master lm ON lm.login_id = tum.login_ref_id";
        $cdbCriteria->addCondition("uvpse.uni_visit_schedule_school_ref_id='".$scheduleSchoolID."' AND t.response='Interested'", "AND");
        $cdbCriteria->addCondition("lm.is_email_confirmed='1' AND lm.is_class_status_confirmed='1'AND lm.is_preference_confirmed='1'", "AND");
        $cdbCriteria->addCondition("NOT EXISTS
        (SELECT 1 FROM di_student_selection dss WHERE
            dss.di_ref_id = '".Yii::app()->user->di_id."' AND dss.user_ref_id = t.student_ref_id AND dss.status = 'Bought'
        )");
        return UniVisitPostStudentsInvited::model()->count($cdbCriteria);
    }
}