<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWorkshopSiGroupStudent is autogenerate by UniModel generator
 *
 * This is the model class for table "workshop_si_group_student".
 *
 * The followings are the available columns in table 'workshop_si_group_student':
 * @property string $workshop_si_group_student_id
 * @property string $workshop_si_group_ref_id
 * @property string $user_ref_id
 * @property integer $is_student_attended
 * @property integer $is_parent_attended
 * @property integer $is_invitation_sent
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property WorkshopSiGroup $workshopSiGroupRef
 * @property WorkshopSiGroupStudentFeedback[] $workshopSiGroupStudentFeedbacks
 */
class BaseWorkshopSiGroupStudent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WorkshopSiGroupStudent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'workshop_si_group_student';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('workshop_si_group_ref_id, user_ref_id, added_on', 'required'),
			array('is_student_attended, is_parent_attended, is_invitation_sent', 'numerical', 'integerOnly'=>true),
			array('workshop_si_group_ref_id, user_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('workshop_si_group_student_id, workshop_si_group_ref_id, user_ref_id, is_student_attended, is_parent_attended, is_invitation_sent, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'workshopSiGroupRef' => array(self::BELONGS_TO, 'WorkshopSiGroup', 'workshop_si_group_ref_id'),
			'workshopSiGroupStudentFeedbacks' => array(self::HAS_MANY, 'WorkshopSiGroupStudentFeedback', 'workshop_si_group_student_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'workshop_si_group_student_id' => 'Workshop Si Group Student',
			'workshop_si_group_ref_id' => 'Workshop Si Group Ref',
			'user_ref_id' => 'User Ref',
			'is_student_attended' => 'Is Student Attended',
			'is_parent_attended' => 'Is Parent Attended',
			'is_invitation_sent' => 'Is Invitation Sent',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('workshop_si_group_student_id',$this->workshop_si_group_student_id,true);
		$criteria->compare('workshop_si_group_ref_id',$this->workshop_si_group_ref_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('is_student_attended',$this->is_student_attended);
		$criteria->compare('is_parent_attended',$this->is_parent_attended);
		$criteria->compare('is_invitation_sent',$this->is_invitation_sent);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}