<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreGallery is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_gallery".
 *
 * The followings are the available columns in table 'vendor_centre_gallery':
 * @property integer $vendor_centre_gallery_id
 * @property string $vendor_centre_ref_id
 * @property string $title
 * @property string $media_type
 * @property string $media_path
 * @property string $is_active
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property VendorCentre $vendorCentreRef
 */
class BaseVendorCentreGallery extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreGallery the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_gallery';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('vendor_centre_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('title', 'length', 'max'=>255),
			array('media_type', 'length', 'max'=>5),
			array('is_active', 'length', 'max'=>1),
			array('media_path, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_gallery_id, vendor_centre_ref_id, title, media_type, media_path, is_active, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_gallery_id' => 'Vendor Centre Gallery',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'title' => 'Title',
			'media_type' => 'Media Type',
			'media_path' => 'Media Path',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_gallery_id',$this->vendor_centre_gallery_id);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('media_type',$this->media_type,true);
		$criteria->compare('media_path',$this->media_path,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}