<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCenter is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_center".
 *
 * The followings are the available columns in table 'vendor_center':
 * @property integer $vendor_center_id
 * @property integer $vendor_ref_id
 * @property string $center_type
 * @property integer $established_year
 * @property string $address1
 * @property string $address2
 * @property integer $country_ref_id
 * @property integer $state_ref_id
 * @property integer $city_ref_id
 * @property integer $locality_ref_id
 * @property string $zipcode
 * @property string $longitude
 * @property string $latitude
 * @property integer $is_hostel_facility
 * @property integer $is_transport_facility
 * @property integer $is_active
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property Vendor $vendorRef
 * @property TblCountryMaster $countryRef
 * @property TblState $stateRef
 * @property TblCityMaster $cityRef
 * @property LookupLocality $localityRef
 * @property VendorCenterContact[] $vendorCenterContacts
 * @property VendorCenterEmail[] $vendorCenterEmails
 * @property VendorCenterVendorCourse[] $vendorCenterVendorCourses
 */
class BaseVendorCenter extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCenter the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_center';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_ref_id, added_by, added_on', 'required'),
			array('vendor_ref_id, established_year, country_ref_id, state_ref_id, city_ref_id, locality_ref_id, is_hostel_facility, is_transport_facility, is_active', 'numerical', 'integerOnly'=>true),
			array('center_type, added_by, modified_by', 'length', 'max'=>10),
			array('address1, address2', 'length', 'max'=>255),
			array('zipcode, longitude, latitude', 'length', 'max'=>20),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_center_id, vendor_ref_id, center_type, established_year, address1, address2, country_ref_id, state_ref_id, city_ref_id, locality_ref_id, zipcode, longitude, latitude, is_hostel_facility, is_transport_facility, is_active, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'vendorRef' => array(self::BELONGS_TO, 'Vendor', 'vendor_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'stateRef' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'localityRef' => array(self::BELONGS_TO, 'LookupLocality', 'locality_ref_id'),
			'vendorCenterContacts' => array(self::HAS_MANY, 'VendorCenterContact', 'vendor_center_ref_id'),
			'vendorCenterEmails' => array(self::HAS_MANY, 'VendorCenterEmail', 'vendor_center_ref_id'),
			'vendorCenterVendorCourses' => array(self::HAS_MANY, 'VendorCenterVendorCourse', 'vendor_center_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_center_id' => 'Vendor Center',
			'vendor_ref_id' => 'Vendor Ref',
			'center_type' => 'Center Type',
			'established_year' => 'Established Year',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'country_ref_id' => 'Country Ref',
			'state_ref_id' => 'State Ref',
			'city_ref_id' => 'City Ref',
			'locality_ref_id' => 'Locality Ref',
			'zipcode' => 'Zipcode',
			'longitude' => 'Longitude',
			'latitude' => 'Latitude',
			'is_hostel_facility' => 'Is Hostel Facility',
			'is_transport_facility' => 'Is Transport Facility',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_center_id',$this->vendor_center_id);
		$criteria->compare('vendor_ref_id',$this->vendor_ref_id);
		$criteria->compare('center_type',$this->center_type,true);
		$criteria->compare('established_year',$this->established_year);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('locality_ref_id',$this->locality_ref_id);
		$criteria->compare('zipcode',$this->zipcode,true);
		$criteria->compare('longitude',$this->longitude,true);
		$criteria->compare('latitude',$this->latitude,true);
		$criteria->compare('is_hostel_facility',$this->is_hostel_facility);
		$criteria->compare('is_transport_facility',$this->is_transport_facility);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}