<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorAttachment is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_attachment".
 *
 * The followings are the available columns in table 'vendor_attachment':
 * @property string $vendor_attachment_id
 * @property integer $vendor_ref_id
 * @property string $attachment_name
 *
 * The followings are the available model relations:
 * @property Vendor $vendorRef
 */
class BaseVendorAttachment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorAttachment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_attachment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_ref_id', 'numerical', 'integerOnly'=>true),
			array('attachment_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_attachment_id, vendor_ref_id, attachment_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorRef' => array(self::BELONGS_TO, 'Vendor', 'vendor_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_attachment_id' => 'Vendor Attachment',
			'vendor_ref_id' => 'Vendor Ref',
			'attachment_name' => 'Attachment Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_attachment_id',$this->vendor_attachment_id,true);
		$criteria->compare('vendor_ref_id',$this->vendor_ref_id);
		$criteria->compare('attachment_name',$this->attachment_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}