<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserUniversityAdmissionScore is autogenerate by UniModel generator
 *
 * This is the model class for table "user_university_admission_score".
 *
 * The followings are the available columns in table 'user_university_admission_score':
 * @property string $user_ref_id
 * @property integer $uni_ref_id
 * @property integer $dept_ref_id
 * @property double $admission_score
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property TblUniversityMaster $uniRef
 * @property LookupDepartment $deptRef
 */
class BaseUserUniversityAdmissionScore extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserUniversityAdmissionScore the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_university_admission_score';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, uni_ref_id, dept_ref_id, admission_score, added_on', 'required'),
			array('uni_ref_id, dept_ref_id', 'numerical', 'integerOnly'=>true),
			array('admission_score', 'numerical'),
			array('user_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_ref_id, uni_ref_id, dept_ref_id, admission_score, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'deptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'dept_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_ref_id' => 'User Ref',
			'uni_ref_id' => 'Uni Ref',
			'dept_ref_id' => 'Dept Ref',
			'admission_score' => 'Admission Score',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('dept_ref_id',$this->dept_ref_id);
		$criteria->compare('admission_score',$this->admission_score);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}