<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserUcas is autogenerate by UniModel generator
 *
 * This is the model class for table "user_ucas".
 *
 * The followings are the available columns in table 'user_ucas':
 * @property integer $user_ucas_id
 * @property string $user_ref_id
 * @property string $ucas_account_id
 * @property string $course
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseUserUcas extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserUcas the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_ucas';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('ucas_account_id', 'length', 'max'=>20),
			array('course', 'length', 'max'=>250),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_ucas_id, user_ref_id, ucas_account_id, course, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_ucas_id' => 'User Ucas',
			'user_ref_id' => 'User Ref',
			'ucas_account_id' => 'Ucas Account',
			'course' => 'Course',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_ucas_id',$this->user_ucas_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('ucas_account_id',$this->ucas_account_id,true);
		$criteria->compare('course',$this->course,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}