<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserInvite is autogenerate by UniModel generator
 *
 * This is the model class for table "user_invite".
 *
 * The followings are the available columns in table 'user_invite':
 * @property string $user_invite_id
 * @property string $user_ref_id
 * @property string $email_id
 * @property string $email_type
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseUserInvite extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserInvite the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_invite';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email_id, email_type, added_on', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('email_id', 'length', 'max'=>100),
			array('email_type', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_invite_id, user_ref_id, email_id, email_type, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_invite_id' => 'User Invite',
			'user_ref_id' => 'User Ref',
			'email_id' => 'Email',
			'email_type' => 'Email Type',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_invite_id',$this->user_invite_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('email_type',$this->email_type,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}