<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserAttachment is autogenerate by UniModel generator
 *
 * This is the model class for table "user_attachment".
 *
 * The followings are the available columns in table 'user_attachment':
 * @property string $attachment_id
 * @property string $user_ref_id
 * @property string $gem_lead_ref_id
 * @property string $title
 * @property string $filename
 * @property string $original_file_name
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property GemLead $gemLeadRef
 * @property TblUserMaster $userRef
 */
class BaseUserAttachment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserAttachment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_attachment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, filename', 'required'),
			array('user_ref_id, gem_lead_ref_id, added_by', 'length', 'max'=>10),
			array('title, filename, original_file_name', 'length', 'max'=>255),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('attachment_id, user_ref_id, gem_lead_ref_id, title, filename, original_file_name, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'gemLeadRef' => array(self::BELONGS_TO, 'GemLead', 'gem_lead_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'attachment_id' => 'Attachment',
			'user_ref_id' => 'User Ref',
			'gem_lead_ref_id' => 'Gem Lead Ref',
			'title' => 'Title',
			'filename' => 'Filename',
			'original_file_name' => 'Original File Name',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('attachment_id',$this->attachment_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('gem_lead_ref_id',$this->gem_lead_ref_id,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('filename',$this->filename,true);
		$criteria->compare('original_file_name',$this->original_file_name,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}