<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversitySocialMedia is autogenerate by UniModel generator
 *
 * This is the model class for table "university_social_media".
 *
 * The followings are the available columns in table 'university_social_media':
 * @property string $university_social_media_id
 * @property integer $uni_ref_id
 * @property integer $social_media_ref_id
 * @property string $media_link
 * @property string $handler_text
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property TblAdmin $modifiedBy
 * @property LookupSocialMedia $socialMediaRef
 * @property TblUniversityMaster $uniRef
 */
class BaseUniversitySocialMedia extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversitySocialMedia the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_social_media';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, social_media_ref_id, media_link, added_on', 'required'),
			array('uni_ref_id, social_media_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('handler_text', 'length', 'max'=>50),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_social_media_id, uni_ref_id, social_media_ref_id, media_link, handler_text, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'socialMediaRef' => array(self::BELONGS_TO, 'LookupSocialMedia', 'social_media_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_social_media_id' => 'University Social Media',
			'uni_ref_id' => 'Uni Ref',
			'social_media_ref_id' => 'Social Media Ref',
			'media_link' => 'Media Link',
			'handler_text' => 'Handler Text',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_social_media_id',$this->university_social_media_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('social_media_ref_id',$this->social_media_ref_id);
		$criteria->compare('media_link',$this->media_link,true);
		$criteria->compare('handler_text',$this->handler_text,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}