<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailLog is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_log".
 *
 * The followings are the available columns in table 'umail_log':
 * @property integer $umail_log_id
 * @property integer $header_ref_id
 * @property integer $message_ref_id
 * @property string $action_type
 * @property integer $current_advisor
 * @property integer $new_advisor
 * @property integer $added_by
 * @property string $added_on
 * @property integer $sender_type
 * @property integer $sender_id
 */
class BaseUmailLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('header_ref_id, action_type, current_advisor, new_advisor, sender_type, sender_id', 'required'),
			array('header_ref_id, message_ref_id, current_advisor, new_advisor, added_by, sender_type, sender_id', 'numerical', 'integerOnly'=>true),
			array('action_type', 'length', 'max'=>9),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('umail_log_id, header_ref_id, message_ref_id, action_type, current_advisor, new_advisor, added_by, added_on, sender_type, sender_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'umail_log_id' => 'Umail Log',
			'header_ref_id' => 'Header Ref',
			'message_ref_id' => 'Message Ref',
			'action_type' => 'Action Type',
			'current_advisor' => 'Current Advisor',
			'new_advisor' => 'New Advisor',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'sender_type' => 'Sender Type',
			'sender_id' => 'Sender',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('umail_log_id',$this->umail_log_id);
		$criteria->compare('header_ref_id',$this->header_ref_id);
		$criteria->compare('message_ref_id',$this->message_ref_id);
		$criteria->compare('action_type',$this->action_type,true);
		$criteria->compare('current_advisor',$this->current_advisor);
		$criteria->compare('new_advisor',$this->new_advisor);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('sender_type',$this->sender_type);
		$criteria->compare('sender_id',$this->sender_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}