<?php

/**
 * This is the model class for table "tbl_university_master".
 *
 * The followings are the available columns in table 'tbl_university_master':
 * @property integer $uni_id
 * @property string $uni_code
 * @property string $uni_name
 * @property string $url_primary_key
 * @property string $seo_keyword
 * @property integer $uni_country_rank
 * @property integer $uni_global_rank
 * @property integer $global_display_rank
 * @property double $uni_rank_factor
 * @property string $uni_slug_name
 * @property string $uni_logo
 * @property string $university_tier
 * @property string $uni_profile
 * @property string $coed
 * @property integer $university_affiliation_ref_id
 * @property string $type_of_institute
 * @property integer $institute_control_ref_id
 * @property string $address
 * @property string $address1
 * @property string $address2
 * @property integer $state_ref_id
 * @property integer $city_ref_id
 * @property string $zipcode
 * @property integer $country_ref_id
 * @property string $contact_email
 * @property string $location_type
 * @property string $website_url
 * @property string $admission_url
 * @property string $course_page_url
 * @property string $application_url
 * @property string $calender_system
 * @property integer $international_stud_total
 * @property integer $international_stud_total_men
 * @property integer $international_stud_total_women
 * @property double $international_stud_per
 * @property integer $total_students
 * @property double $full_time_per
 * @property double $part_time_per
 * @property double $male_per
 * @property double $female_per
 * @property string $flagship_subjects_courses
 * @property string $flagship_subjects_courses_url
 * @property string $admission_cycle_cnt
 * @property string $acceptance_rate
 * @property integer $total_applicants
 * @property integer $total_enrolled_people
 * @property string $enrolment_ratio
 * @property string $job_placement_per_pg
 * @property string $test_needed
 * @property string $likelihood_scholarship
 * @property integer $living_cost_in_city
 * @property integer $living_cost_on_campus
 * @property integer $vintage
 * @property integer $no_of_campus
 * @property string $main_campus_size_in_acres
 * @property string $campus_look_n_feel
 * @property string $campus_link
 * @property string $on_site_residence
 * @property string $student_professor_ratio
 * @property string $longitude
 * @property string $latitude
 * @property string $media_reports
 * @property string $placement_article_link
 * @property string $low_sal_range
 * @property integer $low_sal_range_currency_ref_id
 * @property string $high_sal_range
 * @property integer $high_sal_range_currency_ref_id
 * @property string $avg_salary
 * @property integer $avg_salary_currency_ref_id
 * @property string $median_salary
 * @property integer $median_salary_currency_ref_id
 * @property string $high_domestic_salary
 * @property integer $high_domestic_salary_currency_ref_id
 * @property string $high_international_salary
 * @property integer $high_international_salary_currency_ref_id
 * @property string $admission_comments
 * @property string $is_twining
 * @property string $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 * @property integer $is_featured
 * @property string $is_international_serach
 * @property string $unique_feature
 * @property string $is_user_entered
 * @property string $uni_rating
 * @property string $uni_join
 * @property string $scholarship_link
 * @property string $campus_life
 * @property integer $total_faculties
 * @property integer $phd_faculties
 *
 * The followings are the available model relations:
 * @property Di[] $dis
 * @property DiOnboard[] $diOnboards
 * @property DiOnboardUniversityShortlist[] $diOnboardUniversityShortlists
 * @property EduFare[] $eduFares
 * @property EngagementEmailsUniversities[] $engagementEmailsUniversities
 * @property EntranceExamApplicableLocation[] $entranceExamApplicableLocations
 * @property EoiRequestCollege[] $eoiRequestColleges
 * @property ErrorReportUniversity[] $errorReportUniversities
 * @property EventEmail[] $eventEmails
 * @property MdmCourseLog[] $mdmCourseLogs
 * @property MdmNewCourseAffiliation[] $mdmNewCourseAffiliations
 * @property MdmNewCourseLog[] $mdmNewCourseLogs
 * @property MdmNewCourseTwining[] $mdmNewCourseTwinings
 * @property PmsAssignedAdvisers[] $pmsAssignedAdvisers
 * @property PmsUniversityBucket[] $pmsUniversityBuckets
 * @property PmsUniversityContact[] $pmsUniversityContacts
 * @property PopularCollege[] $popularColleges
 * @property RequestCallback[] $requestCallbacks
 * @property RequestContactDetail[] $requestContactDetails
 * @property ReviewCredit[] $reviewCredits
 * @property ScholarshipHostInstitute[] $scholarshipHostInstitutes
 * @property SeoUniversity[] $seoUniversities
 * @property StudentHotlead[] $studentHotleads
 * @property StudentOutplacementColleges[] $studentOutplacementColleges
 * @property StudentOutplacementUniversity[] $studentOutplacementUniversities
 * @property StudentShortlistUniversity[] $studentShortlistUniversities
 * @property TagUniversity[] $tagUniversities
 * @property TblUniCourses[] $tblUniCourses
 * @property TblUniExtension[] $tblUniExtensions
 * @property TblUniPicturesVideos[] $tblUniPicturesVideoses
 * @property TblUniWeather[] $tblUniWeathers
 * @property LoginMaster $addedBy
 * @property TblCityMaster $cityRef
 * @property TblCountryMaster $countryRef
 * @property LookupInstituteControl $instituteControlRef
 * @property LoginMaster $modifiedBy
 * @property TblState $stateRef
 * @property LookupUniversityAffiliation $universityAffiliationRef
 * @property UniCourseTest[] $uniCourseTests
 * @property UniDiscussion[] $uniDiscussions
 * @property UniFacilities[] $uniFacilities
 * @property UniPlacementCompanies[] $uniPlacementCompanies
 * @property UniUserViews[] $uniUserViews
 * @property UniVisitSchedule[] $uniVisitSchedules
 * @property UniveristyContact[] $univeristyContacts
 * @property UniveristyFinancials[] $univeristyFinancials
 * @property UniversityAdditionalInfo[] $universityAdditionalInfos
 * @property UniversityAlumni[] $universityAlumnis
 * @property UniversityDateIntake[] $universityDateIntakes
 * @property UniversityDepartmentMasterWeightage[] $universityDepartmentMasterWeightages
 * @property UniversityDepartmentOverallCutoff[] $universityDepartmentOverallCutoffs
 * @property UniversityDepartmentSubjectCutoff[] $universityDepartmentSubjectCutoffs
 * @property UniversityDeptRanking[] $universityDeptRankings
 * @property UniversityEthnicity[] $universityEthnicities
 * @property UniversityInsights[] $universityInsights
 * @property UniversityPageView[] $universityPageViews
 * @property UniversityShortName[] $universityShortNames
 * @property UniversitySocialMedia[] $universitySocialMedias
 * @property UserIdealListUniversity[] $userIdealListUniversities
 * @property UserUniApplication[] $userUniApplications
 * @property UserUniversityAdmissionScore[] $userUniversityAdmissionScores
 * @property VendorReviewLogCollege[] $vendorReviewLogColleges
 */
class BaseTblUniversityMaster extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_university_master';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('url_primary_key', 'required'),
			array('uni_country_rank, uni_global_rank, global_display_rank, university_affiliation_ref_id, institute_control_ref_id, state_ref_id, city_ref_id, country_ref_id, international_stud_total, international_stud_total_men, international_stud_total_women, total_students, total_applicants, total_enrolled_people, living_cost_in_city, living_cost_on_campus, vintage, no_of_campus, low_sal_range_currency_ref_id, high_sal_range_currency_ref_id, avg_salary_currency_ref_id, median_salary_currency_ref_id, high_domestic_salary_currency_ref_id, high_international_salary_currency_ref_id, is_featured, total_faculties, phd_faculties', 'numerical', 'integerOnly'=>true),
			array('uni_rank_factor, international_stud_per, full_time_per, part_time_per, male_per, female_per', 'numerical'),
			array('uni_code', 'length', 'max'=>20),
			array('uni_name, uni_slug_name, uni_logo, address1, address2, website_url, admission_url, course_page_url, application_url, flagship_subjects_courses_url, campus_look_n_feel, campus_link, longitude, latitude, scholarship_link', 'length', 'max'=>255),
			array('url_primary_key', 'length', 'max'=>32),
			array('seo_keyword', 'length', 'max'=>50),
			array('university_tier, is_twining, is_active, is_international_serach, is_user_entered', 'length', 'max'=>1),
			array('coed', 'length', 'max'=>12),
			array('type_of_institute', 'length', 'max'=>11),
			array('zipcode, acceptance_rate, enrolment_ratio, job_placement_per_pg, likelihood_scholarship, low_sal_range, high_sal_range, avg_salary, median_salary, high_domestic_salary, high_international_salary, added_by, modified_by', 'length', 'max'=>10),
			array('contact_email', 'length', 'max'=>100),
			array('location_type', 'length', 'max'=>6),
			array('calender_system', 'length', 'max'=>18),
			array('admission_cycle_cnt, student_professor_ratio', 'length', 'max'=>7),
			array('main_campus_size_in_acres', 'length', 'max'=>8),
			array('on_site_residence', 'length', 'max'=>3),
			array('uni_rating', 'length', 'max'=>2),
			array('uni_profile, address, flagship_subjects_courses, test_needed, media_reports, placement_article_link, admission_comments, added_on, modified_on, unique_feature, uni_join, campus_life', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('uni_id, uni_code, uni_name, url_primary_key, seo_keyword, uni_country_rank, uni_global_rank, global_display_rank, uni_rank_factor, uni_slug_name, uni_logo, university_tier, uni_profile, coed, university_affiliation_ref_id, type_of_institute, institute_control_ref_id, address, address1, address2, state_ref_id, city_ref_id, zipcode, country_ref_id, contact_email, location_type, website_url, admission_url, course_page_url, application_url, calender_system, international_stud_total, international_stud_total_men, international_stud_total_women, international_stud_per, total_students, full_time_per, part_time_per, male_per, female_per, flagship_subjects_courses, flagship_subjects_courses_url, admission_cycle_cnt, acceptance_rate, total_applicants, total_enrolled_people, enrolment_ratio, job_placement_per_pg, test_needed, likelihood_scholarship, living_cost_in_city, living_cost_on_campus, vintage, no_of_campus, main_campus_size_in_acres, campus_look_n_feel, campus_link, on_site_residence, student_professor_ratio, longitude, latitude, media_reports, placement_article_link, low_sal_range, low_sal_range_currency_ref_id, high_sal_range, high_sal_range_currency_ref_id, avg_salary, avg_salary_currency_ref_id, median_salary, median_salary_currency_ref_id, high_domestic_salary, high_domestic_salary_currency_ref_id, high_international_salary, high_international_salary_currency_ref_id, admission_comments, is_twining, is_active, added_on, added_by, modified_on, modified_by, is_featured, is_international_serach, unique_feature, is_user_entered, uni_rating, uni_join, scholarship_link, campus_life, total_faculties, phd_faculties', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'dis' => array(self::HAS_MANY, 'Di', 'uni_ref_id'),
			'diOnboards' => array(self::HAS_MANY, 'DiOnboard', 'uni_ref_id'),
			'diOnboardUniversityShortlists' => array(self::HAS_MANY, 'DiOnboardUniversityShortlist', 'uni_ref_id'),
			'eduFares' => array(self::HAS_MANY, 'EduFare', 'uni_ref_id'),
			'engagementEmailsUniversities' => array(self::HAS_MANY, 'EngagementEmailsUniversities', 'uni_ref_id'),
			'entranceExamApplicableLocations' => array(self::HAS_MANY, 'EntranceExamApplicableLocation', 'uni_ref_id'),
			'eoiRequestColleges' => array(self::HAS_MANY, 'EoiRequestCollege', 'uni_ref_id'),
			'errorReportUniversities' => array(self::HAS_MANY, 'ErrorReportUniversity', 'uni_ref_id'),
			'eventEmails' => array(self::HAS_MANY, 'EventEmail', 'uni_ref_id'),
			'mdmCourseLogs' => array(self::HAS_MANY, 'MdmCourseLog', 'uni_ref_id'),
			'mdmNewCourseAffiliations' => array(self::HAS_MANY, 'MdmNewCourseAffiliation', 'uni_ref_id'),
			'mdmNewCourseLogs' => array(self::HAS_MANY, 'MdmNewCourseLog', 'uni_ref_id'),
			'mdmNewCourseTwinings' => array(self::HAS_MANY, 'MdmNewCourseTwining', 'uni_ref_id'),
			'pmsAssignedAdvisers' => array(self::HAS_MANY, 'PmsAssignedAdvisers', 'uni_ref_id'),
			'pmsUniversityBuckets' => array(self::HAS_MANY, 'PmsUniversityBucket', 'uni_ref_id'),
			'pmsUniversityContacts' => array(self::HAS_MANY, 'PmsUniversityContact', 'uni_ref_id'),
			'popularColleges' => array(self::HAS_MANY, 'PopularCollege', 'uni_ref_id'),
			'requestCallbacks' => array(self::HAS_MANY, 'RequestCallback', 'uni_ref_id'),
			'requestContactDetails' => array(self::HAS_MANY, 'RequestContactDetail', 'uni_ref_id'),
			'reviewCredits' => array(self::HAS_MANY, 'ReviewCredit', 'uni_ref_id'),
			'scholarshipHostInstitutes' => array(self::HAS_MANY, 'ScholarshipHostInstitute', 'uni_ref_id'),
			'seoUniversities' => array(self::HAS_MANY, 'SeoUniversity', 'uni_ref_id'),
			'studentHotleads' => array(self::HAS_MANY, 'StudentHotlead', 'uni_ref_id'),
			'studentOutplacementColleges' => array(self::HAS_MANY, 'StudentOutplacementColleges', 'uni_ref_id'),
			'studentOutplacementUniversities' => array(self::HAS_MANY, 'StudentOutplacementUniversity', 'uni_ref_id'),
			'studentShortlistUniversities' => array(self::HAS_MANY, 'StudentShortlistUniversity', 'uni_ref_id'),
			'tagUniversities' => array(self::HAS_MANY, 'TagUniversity', 'uni_ref_id'),
			'tblUniCourses' => array(self::HAS_MANY, 'TblUniCourses', 'uni_ref_id'),
			'tblUniExtensions' => array(self::HAS_MANY, 'TblUniExtension', 'uni_ref_id'),
			'tblUniPicturesVideoses' => array(self::HAS_MANY, 'TblUniPicturesVideos', 'uni_ref_id'),
			'tblUniWeathers' => array(self::HAS_MANY, 'TblUniWeather', 'uni_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'instituteControlRef' => array(self::BELONGS_TO, 'LookupInstituteControl', 'institute_control_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'stateRef' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
			'universityAffiliationRef' => array(self::BELONGS_TO, 'LookupUniversityAffiliation', 'university_affiliation_ref_id'),
			'uniCourseTests' => array(self::HAS_MANY, 'UniCourseTest', 'uni_ref_id'),
			'uniDiscussions' => array(self::HAS_MANY, 'UniDiscussion', 'uni_ref_id'),
			'uniFacilities' => array(self::HAS_MANY, 'UniFacilities', 'uni_ref_id'),
			'uniPlacementCompanies' => array(self::HAS_MANY, 'UniPlacementCompanies', 'uni_ref_id'),
			'uniUserViews' => array(self::HAS_MANY, 'UniUserViews', 'uni_ref_id'),
			'uniVisitSchedules' => array(self::HAS_MANY, 'UniVisitSchedule', 'uni_ref_id'),
			'univeristyContacts' => array(self::HAS_MANY, 'UniveristyContact', 'uni_ref_id'),
			'univeristyFinancials' => array(self::HAS_MANY, 'UniveristyFinancials', 'uni_ref_id'),
			'universityAdditionalInfos' => array(self::HAS_MANY, 'UniversityAdditionalInfo', 'uni_ref_id'),
			'universityAlumnis' => array(self::HAS_MANY, 'UniversityAlumni', 'uni_ref_id'),
			'universityDateIntakes' => array(self::HAS_MANY, 'UniversityDateIntake', 'uni_ref_id'),
			'universityDepartmentMasterWeightages' => array(self::HAS_MANY, 'UniversityDepartmentMasterWeightage', 'uni_ref_id'),
			'universityDepartmentOverallCutoffs' => array(self::HAS_MANY, 'UniversityDepartmentOverallCutoff', 'uni_ref_id'),
			'universityDepartmentSubjectCutoffs' => array(self::HAS_MANY, 'UniversityDepartmentSubjectCutoff', 'uni_ref_id'),
			'universityDeptRankings' => array(self::HAS_MANY, 'UniversityDeptRanking', 'uni_ref_id'),
			'universityEthnicities' => array(self::HAS_MANY, 'UniversityEthnicity', 'uni_ref_id'),
			'universityInsights' => array(self::HAS_MANY, 'UniversityInsights', 'uni_ref_id'),
			'universityPageViews' => array(self::HAS_MANY, 'UniversityPageView', 'uni_ref_id'),
			'universityShortNames' => array(self::HAS_MANY, 'UniversityShortName', 'uni_ref_id'),
			'universitySocialMedias' => array(self::HAS_MANY, 'UniversitySocialMedia', 'uni_ref_id'),
			'userIdealListUniversities' => array(self::HAS_MANY, 'UserIdealListUniversity', 'uni_ref_id'),
			'userUniApplications' => array(self::HAS_MANY, 'UserUniApplication', 'uni_ref_id'),
			'userUniversityAdmissionScores' => array(self::HAS_MANY, 'UserUniversityAdmissionScore', 'uni_ref_id'),
			'vendorReviewLogColleges' => array(self::HAS_MANY, 'VendorReviewLogCollege', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uni_id' => 'Uni',
			'uni_code' => 'Uni Code',
			'uni_name' => 'Uni Name',
			'url_primary_key' => 'Url Primary Key',
			'seo_keyword' => 'Seo Keyword',
			'uni_country_rank' => 'Uni Country Rank',
			'uni_global_rank' => 'Uni Global Rank',
			'global_display_rank' => 'Global Display Rank',
			'uni_rank_factor' => 'Uni Rank Factor',
			'uni_slug_name' => 'Uni Slug Name',
			'uni_logo' => 'Uni Logo',
			'university_tier' => 'University Tier',
			'uni_profile' => 'Uni Profile',
			'coed' => 'Coed',
			'university_affiliation_ref_id' => 'University Affiliation Ref',
			'type_of_institute' => 'Type Of Institute',
			'institute_control_ref_id' => 'Institute Control Ref',
			'address' => 'Address',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'state_ref_id' => 'State Ref',
			'city_ref_id' => 'City Ref',
			'zipcode' => 'Zipcode',
			'country_ref_id' => 'Country Ref',
			'contact_email' => 'Contact Email',
			'location_type' => 'Location Type',
			'website_url' => 'Website Url',
			'admission_url' => 'Admission Url',
			'course_page_url' => 'Course Page Url',
			'application_url' => 'Application Url',
			'calender_system' => 'Calender System',
			'international_stud_total' => 'International Stud Total',
			'international_stud_total_men' => 'International Stud Total Men',
			'international_stud_total_women' => 'International Stud Total Women',
			'international_stud_per' => 'International Stud Per',
			'total_students' => 'Total Students',
			'full_time_per' => 'Full Time Per',
			'part_time_per' => 'Part Time Per',
			'male_per' => 'Male Per',
			'female_per' => 'Female Per',
			'flagship_subjects_courses' => 'Flagship Subjects Courses',
			'flagship_subjects_courses_url' => 'Flagship Subjects Courses Url',
			'admission_cycle_cnt' => 'Admission Cycle Cnt',
			'acceptance_rate' => 'Acceptance Rate',
			'total_applicants' => 'Total Applicants',
			'total_enrolled_people' => 'Total Enrolled People',
			'enrolment_ratio' => 'Enrolment Ratio',
			'job_placement_per_pg' => 'Job Placement Per Pg',
			'test_needed' => 'Test Needed',
			'likelihood_scholarship' => 'Likelihood Scholarship',
			'living_cost_in_city' => 'Living Cost In City',
			'living_cost_on_campus' => 'Living Cost On Campus',
			'vintage' => 'Vintage',
			'no_of_campus' => 'No Of Campus',
			'main_campus_size_in_acres' => 'Main Campus Size In Acres',
			'campus_look_n_feel' => 'Campus Look N Feel',
			'campus_link' => 'Campus Link',
			'on_site_residence' => 'On Site Residence',
			'student_professor_ratio' => 'Student Professor Ratio',
			'longitude' => 'Longitude',
			'latitude' => 'Latitude',
			'media_reports' => 'Media Reports',
			'placement_article_link' => 'Placement Article Link',
			'low_sal_range' => 'Low Sal Range',
			'low_sal_range_currency_ref_id' => 'Low Sal Range Currency Ref',
			'high_sal_range' => 'High Sal Range',
			'high_sal_range_currency_ref_id' => 'High Sal Range Currency Ref',
			'avg_salary' => 'Avg Salary',
			'avg_salary_currency_ref_id' => 'Avg Salary Currency Ref',
			'median_salary' => 'Median Salary',
			'median_salary_currency_ref_id' => 'Median Salary Currency Ref',
			'high_domestic_salary' => 'High Domestic Salary',
			'high_domestic_salary_currency_ref_id' => 'High Domestic Salary Currency Ref',
			'high_international_salary' => 'High International Salary',
			'high_international_salary_currency_ref_id' => 'High International Salary Currency Ref',
			'admission_comments' => 'Admission Comments',
			'is_twining' => 'Is Twining',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'is_featured' => 'Is Featured',
			'is_international_serach' => 'Is International Serach',
			'unique_feature' => 'Unique Feature',
			'is_user_entered' => 'Is User Entered',
			'uni_rating' => 'Uni Rating',
			'uni_join' => 'Uni Join',
			'scholarship_link' => 'Scholarship Link',
			'campus_life' => 'Campus Life',
			'total_faculties' => 'Total Faculties',
			'phd_faculties' => 'Phd Faculties',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('uni_id',$this->uni_id);
		$criteria->compare('uni_code',$this->uni_code,true);
		$criteria->compare('uni_name',$this->uni_name,true);
		$criteria->compare('url_primary_key',$this->url_primary_key,true);
		$criteria->compare('seo_keyword',$this->seo_keyword,true);
		$criteria->compare('uni_country_rank',$this->uni_country_rank);
		$criteria->compare('uni_global_rank',$this->uni_global_rank);
		$criteria->compare('global_display_rank',$this->global_display_rank);
		$criteria->compare('uni_rank_factor',$this->uni_rank_factor);
		$criteria->compare('uni_slug_name',$this->uni_slug_name,true);
		$criteria->compare('uni_logo',$this->uni_logo,true);
		$criteria->compare('university_tier',$this->university_tier,true);
		$criteria->compare('uni_profile',$this->uni_profile,true);
		$criteria->compare('coed',$this->coed,true);
		$criteria->compare('university_affiliation_ref_id',$this->university_affiliation_ref_id);
		$criteria->compare('type_of_institute',$this->type_of_institute,true);
		$criteria->compare('institute_control_ref_id',$this->institute_control_ref_id);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('zipcode',$this->zipcode,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('contact_email',$this->contact_email,true);
		$criteria->compare('location_type',$this->location_type,true);
		$criteria->compare('website_url',$this->website_url,true);
		$criteria->compare('admission_url',$this->admission_url,true);
		$criteria->compare('course_page_url',$this->course_page_url,true);
		$criteria->compare('application_url',$this->application_url,true);
		$criteria->compare('calender_system',$this->calender_system,true);
		$criteria->compare('international_stud_total',$this->international_stud_total);
		$criteria->compare('international_stud_total_men',$this->international_stud_total_men);
		$criteria->compare('international_stud_total_women',$this->international_stud_total_women);
		$criteria->compare('international_stud_per',$this->international_stud_per);
		$criteria->compare('total_students',$this->total_students);
		$criteria->compare('full_time_per',$this->full_time_per);
		$criteria->compare('part_time_per',$this->part_time_per);
		$criteria->compare('male_per',$this->male_per);
		$criteria->compare('female_per',$this->female_per);
		$criteria->compare('flagship_subjects_courses',$this->flagship_subjects_courses,true);
		$criteria->compare('flagship_subjects_courses_url',$this->flagship_subjects_courses_url,true);
		$criteria->compare('admission_cycle_cnt',$this->admission_cycle_cnt,true);
		$criteria->compare('acceptance_rate',$this->acceptance_rate,true);
		$criteria->compare('total_applicants',$this->total_applicants);
		$criteria->compare('total_enrolled_people',$this->total_enrolled_people);
		$criteria->compare('enrolment_ratio',$this->enrolment_ratio,true);
		$criteria->compare('job_placement_per_pg',$this->job_placement_per_pg,true);
		$criteria->compare('test_needed',$this->test_needed,true);
		$criteria->compare('likelihood_scholarship',$this->likelihood_scholarship,true);
		$criteria->compare('living_cost_in_city',$this->living_cost_in_city);
		$criteria->compare('living_cost_on_campus',$this->living_cost_on_campus);
		$criteria->compare('vintage',$this->vintage);
		$criteria->compare('no_of_campus',$this->no_of_campus);
		$criteria->compare('main_campus_size_in_acres',$this->main_campus_size_in_acres,true);
		$criteria->compare('campus_look_n_feel',$this->campus_look_n_feel,true);
		$criteria->compare('campus_link',$this->campus_link,true);
		$criteria->compare('on_site_residence',$this->on_site_residence,true);
		$criteria->compare('student_professor_ratio',$this->student_professor_ratio,true);
		$criteria->compare('longitude',$this->longitude,true);
		$criteria->compare('latitude',$this->latitude,true);
		$criteria->compare('media_reports',$this->media_reports,true);
		$criteria->compare('placement_article_link',$this->placement_article_link,true);
		$criteria->compare('low_sal_range',$this->low_sal_range,true);
		$criteria->compare('low_sal_range_currency_ref_id',$this->low_sal_range_currency_ref_id);
		$criteria->compare('high_sal_range',$this->high_sal_range,true);
		$criteria->compare('high_sal_range_currency_ref_id',$this->high_sal_range_currency_ref_id);
		$criteria->compare('avg_salary',$this->avg_salary,true);
		$criteria->compare('avg_salary_currency_ref_id',$this->avg_salary_currency_ref_id);
		$criteria->compare('median_salary',$this->median_salary,true);
		$criteria->compare('median_salary_currency_ref_id',$this->median_salary_currency_ref_id);
		$criteria->compare('high_domestic_salary',$this->high_domestic_salary,true);
		$criteria->compare('high_domestic_salary_currency_ref_id',$this->high_domestic_salary_currency_ref_id);
		$criteria->compare('high_international_salary',$this->high_international_salary,true);
		$criteria->compare('high_international_salary_currency_ref_id',$this->high_international_salary_currency_ref_id);
		$criteria->compare('admission_comments',$this->admission_comments,true);
		$criteria->compare('is_twining',$this->is_twining,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('is_featured',$this->is_featured);
		$criteria->compare('is_international_serach',$this->is_international_serach,true);
		$criteria->compare('unique_feature',$this->unique_feature,true);
		$criteria->compare('is_user_entered',$this->is_user_entered,true);
		$criteria->compare('uni_rating',$this->uni_rating,true);
		$criteria->compare('uni_join',$this->uni_join,true);
		$criteria->compare('scholarship_link',$this->scholarship_link,true);
		$criteria->compare('campus_life',$this->campus_life,true);
		$criteria->compare('total_faculties',$this->total_faculties);
		$criteria->compare('phd_faculties',$this->phd_faculties);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return BaseTblUniversityMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
