<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTagSchool is autogenerate by UniModel generator
 *
 * This is the model class for table "tag_school".
 *
 * The followings are the available columns in table 'tag_school':
 * @property integer $tag_school_id
 * @property string $tag_name
 * @property integer $si_ref_id
 * @property integer $school_ref_id
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupSchool $schoolRef
 * @property LoginMaster $addedBy
 * @property TblSiDi $siRef
 */
class BaseTagSchool extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TagSchool the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tag_school';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('si_ref_id, school_ref_id', 'numerical', 'integerOnly'=>true),
			array('tag_name', 'length', 'max'=>50),
			array('added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tag_school_id, tag_name, si_ref_id, school_ref_id, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'schoolRef' => array(self::BELONGS_TO, 'LookupSchool', 'school_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'siRef' => array(self::BELONGS_TO, 'TblSiDi', 'si_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tag_school_id' => 'Tag School',
			'tag_name' => 'Tag Name',
			'si_ref_id' => 'Si Ref',
			'school_ref_id' => 'School Ref',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tag_school_id',$this->tag_school_id);
		$criteria->compare('tag_name',$this->tag_name,true);
		$criteria->compare('si_ref_id',$this->si_ref_id);
		$criteria->compare('school_ref_id',$this->school_ref_id);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}