<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentSchool is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_si_students".
 *
 * The followings are the available columns in table 'tbl_si_students':
 * @property integer $id
 * @property integer $user_ref_id
 * @property integer $inst_ref_id
 * @property string $is_invited
 * @property string $is_invitation_accepted
 * @property string $added_on
 */
class BaseStudentSchool extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentSchool the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_si_students';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, inst_ref_id', 'numerical', 'integerOnly'=>true),
			array('is_invited, is_invitation_accepted', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_ref_id, inst_ref_id, is_invited, is_invitation_accepted, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_ref_id' => 'User Ref',
			'inst_ref_id' => 'Inst Ref',
			'is_invited' => 'Is Invited',
			'is_invitation_accepted' => 'Is Invitation Accepted',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_ref_id',$this->user_ref_id);
		$criteria->compare('inst_ref_id',$this->inst_ref_id);
		$criteria->compare('is_invited',$this->is_invited,true);
		$criteria->compare('is_invitation_accepted',$this->is_invitation_accepted,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}