<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentHypothesisCountry is autogenerate by UniModel generator
 *
 * This is the model class for table "student_hypothesis_country".
 *
 * The followings are the available columns in table 'student_hypothesis_country':
 * @property string $student_hypothesis_country_id
 * @property string $user_ref_id
 * @property integer $country_ref_id
 * @property integer $preference_order
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblCountryMaster $countryRef
 * @property TblUserMaster $userRef
 * @property LoginMaster $addedBy
 */
class BaseStudentHypothesisCountry extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentHypothesisCountry the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_hypothesis_country';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, added_by', 'required'),
			array('country_ref_id, preference_order', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, added_by', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_hypothesis_country_id, user_ref_id, country_ref_id, preference_order, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_hypothesis_country_id' => 'Student Hypothesis Country',
			'user_ref_id' => 'User Ref',
			'country_ref_id' => 'Country Ref',
			'preference_order' => 'Preference Order',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_hypothesis_country_id',$this->student_hypothesis_country_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('preference_order',$this->preference_order);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}