<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSiTrackMilestone is autogenerate by UniModel generator
 *
 * This is the model class for table "si_track_milestone".
 *
 * The followings are the available columns in table 'si_track_milestone':
 * @property string $si_track_milestone_id
 * @property integer $si_ref_id
 * @property string $class
 * @property integer $board_ref_id
 * @property integer $passout_month
 * @property integer $passout_year
 * @property string $milestone1_date
 * @property string $milestone2_date
 * @property string $milestone3_date
 * @property string $milestone4_date
 * @property string $milestone5_date
 * @property string $milestone6_date
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LookupBoard $boardRef
 * @property LoginMaster $modifiedBy
 * @property TblSiDi $siRef
 */
class BaseSiTrackMilestone extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SiTrackMilestone the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'si_track_milestone';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('class, board_ref_id, passout_month, passout_year', 'required'),
			//array('si_ref_id, board_ref_id', 'numerical', 'integerOnly'=>true),
			//array('class', 'length', 'max'=>2),
			//array('added_by, modified_by', 'length', 'max'=>10),
			array('milestone1_date, milestone2_date, milestone3_date, milestone4_date, milestone5_date, milestone6_date, modified_on, milestone_status, milestone_id', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('si_track_milestone_id, si_ref_id, class, board_ref_id, passout_month, passout_year, milestone1_date, milestone2_date, milestone3_date, milestone4_date, milestone5_date, milestone6_date, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'siRef' => array(self::BELONGS_TO, 'TblSiDi', 'si_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'si_track_milestone_id' => 'Si Track Milestone',
			'si_ref_id' => 'Si Ref',
			'class' => 'Class',
			'board_ref_id' => 'Board Ref',
			'passout_month' => 'Passout Month',
			'passout_year' => 'Passout Year',
			'milestone1_date' => 'Milestone1 Date',
			'milestone2_date' => 'Milestone2 Date',
			'milestone3_date' => 'Milestone3 Date',
			'milestone4_date' => 'Milestone4 Date',
			'milestone5_date' => 'Milestone5 Date',
			'milestone6_date' => 'Milestone6 Date',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('si_track_milestone_id',$this->si_track_milestone_id,true);
		$criteria->compare('si_ref_id',$this->si_ref_id);
		$criteria->compare('class',$this->class,true);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('passout_month',$this->passout_month);
		$criteria->compare('passout_year',$this->passout_year);
		$criteria->compare('milestone1_date',$this->milestone1_date,true);
		$criteria->compare('milestone2_date',$this->milestone2_date,true);
		$criteria->compare('milestone3_date',$this->milestone3_date,true);
		$criteria->compare('milestone4_date',$this->milestone4_date,true);
		$criteria->compare('milestone5_date',$this->milestone5_date,true);
		$criteria->compare('milestone6_date',$this->milestone6_date,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}