<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseProspectInteraction is autogenerate by UniModel generator
 *
 * This is the model class for table "prospect_interaction".
 *
 * The followings are the available columns in table 'prospect_interaction':
 * @property string $prospect_interaction_id
 * @property string $prospect_ref_id
 * @property integer $advisor_ref_id
 * @property string $other_advisor
 * @property integer $interaction_ref_id
 * @property string $interaction_date
 * @property integer $assisted_by
 * @property string $summary
 * @property integer $rating
 * @property string $next_interaction
 * @property string $added_on
 * @property integer $prospect_main_status_ref_id
 * @property integer $prospect_sub_status_ref_id
 * @property integer $prev_interaction_id
 * @property string $is_completed
 *
 * The followings are the available model relations:
 * @property TblAdmin $advisorRef
 * @property TblAdmin $assistedBy
 * @property MasterInteraction $interactionRef
 * @property LookupProspectStatus $prospectMainStatusRef
 * @property Prospect $prospectRef
 * @property LookupProspectStatus $prospectSubStatusRef
 * @property ProspectPartners[] $prospectPartners
 */
class BaseProspectInteraction extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProspectInteraction the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'prospect_interaction';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('prospect_ref_id, advisor_ref_id, interaction_ref_id', 'required'),
			array('advisor_ref_id, interaction_ref_id, assisted_by, rating, prospect_main_status_ref_id, prospect_sub_status_ref_id, prev_interaction_id', 'numerical', 'integerOnly'=>true),
			array('prospect_ref_id', 'length', 'max'=>10),
			array('other_advisor', 'length', 'max'=>64),
			array('is_completed', 'length', 'max'=>1),
			array('interaction_date, summary, next_interaction, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('prospect_interaction_id, prospect_ref_id, advisor_ref_id, other_advisor, interaction_ref_id, interaction_date, assisted_by, summary, rating, next_interaction, added_on, prospect_main_status_ref_id, prospect_sub_status_ref_id, prev_interaction_id, is_completed', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'advisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'advisor_ref_id'),
			'assistedBy' => array(self::BELONGS_TO, 'TblAdmin', 'assisted_by'),
			'interactionRef' => array(self::BELONGS_TO, 'MasterInteraction', 'interaction_ref_id'),
			'prospectMainStatusRef' => array(self::BELONGS_TO, 'LookupProspectStatus', 'prospect_main_status_ref_id'),
			'prospectRef' => array(self::BELONGS_TO, 'Prospect', 'prospect_ref_id'),
			'prospectSubStatusRef' => array(self::BELONGS_TO, 'LookupProspectStatus', 'prospect_sub_status_ref_id'),
			'prospectPartners' => array(self::HAS_MANY, 'ProspectPartners', 'prospect_interaction_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'prospect_interaction_id' => 'Prospect Interaction',
			'prospect_ref_id' => 'Prospect Ref',
			'advisor_ref_id' => 'Advisor Ref',
			'other_advisor' => 'Other Advisor',
			'interaction_ref_id' => 'Interaction Ref',
			'interaction_date' => 'Interaction Date',
			'assisted_by' => 'Assisted By',
			'summary' => 'Summary',
			'rating' => 'Rating',
			'next_interaction' => 'Next Interaction',
			'added_on' => 'Added On',
			'prospect_main_status_ref_id' => 'Prospect Main Status Ref',
			'prospect_sub_status_ref_id' => 'Prospect Sub Status Ref',
			'prev_interaction_id' => 'Prev Interaction',
			'is_completed' => 'Is Completed',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('prospect_interaction_id',$this->prospect_interaction_id,true);
		$criteria->compare('prospect_ref_id',$this->prospect_ref_id,true);
		$criteria->compare('advisor_ref_id',$this->advisor_ref_id);
		$criteria->compare('other_advisor',$this->other_advisor,true);
		$criteria->compare('interaction_ref_id',$this->interaction_ref_id);
		$criteria->compare('interaction_date',$this->interaction_date,true);
		$criteria->compare('assisted_by',$this->assisted_by);
		$criteria->compare('summary',$this->summary,true);
		$criteria->compare('rating',$this->rating);
		$criteria->compare('next_interaction',$this->next_interaction,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('prospect_main_status_ref_id',$this->prospect_main_status_ref_id);
		$criteria->compare('prospect_sub_status_ref_id',$this->prospect_sub_status_ref_id);
		$criteria->compare('prev_interaction_id',$this->prev_interaction_id);
		$criteria->compare('is_completed',$this->is_completed,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}