<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BasePaymentInvoice is autogenerate by UniModel generator
 *
 * This is the model class for table "payment_invoice".
 *
 * The followings are the available columns in table 'payment_invoice':
 * @property integer $payment_invoice_id
 * @property string $payment_name
 * @property string $payment_amount
 * @property string $payment_for
 * @property string $payment_comment
 * @property string $ip_address
 * @property string $response
 * @property string $status
 * @property string $added_on
 */
class BasePaymentInvoice extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PaymentInvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'payment_invoice';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            array('payment_amount,payment_name', 'required','message' =>'<div class="holder"><p style="padding-left: 10px">Please Enter {attribute}</p></div>'),
            array('payment_amount', 'numerical', 'integerOnly'=>true,'message' =>'<div class="holder"><p>Invalid {attribute}</p></div>'),
			array('payment_name', 'length', 'max'=>100),
            array('payment_name','match','pattern' =>'/^[a-zA-Z ]*$/i','message' => '<div class="holder"><p>Payee name should contain only alphabets</p></div>'),
            array('payment_amount', 'length', 'max'=>10),
			array('payment_for', 'length', 'max'=>255),
			array('payment_comment, response', 'length', 'max'=>500),
			array('ip_address', 'length', 'max'=>20),
			array('status', 'length', 'max'=>9),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('payment_invoice_id, payment_name, payment_amount, payment_for, payment_comment, ip_address, response, status, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'payment_invoice_id' => 'Payment Invoice',
			'payment_name' => 'Payment Name',
			'payment_amount' => 'Payment Amount',
			'payment_for' => 'Payment For',
			'payment_comment' => 'Payment Comment',
			'ip_address' => 'Ip Address',
			'response' => 'Response',
			'status' => 'Status',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('payment_invoice_id',$this->payment_invoice_id);
		$criteria->compare('payment_name',$this->payment_name,true);
		$criteria->compare('payment_amount',$this->payment_amount,true);
		$criteria->compare('payment_for',$this->payment_for,true);
		$criteria->compare('payment_comment',$this->payment_comment,true);
		$criteria->compare('ip_address',$this->ip_address,true);
		$criteria->compare('response',$this->response,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}