<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupWorkplanStage is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_workplan_stage".
 *
 * The followings are the available columns in table 'lookup_workplan_stage':
 * @property integer $workplan_stage_id
 * @property string $stage_name
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupWorkplan[] $lookupWorkplans
 */
class BaseLookupWorkplanStage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupWorkplanStage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_workplan_stage';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('stage_name', 'required'),
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('stage_name', 'length', 'max'=>100),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('workplan_stage_id, stage_name, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupWorkplans' => array(self::HAS_MANY, 'LookupWorkplan', 'workplan_stage_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'workplan_stage_id' => 'Workplan Stage',
			'stage_name' => 'Stage Name',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('workplan_stage_id',$this->workplan_stage_id);
		$criteria->compare('stage_name',$this->stage_name,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}