<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupBoardConversion is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_board_conversion".
 *
 * The followings are the available columns in table 'lookup_board_conversion':
 * @property integer $board_conversion_id
 * @property integer $board_ref_id
 * @property integer $board_equivalent_ref_id
 * @property string $mark_type
 * @property string $board_marks
 * @property integer $convert_marks
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupBoardEquivalent $boardEquivalentRef
 * @property LookupBoard $boardRef
 * @property StudentEducationDetail[] $studentEducationDetails
 * @property StudentGradeCount[] $studentGradeCounts
 */
class BaseLookupBoardConversion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupBoardConversion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_board_conversion';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('board_ref_id, board_marks, convert_marks, added_on', 'required'),
			array('board_ref_id, board_equivalent_ref_id, convert_marks', 'numerical', 'integerOnly'=>true),
			array('mark_type', 'length', 'max'=>2),
			array('board_marks', 'length', 'max'=>4),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('board_conversion_id, board_ref_id, board_equivalent_ref_id, mark_type, board_marks, convert_marks, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'boardEquivalentRef' => array(self::BELONGS_TO, 'LookupBoardEquivalent', 'board_equivalent_ref_id'),
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
			'studentEducationDetails' => array(self::HAS_MANY, 'StudentEducationDetail', 'board_conversion_ref_id'),
			'studentGradeCounts' => array(self::HAS_MANY, 'StudentGradeCount', 'board_conversion_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'board_conversion_id' => 'Board Conversion',
			'board_ref_id' => 'Board Ref',
			'board_equivalent_ref_id' => 'Board Equivalent Ref',
			'mark_type' => 'Mark Type',
			'board_marks' => 'Board Marks',
			'convert_marks' => 'Convert Marks',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('board_conversion_id',$this->board_conversion_id);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('board_equivalent_ref_id',$this->board_equivalent_ref_id);
		$criteria->compare('mark_type',$this->mark_type,true);
		$criteria->compare('board_marks',$this->board_marks,true);
		$criteria->compare('convert_marks',$this->convert_marks);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}