<?php

/**
/* 
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamFees is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_fees".
 *
 * The followings are the available columns in table 'entrance_exam_fees':
 * @property string $entrance_exam_fees_id
 * @property integer $entrance_exam_ref_id
 * @property string $fees
 * @property integer $currency_ref_id
 * @property integer $reservation_ref_id
 * @property string $added_on
 * @property string $modified_on
 * @property integer $added_by
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property LookupCurrency $currencyRef
 * @property EntranceExam $entranceExamRef
 * @property LookupReservation $reservationRef
 * @property TblAdmin $addedBy
 * @property TblAdmin $modifiedBy
 */
class BaseEntranceExamFees extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamFees the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_fees';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_ref_id, fees, currency_ref_id, reservation_ref_id, added_by', 'required'),
			array('entrance_exam_ref_id, currency_ref_id, reservation_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('fees', 'length', 'max'=>8),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_fees_id, entrance_exam_ref_id, fees, currency_ref_id, reservation_ref_id, added_on, modified_on, added_by, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'reservationRef' => array(self::BELONGS_TO, 'LookupReservation', 'reservation_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_fees_id' => 'Entrance Exam Fees',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'fees' => 'Fees',
			'currency_ref_id' => 'Currency Ref',
			'reservation_ref_id' => 'Reservation Ref',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'added_by' => 'Added By',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_fees_id',$this->entrance_exam_fees_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('fees',$this->fees,true);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('reservation_ref_id',$this->reservation_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_by',$this->modified_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}