<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailerCronMilestone is autogenerate by UniModel generator
 *
 * This is the model class for table "emailer_cron_milestone".
 *
 * The followings are the available columns in table 'emailer_cron_milestone':
 * @property integer $emailer_cron_milestone_id
 * @property string $template_key
 * @property string $template_description
 * @property string $template_text
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property EmailerMilestoneTracker[] $emailerMilestoneTrackers
 */
class BaseEmailerCronMilestone extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailerCronMilestone the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'emailer_cron_milestone';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('template_key, template_description, template_text, added_on', 'required'),
			array('template_key', 'length', 'max'=>50),
			array('template_description', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('emailer_cron_milestone_id, template_key, template_description, template_text, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailerMilestoneTrackers' => array(self::HAS_MANY, 'EmailerMilestoneTracker', 'emailer_cron_milestone_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'emailer_cron_milestone_id' => 'Emailer Cron Milestone',
			'template_key' => 'Template Key',
			'template_description' => 'Template Description',
			'template_text' => 'Template Text',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('emailer_cron_milestone_id',$this->emailer_cron_milestone_id);
		$criteria->compare('template_key',$this->template_key,true);
		$criteria->compare('template_description',$this->template_description,true);
		$criteria->compare('template_text',$this->template_text,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}