<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUserHotlead is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user_hotlead".
 *
 * The followings are the available columns in table 'di_user_hotlead':
 * @property string $di_user_hotlead_id
 * @property integer $di_user_ref_id
 * @property string $student_hotlead_ref_id
 * @property string $status
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property StudentHotlead $studentHotleadRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property DiUser $diUserRef
 */
class BaseDiUserHotlead extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUserHotlead the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user_hotlead';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_user_ref_id, student_hotlead_ref_id, added_on, added_by', 'required'),
			array('di_user_ref_id', 'numerical', 'integerOnly'=>true),
			array('student_hotlead_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('status', 'length', 'max'=>6),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_hotlead_id, di_user_ref_id, student_hotlead_ref_id, status, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentHotleadRef' => array(self::BELONGS_TO, 'StudentHotlead', 'student_hotlead_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'diUserRef' => array(self::BELONGS_TO, 'DiUser', 'di_user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_hotlead_id' => 'Di User Hotlead',
			'di_user_ref_id' => 'Di User Ref',
			'student_hotlead_ref_id' => 'Student Hotlead Ref',
			'status' => 'Status',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_hotlead_id',$this->di_user_hotlead_id,true);
		$criteria->compare('di_user_ref_id',$this->di_user_ref_id);
		$criteria->compare('student_hotlead_ref_id',$this->student_hotlead_ref_id,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}