<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiBannerSetAlert is autogenerate by UniModel generator
 *
 * This is the model class for table "di_banner_set_alert".
 *
 * The followings are the available columns in table 'di_banner_set_alert':
 * @property string $di_banner_set_alert_id
 * @property integer $bs_ref_id
 * @property string $alert_on
 * @property string $added_on
 * @property string $mobile_number
 *
 * The followings are the available model relations:
 * @property DiBannerCampaignAdData $bsRef
 */
class BaseDiBannerSetAlert extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiBannerSetAlert the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_banner_set_alert';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bs_ref_id, alert_on, mobile_number', 'required'),
			array('bs_ref_id', 'numerical', 'integerOnly'=>true),
			array('alert_on', 'length', 'max'=>1),
			array('mobile_number', 'length', 'max'=>15),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_banner_set_alert_id, bs_ref_id, alert_on, added_on, mobile_number', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'bsRef' => array(self::BELONGS_TO, 'DiBannerCampaignAdData', 'bs_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_banner_set_alert_id' => 'Di Banner Set Alert',
			'bs_ref_id' => 'Bs Ref',
			'alert_on' => 'Alert On',
			'added_on' => 'Added On',
			'mobile_number' => 'Mobile Number',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_banner_set_alert_id',$this->di_banner_set_alert_id,true);
		$criteria->compare('bs_ref_id',$this->bs_ref_id);
		$criteria->compare('alert_on',$this->alert_on,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('mobile_number',$this->mobile_number,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}