<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDepartmentEntranceExam is autogenerate by UniModel generator
 *
 * This is the model class for table "department_entrance_exam".
 *
 * The followings are the available columns in table 'department_entrance_exam':
 * @property integer $department_entrance_exam_id
 * @property integer $country_ref_id
 * @property integer $department_ref_id
 * @property integer $entrance_exam_ref_id
 *
 * The followings are the available model relations:
 * @property TblCountryMaster $countryRef
 * @property LookupDepartment $departmentRef
 * @property EntranceExam $entranceExamRef
 * @property UniversityDepartmentEntranceExamOverallCutoff[] $universityDepartmentEntranceExamOverallCutoffs
 */
class BaseDepartmentEntranceExam extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DepartmentEntranceExam the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'department_entrance_exam';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_ref_id, department_ref_id, entrance_exam_ref_id', 'required'),
			array('country_ref_id, department_ref_id, entrance_exam_ref_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('department_entrance_exam_id, country_ref_id, department_ref_id, entrance_exam_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'universityDepartmentEntranceExamOverallCutoffs' => array(self::HAS_MANY, 'UniversityDepartmentEntranceExamOverallCutoff', 'department_entrance_exam_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'department_entrance_exam_id' => 'Department Entrance Exam',
			'country_ref_id' => 'Country Ref',
			'department_ref_id' => 'Department Ref',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('department_entrance_exam_id',$this->department_entrance_exam_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}