<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCareerCountry is autogenerate by UniModel generator
 *
 * This is the model class for table "career_country".
 *
 * The followings are the available columns in table 'career_country':
 * @property string $career_country_id
 * @property integer $country_ref_id
 * @property string $career_ref_id
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LookupCareer $careerRef
 * @property LoginMaster $addedBy
 * @property TblCountryMaster $countryRef
 */
class BaseCareerCountry extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CareerCountry the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'career_country';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('career_ref_id, added_on, added_by', 'required'),
			array('country_ref_id', 'numerical', 'integerOnly'=>true),
			array('career_ref_id, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('career_country_id, country_ref_id, career_ref_id, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'careerRef' => array(self::BELONGS_TO, 'LookupCareer', 'career_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'career_country_id' => 'Career Country',
			'country_ref_id' => 'Country Ref',
			'career_ref_id' => 'Career Ref',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('career_country_id',$this->career_country_id,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('career_ref_id',$this->career_ref_id,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}