<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblUserMaster');

class TblUserMaster extends BaseTblUserMaster {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public $dob_date;
    public $dob_month;
    public $dob_year;
    public $school_name;
    public $parent_name;
    public $board_ref_id;
    // for pms
    public $username;
    public $shortlistCnt;
    public $bucketsCnt;
    public $dept_ref;
    public $inst_name;
    public $departments;
    public $uni_id;
    public $uni_name;
    public $board_desc;
    public $is_email_confirmed;
    public $is_class_status_confirmed;
    public $is_preference_confirmed;
    public $country_pref;
    public $country_pref_order;
    public $dept_pref;
    public $dept_pref_order;
    public $umail_recency;
    public $profile_validate_status;
    public $validated_by;
    public $umail_request_to;
    public $inst_ref_id;
    public $is_b2b;
    public $login_count;
    public $umail_count;
    public $umail_tags;
    public $offer_count;
    public $number;
    public $webinars_attended_count;
    public $webinars_registered_count;
    public $assigned_count;
    public $milestones;

    public function behaviors() {
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }

    public function StudentActivityFeedLoggableAttributes() {
        return array(
            'address1, address2, city_ref_id, state_ref_id, country_ref_id, post_code' => 'location',
            'gender' => 'gender',
            //'passout_year' => '12th_completion_year',
            'first_name, middle_name, last_name, father_first_name, father_last_name, mother_first_name, mother_last_name, guardian_first_name, guardian_last_name, introduce_yourself, ' => 'personal_information',
            'other_activities, dob, ethnicity_ref_id' => 'extra_curricular',
            'user_photo' => 'profile_picture',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     * Return list of student for individual tracking module
     */
    public function customSearch($InstituteId) {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->join = ' INNER JOIN tbl_si_students as tss ON tss.user_ref_id = t.user_id INNER JOIN login_master as lm ON lm.login_id = t.login_ref_id';
        $criteria->condition = "tss.inst_ref_id = :value";
        $criteria->params = array(":value" => $InstituteId);

        $criteria->compare('user_id', $this->user_id, true);

        if ($this->first_name != '') {
            $criteria2 = new CDbCriteria;

            $criteria2->compare('first_name', $this->first_name, true, 'OR');
            $criteria2->compare('last_name', $this->first_name, true, 'OR');

            $namePart = explode(" ", $this->first_name, 2);
            if (count($namePart) > 1) {
                $criteria2->compare('first_name', $namePart[0], true, 'OR');
                $criteria2->compare('last_name', $namePart[1], true, 'OR');
            }

            $criteria2->compare('lm.username', $this->first_name, true, 'OR');
            $criteria->mergeWith($criteria2);
        }
        //$criteria->compare('first_name',$this->first_name,true);

        $criteria->compare('present_class', $this->present_class);
        $criteria->compare('present_board_ref_id', $this->present_board_ref_id);
        $criteria->order = "first_name, last_name ASC";
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('passout_year, passout_month', 'required'),
            array('first_name, last_name, gender', 'required', 'on' => 'EditProfile'),
            array('dob', 'checkDOB', 'on' => 'EditProfile'),
            array('membership_ref_id, city_ref_id, state_ref_id, country_ref_id, present_board_ref_id, school_ref_id, passout_year, passout_month, ethnicity_ref_id, family_income_ref_id, primary_financing_ref_id, scholarship_importance_ref_id, reason_study_abroad_ref_id, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, book_session_count, critical_percent, recommended_percent', 'numerical', 'integerOnly' => true),
            array('login_ref_id', 'length', 'max' => 10),
            array('uno', 'length', 'max' => 15),
            array('user_photo', 'length', 'max' => 255),
            array('first_name, middle_name, last_name', 'length', 'max' => 100),
            array('father_first_name, father_last_name, mother_first_name, mother_last_name, guardian_first_name, guardian_last_name', 'length', 'max' => 75),
            //array('address1, address2, city, state', 'length', 'max'=>200),
            array('address1, address2, other_activities,ps_leadership', 'length', 'max' => 200),
            array('post_code', 'length', 'max' => 12),
            array('present_class', 'length', 'max' => 2),
            array('class_status', 'length', 'max' => 9),
            array('gender, is_newsletter_subscribe, new_password, is_valid_email', 'length', 'max' => 1),
            array('dob, ps_why_this_subject, ps_leadership, other_activities, introduce_yourself, added_on, modified_on, profile_complete_date, user_id,ps_leadership,signup_source_ref_id', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('user_id, login_ref_id, membership_ref_id, uno, user_photo, first_name, middle_name, last_name, father_first_name, father_last_name, mother_first_name, mother_last_name, address1, address2, city_ref_id, state_ref_id, country_ref_id, post_code, present_class, class_status, present_board_ref_id, school_ref_id, passout_year, passout_month, dob, gender, ethnicity_ref_id, family_income_ref_id, primary_financing_ref_id, scholarship_importance_ref_id, reason_study_abroad_ref_id, ps_why_this_subject, ps_leadership, introduce_yourself, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, is_newsletter_subscribe, added_on, modified_on, new_password, book_session_count, is_valid_email, profile_complete_date, critical_percent, recommended_percent, is_visited_school,is_location_entered, know_your_subjects', 'safe', 'on' => 'search'),
        );
    }

    public function beforeSave() {
        try {
            if ($this->isNewRecord) {
                $ctrlname = Yii::app()->controller->id;
                if (isset(Yii::app()->session['login_track']) && ($ctrlname == "createProfile" || $ctrlname == "facebook")) {
                    $ctrlname = Yii::app()->session['login_track'];
                    unset(Yii::app()->session['login_track']);
                } else if (isset(Yii::app()->session['login_track']) && Yii::app()->session['login_track'] == "Contact details") {
                    $ctrlname = "College page";
                    unset(Yii::app()->session['login_track']);
                }
                $this->signup_source_ref_id = 1;                
                switch ($ctrlname) {
                    case "index":
                        $ctrlname = "Test page";
                        break;
                    case "Unipagination":
                        $ctrlname = "College page";
                        break;
                    case "premiumService":
                        $ctrlname = "Gem Service";
                        break;
                    case "default":
                        $ctrlname = "Gem Service";
                        break;
                    case "unipageaction":
                        $ctrlname = "College Search";
                        break;
                    case "profile":
                        $ctrlname = "College Discussion Page";
                        break;
                    default:
                        $ctrlname = $ctrlname;
                }
               
                if(isset($_SESSION['index_foo']) && $_SESSION['index_foo']==1){
                    $ctrlname="HomepageV2";
                    $_SESSION['index_foo']=0;
                }

                $where = 'source_name like "%' . $ctrlname . '%"';
                $source_id = Yii::app()->db->createCommand()
                        ->select('signup_source_id')
                        ->from('lookup_signup_source')
                        ->where($where)
                        ->queryRow();
                if (!empty($source_id)) {
                    $this->signup_source_ref_id = $source_id['signup_source_id'];
                    if ($source_id['signup_source_id'] == 2) {
                        $hostName = explode(".", $_SERVER['HTTP_HOST']);
                        if ($hostName[0] != "www") {
                            $this->signup_source_ref_id = 20; //B2B signup.
                        }
                    }
                }
                
                $this->source_device = Yii::app()->mobileDetect->isMobile() ? 'Mobile' : 'Desktop';
            }
            return true;
        } catch (Exception $ex) {
            echo $ex;
        }
        
        return true;
    }

    public function checkDOB($attribute, $params) {
        $postData = Yii::app()->request->getPost('TblUserMaster');
        $day = $postData['dob_date'];
        $month = $postData['dob_month'];
        $year = $postData['dob_year'];
        if ($day != '' || $month != '' || $year != '') {
            if ($day == '') {
                $this->addError('dob_date', 'Select a valid birth date ');
            }
            if ($month == '') {
                $this->addError('dob_month', 'Select a valid birth month ');
            }
            if ($year == '') {
                $this->addError('dob_year', 'Select a valid birth year ');
            }
//                if(!@checkdate($month,$day,$year)) {
//                    $this->addError($attribute, 'Select a valid birth date ');
//                }
        }
    }

    /**
     * Retrieves a distinct list of board for $InstituteId.
     * @param integer $InstituteId id of institute
     * @return array of distinct list of board.
     */
    public function getDistinctBoardListForInstitute($InstituteId) {
        $boardList = Yii::app()->db->createCommand()
                ->selectDistinct('board_name')
                ->select('board_id, board_name')
                ->from('tbl_user_master u')
                ->join('lookup_board lb', 'u.present_board_ref_id = lb.board_id')
                ->join('tbl_si_students tss', 'u.user_id = tss.user_ref_id')
                ->where(array("and", "tss.inst_ref_id=:instId", "present_board_ref_id != ''"), array(':instId' => $InstituteId))
                //->where("and","present_board_ref_id != ''")
                ->order("board_name asc")
                ->queryAll();
        return $boardList;
    }

    /**
     * Retrieves a distinct list of class for $InstituteId.
     * @param integer $InstituteId id of institute
     * @return array of distinct list of class.
     */
    public function getDistinctClassForInstitute($InstituteId) {
        $classList = Yii::app()->db->createCommand()
                ->selectDistinct('present_class')
                ->from('tbl_user_master u')
                ->join('tbl_si_students tss', 'u.user_id = tss.user_ref_id')
                ->where(array("and", "tss.inst_ref_id=:instId", "present_class != ''"), array(':instId' => $InstituteId))
                //->where("present_class != ''")
                ->order("present_class asc")
                ->queryAll();
        return $classList;
    }

    public function getPreferredCountries() {
        $countries = $this->studentPreferredCountries;
        //echo "<pre>"; print_r($countries); exit;
        $data = array();

        foreach ($countries as $country) {
            $data[$country->country_ref_id] = $country->countryRef->country_name;
        }

        return $data;
    }

    public function getHypothesisCountries() {
        $countries = $this->studentHypothesisCountries;
        $data = array();

        foreach ($countries as $country) {
            $data[$country->country_ref_id] = $country->countryRef->country_name;
        }

        return $data;
    }

    public function getPreferredCourses() {
        $courses = $this->studentPreferredDepartments;
        $data = array();

        foreach ($courses as $course) {
            $data[$course->preferred_department_id]['name'] = $course->subDeptRef->department_name;
            $data[$course->preferred_department_id]['main_dept_ref_id'] = $course->main_dept_ref_id;
            $data[$course->preferred_department_id]['sub_dept_ref_id'] = $course->sub_dept_ref_id;
            $data[$course->preferred_department_id]['course_ref_id'] = $course->course_ref_id;
        }

        return $data;
    }

    public function getHypothesisCourses() {
        $courses = $this->studentHypothesisDepartments;
        $data = array();

        foreach ($courses as $course) {
            $data[$course->student_hypothesis_department_id]['name'] = $course->subDeptRef->department_name;
            $data[$course->student_hypothesis_department_id]['main_dept_ref_id'] = $course->main_dept_ref_id;
            $data[$course->student_hypothesis_department_id]['sub_dept_ref_id'] = $course->sub_dept_ref_id;
        }

        return $data;
    }

    public function getPreferredCareers($getIdAsKey = false) {
        $careers = $this->studentPreferredCareers;
        $data = array();

        foreach ($careers as $career) {
            if ($getIdAsKey)
                $data[$career->career_ref_id] = $career->careerRef->career_name;
            else
                $data[] = $career->careerRef->career_name;
        }
        return $data;
    }

    public function setPreferredCountries($list, $loggedFor = null) {
        $currentList = array_flip($this->getPreferredCountries());

        $log = array_diff($list, $currentList);
        if (count($log) == 0) {
            //return true;
        }

        try {
            // delete the existing preferred list and insert new one
            foreach ($this->studentPreferredCountries as $spc) {
                $spc->delete();
            }

            // inserting the preferred list
            $i = 1;
            foreach ($list as $val) {
                $spc = new StudentPreferredCountry();
                $spc->country_ref_id = $val;
                $spc->user_ref_id = $this->user_id;
                $spc->preference_order = $i++;
                $spc->save(false);
            }

            // inserting the preferred list
            foreach ($currentList as $val) {
                $spc = new StudentPreferredCountryLog();
                $spc->country_ref_id = $val;
                $spc->user_ref_id = $this->user_id;
                $spc->logged_for = $loggedFor;
                $spc->save(false);
            }
        } catch (Exception $e) {
            return $e->getMessage();
        }

        return true;
    }

    public function setPreferredCourses($list, $loggedFor = null) {
        $currentList = $this->getPreferredCourses();

        $l = array();
        $c = array();
        foreach ($currentList as $k => $v)
            $c[] = $v['sub_dept_ref_id'];
        foreach ($list as $k => $v)
            $l[] = $v['sub_dept_ref_id'];
        $log = array_diff($l, $c);

        if (count($log) == 0) { // if no changes are done, dont add to log
            //return true;
        }
        try {
            // delete the existing preferrelist and insert new one
            foreach ($this->studentPreferredDepartments as $spc) {
                $spc->delete();
            }

            // inserting the preferred list
            foreach ($list as $val) {
                $spc = new StudentPreferredDepartment();
                $spc->main_dept_ref_id = $val['main_dept_ref_id'];
                $spc->sub_dept_ref_id = $val['sub_dept_ref_id'];
                $spc->user_ref_id = $this->user_id;
                $spc->save(false);
            }

            // inserting the preferred list
            foreach ($currentList as $val) {
                $spc = new StudentPreferredDepartmentLog();
                $spc->main_dept_ref_id = $val['main_dept_ref_id'];
                $spc->sub_dept_ref_id = $val['sub_dept_ref_id'];
                $spc->user_ref_id = $this->user_id;
                $spc->logged_for = $loggedFor;
                $spc->save(false);
            }
        } catch (Exception $e) {
            return $e->getMessage();
            // 		 return false;
        }

        return true;
    }

    public function setPreferredCareers($list) {
        $currentList = $this->getPreferredCourses();


        try {
            // delete the existing preferrelist and insert new one
            foreach ($this->studentPreferredCareers as $spc) {
                $spc->delete();
            }

            // inserting the preferred list
            foreach ($list as $key => $val) {
                $spc = new StudentPreferredCareer();
                $spc->career_ref_id = $key;
                $spc->user_ref_id = $this->user_id;
                $spc->save(false);
            }
        } catch (Exception $e) {
            //echo $e->getMessage();
            return false;
        }
        return true;
    }

    public function getName() {
        return $this->first_name . ' ' . $this->last_name;
    }

    public function getStudentSi() {
        $sql = "select s.inst_ref_id as id, si.inst_name as name from tbl_si_students s, tbl_si_di si where s.inst_ref_id= si.inst_id AND s.user_ref_id=" . $this->user_id;
        //	$sql = "select s.inst_ref_id, si.inst_name from tbl_si_students s, tbl_si_di si where s.inst_ref_id= si.inst_id AND s.user_ref_id=90";
        $rs = Yii::app()->db->createCommand($sql)->query();

        foreach ($rs as $row) {
            return $row;
        }
    }

    public function getUnreadUmails() {
        $sql = "SELECT COUNT(*) as count FROM umail_header UH LEFT JOIN umail_message UM ON UM.header_ref_id = UH.header_id WHERE UM.recipient_id = '" . $this->user_id . "' AND UH.sender_type = 1 AND UH.status = 'Replied' AND UM.added_on = (SELECT added_on from umail_message where header_ref_id = UH.header_id ORDER BY added_on DESC LIMIT 0, 1) ORDER BY UM.added_on DESC";
        /* $sql = "SELECT COUNT(*) as count
          FROM umail_message
          WHERE sender_type = 1
          AND recipient_id = ".$this->user_id."
          AND `status` IN ('Replied')"; */
        //	$sql = "select s.inst_ref_id, si.inst_name from tbl_si_students s, tbl_si_di si where s.inst_ref_id= si.inst_id AND s.user_ref_id=90";
        $rs = Yii::app()->db->createCommand($sql)->query();

        foreach ($rs as $row) {
            //print_r($row);
            if ($row['count']) {
                return $row['count'];
            } else {
                return 0;
            }
        }
    }

    public static function getUserDetails($userId = 0) {
        $modelUserMaster = self::model()->find(array("condition" => "user_id = " . $userId));
        if (!empty($modelUserMaster)) {
            return $modelUserMaster;
        } else {
            return false;
        }
    }

    static function getL2Keys($array) {
        $result = array();
        foreach ($array as $sub) {
            $result[] = $sub->attributes['label'];
        }
        return array_values($result);
    }

    static function calcCriticalPercent($user_ref_id) {
        //$userSession = unserialize($_SESSION['sUserUnivariety']);
        //
		if (!$user_ref_id) {
            $user_ref_id = Profile::getUserId();
        }
        if (isset($user_ref_id)) {
            $k = new TblUserProfCriticalCompletion;
            $totalCols = array_keys($k->tableSchema->columns);
            $Cols12th = self::getL2Keys(LookupUrl::model()->findAll(array('condition' => 'class_level=12 AND type_of_field = "critical" ', 'select' => 'label')));
            $Cols9th = self::getL2Keys(LookupUrl::model()->findAll(array('condition' => 'class_level=9 AND type_of_field = "critical" ', 'select' => 'label')));
            $commonCols = array_diff($totalCols, $Cols12th, $Cols9th);
            $maxCols12 = array_merge($commonCols, $Cols12th);
            $maxCols9 = array_merge($commonCols, $Cols9th);
            $maxCols = count($maxCols12) - 1;
            $maxColsArr = $maxCols12;
            if (Profile::isTenth($user_ref_id)) {
                $maxCols = count($maxCols9) - 1;
                $maxColsArr = $maxCols9;
            }
            //	$maxCols = count($k->tableSchema->columns)-3;
            $current = 0;
            $round = 0;
            $percentage = 0;
            $ucp = TblUserProfCriticalCompletion::model()->findByAttributes(array('user_ref_id' => $user_ref_id));

            if (isset($ucp)) {
                //	echo 'inside';
                foreach ($ucp->attributes as $key => $atr) {
                    if ($atr == 1 && $round != 0 && in_array($key, $maxColsArr)) {
                        //$this->printr($atr);
                        $current++;
                    }
                    $round++;
                }
                //echo $round;
                //echo $user_ref_id.'<br />';
                $percentage = floor(($current * 100) / $maxCols);
                $criteria = new CDbCriteria;
                $criteria->condition = 'user_id = ' . $user_ref_id;
                $temp_arr = Profile::model()->findByPk($user_ref_id);
                $curr_label = Profile::manualRedirectId($user_ref_id);
                $a = '';
                $LookupUrlSearch = LookupUrl::model()->find(array('condition' => 'label = "' . $curr_label . '"'));
                (isset($LookupUrlSearch)) ? $a = $LookupUrlSearch->attributes['url_id'] : '';

                //$a = $temp_arr['redirect_url_ref_id']+1;
                $temp_arr['critical_percent'] = round($percentage);
                //if($a <= 8) {
                //$temp_arr['redirect_url_ref_id'] = $a;
                //}
                //	$ucp->attributes = $temp_arr;
                //	echo '<br />'.$percentage;
                //$this->printr($temp_arr->attributes);
                //$this->printr($ucp->attributes);
                if (!($temp_arr->validate() && $temp_arr->save())) {
                    throw new CHttpException(400, 'Illegal request. Make sure you access the site properly.');
                } else {
                    //$this->printr($temp_arr->attributes);
                }
            }
        } else {
            
        }
    }

    /**
     * Returns true if country preference is set to Not sure else false
     * @return boolean
     */
    public function isCountryPreferenceNotSure() {
        if (count($this->studentPreferredCountries) == 1) {
            $row = $this->studentPreferredCountries[0];
            if ($row->not_sure == 1 || empty($row->country_ref_id)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Returns true if department preference is set to Not sure else false
     * @return boolean
     */
    public function isDepartmentPreferenceNotSure() {
        if (count($this->studentPreferredDepartments) == 1) {
            $row = $this->studentPreferredDepartments[0];
            if ($row->not_sure == 1 || (empty($row->main_dept_ref_id) && empty($row->sub_dept_ref_id))) {
                return true;
            }
        }
        return false;
    }

    /**
     * Returns true if career preference is set to Not sure else false
     * @return boolean
     */
    public function isCareerPreferenceNotSure() {
        if (count($this->studentPreferredCareers) == 1) {
            $row = $this->studentPreferredCareers[0];
            if ($row->not_sure == 1 || empty($row->career_ref_id)) {
                return true;
            }
        }
        return false;
    }

    //TODO: #994 removed 'father_email,mother_email' field
    public function getParentEmail($UserId = false) {
        global $db;
        $fldUserName = "";

        $sqlSelect = "SELECT LC.contact_type, SAE.email_id,SAE.contact_type_ref_id FROM student_alternate_email SAE 
					   LEFT JOIN  lookup_contact_type LC ON SAE.contact_type_ref_id = LC.contact_type_id WHERE SAE.login_ref_id = '" . $UserId . "'
					   AND SAE.contact_type_ref_id != 1 ORDER BY SAE.contact_type_ref_id";
        $cmd = Yii::app()->db->createCommand($sqlSelect);
        $res = $cmd->queryAll();

        if ($res > 0) {
            $comma = '';
            for ($i = 0; $i < count($res); $i++) {
                $fldUserName .= $comma . $res[$i]['email_id'];
                $comma = ',';
            }
            return $fldUserName;
        }
        /* 		 if($res > 0)
          {
          $row	= $res[0];
          if(strlen($row['father_email']) > 0 && strlen($row['mother_email']) > 0)
          $fldUserName = $row['father_email'].",".$row['mother_email'];

          else if(strlen($row['father_email']) > 0)
          $fldUserName = $row['father_email'];

          else if(strlen($row['mother_email']) > 0)
          $fldUserName = $row['mother_email'];

          return $fldUserName;
          } */
    }

    public function getUmailHeaderUserDetails($headerId = false) {

        $sql = "SELECT us.first_name,us.user_id,us.last_name,us.user_photo,us.present_class,lb.board_name,umil.milestone_id,lm.username,us.gender  FROM umail_header uh
			 LEFT JOIN tbl_user_master us ON us.user_id = uh.sender_id AND sender_type = 1
			 LEFT JOIN login_master lm ON lm.login_id = us.login_ref_id
			 LEFT JOIN lookup_board lb ON lb.board_id = us.present_board_ref_id
			 LEFT JOIN user_milestone umil ON umil.user_ref_id = us.user_id 
 			 WHERE uh.header_id = '" . $headerId . "'";

        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();

        if ($res) {
            return $res;
        }
    }

    public function getUserMilestone($userRefId = false) {
        $sql = "SELECT DISTINCT user_ref_id,
				  CASE
				  WHEN ( MAX(milestone_id) = 61 OR MAX(milestone_id) = 62 OR MAX(milestone_id) = 63) THEN 5
				  ELSE MAX(milestone_id)
				  END AS milestone
				     FROM user_milestone
				 WHERE `status` = 'Confirmed' AND user_ref_id = '" . $userRefId . "'
				 GROUP BY user_ref_id";

        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    /*
     * Function to validate email and also check csv file for proper values
     */

    public function studentMasterValidate($attribute, $params) {

        $schoolBoard = LookupBoard::GetSchoolBoard($attribute['board'], $attribute['instId']);

        if ($attribute['studyLevel'] != '11' && $attribute['studyLevel'] != '12' && $attribute['studyLevel'] != '9' && $attribute['studyLevel'] != '10') {
            $this->addError('present_class', 'Please upload csv with current study level as 9/10/11/12 in row ' . $attribute['currRow']);
            return false;
        } else if ($attribute['status'] != 'Complete' && $attribute['status'] != 'Pursuing') {
            $this->addError('present_status', 'Please upload csv with status as Complete/Pursuing in row ' . $attribute['currRow']);
            return false;
        } else if ($attribute['gender'] != 'Male' && $attribute['gender'] != 'Female') {
            $this->addError('gender', 'Please upload csv with gender as Male/Female in row ' . $attribute['currRow']);
            return false;
        } else if ($schoolBoard == 0) {
            $this->addError('present_board_ref_id', 'Please upload csv with valid board/curriculum in row ' . $attribute['currRow']);
            return false;
        } else {
            return true;
        }
    }

    public function getManageUsersSearch($siRefId = 0, $limitStart = 0, $limitEnd = 6, $searchParams = array()) {
        $condition = '';
        $sql = "SELECT DISTINCT(um.user_id) user_id, um.first_name, um.last_name, um.present_class, lb.board_name, lb.board_desc,tss.inst_ref_id,
				-- (SELECT CONCAT(GROUP_CONCAT(DISTINCT(country_ref_id)), '#_#', not_sure) FROM student_preferred_country WHERE user_ref_id = user_id ORDER BY preference_order) newcountry_ref_id,
				-- (SELECT CONCAT(GROUP_CONCAT(DISTINCT(main_dept_ref_id)), '#_#', not_sure) FROM student_preferred_department WHERE user_ref_id = user_id ORDER BY preference_order) newdept_ref_id,
				um.critical_percent, um.user_photo, um.gender, lm.username
				FROM tbl_si_students tss
				LEFT JOIN tbl_user_master um ON um.user_id = tss.user_ref_id
				LEFT JOIN login_master lm on lm.login_id = um.login_ref_id
				LEFT JOIN student_preferred_country spc ON spc.user_ref_id = um.user_id
				LEFT JOIN student_preferred_department spd ON spd.user_ref_id = um.user_id
				LEFT JOIN tbl_country_master cm ON spc.country_ref_id = cm.country_id
				LEFT JOIN lookup_board lb ON lb.board_id = um.present_board_ref_id
				WHERE tss.inst_ref_id = :siRefId";
        if (@$searchParams['userId'] != '') {
            $condition .= " AND um.user_id IN (" . $searchParams['userId'] . ")";
        }
        if (@$searchParams['classLevel'] != '') {
            $condition .= " AND um.present_class IN (" . $searchParams['classLevel'] . ")";
        }

        if (@$searchParams['board'] != '') {
            $condition .= " AND lb.board_id IN (" . $searchParams['board'] . ")";
        }

        if (@$searchParams['country'] != '') {
            $condition .= " AND spc.country_ref_id = '" . $searchParams['country'] . "'";
        }

        if (@$searchParams['preference_order'] != '') {
            $condition .= " AND spc.preference_order = '" . $searchParams['preference_order'] . "'";
        }

        if (@$searchParams['department'] != '') {
            $condition .= " AND spd.main_dept_ref_id = '" . $searchParams['department'] . "'";
        }

        if (@$searchParams['profile_percent'] != '') {
            $condition .= " AND um.critical_percent " . $searchParams['profile_percent'];
        }

        if (@$searchParams['users_joined'] != '') {
            $days = $searchParams['users_joined'];
            if ($days > 0) {
                $condition .= " AND um.added_on >= DATE_SUB(CURDATE(), INTERVAL " . $days . " DAY)";
            }
            if ($days < 0) {
                $days = ($days * $days) + $days; //changing -ve to +ve number. ex: (-2 * -2) + (-2) = 2
                $condition .= " AND um.added_on < DATE_SUB(CURDATE(), INTERVAL " . $days . " DAY)";
            }
        }
        if ($condition != '') {
            $sql .= $condition;
        }

        $sql .= " ORDER BY um.first_name ASC LIMIT " . $limitStart . "," . $limitEnd;

        $cmd = Yii::app()->db->createCommand($sql);
        $cmd->bindValue(":siRefId", $siRefId, PDO::PARAM_INT);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getUserClassLevels($siRefId) {
        $sql = "SELECT DISTINCT(um.present_class) present_class FROM tbl_si_students sis
				LEFT JOIN tbl_user_master um ON sis.user_ref_id = um.user_id
				WHERE sis.inst_ref_id = :siRefId 
				AND um.present_class IS NOT NULL 
				AND um.present_class != '' 
				ORDER BY um.present_class";
        $cmd = Yii::app()->db->createCommand($sql);
        $cmd->bindValue(":siRefId", $siRefId, PDO::PARAM_INT);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function searchStudentsByNameEmails($siRefId = 0, $query = '') {
        $sql = "SELECT CONCAT(um.first_name, ' ',um.last_name) student_name, um.user_id, (1=1) username 
				FROM tbl_si_students sis 
				LEFT JOIN tbl_user_master um  ON sis.user_ref_id = um.user_id 
				WHERE (um.first_name LIKE '%" . $query . "%' OR um.last_name LIKE '%" . $query . "%') AND sis.inst_ref_id = '" . $siRefId . "'
				UNION
				SELECT (1=1) student_name, um.user_id, lm.username 
				FROM tbl_si_students sis 
				LEFT JOIN tbl_user_master um ON um.user_id = sis.user_ref_id
				LEFT JOIN login_master lm ON lm.login_id = um.login_ref_id
				WHERE  (lm.user_type_ref_id=1 AND lm.username LIKE '%" . $query . "%') AND sis.inst_ref_id = '" . $siRefId . "'
				ORDER BY student_name,username";
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    /*
     * Counting total number of students of a school with the given percentage
     * Input should be like "0-25", "26-50"...etc
     */

    public static function getTotalStudentsByProfilePercent($siRefId = 0, $percentage = '') {
        $count = 0;
        $res = NULL;
        if ($percentage != '') {
            $condition = ' AND um.critical_percent BETWEEN ' . str_replace('-', ' AND ', $percentage);
            $sql = "SELECT COUNT(DISTINCT(um.user_id)) total_students 
					FROM tbl_si_students tss
					LEFT JOIN tbl_user_master um ON um.user_id = tss.user_ref_id
					WHERE tss.inst_ref_id = :siRefId" . $condition;
            $cmd = Yii::app()->db->createCommand($sql);
            $cmd->bindValue(":siRefId", $siRefId, PDO::PARAM_INT);
            $res = $cmd->queryAll();
            foreach ($res as $val) {
                $count = $val['total_students'];
            }
        }
        return $count;
    }

    public static function updateUserFields($userId = 0, $fields = array()) {
        $model = self::model()->findAllByPk($userId);
        if (!$model) {
            $model = new TblUserMaster();
            $model->attributes = $fields;
            $model->save(false);
        } else {
            $model = new TblUserMaster();
            //$model->updateAll($fields);
            $model->updateByPk($userId, $fields);
        }
    }

    public static function getUserInformation($userId) {
        $userInfo = array();
        $modelUserInfo = self::model()->findAllByPk($userId);
        foreach ($modelUserInfo as $userValues) {
            $userInfo = $userValues->attributes;
        }
        return $userInfo;
        /* if(count($requiredFields)>0){
          $cdbCriteria->select = implode(',', $requiredFields);
          } */
    }

// Reports- start                
    public static function getInstitutes() {
        $sql = "SELECT inst_id,inst_name from tbl_si_di ORDER BY inst_name";
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getInstituteUserCount($instId, $start, $end) {

        $sql = "SELECT inst_ref_id FROM tbl_user_master t
                    JOIN tbl_si_students ts ON t.user_id=ts.user_ref_id
                    WHERE t.profile_status_ref_id in (1,3) AND critical_percent BETWEEN $start AND $end  AND ts.inst_ref_id=$instId";
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
        //CVarDumper::dump($res,10,true); exit;        
    }

    public static function getTotalInstituteUserCount($instId) {

        $sql = "SELECT inst_ref_id FROM tbl_user_master t
                    JOIN tbl_si_students ts ON t.user_id=ts.user_ref_id
                    WHERE ts.inst_ref_id=$instId AND t.profile_status_ref_id in (1,3)";
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getClasswiseCount($InstId, $start, $end) {

        if ($start && $end && $InstId) {
            if ($start == 1) {
                $start = 0;
            }
            $sql = "SELECT COUNT(present_class) AS ClassCount,present_class FROM tbl_user_master t
                INNER JOIN tbl_si_students ts ON t.user_id=ts.user_ref_id
                WHERE  inst_ref_id = '$InstId' AND present_class!='' AND t.profile_status_ref_id in (1,3) AND critical_percent BETWEEN '$start' AND '$end' GROUP BY present_class";
        } else {
            $sql = "SELECT present_class FROM tbl_user_master t WHERE  present_class!='' AND t.profile_status_ref_id in (1,3) GROUP BY present_class";
        }
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getClasswisecreticalCount($InstId, $start, $end, $class) {
        if ($end && $InstId && $class) {
            $sql = "SELECT present_class 
                        FROM tbl_user_master t 
                        INNER JOIN tbl_si_students ts ON t.user_id=ts.user_ref_id 
                        WHERE ts.inst_ref_id = '$InstId'  AND present_class !='' AND t.profile_status_ref_id in (1,3) AND critical_percent BETWEEN '$start' AND '$end'  AND t.present_class='$class'";
        } else {
            $sql = "SELECT present_class 
                        FROM tbl_user_master t 
                        INNER JOIN tbl_si_students ts ON t.user_id=ts.user_ref_id 
                        WHERE ts.inst_ref_id = '$InstId' AND t.profile_status_ref_id in (1,3) AND present_class !='' ";
        }
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getMembershipId($userId = 0) {
        $result = self::model()->find("user_id = '" . $userId . "'");
        if ($result) {
            return $result->attributes['membership_ref_id'];
        } else {
            return false;
        }
    }

    // Reports - end

    public function studentProfileValidateSearch() {

        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->with = array('loginRef');
        $cdbCriteria->compare("loginRef.is_active", 1);

        $cdbCriteria->addInCondition("t.profile_status_ref_id", array(1, 3), "AND");

        $cdbCriteria->compare("loginRef.user_type_ref_id", 1);
        if ($this->first_name != '')
            $cdbCriteria->addCondition("(t.first_name like '%$this->first_name%' OR t.last_name like '%$this->first_name%')", "AND");

        if ($_GET['loginRef']['is_email_confirmed'] != '')
            $cdbCriteria->addCondition("loginRef.is_email_confirmed = " . $_GET['loginRef']['is_email_confirmed'], "AND");

        if ($_GET['loginRef']['is_class_status_confirmed'] != '')
            $cdbCriteria->addCondition("loginRef.is_class_status_confirmed = " . $_GET['loginRef']['is_class_status_confirmed'], "AND");

        if ($_GET['loginRef']['is_preference_confirmed'] != '')
            $cdbCriteria->addCondition("loginRef.is_preference_confirmed = " . $_GET['loginRef']['is_preference_confirmed'], "AND");

        if (isset($_GET['present_class'])) {
            switch ($_GET['present_class']) {
                case '9p': {
                        $cdbCriteria->addCondition("t.present_class = '9' AND t.class_status = 'Pursuing'", "AND");
                        break;
                    }
                case '10p': {
                        $cdbCriteria->addCondition("t.present_class = '10' AND t.class_status = 'Pursuing'", "AND");
                        break;
                    }
                case '11p': {
                        $cdbCriteria->addCondition("t.present_class = '11' AND t.class_status = 'Pursuing'", "AND");
                        break;
                    }
                case '12p': {
                        $cdbCriteria->addCondition("t.present_class = '12' AND t.class_status = 'Pursuing'", "AND");
                        break;
                    }
                case '12c': {
                        $cdbCriteria->addCondition("t.present_class = '12' AND t.class_status = 'Completed'", "AND");
                        break;
                    }
            }
        }

        if (isset($_GET['membership_ref_id']) && $_GET['membership_ref_id'] != '') {
            $cdbCriteria->addCondition("t.membership_ref_id = " . $_GET['membership_ref_id'], "AND");
        }


        $cdbCriteria->order = "t.first_name, t.last_name ASC";

        return new CActiveDataProvider($this, array(
            'criteria' => $cdbCriteria,
            'pagination' => array(
                'pageSize' => 30,
                'pageVar' => 'page',
            ),
        ));
    }

    public static function phraseClassLevel($classLevel = '', $status = '') {
        if ($classLevel != '') {
            return $classLevel . '<sup>th</sup> ' . $status;
        } else {
            return '--';
        }
    }

    public static function phraseName($firstName = '', $lastName = '') {
        if ($firstName == '' && $lastName == '') {
            return 'Unknown';
        } elseif ($firstName != '') {
            return CHtml::encode($firstName . ' ' . $lastName);
        } else {
            return '--';
        }
    }

    public static function prepareStudentMembershipType($membershipRef = 0) {
        switch ($membershipRef) {
            case 1: {
                    return 'Guest';
                    break;
                }
            case 2: {
                    return 'SI';
                    break;
                }
            case 3: {
                    return 'GEM';
                    break;
                }
            case 4: {
                    return 'SI & GEM';
                    break;
                }
        }
    }

    public static function displayDate($date = '', $dateFormat = '') {
        if ($date != '') {
            return date($dateFormat, strtotime($date));
        }
    }

    /*
     *  Update the critical fields
     */

    public static function getAndUpdateCriticalFields($userid) {

        $details = TblUserMaster::model()->findByPk($userid);
        if (!empty($details->present_class)) {

            $criticalFields['country'] = StudentPreferredCountry::model()->count('user_ref_id=:userid', array('userid' => $userid));
            $criticalFields['name'] = TblUserMaster::model()->count(array('condition' => 'user_id=' . $userid . ' AND first_name!="" AND last_name!="" '));
            $criticalFields['dob'] = TblUserMaster::model()->count(array('condition' => 'user_id=' . $userid . ' AND dob!="" '));
            $criticalFields['gender'] = TblUserMaster::model()->count(array('condition' => 'user_id=' . $userid . ' AND gender!="" '));
            $criticalFields['phone'] = StudentContactNumber::model()->count('user_ref_id=:userid AND is_primary=1', array('userid' => $userid));

            $criticalFields['citizenship'] = StudentCitizenship::model()->count('user_ref_id=:userid', array('userid' => $userid));

            $criticalFields['edu_study_level'] = StudentEducation::model()->count(array('condition' => 'user_ref_id=' . $userid . ' AND class_level!="" '));
            $criticalFields['school_name'] = StudentEducation::model()->count(array('condition' => 'user_ref_id=' . $userid . ' AND school_name!="" '));
            $criticalFields['completion_year'] = StudentEducation::model()->count(array('condition' => 'user_ref_id=' . $userid . ' AND year!="" '));
            $criticalFields['board'] = StudentEducation::model()->count(array('condition' => 'user_ref_id=' . $userid . ' AND board_ref_id!="" '));

            if ($details->present_class == '9' || $details->present_class == '10') {

                $criticalFields['curriculum'] = StudentPreferredBoard::model()->count('user_ref_id=:userid', array('userid' => $userid));
                $criticalFields['career'] = StudentPreferredCareer::model()->count('user_ref_id=:userid', array('userid' => $userid));
                $criticalFields['like_subjects'] = StudentPreferredSubject::model()->count('user_ref_id=:userid', array('userid' => $userid));
                $criticalFields['interest'] = TblUserInterest::model()->count('user_ref_id=:userid', array('userid' => $userid));

                if ($details->membership_ref_id == 2) {
                    $lookupUrls = LookupUrl::getRedirectAllUrls(9, 'critical');
                    foreach ($lookupUrls as $urlDetails) {
                        if ($criticalFields[$urlDetails->attributes['label']] < 1) {
                            self::updateRedirectUrlRefId($userid, $urlDetails->attributes['url_id']);
                        }
                    }
                }
                if ($details->critical_percent > 74 || $details->membership_ref_id != 2) {
                    self::updateRedirectUrlRefId($userid, 14);
                }
            } elseif ($details->present_class == '11' || $details->present_class == '12') {
                $criticalFieldsArray[12] = array('phone',
                    'edu_study_level', 'school_name', 'completion_year', 'board',
                    'intended_subjects',
                    'country', 'likely_start_period', 'study_level', 'preferred_course_duration',
                    'name', 'dob', 'gender', 'citizenship');

                $criticalFields['likely_start_period'] = StudentPreferredPeriod::model()->count('user_ref_id=:userid', array('userid' => $userid));
                $criticalFields['study_level'] = StudentPreferredStudyLevel::model()->count('user_ref_id=:userid', array('userid' => $userid));
                $criticalFields['preferred_course_duration'] = StudentPreferredDuration::model()->count('user_ref_id=:userid', array('userid' => $userid));
                $criticalFields['intended_subjects'] = StudentPreferredDepartment::model()->count('user_ref_id=:userid', array('userid' => $userid));

                if ($details->membership_ref_id == 2) {
                    $lookupUrls = LookupUrl::getRedirectAllUrls(12, 'critical');
                    if ($criticalFields['phone'] < 1) {
                        self::updateRedirectUrlRefId($userid, $lookupUrls[0]->url_id);
                    } elseif ($criticalFields['edu_study_level'] < 1 || $criticalFields['school_name'] < 1 || $criticalFields['completion_year'] < 1 || $criticalFields['board'] < 1) {
                        self::updateRedirectUrlRefId($userid, $lookupUrls[1]->url_id);
                    } elseif ($criticalFields['intended_subjects'] < 1) {
                        self::updateRedirectUrlRefId($userid, $lookupUrls[2]->url_id);
                    } elseif ($criticalFields['country'] < 1 || $criticalFields['likely_start_period'] < 1 || $criticalFields['study_level'] < 1 || $criticalFields['preferred_course_duration'] < 1) {
                        self::updateRedirectUrlRefId($userid, $lookupUrls[3]->url_id);
                    }
                }
                if ($details->critical_percent > 74 || $details->membership_ref_id != 2) {
                    self::updateRedirectUrlRefId($userid, 14);
                }
            }
            echo '<pre>';
            print_r($criticalFields); //exit;
            if (is_array($criticalFields)) {
                foreach ($criticalFields as $key => $val) {
                    if ($val > 0)
                        $updateVal = 1;
                    else
                        $updateVal = 0;

                    $criticalFields[$key] = $updateVal;
                }
            }
            TblUserProfCriticalCompletion::updateCriticalFields($userid, $criticalFields);
            // Profile Persent Calculation
            if ($_GET['update'] == 1) {
                //self::calcCriticalPercent($userid);
                CommonUtils::calculateCriticalPercentage($userid);
            }
        }
    }

    /*
     * Update the RedirecturlId in tbl-user_master table
     */

    public static function updateRedirectUrlRefId($userId, $redirectUrlRefId) {
        if ($_GET['update'] == 1) {
            self::model()->updateByPk($userId, array("redirect_url_ref_id" => $redirectUrlRefId));
        }
    }

    // Get user image and name form user login Id
    public static function getUserNameAndImageFromLoginId($userId) {
        $loginData = LoginMaster::model()->findByPk($userId);

        $userTypeId = $loginData->user_type_ref_id;
        if ($userTypeId == 1) { // if student
            $criteria = new CDbCriteria;
            $criteria->select = "first_name, last_name, user_photo, gender";
            $criteria->condition = "login_ref_id = :value";
            $criteria->params = array(":value" => $userId);

            $userData = self::model()->find($criteria);
            $data['name'] = $userData->first_name . " " . $userData->last_name;

            $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/thumb_90x90/';
            if ($userData->user_photo) {
                if (file_exists($userImagePath . $userData->user_photo)) {
                    $data['image'] = "/uploads/user/thumb/thumb_90x90/" . $userData->user_photo;
                } else {
                    if ($userData->gender == "F") {
                        $data['image'] = "/uploads/user/thumb/thumb_90x90/user_img_female.jpg";
                    } else {
                        $data['image'] = "/uploads/user/thumb/thumb_90x90/user_img_male.jpg";
                    }
                }
            } else {
                if ($userData->gender == "F") {
                    $data['image'] = "/uploads/user/thumb/thumb_90x90/user_img_female.jpg";
                } else {
                    $data['image'] = "/uploads/user/thumb/thumb_90x90/user_img_male.jpg";
                }
            }
        } else if ($userTypeId == 2) { // if CSS
            $criteria = new CDbCriteria;
            $criteria->select = "inst_username, inst_logo";
            $criteria->condition = "login_ref_id = :value";
            $criteria->params = array(":value" => $userId);

            $userData = TblSiDi::model()->find($criteria);
            if ($userData) {
                $data['name'] = $userData->inst_username;
                $ImagePath = $_SERVER['DOCUMENT_ROOT'] . '/uploads/institute/logos/' . $userData->inst_logo;
                if (file_exists($ImagePath))
                    $data['image'] = "/uploads/institute/logos/" . $userData->inst_logo;
                else
                    $data['image'] = "/app/themes/new_grid_theme/views/layouts/images/best-career.jpg";
            } else { // If advisor
                $criteria = new CDbCriteria;
                $criteria->select = "admin_id";
                $criteria->condition = "t.login_ref_id = :value";
                $criteria->params = array(":value" => $userId);

                $userData = TblAdmin::model()->with(array('siRef' => array('select' => 'inst_username, inst_logo')))->find($criteria);
                $data['name'] = $userData->siRef->inst_username;
                $data['image'] = "/uploads/institute/logos/" . $userData->siRef->inst_logo;
            }
        } else {
            $criteria = new CDbCriteria;
            $criteria->select = "admin_id, admin_full_name";
            $criteria->condition = "t.login_ref_id = :value";
            $criteria->params = array(":value" => $userId);

            $userData = TblAdmin::model()->find($criteria);
            $data['name'] = $userData->admin_full_name;
            $data['image'] = "/uploads/user/thumb/thumb_90x90/user_img_male.jpg";
        }
        return $data;
    }

    public static function updateAllPresentboardNullUsers() {
        /* $criteria=new CDbCriteria;
          $criteria->select = "t.user_id, t.present_board_ref_id, be.board_ref_id , se.class_level, t.membership_ref_id, be.board_name";
          $criteria->join = "INNER JOIN student_education se ON se.user_ref_id = t.user_id
          INNER JOIN lookup_board_equivalent be ON be.board_equivalent_id = se.board_ref_id";
          $criteria->addCondition("t.present_board_ref_id IS NULL", "AND");
          $criteria->addCondition("se.board_ref_id IS NOT NULL", "AND");
          $criteria->group = "se.user_ref_id";
          $criteria->order = "se.class_level, t.membership_ref_id DESC";
          $result = self::model()->findAll($criteria); */
        $sql = "SELECT  um.user_id
                ,um.present_board_ref_id
                ,(SELECT lb.board_equivalent_id FROM student_education se1 , lookup_board_equivalent lb 
                WHERE se1.board_ref_id = lb.board_equivalent_id
                AND se1.user_ref_id = um.user_id ORDER BY se1.class_level DESC LIMIT 1
                ) AS board_equivalent_id
                ,(SELECT lb.board_ref_id FROM student_education se1 , lookup_board_equivalent lb 
                WHERE se1.board_ref_id = lb.board_equivalent_id
                AND se1.user_ref_id = um.user_id ORDER BY se1.class_level DESC LIMIT 1
                ) AS board_ref_id
                ,(SELECT se1.class_level FROM student_education se1 , lookup_board_equivalent lb 
                WHERE se1.board_ref_id = lb.board_equivalent_id
                AND se1.user_ref_id = um.user_id ORDER BY se1.class_level DESC LIMIT 1
                ) AS class_level 
                ,um.membership_ref_id
                ,be.board_name
               FROM tbl_user_master um
               INNER JOIN student_education se ON se.user_ref_id = um.user_id
               INNER JOIN lookup_board_equivalent be ON be.board_equivalent_id = se.board_ref_id
               WHERE um.present_board_ref_id IS NULL
               AND se.board_ref_id IS NOT NULL
               GROUP BY se.user_ref_id";
        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        foreach ($result as $val) {
            echo $val['user_id'] . '<br>';
            if ($_GET['update'] == 1) {
                TblUserMaster::updateUserFields($val['user_id'], array('present_board_ref_id' => $val['board_ref_id']));
            }
        }
    }

    public function findById($loginId = false) {
        $result = self::model()->find('login_ref_id=:key', array(':key' => $loginId));

        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

    public static function manageInstitutescountByBoard($instId, $class, $passout_year, $boardId) {
        $sql = "SELECT  inst_name, present_class, board_name ,passout_year, lb.board_id, tsd.is_active, COUNT(*) AS 'total'
             FROM tbl_user_master um 
             JOIN tbl_si_students si ON si.user_ref_id = um.user_id
             JOIN tbl_si_di tsd ON tsd.inst_id = si.inst_ref_id
             JOIN lookup_board lb ON lb.board_id = um.present_board_ref_id
             WHERE si.inst_ref_id = '$instId' AND um.class_status='Pursuing'
             AND um.present_class = '$class' AND um.passout_year = '$passout_year'
             AND board_id = '$boardId'";
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getStudentDetailsByLoginId($loginRefId) {
        $result = self::model()->find(array("condition" => "t.login_ref_id = $loginRefId"));
        return $result;
    }

    public static function getAllBoardIdsByClass($instId, $class, $passout_year) {
        $sql = "SELECT board_ref_id AS board_id FROM student_upload_master_list
            WHERE inst_ref_id = '$instId' AND class='$class' AND completion_year='$passout_year'
            AND class_status='Pursuing' 
            GROUP BY board_ref_id        
          UNION
             SELECT board_id AS board_id
             FROM tbl_user_master um 
             JOIN tbl_si_students si ON si.user_ref_id = um.user_id
             JOIN tbl_si_di tsd ON tsd.inst_id = si.inst_ref_id
             JOIN lookup_board lb ON lb.board_id = um.present_board_ref_id
             WHERE si.inst_ref_id = '$instId' AND um.present_class = '$class'
             AND um.class_status='Pursuing' AND um.passout_year = '$passout_year'
             GROUP BY present_board_ref_id";
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getManageInstitutesUsers($instId, $class, $passout_year, $boardId) {
        $sql = "SELECT lm.username,um.user_id,present_class, board_name ,passout_year, lb.board_id
             FROM tbl_user_master um 
             JOIN tbl_si_students si ON si.user_ref_id = um.user_id
             JOIN login_master lm ON lm.login_id = um.login_ref_id
             JOIN lookup_board lb ON lb.board_id = um.present_board_ref_id
             WHERE si.inst_ref_id = '$instId' AND um.class_status='Pursuing'
             AND um.present_class = '$class' AND um.passout_year = '$passout_year'
             AND lb.board_id = '$boardId'";
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    //To get the board details
    public static function getExtBoards($extadvId = 0) {
        $cdb = new CDbCriteria();
        $cdb->join = "INNER JOIN tbl_user_master lb ON (lb.present_board_ref_id = t.board_id) ";
        $cdb->join .= "INNER JOIN prospect p ON (p.user_ref_id = lb.user_id)";
        $cdb->condition = "p.advisor_ref_id = " . $extadvId;
        $results = LookupBoard::model()->findAll($cdb);
        return $results;
    }

    //It will gives the external student details. this function is using in extadvdashboard module to get the list of sudents to display on manage students section.
    public function getExtStudentDetailByClass($extadvid = 0, $class = '', $board = '', $graduatioYear = '', $limit = 0, $offset = 0, $searchText = '', $trackFlag = false) {
        try {
            /* $criteria = new CDbCriteria();
              $criteria->select = 'user_id, first_name, last_name, school_ref_id, critical_percent';
              $criteria->together = true;
              $criteria->join="INNER JOIN prospect AS p ON p.user_ref_id=t.user_id";

              // $criteria->with = array('prospect'=>array('select'=>'inst_ref_id'), 'loginRef'=>array('select'=>'username'));
              //        $criteria->with = array('studentUploadMasterLists'=>array('select'=>'class,completion_year'),
              //                                'loginRef'=>array('select'=>'username'));

              $criteria->compare('t.present_class', $class);
              $criteria->compare('t.present_board_ref_id', $board);

              if($graduatioYear == 2){
              //$criteria->addCondition("CONCAT(passout_year,passout_month) <= DATE_FORMAT(NOW(),'%Y%m')", "AND");
              //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') <= DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
              $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') < NOW()", "AND");
              }
              if($graduatioYear == 1){
              //$criteria->addCondition("CONCAT(passout_year,passout_month) >= DATE_FORMAT(NOW(),'%Y%m')", "AND");
              //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') > DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
              $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') > NOW()", "AND");
              }
              if($graduatioYear>3){
              $criteria->compare('t.passout_year', $graduatioYear);
              }
              if(!$board && $trackFlag){
              $criteria->addCondition('t.present_board_ref_id IS NULL');
              }
              $criteria->offset = $offset;
              $criteria->group = 't.user_id';
              if ($limit) {
              $criteria->limit = $limit;
              }
              if ($searchText) {
              $searchTerm = mysql_escape_string($searchText);
              $criteria->addCondition("p.advisor_ref_id = " . $extadvid . "  AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%')");
              $criteria->order = "(CASE WHEN t.first_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.first_name";
              } else {
              $criteria->addCondition("p.advisor_ref_id= " . $extadvid );
              }
              $result = self::model()->findAll($criteria);

              //echo "hello";
              //echo "<pre>"; print_r(self::model()->getQuery()); echo "</pre>"; exit;

              //return $result; */
            $criteria_condition = "";
            $criteria_condition_search = "";
            $limit_condition = "LIMIT 20";
            if ($class != "" && $board != "") {
                $criteria_condition.="((t.present_class =" . $class . ") AND (t.present_board_ref_id = " . $board . " ))";
            } else if ($class != "") {
                $criteria_condition.="(t.present_class =" . $class . ") AND";
            } else if ($board != "") {
                $criteria_condition.="(t.present_board_ref_id =" . $board . ") AND";
            }
            if ($graduatioYear == 2) {
                //$criteria->addCondition("CONCAT(passout_year,passout_month) <= DATE_FORMAT(NOW(),'%Y%m')", "AND");
                //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') <= DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
                $criteria_condition.=" (CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') < NOW())";
            }
            if ($graduatioYear == 1) {
                //$criteria->addCondition("CONCAT(passout_year,passout_month) >= DATE_FORMAT(NOW(),'%Y%m')", "AND");
                //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') > DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
                $criteria_condition.=" (CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') > NOW())";
            }
            if ($limit) {
                $limit_condition = "LIMIT " . $limit;
            }
            $orderby = "";
            if ($searchText) {
                $searchTerm = mysql_escape_string($searchText);
                $criteria_condition.=" AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%')";
                $orderby = "(CASE WHEN t.first_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.first_name";
            }
            $sql = "SELECT t.user_id, t.first_name, t.last_name, t.school_ref_id, t.critical_percent FROM `tbl_user_master` `t` 
			INNER JOIN prospect AS p ON p.user_ref_id=t.user_id WHERE " . $criteria_condition . "AND p.advisor_ref_id=" . $extadvid . " GROUP BY t.user_id " . $orderby . " " . $limit_condition . "  UNION ALL SELECT t.user_id, t.first_name, t.last_name, t.school_ref_id, t.critical_percent FROM `tbl_user_master` `t` 
			INNER JOIN login_master AS lm ON lm.login_id=t.login_ref_id
			INNER JOIN gem_lead AS gl ON gl.email_id=lm.username
			INNER JOIN gem_lead_prospect AS gp ON gp.gem_lead_ref_id=gl.gem_lead_id WHERE " . $criteria_condition . "AND gp.advisor_ref_id=" . $extadvid . " GROUP BY t.user_id " . $orderby . " " . $limit_condition;

            $command = Yii::app()->db->createCommand($sql);
            $rowCount = $command->execute(); // execute the non-query SQL
            $dataReader = $command->queryAll();
            return $dataReader;
        } catch (Exception $ex) {
            echo $ex;
        }
    }

    //It will gives the external student details count. this function is using in extadvdashboard module to get the list of sudents to display on manage students section.
    public static function getExtStudentCountByClass($extadvid = 0, $class = '', $board = '', $graduatioYear = '', $searchText = '', $trackFlag = false) {
        /* $criteria = new CDbCriteria();
          $criteria->select = 'user_id';
          $criteria->together = true;
          $criteria->compare('t.present_class', $class);
          $criteria->compare('t.present_board_ref_id', $board);
          $currentYear = date('Y');
          $currentMonth = date('m');
          if($graduatioYear == 2){
          $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') < NOW()", "AND");
          }
          if($graduatioYear == 1){
          $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') > NOW()", "AND");
          }
          if($graduatioYear>3){
          $criteria->compare('t.passout_year', $graduatioYear);
          }
          if(!$board && $trackFlag){
          $criteria->addCondition('t.present_board_ref_id IS NULL');
          }
          // $criteria->with = array('tblSiStudents'=>array('select'=>'inst_ref_id'),'loginRef'=>array('select'=>'username'));
          $criteria->join="INNER JOIN prospect AS p ON p.user_ref_id=t.user_id";


          if ($searchText) {
          $searchTerm = mysql_escape_string($searchText);
          $criteria->addCondition("p.advisor_ref_id = " . $extadvid . "  AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%')");
          $criteria->order = "(CASE WHEN t.first_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.first_name";
          } else {
          $criteria->addCondition("p.advisor_ref_id = " . $extadvid );
          }
          $criteria->group = 't.user_id';
          $count = self::model()->count($criteria); */

        $criteria_condition = "";
        $criteria_condition_search = "";
        $limit_condition = "LIMIT 20";
        if ($class != "" && $board != "") {
            $criteria_condition.="((t.present_class =" . $class . ") AND (t.present_board_ref_id = " . $board . " ))";
        } else if ($class != "") {
            $criteria_condition.="(t.present_class =" . $class . ") AND";
        } else if ($board != "") {
            $criteria_condition.="(t.present_board_ref_id =" . $board . ") AND";
        }
        if ($graduatioYear == 2) {
            //$criteria->addCondition("CONCAT(passout_year,passout_month) <= DATE_FORMAT(NOW(),'%Y%m')", "AND");
            //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') <= DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
            $criteria_condition.=" (CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') < NOW())";
        }
        if ($graduatioYear == 1) {
            //$criteria->addCondition("CONCAT(passout_year,passout_month) >= DATE_FORMAT(NOW(),'%Y%m')", "AND");
            //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') > DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
            $criteria_condition.=" (CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') > NOW())";
        }
        if ($limit) {
            $limit_condition = "LIMIT " . $limit;
        }
        $orderby = "";
        if ($searchText) {
            $searchTerm = mysql_escape_string($searchText);
            $criteria_condition.=" AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%')";
        }
        $sql = "SELECT t.user_id, t.first_name, t.last_name, t.school_ref_id, t.critical_percent FROM `tbl_user_master` `t` 
			INNER JOIN prospect AS p ON p.user_ref_id=t.user_id WHERE " . $criteria_condition . "AND p.advisor_ref_id=" . $extadvid . " GROUP BY t.user_id  
			UNION ALL SELECT t.user_id, t.first_name, t.last_name, t.school_ref_id, t.critical_percent FROM `tbl_user_master` `t` 
			INNER JOIN login_master AS lm ON lm.login_id=t.login_ref_id
			INNER JOIN gem_lead AS gl ON gl.email_id=lm.username
			INNER JOIN gem_lead_prospect AS gp ON gp.gem_lead_ref_id=gl.gem_lead_id WHERE " . $criteria_condition . "AND gp.advisor_ref_id=" . $extadvid . " GROUP BY t.user_id ";

        $command = Yii::app()->db->createCommand($sql);
        $rowCount = $command->execute(); // execute the non-query SQL		

        return $rowCount;
    }

    public static function getSIStudentDetailByClass($instId = 0, $class = '', $board = '', $graduatioYear = '', $limit = 0, $offset = 0, $searchText = '', $trackFlag = false, $status = '') {

        $criteria = new CDbCriteria();
        $criteria->select = 't.user_id, t.first_name,t.last_name, t.school_ref_id, t.critical_percent';
        $criteria->together = true;
        $with = array('tblSiStudents' => array('select' => 'tblSiStudents.inst_ref_id'), 'loginRef' => array('select' => 'loginRef.username'), 'studentOutplacementSColleges' => array('select' => 'studentOutplacementSColleges.student_outplacement_colleges_id'));
//        $criteria->with = array('studentUploadMasterLists'=>array('select'=>'class,completion_year'),
//                                'loginRef'=>array('select'=>'username'));

        switch ($status) {
            case "Y":
                $with['studentOutplacementSColleges']['condition'] = 'studentOutplacementSColleges.user_ref_id IS NOT NULL';
                // $criteria->join = 'LEFT JOIN student_outplacement_colleges soc ON soc.user_ref_id = t.user_id AND soc.user_ref_id  IS NOT NULL';
                // $criteria->addCondition('studentOutplacementSColleges.user_ref_id IS NOT NULLL');
                break;

            case "N":
                $with['studentOutplacementSColleges']['condition'] = 'studentOutplacementSColleges.user_ref_id IS NULL';
                break;

            default :
            //  $criteria->join = 'LEFT JOIN student_outplacement_colleges soc ON soc.user_ref_id = t.user_id';
        }

        $criteria->with = $with;

        $criteria->group = 't.user_id';


        $criteria->compare('t.present_class', $class);
        $criteria->compare('t.present_board_ref_id', $board);
        if ($graduatioYear == 2) {
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') < NOW()", "AND");
        }
        if ($graduatioYear == 1) {
            //$criteria->addCondition("CONCAT(passout_year,passout_month) >= DATE_FORMAT(NOW(),'%Y%m')", "AND");
            //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') > DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') > NOW()", "AND");
        }
        if ($graduatioYear > 3) {
            $criteria->compare('t.passout_year', $graduatioYear);
        }
        if (!$board && $trackFlag) {
            $criteria->addCondition('t.present_board_ref_id IS NULL');
        }


        $criteria->offset = $offset;
        $criteria->group = 't.user_id';
        if ($limit) {
            $criteria->limit = $limit;
        }
        if ($searchText) {
            $searchTerm = mysql_escape_string($searchText);
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId . "  AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%' OR  loginRef.username like '%" . $searchTerm . "%')");
            $criteria->order = "(CASE WHEN t.first_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.first_name";
        } else {
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId);
        }


        $result = self::model()->findAll($criteria);
        return $result;
    }

    public static function get_si_student_detail_by_class($instId = 0, $class = '', $board = '', $graduatioYear = '', $limit = 0, $offset = 0, $searchText = '', $trackFlag = false, $psychometric_report, $alumni_report = '') {

        $passed_args = func_get_args();
        Yii::app()->session['psychometric_test_arguments'] = $passed_args;
        if (empty($passed_args))
            return array();

        $criteria = new CDbCriteria();
        $criteria->select = 't.user_id, t.first_name, t.last_name, t.school_ref_id, t.critical_percent, t.present_class, t.class_status, t.present_board_ref_id';
        $criteria->together = true;
        $criteria->with = array(
            'tblSiStudents' => array('select' => 'inst_ref_id'),
            'loginRef' => array('select' => 'username')
        );
//        $criteria->with = array('studentUploadMasterLists'=>array('select'=>'class,completion_year'), 
//                                'loginRef'=>array('select'=>'username'));
        $criteria->compare('t.present_class', $class);
        if ($board)
            $criteria->compare('t.present_board_ref_id', $board);
        if ($graduatioYear == 2) {
            //$criteria->addCondition("CONCAT(passout_year,passout_month) <= DATE_FORMAT(NOW(),'%Y%m')", "AND");
            //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') <= DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') < NOW()", "AND");
        }
        if ($graduatioYear == 1) {
            //$criteria->addCondition("CONCAT(passout_year,passout_month) >= DATE_FORMAT(NOW(),'%Y%m')", "AND");
            //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') > DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') > NOW()", "AND");
        }
        if ($graduatioYear > 3) {
            $criteria->compare('t.passout_year', $graduatioYear);
        }
        if (!$board && $trackFlag) {
            $criteria->addCondition('t.present_board_ref_id IS NULL');
        }
        $criteria->offset = $offset;
        $criteria->group = 't.user_id';
        if ($limit) {
            $criteria->limit = $limit;
        }

        switch ($psychometric_report) {
            case 'test_taken':
                $criteria->with['psychometricTest'] = array(
                    'select' => 'psychometricTest.start_date, psychometricTest.end_date, psychometricTest.payment_status',
                    'condition' => 'psychometricTest.end_date IS NOT NULL AND (psychometricTest.payment_status <> "Completed" OR psychometricTest.payment_status IS NULL)',
                );
                //$criteria->join = ' INNER JOIN psychometric_test pt ON t.user_id = pt.user_ref_id AND pt.end_date IS NOT NULL AND (pt.payment_status <> "Completed" OR pt.payment_status IS NULL)';
                break;
            case 'got_full_report':
                $criteria->with['psychometricTest'] = array(
                    'select' => 'psychometricTest.start_date, psychometricTest.end_date, psychometricTest.payment_status',
                    'condition' => 'psychometricTest.end_date IS NOT NULL AND psychometricTest.payment_status = "Completed"',
                );
                //$criteria->join = ' INNER JOIN psychometric_test pt ON t.user_id = pt.user_ref_id AND pt.end_date IS NOT NULL AND pt.payment_status = "Completed"';
                break;
            case 'test_not_taken':
                $criteria->with['psychometricTest'] = array(
                    'select' => 'psychometricTest.start_date, psychometricTest.end_date, psychometricTest.payment_status',
                    'condition' => 'psychometricTest.user_ref_id IS NULL',
                );
                //$criteria->join = ' LEFT JOIN psychometric_test pt ON t.user_id = pt.user_ref_id';
                //$criteria->addCondition('pt.user_ref_id IS NULL');
                break;
            case 'appeared':
                $criteria->with['psychometricTest'] = array(
                    'select' => 'psychometricTest.start_date, psychometricTest.end_date, psychometricTest.payment_status',
                    'condition' => 'psychometricTest.end_date IS NOT NULL',
                );
                //$criteria->join = ' INNER JOIN psychometric_test pt ON t.user_id = pt.user_ref_id AND pt.end_date IS NOT NULL';
                break;
            default:
                break;
        }

        if ($searchText) {
            $searchTerm = mysql_escape_string($searchText);
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId . "  AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%' OR  loginRef.username like '%" . $searchTerm . "%')");
            $criteria->order = "(CASE WHEN t.first_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.first_name";
        } else {
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId);
        }
        $result = self::model()->findAll($criteria);
        return $result;
    }

    public static function getSIStudentDetailByUserId($userId = 0) {
        $criteria = new CDbCriteria();
        $criteria->together = true;
        $criteria->with = array(
            'studentPreferredCountries' => array('select' => 'country_ref_id, not_sure'),
            'studentPreferredCountries.countryRef' => array('select' => 'country_name'),
            'studentPreferredDepartments' => array('select' => 'main_dept_ref_id, not_sure'),
            'studentPreferredDepartments.mainDeptRef' => array('select' => 'department_name'),
            'studentPreferredPeriods' => array('select' => 'period_ref_id, year'),
            'studentPreferredPeriods.periodRef' => array('select' => 'months'));
        $criteria->compare('t.user_id', $userId);
        $result = self::model()->findAll($criteria);
        return $result;
    }

    public static function get_alumni_si_student_detail_by_year_board($instId = 0, $board = '', $graduatioYear = '', $limit = 0, $offset = 0, $searchText = '', $trackFlag = false) {


        $criteria = new CDbCriteria();
        $criteria->select = 't.user_id, t.first_name, t.last_name, t.school_ref_id, t.critical_percent, t.present_class, t.class_status, t.present_board_ref_id,t.passout_year';
        $criteria->together = true;
        $criteria->with = array(
            'tblSiStudents' => array('select' => 'inst_ref_id'),
            'loginRef' => array('select' => 'username'),
        );

        $criteria->join = 'JOIN student_outplacement_colleges soc ON t.user_id = soc.user_ref_id ';
        // $criteria->select = 'soc.status,soc.amount';
        $criteria->compare('t.present_board_ref_id', $board);
        if ($graduatioYear == 2) {
            //$criteria->addCondition("CONCAT(passout_year,passout_month) <= DATE_FORMAT(NOW(),'%Y%m')", "AND");
            //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') <= DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') < NOW()", "AND");
        }
        if ($graduatioYear == 1) {
            //$criteria->addCondition("CONCAT(passout_year,passout_month) >= DATE_FORMAT(NOW(),'%Y%m')", "AND");
            //$criteria->addCondition("STR_TO_DATE (CONCAT(passout_year,passout_month), '%Y%m') > DATE_FORMAT(NOW(),'%Y-%m-%d')", "AND");
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') > NOW()", "AND");
        }
        if ($graduatioYear > 3) {
            $criteria->compare('t.passout_year', $graduatioYear);
        }
        if (!$board && $trackFlag) {
            $criteria->addCondition('t.present_board_ref_id IS NULL');
        }
        $criteria->offset = $offset;
        $criteria->group = 't.user_id';
        if ($limit) {
            $criteria->limit = $limit;
        }

        if ($searchText) {
            $searchTerm = mysql_escape_string($searchText);
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId . "  AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%' OR  loginRef.username like '%" . $searchTerm . "%')");
            $criteria->order = "(CASE WHEN t.first_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.first_name";
        } else {
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId);
        }
        $result = self::model()->findAll($criteria);
        return $result;
    }

    public static function get_si_students_count_by_class($instId = 0, $class = '', $board = '', $graduatioYear = '', $searchText = '', $trackFlag = false, $psychometric_report) {
        $criteria = new CDbCriteria();
        $criteria->select = 'user_id';
        $criteria->together = true;
        $criteria->compare('t.present_class', $class);
        $criteria->compare('t.present_board_ref_id', $board);
        $currentYear = date('Y');
        $currentMonth = date('m');
        if ($graduatioYear == 2) {
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') < NOW()", "AND");
        }
        if ($graduatioYear == 1) {
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') > NOW()", "AND");
        }
        if ($graduatioYear > 3) {
            $criteria->compare('t.passout_year', $graduatioYear);
        }
        if (!$board && $trackFlag) {
            $criteria->addCondition('t.present_board_ref_id IS NULL');
        }
        $criteria->with = array('tblSiStudents' => array('select' => 'inst_ref_id'), 'loginRef' => array('select' => 'username'));

        switch ($psychometric_report) {
            case 'test_taken':
                $criteria->join = ' INNER JOIN psychometric_test pt ON t.user_id = pt.user_ref_id AND pt.end_date IS NOT NULL AND (pt.payment_status <> "Completed" OR pt.payment_status IS NULL)';
                break;
            case 'got_full_report':
                $criteria->join = ' INNER JOIN psychometric_test pt ON t.user_id = pt.user_ref_id AND pt.end_date IS NOT NULL AND pt.payment_status = "Completed"';
                break;
            case 'test_not_taken':
                $criteria->join = ' LEFT JOIN psychometric_test pt ON t.user_id = pt.user_ref_id';
                $criteria->addCondition('pt.user_ref_id IS NULL');
                break;
            case 'appeared':
                $criteria->join = ' INNER JOIN psychometric_test pt ON t.user_id = pt.user_ref_id AND pt.end_date IS NOT NULL';
                break;
            default:
                break;
        }

        if ($searchText) {
            $searchTerm = mysql_escape_string($searchText);
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId . "  AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%' OR  loginRef.username like '%" . $searchTerm . "%')");
            $criteria->order = "(CASE WHEN t.first_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.first_name";
        } else {
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId);
        }
        $criteria->group = 't.user_id';
        $count = self::model()->count($criteria);
        return $count;
    }

    public static function getSIStudentCountByClass($instId = 0, $class = '', $board = '', $graduatioYear = '', $searchText = '', $trackFlag = false, $status = '') {
        $criteria = new CDbCriteria();
        $criteria->select = 'user_id';
        $criteria->together = true;
        $criteria->compare('t.present_class', $class);

        $criteria->compare('t.present_board_ref_id', $board);
        $currentYear = date('Y');
        $currentMonth = date('m');



        if ($graduatioYear == 2) {
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') < NOW()", "AND");
        }
        if ($graduatioYear == 1) {
            $criteria->addCondition("CONCAT(t.passout_year, '-', IF(t.passout_month < 10, CONCAT(0, t.passout_month), t.passout_month), '-01 00:00:00') > NOW()", "AND");
        }
        if ($graduatioYear > 3) {
            $criteria->addCondition('t.passout_year=' . $graduatioYear);
            $criteria->compare('t.passout_year', $graduatioYear);
        }
        if (!$board && $trackFlag) {
            $criteria->addCondition('t.present_board_ref_id IS NULL');
        }
        $with = array('tblSiStudents' => array('select' => 'inst_ref_id'), 'loginRef' => array('select' => 'username'), 'studentOutplacementSColleges' => array('select' => 'studentOutplacementSColleges.student_outplacement_colleges_id'));


        switch ($status) {
            case "Y":
                $with['studentOutplacementSColleges']['condition'] = 'studentOutplacementSColleges.user_ref_id IS NOT NULL';
                // $criteria->join = 'LEFT JOIN student_outplacement_colleges soc ON soc.user_ref_id = t.user_id AND soc.user_ref_id  IS NOT NULL';
                // $criteria->addCondition('studentOutplacementSColleges.user_ref_id IS NOT NULLL');
                break;

            case "N":
                $with['studentOutplacementSColleges']['condition'] = 'studentOutplacementSColleges.user_ref_id IS NULL';
                break;

            default :
            //  $criteria->join = 'LEFT JOIN student_outplacement_colleges soc ON soc.user_ref_id = t.user_id';
        }

        $criteria->with = $with;

        $criteria->group = 't.user_id';

        if ($searchText) {
            $searchTerm = mysql_escape_string($searchText);
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId . "  AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%' OR  loginRef.username like '%" . $searchTerm . "%')");
            $criteria->order = "(CASE WHEN t.first_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.first_name";
        } else {
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId);
        }
        $criteria->group = 't.user_id';
        $count = self::model()->count($criteria);
        return $count;
    }

    public static function getUniqueCompletionYearList($schoolId) {
        $criteria = new CDbCriteria();
        $criteria->select = 'passout_year';
        $criteria->condition = "present_class IN ('11','12')";
        $criteria->group = 'passout_year';
        $criteria->order = 'passout_year';
        $result = self::model()->findAll($criteria);
        return $result;
    }

    /**
     * This method will return the university data with specified columns
     * @param int $id     
     * @param string $columns (optional)
     * @return array
     */
    public static function getUserAttributeById($id, $columns = '') {
        $criteria = new CDbCriteria();
        if (strlen($columns)) {
            $criteria->select = $columns;
        } else {
            $criteria->select = '*';
        }

        $criteria->condition = 'user_id=:id';
        $criteria->params = array(':id' => $id);
        $data = self::model()->find($criteria);
        return $data;
    }

    public static function getCurrentRedirectUrlOrder($userId) {
        $criteria = new CDbCriteria;
        $criteria->select = 'user_id';
        $criteria->addCondition("user_id = " . $userId, "AND");
        $criteria->order = "redirect_order desc";
        $res = self::model()->with('redirectUrlRef')->find($criteria);
        return $res;
    }

    public static function getEmailIdsByInstitute($instId = 0, $searchText = '', $limit = 0) {
        $criteria = new CDbCriteria();
        $criteria->select = 'user_id, first_name, last_name, school_ref_id';
        $criteria->together = true;
        $criteria->with = array('tblSiStudents' => array('select' => 'inst_ref_id'), 'loginRef' => array('select' => 'username'));
        if ($limit) {
            $criteria->limit = $limit;
        }
        if ($searchText) {
            $searchTerm = mysql_escape_string($searchText);
            $criteria->addCondition("tblSiStudents.inst_ref_id = " . $instId . "  AND (t.first_name like '%" . $searchTerm . "%' OR  t.last_name like '%" . $searchTerm . "%' OR  loginRef.username like '%" . $searchTerm . "%')");
            $criteria->order = "(CASE WHEN t.first_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.first_name";
        }
        $result = self::model()->findAll($criteria);
        return $result;
    }

    public static function getSiStudentReportByInstId($instId = 0, $class = 0, $board = 0, $year = 0) {

        $criteria = new CDbCriteria();
        $criteria->with = array(
            'presentBoardRef',
            'studentPreferredCountries', 'studentPreferredCountries.countryRef',
            'studentPreferredDepartments', 'studentPreferredDepartments.mainDeptRef'
        );
        $criteria->join = ' JOIN tbl_si_students tss ON tss.user_ref_id = t.user_id';
        $criteria->join .= " JOIN si_track_milestone stm ON stm.si_ref_id = tss.inst_ref_id AND stm.class = t.present_class AND stm.passout_year = t.passout_year AND stm.board_ref_id = t.present_board_ref_id";

        $criteria->addCondition("t.present_class IN('9','10','11','12')", "AND");
        $criteria->addCondition("t.present_board_ref_id IS NOT NULL AND t.passout_year IS NOT NULL", "AND");
        $criteria->addCondition("tss.inst_ref_id = '" . $instId . "' AND t.class_status = 'Pursuing'", "AND");

        if ($class) {
            if(is_array($class)){
                $classCondition = "'".implode("','", $class). "'";
                $criteria->addCondition("t.present_class IN ($classCondition)", "AND");
            }
            else{
                $criteria->addCondition("t.present_class = '" . $class . "' ", "AND");
            }
        }

        if ($board) {
            $criteria->addCondition("t.present_board_ref_id = '" . $board . "' ", "AND");
        }

        if ($year) {
            $criteria->addCondition("t.passout_year = '" . $year . "' ", "AND");
        }

        return self::model()->findAll($criteria);
    }

    public static function getmembershipName($membershipId) {
        if ($membershipId == 1)
            return 'Guest';
        elseif ($membershipId == 2)
            return 'SI student';
        elseif ($membershipId == 3)
            return 'GEM Student';
        elseif ($membershipId == 4)
            return 'SI and GEM Student';
    }

    public function getNonValidateProfiles() {

        $where = "";
        if ($_GET['TblUserMaster']['umail_recency']) {
            $delta = (int) trim($_GET['TblUserMaster']['umail_recency'], '-');
            $op = '>';
            if (strstr($_GET['TblUserMaster']['umail_recency'], '-')) {
                $op = '<';
            }
            list($y, $m, $d) = explode('-', date('Y-m-d'));
            $date = date('Y-m-d', mktime(0, 0, 0, $m, $d - $delta, $y));
            $where .= " AND UM.added_on " . $op . " '" . $date . "'";
            //(SELECT COUNT(*) AS umail_count FROM `umail_header` WHERE sender_type=1 AND sender_id=UM.user_id AND UM.added_on ".$op." '". $date . "')  AS umail_count,
        }

        $sql = "SELECT CONCAT(UM.first_name,' ',UM.last_name) AS name,UM.user_id,LM.login_id, COUNT(DISTINCT(UME.message_id)) AS umail_count,
            LM.username,LM.profile_validate_status,LM.is_umail_update,LM.is_student_profile_confirmed,SN.number,LM.is_valid,UM.passout_year, LS.school_name,LM.added_on,UM.modified_on,
            (SELECT added_on FROM umail_message TUME WHERE sender_type = 1 AND UM.user_id = TUME.sender_id ORDER BY added_on DESC LIMIT 1) AS umail_last_message
            FROM umail_message UME
            JOIN umail_header UH ON UH.header_id = UME.header_ref_id
            JOIN tbl_user_master UM ON (UM.user_id = UME.sender_id)
            JOIN login_master LM ON UM.login_ref_id = LM.login_id
            LEFT JOIN student_preferred_country spc ON spc.user_ref_id = UM.user_id
            LEFT JOIN student_preferred_department spd ON spd.user_ref_id = UM.user_id
            LEFT JOIN lookup_school LS ON LS.school_id = UM.school_ref_id
            LEFT JOIN student_contact_number SN ON (SN.user_ref_id = UM.user_id AND is_primary =1 AND contact_type_ref_id=1)
            WHERE UME.sender_type = 1 $where";

        if ($this->passout_year) {
            $sql .= " AND UM.passout_year = '$this->passout_year' ";
        }
        if ($_GET['TblUserMaster']['country_pref']) {
            $this->country_pref = $_GET['TblUserMaster']['country_pref'];
            $sql .= " AND spc.country_ref_id = '" . $_GET['TblUserMaster']['country_pref'] . "'";

            if ($_GET['TblUserMaster']['country_pref_order'])
                $sql .= " AND spc.preference_order = '" . $_GET['TblUserMaster']['country_pref_order'] . "'";
        }
        if ($_GET['TblUserMaster']['dept_pref']) {
            $sql .= " AND spd.main_dept_ref_id = '" . $_GET['TblUserMaster']['dept_pref'] . "'";

            if ($_GET['TblUserMaster']['dept_pref_order'])
                $sql .= " AND spd.preference_order = '" . $_GET['TblUserMaster']['dept_pref_order'] . "'";
        }
        if ($this->critical_percent) {
            list($p1, $p2) = explode('-', $this->critical_percent);
            $sql .= " AND UM.critical_percent BETWEEN " . $p1 . " AND " . $p2 . " ";
        }
        if ($this->added_on) {
            $delta = (int) trim($this->added_on, '-');
            $op = '>';
            if (strstr($this->added_on, '-')) {
                $op = '<';
            }
            list($y, $m, $d) = explode('-', date('Y-m-d'));
            $date = date('Y-m-d', mktime(0, 0, 0, $m, $d - $delta, $y));
            $sql .= " AND UM.added_on " . $op . " '" . $date . "' ";
        }
        if ($this->modified_on) {
            $delta = (int) trim($this->modified_on, '-');
            $op = '>';
            if (strstr($this->modified_on, '-')) {
                $op = '<';
            }
            list($y, $m, $d) = explode('-', date('Y-m-d'));
            $date = date('Y-m-d', mktime(0, 0, 0, $m, $d - $delta, $y));
            $sql .= " AND UM.modified_on " . $op . " '" . $date . "' AND UM.modified_on IS NOT NULL";
        }
        if ($_GET['TblUserMaster']['profile_validate_status']) {
            if ($_GET['TblUserMaster']['profile_validate_status'] == 'Validated')
                $sql .= " AND LM.is_student_profile_confirmed = 1";
            elseif ($_GET['TblUserMaster']['profile_validate_status'] == 'NotValidated')
                $sql .= " AND LM.is_student_profile_confirmed != 1 AND LM.profile_validate_status IS NULL";
            else
                $sql .= " AND LM.profile_validate_status = '" . $_GET['TblUserMaster']['profile_validate_status'] . "' AND new_umail=1";
        }
        if ($_GET['TblUserMaster']['username']) {
            $sql .= " AND (LM.username LIKE '%" . $_GET['TblUserMaster']['username'] . "%' OR UM.first_name LIKE '%" . $_GET['TblUserMaster']['username'] . "%' OR UM.last_name LIKE '%" . $_GET['TblUserMaster']['username'] . "%')";
        }
        $sql .= " AND LM.new_umail='1' AND UM.passout_year>2014 AND (profile_validate_status IS NULL OR profile_validate_status = 'NoActionRequired') GROUP BY UM.user_id HAVING umail_count>0";

        //echo '###'.$sql;
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        return new CArrayDataProvider($rawData, array(
            'pagination' => array(
                'pageSize' => 20,
            ),
            'sort' => array(
                //'defaultOrder' => 'umail_count DESC',
                'defaultOrder' => 'umail_last_message DESC',
                'sortVar' => 'sort',
                'attributes' => array(
                    'added_on',
                    'modified_on',
                    'umail_last_message',
                    /* 'name' => array(
                      'asc' => 'name',
                      'desc' => 'name DESC',
                      ), */
                    'passout_year' => array(
                        'asc' => 'passout_year',
                        'desc' => 'passout_year DESC',
                    ),
                    'umail_count' => array(
                        'asc' => 'umail_count',
                        'desc' => 'umail_count DESC',
                    ),
                ),
            )
        ));
    }

    public static function getTimelineFilters() {
        return array(
            '7' => '< 7 days',
            '30' => '< 30 days',
            '90' => '< 90 days',
            '180' => '< 180 days',
            '180-' => '> 180 days'
        );
    }

    public function getRequestValidateProfiles() {

        $sql = "SELECT CONCAT(UM.first_name,' ',UM.last_name) AS name,UM.first_name,UM.last_name,UM.user_id,LM.login_id,LM.request_validated_on,
           (SELECT COUNT(*) AS umail_count FROM `umail_header` WHERE sender_type=1 AND sender_id=UM.user_id)  AS umail_count,
            LM.username,LM.profile_validate_status,LM.is_umail_update,LM.umail_request_to,SN.number,LM.is_valid,UM.passout_year, LS.school_name,LM.added_on,UM.modified_on,
            (SELECT COUNT(*) FROM umail_message UM WHERE UM.sender_id = UM.user_id AND UM.is_refernce_umail='1') as umailRefCnt
            FROM tbl_user_master UM
            LEFT JOIN login_master LM ON UM.login_ref_id = LM.login_id
            LEFT JOIN student_preferred_country spc ON spc.user_ref_id = UM.user_id
            LEFT JOIN student_preferred_department spd ON spd.user_ref_id = UM.user_id
            LEFT JOIN lookup_school LS ON LS.school_id = UM.school_ref_id
            LEFT JOIN student_contact_number SN ON (SN.user_ref_id = UM.user_id AND is_primary =1 AND contact_type_ref_id=1)
            WHERE 1=1";

        if ($this->passout_year) {
            $sql .= " AND UM.passout_year = '$this->passout_year' ";
        }
        if ($_GET['TblUserMaster']['country_pref']) {
            $this->country_pref = $_GET['TblUserMaster']['country_pref'];
            $sql .= " AND spc.country_ref_id = '" . $_GET['TblUserMaster']['country_pref'] . "'";

            if ($_GET['TblUserMaster']['country_pref_order'])
                $sql .= " AND spc.preference_order = '" . $_GET['TblUserMaster']['country_pref_order'] . "'";
        }
        if ($_GET['TblUserMaster']['dept_pref']) {
            $sql .= " AND spd.main_dept_ref_id = '" . $_GET['TblUserMaster']['dept_pref'] . "'";

            if ($_GET['TblUserMaster']['dept_pref_order'])
                $sql .= " AND spd.preference_order = '" . $_GET['TblUserMaster']['dept_pref_order'] . "'";
        }
        if ($_GET['TblUserMaster']['umail_request_to']) {
            $sql .= " AND LM.umail_request_to = '" . $_GET['TblUserMaster']['umail_request_to'] . "'";
        }
        if ($_GET['TblUserMaster']['username']) {
            $sql .= " AND (LM.username LIKE '%" . $_GET['TblUserMaster']['username'] . "%' OR UM.first_name LIKE '%" . $_GET['TblUserMaster']['username'] . "%' OR UM.last_name LIKE '%" . $_GET['TblUserMaster']['username'] . "%')";
        }
        if ($_GET['TblUserMaster']['number']) {
            if ($_GET['TblUserMaster']['number'] == 1)
                $sql .= " AND SN.number IS NOT NULL";
            else if ($_GET['TblUserMaster']['number'] == 2)
                $sql .= " AND SN.number IS NULL";
        }
        $sql .= " AND LM.profile_validate_status = 'RequestValidate' AND LM.is_student_profile_confirmed!=1 GROUP BY UM.user_id HAVING umail_count>0";

        //echo '###'.$sql;
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        return new CArrayDataProvider($rawData, array(
            'pagination' => array(
                'pageSize' => 20,
            ),
            'sort' => array(
                'defaultOrder' => 'umail_count DESC',
                'sortVar' => 'sort',
                'attributes' => array(
                    'added_on',
                    'modified_on',
                    /* 'name' => array(
                      'asc' => 'name',
                      'desc' => 'name DESC',
                      ), */
                    'passout_year' => array(
                        'asc' => 'passout_year',
                        'desc' => 'passout_year DESC',
                    ),
                    'umail_count' => array(
                        'asc' => 'umail_count',
                        'desc' => 'umail_count DESC',
                    ),
                ),
            )
        ));
    }

    public function getProfileValidatedReport() {

        $sql = "SELECT CONCAT(UM.first_name,' ',UM.last_name) AS name,UM.user_id,LM.login_id,
            LM.username,LM.is_request_message,LM.profile_validate_status,LM.validated_by,LM.request_validated_on,LM.validated_on,
            LM.is_umail_update,LM.is_student_profile_confirmed,SN.number,LM.is_valid,UM.passout_year, LS.school_name,LM.added_on,
            (SELECT admin_full_name FROM tbl_admin WHERE admin_id=LM.validated_by) as validatedBy
            FROM tbl_user_master UM
            LEFT JOIN login_master LM ON UM.login_ref_id = LM.login_id
            LEFT JOIN student_preferred_country spc ON spc.user_ref_id = UM.user_id
            LEFT JOIN student_preferred_department spd ON spd.user_ref_id = UM.user_id
            LEFT JOIN lookup_school LS ON LS.school_id = UM.school_ref_id
            LEFT JOIN student_contact_number SN ON (SN.user_ref_id = UM.user_id AND is_primary =1 AND contact_type_ref_id=1)
            WHERE 1=1";

        if ($this->passout_year) {
            $sql .= " AND UM.passout_year = '$this->passout_year' ";
        }
        if ($_GET['TblUserMaster']['country_pref']) {
            $this->country_pref = $_GET['TblUserMaster']['country_pref'];
            $sql .= " AND spc.country_ref_id = '" . $_GET['TblUserMaster']['country_pref'] . "'";

            if ($_GET['TblUserMaster']['country_pref_order'])
                $sql .= " AND spc.preference_order = '" . $_GET['TblUserMaster']['country_pref_order'] . "'";
        }
        if ($_GET['TblUserMaster']['dept_pref']) {
            $sql .= " AND spd.main_dept_ref_id = '" . $_GET['TblUserMaster']['dept_pref'] . "'";

            if ($_GET['TblUserMaster']['dept_pref_order'])
                $sql .= " AND spd.preference_order = '" . $_GET['TblUserMaster']['dept_pref_order'] . "'";
        }
        if ($this->critical_percent) {
            list($p1, $p2) = explode('-', $this->critical_percent);
            $sql .= " AND UM.critical_percent BETWEEN " . $p1 . " AND " . $p2 . " ";
        }
        if ($this->modified_on) {
            $delta = (int) trim($this->modified_on, '-');
            $op = '>';
            if (strstr($this->modified_on, '-')) {
                $op = '<';
            }
            list($y, $m, $d) = explode('-', date('Y-m-d'));
            $date = date('Y-m-d', mktime(0, 0, 0, $m, $d - $delta, $y));
            $sql .= " AND UM.modified_on " . $op . " '" . $date . "' AND UM.modified_on IS NOT NULL";
        }
        if ($_GET['TblUserMaster']['profile_validate_status']) {
            if ($_GET['TblUserMaster']['profile_validate_status'] == 'Validated')
                $sql .= " AND LM.is_student_profile_confirmed = 1";
            else
                $sql .= " AND LM.profile_validate_status = '" . $_GET['TblUserMaster']['profile_validate_status'] . "'";
        }
        if ($_GET['TblUserMaster']['validated_by']) {
            $sql .= " AND LM.validated_by = '" . $_GET['TblUserMaster']['validated_by'] . "'";
        }
        if ($_GET['TblUserMaster']['username']) {
            $sql .= " AND (LM.username LIKE '%" . $_GET['TblUserMaster']['username'] . "%' OR UM.first_name LIKE '%" . $_GET['TblUserMaster']['username'] . "%' OR UM.last_name LIKE '%" . $_GET['TblUserMaster']['username'] . "%')";
        }
        $sql .= " AND LM.profile_validate_status = 'RequestValidate' GROUP BY UM.user_id";

        //echo '###'.$sql;
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        return new CArrayDataProvider($rawData, array(
            'pagination' => array(
                'pageSize' => 20,
            ),
            'sort' => array(
                'defaultOrder' => 'umail_count DESC',
                'sortVar' => 'sort',
                'attributes' => array(
                    'request_validated_on',
                    'validated_on',
                    'request_validated_on' => array(
                        'asc' => 'request_validated_on',
                        'desc' => 'request_validated_on DESC',
                    ),
                ),
            )
        ));
    }

    public static function getProspectPassouts() {
        $criteria = new CDbCriteria;
        $criteria->select = 't.passout_year';
        $criteria->distinct = true;
        $criteria->join = " INNER JOIN prospect p ON t.user_id = p.user_ref_id ";
        $criteria->condition = " t.passout_year > 0 ";
        $criteria->order = " passout_year asc ";
        $passouts = TblUserMaster::model()->findAll($criteria);
        $passoutList = array();
        foreach ($passouts as $year) {
            $passoutList[$year->passout_year] = $year->passout_year;
        }
        return $passoutList;
    }

    public static function getDetails($uid) {
        $sql = 'SELECT * FROM tbl_user_master
                WHERE user_id=' . $uid . '';
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public function getPreferredCareersRelatedDept() {
        $courses = $this->studentPreferredCareers;
        $data = array();

        foreach ($courses as $course) {
            $data[$course->student_preferred_career_id]['main_dept_ref_id'] = $course->careerRef->main_dept_ref_id;
        }

        return $data;
    }

}
