<?php

class ValidatePassoutYear extends CComponent {

    public $userId = null;
    private $passout_year;

    public function validateClass() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $user = TblUserMaster::model()->findByPk($this->userId);
        if (!$user->user_id) {
            return 0;
        }

        $current_year = date('Y');

        $profile_creation_year = date('Y', strtotime($user->added_on));
        $profile_creation_month = date('n', strtotime($user->added_on));
        $this->passout_year = $user->passout_year;
        if ($this->passout_year == 0) {
            return 0;
        }

        $present_class = $user->present_class;
        $class_status = $user->class_status;
        $return = 0;
        $user->present_board_ref_id = $user->present_board_ref_id ? $user->present_board_ref_id : 1;
        switch ($profile_creation_year) {
            case $current_year - 2:
                switch ($user->present_board_ref_id) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return = $this->checkYearMinus2($present_class, $class_status, $current_year, $profile_creation_month, 2);
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return = $this->checkYearMinus2($present_class, $class_status, $current_year, $profile_creation_month, 6);
                        break;
                }
                break;
            case $current_year - 1:
                switch ($user->present_board_ref_id) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return = $this->checkYearMinus1($present_class, $class_status, $current_year, $profile_creation_month, 2);
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return = $this->checkYearMinus1($present_class, $class_status, $current_year, $profile_creation_month, 6);
                        break;
                }
                break;
            case $current_year:
                switch ($user->present_board_ref_id) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return = $this->checkYear($present_class, $class_status, $current_year, $profile_creation_month, 2);
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return = $this->checkYear($present_class, $class_status, $current_year, $profile_creation_month, 6);
                        break;
                }
                break;
            default:
                $return = 0;
                break;
        }
        return $return;
    }

    private function checkYearMinus2($present_class, $class_status, $current_year, $profile_creation_month, $month_filter) {
        $return = 0;
        if ($present_class == 10 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = ($this->passout_year == ($current_year + 1)) ? 1 : 0;
            } else {
                $return = ($this->passout_year == ($current_year)) ? 1 : 0;
            }
        } elseif ($present_class == 11 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = ($this->passout_year == ($current_year)) ? 1 : 0;
            } else {
                $return = ($this->passout_year == ($current_year - 1)) ? 1 : 0;
            }
        } elseif ($present_class == 12 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = ($this->passout_year == ($current_year - 1)) ? 1 : 0;
            } else {
                $return = ($this->passout_year == ($current_year - 2)) ? 1 : 0;
            }
        } elseif ($present_class == 12 && $class_status == 'Completed') {
            $return = ($this->passout_year <= ($current_year - 2)) ? 1 : 0;
        }

        return $return;
    }

    private function checkYearMinus1($present_class, $class_status, $current_year, $profile_creation_month, $month_filter) {
        $return = 0;
        if ($present_class == 10 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = ($this->passout_year == ($current_year + 2)) ? 1 : 0;
            } else {
                $return = ($this->passout_year == ($current_year + 1)) ? 1 : 0;
            }
        } elseif ($present_class == 11 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = ($this->passout_year == ($current_year + 1)) ? 1 : 0;
            } else {
                $return = ($this->passout_year == ($current_year)) ? 1 : 0;
            }
        } elseif ($present_class == 12 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = ($this->passout_year == ($current_year)) ? 1 : 0;
            } else {
                $return = ($this->passout_year == ($current_year - 1)) ? 1 : 0;
            }
        } elseif ($present_class == 12 && $class_status == 'Completed') {
            $return = ($this->passout_year <= ($current_year - 1)) ? 1 : 0;
        }
        return $return;
    }

    private function checkYear($present_class, $class_status, $current_year, $profile_creation_month, $month_filter) {
        $return = 0;
        if ($present_class == 10 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = ($this->passout_year == ($current_year + 3)) ? 1 : 0;
            } else {
                $return = ($this->passout_year == ($current_year + 2)) ? 1 : 0;
            }
        } elseif ($present_class == 11 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = ($this->passout_year == ($current_year + 2)) ? 1 : 0;
            } else {
                $return = ($this->passout_year == ($current_year + 1)) ? 1 : 0;
            }
        } elseif ($present_class == 12 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = ($this->passout_year == ($current_year + 1)) ? 1 : 0;
            } else {
                $return = ($this->passout_year == ($current_year)) ? 1 : 0;
            }
        } elseif ($present_class == 12 && $class_status == 'Completed') {
            $return = ($this->passout_year <= ($current_year)) ? 1 : 0;
        }
        return $return;
    }
}