<?php

class StudentPassoutYear extends CComponent {

    public $userId = null;
    private $passout_year;

    public function getClass() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $user = TblUserMaster::model()->findByPk($this->userId);
        if (!$user->user_id) {
            return 0;
        }

        $current_year = date('Y');

        $profile_creation_year = date('Y', strtotime($user->added_on));
        $profile_creation_month = date('n', strtotime($user->added_on));
        $this->passout_year = $user->passout_year;

        $present_class = $user->present_class;
        $class_status = $user->class_status;
        $return = 0;
        $user->present_board_ref_id = $user->present_board_ref_id ? $user->present_board_ref_id : 1;
        switch ($profile_creation_year) {
            case $current_year - 2:
                switch ($user->present_board_ref_id) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return = $this->checkYearMinus2($present_class, $class_status, $current_year, $profile_creation_month, 3);
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return = $this->checkYearMinus2($present_class, $class_status, $current_year, $profile_creation_month, 6);
                        break;
                }
                break;
            case $current_year - 1:
                switch ($user->present_board_ref_id) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return = $this->checkYearMinus1($present_class, $class_status, $current_year, $profile_creation_month, 3);
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return = $this->checkYearMinus1($present_class, $class_status, $current_year, $profile_creation_month, 6);
                        break;
                }
                break;
            case $current_year:
                switch ($user->present_board_ref_id) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return = $this->checkYear($present_class, $class_status, $current_year, $profile_creation_month, 3);
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return = $this->checkYear($present_class, $class_status, $current_year, $profile_creation_month, 6);
                        break;
                }
                break;
            default:
                $return = 0;
                break;
        }
        return $return;
    }

    private function checkYearMinus2($present_class, $class_status, $current_year, $profile_creation_month, $month_filter) {
        $return = 0;
        if ($present_class == 10 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = $current_year + 1;
            } else {
                $return = $current_year;
            }
        } elseif ($present_class == 11 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = $current_year;
            } else {
                $return = $current_year - 1;
            }
        } elseif ($present_class == 12 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = $current_year - 1;
            } else {
                $return = $current_year - 2;
            }
        } elseif ($present_class == 12 && $class_status == 'Completed') {
            $return = $current_year - 2;
        }

        return $return;
    }

    private function checkYearMinus1($present_class, $class_status, $current_year, $profile_creation_month, $month_filter) {
        $return = 0;
        if ($present_class == 10 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = $current_year + 2;
            } else {
                $return = $current_year + 1;
            }
        } elseif ($present_class == 11 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = $current_year + 1;
            } else {
                $return = $current_year;
            }
        } elseif ($present_class == 12 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = $current_year;
            } else {
                $return = $current_year - 1;
            }
        } elseif ($present_class == 12 && $class_status == 'Completed') {
            $return = $current_year - 1;
        }
        return $return;
    }

    private function checkYear($present_class, $class_status, $current_year, $profile_creation_month, $month_filter) {
        $return = 0;
        if ($present_class == 10 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = $current_year + 3;
            } else {
                $return = $current_year + 2;
            }
        } elseif ($present_class == 11 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = $current_year + 2;
            } else {
                $return = $current_year + 1;
            }
        } elseif ($present_class == 12 && $class_status == 'Pursuing') {
            if ($profile_creation_month > $month_filter) {
                $return = $current_year + 1;
            } else {
                $return = $current_year;
            }
        } elseif ($present_class == 12 && $class_status == 'Completed') {
            $return = $current_year;
        }
        return $return;
    }

    public function recalculateStudentPassoutYear() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $user = TblUserMaster::model()->findByPk($this->userId);
        if (!$user->user_id) {
            return 0;
        }

        $currentYear = date('Y', strtotime($user->added_on));
        $currentMonth = date('n', strtotime($user->added_on));
        $return = array();

        if ($user->present_board_ref_id) {
            $board = $user->present_board_ref_id;
        } else {
            $education = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$this->userId, 'class_level'=>'12'));
            $board = $education->boardRef->board_ref_id;
        }
        $class = $user->present_class;
        $class_status = ($user->class_status == "Pursuing") ? 'p' : 'c';
        $class = $class.$class_status;

        switch ($class) {
            case '10p':
                switch ($board) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return['month'] = 2;
                        if ($currentMonth <= 2) {
                            $return['year'] = $currentYear+2;
                        } else {
                            $return['year'] = $currentYear+3;
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return['month'] =  6;
                        if ($currentMonth <= 6) {
                            $return['year'] = $currentYear+2;
                        } else {
                            $return['year'] = 3;
                        }
                        break;
                }
                break;
            case '11p':
                switch ($board) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return['month'] =  2;
                        if ($currentMonth <= 2) {
                            $return['year'] = $currentYear+1;
                        } else {
                            $return['year'] = $currentYear+2;
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return['month'] =  6;
                        if ($currentMonth <= 6) {
                            $return['year'] = $currentYear+1;
                        } else {
                            $return['year'] = $currentYear+2;
                        }
                        break;
                }
                break;
            case '12p':
                switch ($board) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return['month'] =  2;
                        if ($currentMonth <= 2) {
                            $return['year'] = $currentYear;
                        } else {
                            $return['year'] = $currentYear+1;
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return['month'] =  6;
                        if ($currentMonth <= 6) {
                            $return['year'] = $currentYear;
                        } else {
                            $return['year'] = $currentYear+1;
                        }
                        break;
                }
                break;
            case '12c':
                switch ($board) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return['month'] =  2;
                        if ($currentMonth <= 2) {
                            $return['year'] = $currentYear - 1;
                        } else {
                            $return['year'] = $currentYear;
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return['month'] =  6;
                        if ($currentMonth <= 6) {
                            $return['year'] = $currentYear - 1;
                        } else {
                            $return['year'] = $currentYear;
                        }
                        break;
                }
                break;
        }
        if ($user->present_class) {
            $user->passout_year = $return['year'];
            $user->passout_month = $return['month'];
            $user->save(false);
        }
        return $return;
    }
}

