<?php
$model = new ProfileData($section);
$user = TblUserMaster::model()->findByPk($user_id);

$countryData = Yii::app()->db->createCommand()
    ->from('tbl_country_master as tcm')
    ->select('phone_code, country_name')
    ->where('is_active= "Y" AND country_code <> "" ')
    ->order('country_name ASC')
    ->queryAll();
$country_list = array();

foreach ($countryData as $country) {
    $phone_code = $country['phone_code'];
    $country_list[$phone_code] = $country['country_name']." (+$phone_code)";
}
asort($country_list);

$citizenshipList = CHtml::listData(TblCountryMaster::getActiveCountriesList(), 'country_id', 'country_name');

$emailModel = StudentAlternateEmail::model()->find(array("condition" => "login_ref_id = '" . $user->login_ref_id . "' AND  contact_type_ref_id = 1"));
$contactModel = StudentContactNumber::model()->find(array("condition" => "user_ref_id = '" . $user->user_id . "' AND  contact_type_ref_id = 1 AND is_primary = 1"));
$model->country_ref_id = $user->country_ref_id;
$model->address1 = $user->address1;
$model->address2 = $user->address2;
$model->post_code = $user->post_code;
$model->city_ref_id = $user->city_ref_id;
$model->introduce_yourself = $user->introduce_yourself;
$model->alternate_email = $emailModel->email_id;
$model->country_code = $contactModel->country_code ? $contactModel->country_code : $user->countryRef->phone_code;
$model->phone = $contactModel->number ? $contactModel->number : '';

Yii::app()->clientScript->corePackages = array();
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'OfferData'.uniqid(),
    'htmlOptions' => array('class'=>'OfferData'),
    'action' => array('/myProfile/validate?section='.$section),
    'enableAjaxValidation' => true,
    'enableClientValidation' => false,
    'clientOptions' => array(
        'validateOnSubmit' => true,
        //'validateOnChange' => false,
        'beforeValidate'=> 'js:function(){
          $("#main_data").hide();
          $("#load_data").show();
           return true;
        }',
        'validateOnType' => false,
        'afterValidate' => 'js:function(form, data, hasError){
                        if(!$.isEmptyObject(data)){
                          $("#main_data").show();
                          $("#load_data").hide();
                            for(var i in data) {
                                var id = i, message = data[i][0];
                               $("#"+i+"_em_").html(message).show();
                            }
                            $("html, body").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 100 }, 1000);
                            return false;
                        }else{
                            post_data();
                        }
                    }',
    ),
));
echo $form->hiddenField($model,'user_id',array('value'=>$user_id));
echo $form->hiddenField($model,'section',array('value'=>$section));
$i = 0;
?>
<div class="row multi_line small-gutter current-selection visible">
<div class="row border-bottom gutter_vertical">
    <h3 class="left profile-nav title current">Personal Information</h3>
</div>

<div class="gutter_vertical visible clearfix">
    <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">Mobile Number</div>
    <div class="grid_2 pull small_gutter_r relative styledSelect2 ">
        <?php
        echo $form->dropDownList($model, 'country_code',$country_list, array('empty'=>'Country Code', 'class'=>'full-width'));
        echo $form->error($model, 'country_code', array("class" => "errorMessage popup"));
        ?>
    </div>
    <div class="grid_4 pull relative">
        <?php
        echo $form->textField($model, 'phone', array('placeholder'=>"Mobile Number", "maxlength"=>"12","class"=>"full-width"));
        echo $form->error($model, 'phone', array("class" => "errorMessage popup"));
        ?>
    </div>
</div>
        <div class="gutter_vertical visible clearfix">
            <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">Email</div>
            <div class="grid_6 pull small_gutter_r relative">
                <div class="small_gutter_t color-gray small"><?php echo $user->loginRef->username; ?></div>
            </div>
        </div>
        <div class="gutter_vertical visible clearfix">
            <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">Alternate Email</div>
            <div class="grid_6 pull small_gutter_r relative">
                <?php echo $form->textField($model, "alternate_email", array('maxlength' => "50", 'placeholder' => 'Alternate Email Address (optional)','class'=>'full-width'));?>
                <?php echo $form->error($model, "alternate_email", array('class'=>'popup errorMessage')); ?>
            </div>
        </div>
<?php
$cnt = 1;
if($user->father_first_name){
    $model->pfname[$cnt] = $user->father_first_name;
    $model->plname[$cnt] = $user->father_last_name;
    $model->contact_type_ref_id[$cnt] = 2;
    $cnt++;
}
if($user->mother_first_name){
    $model->pfname[$cnt] = $user->mother_first_name;
    $model->plname[$cnt] = $user->mother_last_name;
    $model->contact_type_ref_id[$cnt] = 3;
    $cnt++;
}
if($user->guardian_first_name){
    $model->pfname[$cnt] = $user->guardian_first_name;
    $model->plname[$cnt] = $user->guardian_last_name;
    $model->contact_type_ref_id[$cnt] = 4;
    $cnt++;
}
if ($cnt>1) {
    for($j=1; $j<$cnt; $j++)
    {
        $i++;
        $emailInfo = StudentAlternateEmail::model()->find('login_ref_id = '.$user->login_ref_id.' AND contact_type_ref_id = '.$model->contact_type_ref_id[$i].' ');
        $model->emails[$i] = $emailInfo->email_id;
        $contact = StudentContactNumber::model()->find('user_ref_id = '.$user->user_id.' AND contact_type_ref_id= '.$model->contact_type_ref_id[$i].' ');
        $model->country_codes[$i] = $contact->country_code;
        $model->phones[$i] = $contact->number;
        ?>
    <div class="gutter_vertical visible DivCount" id="otherInfo_<?php echo $i; ?>">
        <div class="clearfix gutter_vertical visible">
            <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">Parent (optional)</div>
            <div class="grid_2 pull small_gutter_r styledSelect2 relative">
                <?php $contactTypeList = CHtml::listData(LookupContactType::getContactType(true), 'contact_type_id', 'contact_type');
                echo $form->dropDownList($model, "contact_type_ref_id[".$i."]", $contactTypeList, array('class'=>'full-width','empty'=>'Choose Relationship'));
                echo $form->error($model, "contact_type_ref_id[".$i."]", array('class'=>'popup errorMessage'));
                ?>
            </div>
            <div class="grid_2 pull small_gutter_r relative">
                <?php echo $form->textField($model, "pfname[".$i."]", array('maxlength' => "50", 'placeholder' => 'Parent Name','class'=>'full-width'));?>
                <?php echo $form->error($model, "pfname[".$i."]", array('class'=>'popup errorMessage')); ?>
            </div>
            <div class="grid_2 pull small_gutter_r relative">
                <?php echo $form->textField($model, "emails[".$i."]", array('maxlength' => "50", 'placeholder' => 'Email Address','class'=>'full-width'));?>
                <?php echo $form->error($model, "emails[".$i."]", array('class'=>'popup errorMessage')); ?>
            </div>
        </div>

        <div class="clearfix gutter_vertical visible">
            <div class="grid_2 pull small_gutter_r display-non text-right small_gutter_t small">&nbsp;</div>
            <div class="grid_2 pull small_gutter_r styledSelect2 relative">
                <?php
                echo $form->dropDownList($model, "country_codes[".$i."]",$country_list, array('empty'=>'Country Code', 'class'=>'full-width'));
                echo $form->error($model, "country_codes[".$i."]", array("class" => "errorMessage popup"));
                ?>
            </div>
            <div class="grid_4 pull small_gutter_r relative">
                <?php
                echo $form->textField($model, "phones[".$i."]", array('placeholder'=>"Mobile Number", "maxlength"=>"12","class"=>"full-width"));
                echo $form->error($model, "phones[".$i."]", array("class" => "errorMessage popup"));
                ?>
            </div>
        </div>
        <div class="gutter_vertical">
            <?php
            if ($cnt-1 == $i) {
                echo "<a  id='add_".$i."'  onclick='add_more(".$i.")' rel='".$i."' href='javascript:void(0)' class='add_parent push_2'><i class='fa fa-plus small_gutter_r'></i> Add other parent</a>";
                echo "<a id='remove_".$i."' style='display: none' class='rem_parent push_2'  onclick='deleteParentInfo(".$i.",".$model->contact_type_ref_id[$i].")' href='javascript:void(0)'> &nbsp;&nbsp;Remove</a>";
            } else {
                echo "<a id='remove_".$i."' rel='".$i."' onclick='deleteParentInfo(".$i.",".$model->contact_type_ref_id[$i].")' href='javascript:void(0)' class='push_2'>&nbsp;&nbsp; Remove</a>";
                echo "<a id='add_".$i."' style='display: none' onclick='add_more(".$i.")' class='rem_parent' href='javascript:void(0)' class='add_parent push_2'> &nbsp;&nbsp;<i class='fa fa-plus small_gutter_r'></i> Add other parent</a>";
            }
            ?>

        </div>

    </div>
        <?php }   } else { $i++;
    ?>
    <?php
    $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$user_id, 'step_no'=>5));
    if($det || in_array($user->present_class, array(9, 10)) || $user->class_change) { ?>
        <div class="row">
            <a href="javascript:void(0)" onclick="$('#other_par').hide();$('.DivCount').show();
        <?php if(in_array($user->present_class, array(11, 12)) && !$user->father_first_name){ ?>
            $('#ProfileData_contact_type_ref_id_1').focus();
         <?php } ?>" id="other_par" class="push_2"><i class="fa fa-plus"></i> Add parent details</a>
        </div>
    <?php } ?>
<div class="gutter_vertical visible DivCount" id="otherInfo_<?php echo $i; ?>">
    <div class="clearfix gutter_vertical visible">
        <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">Parent (optional)</div>
        <div class="grid_2 pull small_gutter_r styledSelect2 relative">
            <?php $contactTypeList = CHtml::listData(LookupContactType::getContactType(true), 'contact_type_id', 'contact_type');
            echo $form->dropDownList($model, "contact_type_ref_id[".$i."]", $contactTypeList, array('class'=>'full-width','empty'=>'Choose Relationship'));
            echo $form->error($model, "contact_type_ref_id[".$i."]", array('class'=>'popup errorMessage'));
            ?>
        </div>
        <div class="grid_2 pull small_gutter_r relative">
            <?php echo $form->textField($model, "pfname[".$i."]", array('maxlength' => "50", 'placeholder' => 'Parent Name','class'=>'full-width'));?>
            <?php echo $form->error($model, "pfname[".$i."]", array('class'=>'popup errorMessage')); ?>
        </div>
        <div class="grid_2 pull small_gutter_r relative">
            <?php echo $form->textField($model, "emails[".$i."]", array('maxlength' => "50", 'placeholder' => 'Email Address','class'=>'full-width'));?>
            <?php echo $form->error($model, "emails[".$i."]", array('class'=>'popup errorMessage')); ?>
        </div>
    </div>

    <div class="clearfix gutter_vertical visible">
        <div class="grid_2 pull small_gutter_r display-non text-right small_gutter_t small">&nbsp;</div>
        <div class="grid_2 pull small_gutter_r styledSelect2 relative">
            <?php
            echo $form->dropDownList($model, "country_codes[".$i."]",$country_list, array('empty'=>'Country Code', 'class'=>'full-width'));
            echo $form->error($model, "country_codes[".$i."]", array("class" => "errorMessage popup"));
            ?>
        </div>
        <div class="grid_4 pull small_gutter_r relative">
            <?php
            echo $form->textField($model, "phones[".$i."]", array('placeholder'=>"Mobile Number", "maxlength"=>"12","class"=>"full-width"));
            echo $form->error($model, "phones[".$i."]", array("class" => "errorMessage popup"));
            ?>
        </div>
    </div>
    <div class="gutter_vertical push_2">
        <?php
        echo "<a  id='add_".$i."'  onclick='add_more(".$i.")' rel='".$i."' href='javascript:void(0)' class='add_parent'><i class='fa fa-plus'></i> Add other parent</a>";
        echo "<a id='remove_".$i."' style='display: none'  onclick='remov(".$i.")' class='rem_parent' href='javascript:void(0)'>Remove</a>";
        ?>
    </div>
</div>

    <?php } ?>

<div class="center gutter-verticle-auto">
    <?php echo CHtml::submitButton('submit', array('value' => 'Save', 'class' => "button-blue tny small_gutter_r")); ?>
    <?php
    $sec_status = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$user_id, 'step_no'=>5));
    if ($sec_status) {
        $sec = $this->get_section($user_id);
        ?>
        <a href="javascript:void(0)" onclick="load_next(<?php echo $user_id ?>, '<?php echo $sec; ?>');" class="color-gray small "><span class="small">Cancel</span></a>
        <?php } ?>
</div>
</div>
<?php $this->endWidget(); ?>
<script type="text/javascript">

    $(function(){
        <?php if(in_array($user->present_class, array(9, 10))){ ?>
        $("#other_par").trigger("click");
        <?php } ?>
    });
    $("body").on('focus', 'input, select',function(){
        $(this).next('div.errorMessage').hide('slow');
    })
    function remov(id) {
        var new_id = id+1;
        $('#otherInfo_'+id).remove();
        show_hide_dept(new_id);
    }
    function add_more(id) {
        var new_id = id+1;

        $.ajax({
            url: "/app/myProfile/otherAddMore",
            type: "POST",
            data: { id: new_id},
            context: document.body
        }).done(function(data) {
                    $("#otherInfo_"+id).after(data);
                    show_hide_dept(new_id);
                });
    }

    function post_data() {
        var datastring = $(".OfferData").serialize();
        $.ajax({
            type: "POST",
            url: "/app/myProfile/saveOtherInfo",
            data: datastring,
            dataType: "json",
            success: function(data) {
                load_next(data.user_id, data.section);
            },
            error: function(){
                alert('error handing here');
            }
        });
    }

    $('#ProfileData_country_ref_id').change(function(){
        var countryId = $(this).val();
        $.ajax({
            type: "GET",
            data: "countryId="+countryId,
            url: "<?php echo Yii::app()->createUrl("student/profile/getCityList")?>",
            async: false,
            success: function(data){
                var listData = $.parseJSON(data);
                dropdownElement = $("#ProfileData_city_ref_id");
                dropdownElement.find('option').remove();
                dropdownElement.append($('<option></option>').val('').html('Choose City'));
                $.each(listData, function(index, value){
                    dropdownElement.append($('<option></option>').val(index).html(value));
                });
                $("#ProfileData_city_ref_id").show();
            }
        });
    });

    function deleteParentInfo(id, deleteId){
        if(confirm("Are you sure to remove contact?"))
        {
            $('#otherInfo_'+id).remove();
            if(deleteId>0){
                $.ajax({
                    url: "/app/myProfile/deleteParentInfo",
                    type: "POST",
                    data: { id: deleteId,user_id:<?php echo Yii::app()->request->getParam('user_id')?>},
                    context: document.body
                }).done(function(data) {
                            show_hide_dept(id+1);
                        });
            }
        }
    }

    function show_hide_dept(id) {
        var len = $('a.add_parent').length;
        if ($('a.add_parent').length == 3) {
            $('a.add_parent').hide();
            $('a.rem_parent').show();
            //$('#remove_3').focus();
            $('#ProfileData_contact_type_ref_id_'+id).focus();
        } else if ($('a.add_parent').length == 1) {
            $('a.add_parent').show();
            $('a.rem_parent').hide();
            $('#ProfileData_contact_type_ref_id_'+id).focus();
        } else {
            var j = 0;
            //$('#add_2').focus();
            $('#ProfileData_contact_type_ref_id_'+id).focus();

            $('a.add_parent').each( function() {
                rel_tag = $(this).attr('rel');
                if (j == 0) {
                    $('#add_'+rel_tag).hide();
                    $('#remove_'+rel_tag).show();
                    //$('#remove_'+rel_tag).focus();
                    $('#ProfileData_contact_type_ref_id_'+rel_tag).focus();
                } else {
                    $('#add_'+rel_tag).show();
                    $('#remove_'+rel_tag).hide();
                    $('#ProfileData_contact_type_ref_id_'+rel_tag).focus();
                    //$('#add_'+rel_tag).focus();
                }
                j = j + 1;
            });
        }
    }

</script>