<?php
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/themes/new_grid_theme/views/layouts/javascript/mailcheck.min.js", CClientScript::POS_END);

Yii::import('application.components.signupHelper.*');
$helper_obj = new signupHelper();
$res = $helper_obj->validateProfileAfterSignup();
?>
<section id="banner">
    <style type="text/css">
        #suggestedEmail{
        color: #B94A48 !important;
        font-size: 0.9em !important;
        }
        .domain{
        color: #08c !important;
        font-weight: bold !important;
        text-decoration: underline !important;
        }
        .suggestedMail{
            margin-left: 261px !important;
        }
        .reject-link {background: url('<?php Yii::app()->baseUrl;?>/../images/reject.png') no-repeat left center transparent; font-size: 0.9em; padding-left: 17px;}
    </style>
    <script>
        $(function(){
            $("input, select").on('focus', function(){
                $(this).next('div.errorMessage').hide('slow');
            })
        });

        function removeSpace(val, id){
            //$("#"+id).val($.trim(val));
        }
    </script>
    <div class="ground" style="background-position: 0 100%;">
        <div style="background-position: 8.45714% 40.7%; transition: all 0.5s linear 0s;" class="clouds">
            <div style="height: 630px;" class="shadow clearfix">
                <div class="slide-container signup" style="display: block; right: 23%; top: 4%; width: 533px;">
                    <div class="center">
                        <h3 class="uppercase gutter_vertical">Welcome to Univariety</h3>
                        <span>Discover a world of careers, colleges and scholarship options</span>
                    </div>
                    <div>
                        <?php
                        $form = $this->beginWidget('CActiveForm', array(
                            'id' => 'signupB2CData',
                            'enableAjaxValidation' => true,
                            'enableClientValidation' => false,
                            'clientOptions' => array(
                                'validateOnSubmit' => true,
                                'validateOnChange' => false,
                                'validateOnType' => false,
                                'afterValidate'=>'js:function(form,data,hasError){
                                    if(!hasError){
                                        ga("send", "event", "signupb2c", "page", "'.$res.'");
                                    }
                                    return true;
                                }'
                            ),
                        ));
                        ?>
                            <div class="row no-gutter clearfix no-outer-gutter visible">
                                <div class="no-gutter grid_3 pull relative gutter_horizontal">
                                    <?php
                                        echo $form->textField($model, 'first_name', array('placeholder'=>"First Name", 'class'=>'gutter_horizontal', "maxlength"=>"20"));
                                        echo $form->error($model, 'first_name', array("class" => "errorMessage popup"));
                                    ?>
                                </div>
                                <div class="no-gutter grid_3 pull relative">
                                    <?php
                                        echo $form->textField($model, 'last_name', array('placeholder'=>"Last Name ", "maxlength"=>"20"));
                                        echo $form->error($model, 'last_name', array("class" => "errorMessage popup"));
                                    ?>
                                </div>
                            </div>
                            <div class="no-gutter relative">
                                <?php
                                    echo $form->textField($model, 'username', array('placeholder'=>"Your Email Address", 'onkeyup' => 'return removeSpace(this.value, "StudentSignupB2C_username");', "maxlength"=>"40"));
                                    echo $form->error($model, 'username', array("class" => "errorMessage popup"));
                                ?>
                            </div>
                            <span id="suggestedEmail"></span>

                            <div class="no-gutter relative">
                                <?php
                                    echo $form->textField($model, 'confirm_username', array('placeholder'=>"Confirm Your Email Address", 'onkeyup' => 'return removeSpace(this.value, "StudentSignupB2C_confirm_username");', "maxlength"=>"40"));
                                    echo $form->error($model, 'confirm_username', array("class" => "errorMessage popup"));
                                ?>
                            </div>
                            <div class="no-gutter relative">
                                <?php
                                    $model->password = '';
                                    echo $form->passwordField($model, 'password', array('placeholder'=>"Password", "maxlength"=>"25"));
                                    echo $form->error($model, 'password', array("class" => "errorMessage popup"));
                                ?>
                            </div>
                            <div class="row visible no-gutter relative">
                                <?php
                                echo $form->dropDownList($model, 'present_class', $this->currentStudyLevelArray, array('empty'=>'You are a student in'));
                                echo $form->error($model, 'present_class', array("class" => "errorMessage popup"));
                                ?>
                            </div>
                            <div class="no-gutter relative normal-font" >
                                <?php
                                    echo '<span style="margin-right: 25px;">';
                                    echo $form->radioButton($model, 'gender', array( 'value'=>'M' ,'uncheckValue'=>null, 'class'=>'left grid_0'));
                                    echo ' Male</span>';

                                    echo '<span style="">';
                                    echo $form->radioButton($model, 'gender', array( 'value'=>'F' ,'uncheckValue'=>null, 'class'=>'left grid_0'));
                                    echo ' Female</span>';

                                    echo $form->error($model, 'gender', array("class" => "errorMessage popup"));
                                ?>
                            </div>

                            <p class="row center normal-font" style="margin-bottom: 7px;">By clicking 'Sign Up' you agree to our <a href="/app/content/termscondition" target="_blank">Terms & Conditions</a></p>
                            <?php echo CHtml::submitButton('Sign Up', array('value' => 'Sign Up', 'class' => "button-blue tny full", 'id'=>"studentSignUp")); ?>
                        <?php $this->endWidget(); ?>
                    </div>
                </div>
            </div>
            <div style="background-position: 7.4% 0; height: 104px; bottom: 0;" class="grass"></div>
        </div>
    </div>

</section>
<script>
    $(function(){
        $('#StudentSignupB2C_username').on('blur',function() {
            $(this).mailcheck({
                suggested: function(element, suggestion) {
                var suggestion = "Did you mean <span class='suggestion'>" +
                                                           "<span class='address'>" + suggestion.address + "</span>"
                                                           + "@<a href='#' class='domain'>" + suggestion.domain +
                                                           "</a></span>?  " + "<span class = 'reject-link'></span>";
                $("#suggestedEmail").html(suggestion).fadeIn(150);
                $('#suggestedEmail').addClass('suggestedMail');
                }
            });
        });

        $("#suggestedEmail").on('click', '.domain', function() {
          // On click, fill in the field with the suggestion and remove the suggestedEmail div
          $('#StudentSignupB2C_username').val($(".suggestion").text());
          $("#suggestedEmail").fadeOut(200, function() {
            $(this).empty();
          });
          return false;
        });

        $("body").on('click', 'span .reject-link',function() {
            // On click, hide the suggestedEmail div
            $("#suggestedEmail").hide();
            return false;
        });
    });
</script>