
<?php if (empty($webinars_data['events'])): ?>

    <div class="row multi_line">
        <div class="row center div-inner-gutter-space">
            <img src="/app/themes/new_grid_theme/views/layouts/images/empty-box.jpg" alt="">
        </div>
        <h4 class="row center ">No data found !</h4>
    </div>

<?php else: ?>    
<table class="grid_view no-hover">
    <tr class="gray-bg">
        <th>Title & Major</th>
        <th>Date & Time</th>
        <th class="grid_2">Download Certificate</th>
    </tr>

    <?php foreach ($webinars_data['events'] as $event_id => $event): ?>
        <tr>
            <td>
                <h4><a target="_blank" href="<?php echo $this->createUrl('/webinar/past',array('event' => $event['Event']['webinar_key'])) ?>"><?php echo $event['Event']['event_title']; ?></a></h4>
                <div class="color-gray">
                    <?php 
                        if($event['Department']){
                            echo array_shift($event['Department']);
                            if(!empty($event['Department'])) echo sprintf(' and %d more..', count($event['Department']));
                        }
                    ?>
                </div>
            </td>
            <td class="grid_3">
                <?php
                    $event_start_date_time = DateTime::createFromFormat('Y-m-d H:i:s', $event['Event']['event_start_time'], new DateTimeZone('UTC'));
                    $event_start_date_time->setTimeZone(new DateTimeZone($event['Event']['timezone']));
                    $event_end_date_time = DateTime::createFromFormat('Y-m-d H:i:s', $event['Event']['event_end_time'], new DateTimeZone('UTC'));
                    $event_end_date_time->setTimeZone(new DateTimeZone($event['Event']['timezone']));

                ?>
                <div class="center"><?php echo $event_start_date_time->format('j\<\s\u\p\>S\<\/\s\u\p\> M, Y'); ?></div>
                <div class="center">
                    <?php
                        echo sprintf('%s to %s %s',$event_start_date_time->format('g:ia'), $event_end_date_time->format('g:ia'), $event_end_date_time->format('T'));
                    ?>
                </div>
            </td>
            <td class="center">
                <a href="<?php echo $this->createUrl('download_certificate',array('event' => $event['Event']['webinar_key'])); ?>">
                    <i class="fa fa-file-pdf-o fa-lg"></i>
                </a>
            </td>
        </tr>
    <?php endforeach; ?>
</table>

<?php endif; ?>

