<?php

class StudentSubjectDetail extends CFormModel {

    public $student_subject_ref_id;
    public $marks;
    public $points;
    public $grade;
    public $grade_ref_id;
    public $school_name;
    public $student_education_detail_id;
    public $insertFlag;
    public $class;
    public $board_conversion_ref_id;

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'student_subject_ref_id' => 'subject',
            'marks' => 'marks',
            'points' => 'points',
        );
    }

    /**
     * Declares the validation rules.
     * 
     */
    public function rules() {
        return array(
            array('marks', 'valiadateMarks', 'on' => 'Marks'),
            array('points', 'numerical', 'integerOnly' => true,'message'=>'<div class="holder"><p>Your points should be number</p></div>', 'on' => 'Points'),
            array('student_subject_ref_id, student_education_detail_id, grade_ref_id,board_conversion_ref_id, points, marks, insertFlag, class', 'safe'),
        );
    }

    public function valiadateMarks($attribute, $param) {
        if($this->class == 10 && $_POST['StudentEducationProfile']['10']['board_equivalent_id'] == 1 && $_POST['StudentEducationProfile']['10']['overall_marks']  <= 10){
            if ($this->student_subject_ref_id != '' && $this->marks != '') {
                if (!is_numeric($this->marks)) {
                    $this->addError($attribute, '<div class="holder"><p>Numbers only</p></div>');
                } elseif ($this->marks <= 0) {
                    $this->addError($attribute, '<div class="holder"><p>Marks can not be more than 10</p></div>');
                } elseif ($this->marks > 10) {
                    $this->addError($attribute, '<div class="holder"><p>Marks can not be more than 10</p></div>');
                }
            }
        }else{
            if ($this->student_subject_ref_id != '' && $this->marks != '') {
                if (!is_numeric($this->marks)) {
                    $this->addError($attribute, '<div class="holder"><p>Numbers only</p></div>');
                } elseif ($this->marks <= 0) {
                    $this->addError($attribute, '<div class="holder"><p>Marks between 0 - 100</p></div>');
                } elseif ($this->marks > 100) {
                    $this->addError($attribute, '<div class="holder"><p>Marks between 0 - 100</p></div>');
                }
            }
        }
        
    }

}

?>