<?php
class ProfileController extends Controller
{
    public $activeMenuLink;
	public $userId, $loginRefId = 0;
    public $rbacRole = '';
    public $likelyStartPeriodYear, $userSession;
    public $_hasEdit = false;
    public $_isDI = false;
    public $activeLink;
    public $defaultUserData = array('M' => array('gender' => 'Male', 'defaultImage' => 'user_img_male.jpg'), 'F' => array('gender' => 'Female', 'defaultImage' => 'user_img_female.jpg'));

    public $imageUploadErrorMessage = '';
    public $userImage = '';
    public $isUserImageAvailable = false;
    public $isUploading = false;
    public $userParams = array();
    public $userData;
    public $alumniuserDetails = array();
    public $alumniuserTestDetails = array();
    public $alumniStudentmessage = array();

    public $currentStudyLevelArray = array(
        '9p' => '9th',
        '10p' => '10th',
        '11p' => '11th',
        '12p' => '12th',
        '12c' => '12th Completed',
    );
    public $profileValidationAccess = false;


    public function filters(){
        return array(
            //'rights',
        );
    }
    /*public function accessRules()
    {
        return array(
            array('allow',
                  'users' => array('*'),
            ),
        );
    }*/

    public function init()
    {
        parent::init();
        $cs = Yii::app()->clientScript;
        $cs->scriptMap['main.js'] = false;
        Yii::app()->theme = 'uni_avada';

		if( Yii::app()->session->get('user_type_ref_id') == 2 ) {
			$this->layout = "//layouts/css_track_inner";
		}
		else{
			$this->layout = "//layouts/inner_page";
        }
        //$this->pageTitle = Yii::app()->name .' - Edit Profile';
        $this->userId = CommonUtils::getSessionValue('sUserUnivariety', 'UserId');
        $this->loginRefId = Yii::app()->user->id;
        $this->rbacRole = CommonUtils::getRbacUserRole(Yii::app()->user->id);



        //UN-MASKING USER ID FOR DI
        $requestUserId = base64_decode(Yii::app()->request->getParam('uid'));
        if(($this->rbacRole == 'DI' || $this->rbacRole == 'DiModerator') && Yii::app()->request->getParam('uid') > 0){
            $this->redirect('/app/di/dashboard');
        }
        if($requestUserId > 0){
            //do nothing
        }else{
            $requestUserId = Yii::app()->request->getParam('uid');
        }

		
		
        //UN-MASKING USER ID FOR DI_END

        if ($this->userId < 1 && $requestUserId > 0 && ($this->rbacRole == 'SI' || $this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin' || $this->rbacRole == 'DI' || $this->rbacRole == 'DiModerator' || Yii::app()->session->get('user_type_ref_id') == 6)) {
            $this->userId = $requestUserId;//Yii::app()->request->getQuery('uid');
        }
        if ($this->rbacRole == 'Student' || $this->rbacRole == 'SI' || $this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin') {
            $this->_hasEdit = true;
        }

        if ($this->userId == '' || $this->userId <= 0) {
            $this->redirect(Yii::app()->createUrl('login'));
        }

        if ($this->rbacRole == 'SI') {
            $siDetail = TblSiDi::GetSchoolLookupId(Yii::app()->user->sub_id);
            $userDetail = TblUserMaster::getUserDetails($this->userId);

           //For Alumni Student Information
            $this->alumniuserDetails = StudentOutplacementColleges::model()->findAll(array("condition" => "user_ref_id = " . $this->userId));
            $this->alumniuserTestDetails = StudentOutplacementTests::model()->findAll(array("condition" => "user_ref_id = " . $this->userId));
            $this->alumniStudentmessage = UserOutplacementMessage::model()->findAll(array("condition" => "user_ref_id = " . $this->userId));

            //End of Alumni Student Information

            if ($userDetail->school_ref_id != $siDetail->school_ref_id) {
                $this->redirect(Yii::app()->createUrl('login'));
            }
        }

        if ( ($this->rbacRole == 'DI') || ($this->rbacRole == 'DiModerator') ) {
            $this->_isDI = true;
            $this->_hasEdit = false;
        }

        if ($this->rbacRole != 'Student') {
            $this->userParams = array('uid' => $this->userId);
        }

        $this->userData = TblUserMaster::getUserDetails($this->userId);
        if ($this->userData->present_class == 9) {
            //$this->_hasEdit = false;
        }
        $referrer = Yii::app()->getRequest()->getUrlReferrer();
        if(strstr($referrer, 'MyAssignedGems') == 'MyAssignedGems'){
            $this->_hasEdit = false;
        }

        if($this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin'){
            $this->profileValidationAccess = true;
        }

        $this->pageTitle = Yii::app()->name .' - '.$this->userData->first_name .' '.$this->userData->last_name;

    }


    public function beforeAction($action){

        parent::beforeAction($action);
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        return true;
    }

    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'postRegistration') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionIndex(){

       Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";


        $helpervariable = Yii::app()->request->getParam('helperId');
        switch($this->rbacRole){
            case 'Student':
                $this->breadcrumbs=array(
                    'Home'=>array('/dashboard'),
                    'My Profile',
                );
                break;
            case 'DI':
            case 'DiModerator':
                $studentName = DiHelper::getStudentName($this->userData->user_id);
                $this->breadcrumbs=array(
                    $studentName,
                );
                $this->pageTitle = Yii::app()->name .' - '.$studentName;
                // code for profile views by university
                $m = new UniUserViews;
                $m->setAttributes(array(
                    'uni_ref_id' => Yii::app()->user->di_uni_id,
                    'user_ref_id' => $this->userData->user_id,
                    'viewed_on' => date('Y-m-d H:i:s')
                ));
                $m->save();
                break;
            default:

                $expertVendor = Yii::app()->user->getState('isVendor');
                if($expertVendor){
                    $expertID = Yii::app()->user->sub_id;
                    $student_id =  $this->userData->user_id;
                    $studentName = $this->userData->first_name.' '.$this->userData->last_name;
                    if(!DiHelper::isVendorBoughtStudentProfile($expertID,$student_id))
                        $studentName = $this->userData->first_name.'...';

                    $this->pageTitle = Yii::app()->name .' - '.$studentName;

                }else{

                    $studentName = implode(' ', array($this->userData->first_name, $this->userData->last_name));
                    $this->breadcrumbs=array(
                        (($studentName == ' ')? 'Unknown' : $studentName)
                    );
                }
        }

        /*if ($this->rbacRole == 'Student') {
            $this->breadcrumbs=array(
                'Home'=>array('/dashboard'),
                'My Profile',
            );
        }

        if ($this->rbacRole == 'DI') {
            $this->breadcrumbs=array(
                implode(' ', array($this->userData->first_name, $this->userData->last_name)),
            );
        }*/

        $this->userData->gender = ($this->userData->gender != '') ? $this->userData->gender : 'M';

        if ($this->userData->user_photo != '') {

            if (file_exists($userImagePath . $this->userData->user_photo)) {

                $this->userImage = $userImagePath . $this->userData->user_photo;
                $this->isUserImageAvailable = true;
            }else{
               
                $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
          
            }
        }
        if ($this->userImage == '') {
            $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
        }
	       $profilePercentage = CommonUtils::calculateCriticalPercentage($this->userData->user_id);			
       $this->render("index",array('profilePercentage'=>$profilePercentage,'helpervariable'=>$helpervariable,'userData'=>$this->userData,'alumniuserDetails'=>$this->alumniuserDetails,'alumniuserTestDetails' => $this->alumniuserTestDetails));

    }


   /* Student profile basic information tab */

    public function actionEditBasicInfo() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->pageTitle = Yii::app()->name .'- Basic Information';

        $loginId = Yii::app()->user->id;
        $userId = $this->userId;

        Yii::import('application.components.profilevalidation.*');
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id  = '".$userId."' ";
        $student_validation_scores = ProfileValidationScore::model()->find($criteria);
        if (!$student_validation_scores->profile_validation_score_id) {
            $obj = new ValidateStudent();
            $obj->userId = $userId;
            $obj->validateProfileAfterSignup();
        }

        if (count($_POST) == 0) {
            $tblUserMasterModel = TblUserMaster::model()->with('schoolRef', 'loginRef')->findByPk($userId);
            $studentAddressCountryCode ='';
            if($tblUserMasterModel->country_ref_id){
                $studentAddressCountryCode = $tblUserMasterModel->countryRef->phone_code;
            }
            
            $studentBasicInfoModel = new StudentEditProfile();
            foreach ($studentBasicInfoModel->attributes as $key => $value) {
                if( $key != "citizenship_ref_id1" || $key != "citizenship_ref_id2" ) {
                    $studentBasicInfoModel->{$key} = $tblUserMasterModel->attributes[$key];
                }
            }
            
            $studentCitizenship = StudentCitizenship::getStudentCitizenship($userId);
            $counter = 1;
            foreach ($studentCitizenship as $data) {
                $studentBasicInfoModel->{citizenship_ref_id . $counter} = $data->citizenship_ref_id;
                $studentBasicInfoModel->{studentCitizenshipId . $counter} = $data->student_citizenship_id;
                $counter++;
            }
            
            //print_r($tblUserMasterModel->attributes);print_r($tblUserMasterModel->schoolRef->attributes);
            $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
            $studentBasicInfoModel->gender = $tblUserMasterModel->gender;
            if ($tblUserMasterModel->user_photo != '') {
                if (file_exists($userImagePath . $tblUserMasterModel->user_photo)) {
                    $this->userImage = $userImagePath . $tblUserMasterModel->user_photo;
                    $this->isUserImageAvailable = true;
                } else {
                    $this->userImage = $userImagePath . $this->defaultUserData[$tblUserMasterModel->gender]['defaultImage'];
                }
            }
            if ($this->userImage == '') {
                $this->userImage = $userImagePath . $this->defaultUserData[$tblUserMasterModel->gender]['defaultImage'];
            }
            $emailId = $tblUserMasterModel->loginRef->username;
            $dob = explode('-', $tblUserMasterModel->attributes['dob']);
            $studentBasicInfoModel->dob_date = $dob[2];
            $studentBasicInfoModel->dob_month = $dob[1];
            $studentBasicInfoModel->dob_year = $dob[0];
            $studentBasicInfoModel->school_name = $tblUserMasterModel->schoolRef->school_name;
            $ethnicityList = CHtml::listData(MasterEthnicity::getEthnicityDetails(), 'ethnicity_id', 'ethnicity_name');
            $citizenshipList = CHtml::listData(TblCountryMaster::getActiveCountriesList(), 'country_id', 'country_name');
            $tblStudentContactModel = StudentContactNumber::model()->with('contactTypeRef')->find(array("condition" => "user_ref_id = " . $userId . ' AND contact_type_ref_id ="1" AND is_primary = 1'));
            $studentBasicInfoModel->student_country_code = $tblStudentContactModel->country_code;
            $studentBasicInfoModel->student_number = $tblStudentContactModel->number;
            $i = 1;
            $fatherContactInfos = StudentContactNumber::getContactNumbersOfParent($userId, '2');
            $fatherEmailInfos = StudentAlternateEmail::getEmailsOfParent($tblUserMasterModel->login_ref_id, '2');
            if ($fatherContactInfos || $fatherEmailInfos || $tblUserMasterModel->father_first_name !='' || $tblUserMasterModel->father_last_name != '') {
                
                $parentDetailModels[$i] = new ParentDetail();
                $id = 1;
                $parentDetailModels[$i]->contact_type_ref_id = 2;
                $parentDetailModels[$i]->parent_first_name = $tblUserMasterModel->father_first_name;
                //$parentDetailModels[$i]->parent_last_name = $tblUserMasterModel->father_last_name;
                foreach ($fatherContactInfos as $key => $fatherContactInfo) {
                    $countryCode = 'country_code' . $id;
                    $number = 'number' . $id;
                    $contactPrimaryId = 'student_contact_number_id' . $id;
                    $parentDetailModels[$i]->$countryCode = $fatherContactInfo->country_code;
                    $parentDetailModels[$i]->$number = $fatherContactInfo->number;
                    $parentDetailModels[$i]->$contactPrimaryId = $fatherContactInfo->student_contact_number_id;
                    $id++;
                }
                $id = 1;
                foreach ($fatherEmailInfos as $key => $fatherEmailInfo) {
                    $email = 'email_id' . $id;
                    $emailPrimaryId = 'student_alternate_email_id' . $id;
                    $parentDetailModels[$i]->$email = $fatherEmailInfo->email_id;
                    $parentDetailModels[$i]->$emailPrimaryId = $fatherEmailInfo->student_alternate_email_id;
                    $id++;
                }
                $i++;
            }
            $motherContactInfos = StudentContactNumber::getContactNumbersOfParent($userId, '3');
            $motherEmailInfos = StudentAlternateEmail::getEmailsOfParent($tblUserMasterModel->login_ref_id, '3');
            if ($motherContactInfos || $motherEmailInfos || $tblUserMasterModel->mother_first_name !='' || $tblUserMasterModel->mother_last_name !='') {
                
                $parentDetailModels[$i] = new ParentDetail();
                $id = 1;
                $parentDetailModels[$i]->contact_type_ref_id = 3;
                $parentDetailModels[$i]->parent_first_name = $tblUserMasterModel->mother_first_name;
                //$parentDetailModels[$i]->parent_last_name = $tblUserMasterModel->mother_last_name;
                foreach ($motherContactInfos as $key => $motherContactInfo) {
                    $countryCode = 'country_code' . $id;
                    $number = 'number' . $id;
                    $contactPrimaryId = 'student_contact_number_id' . $id;
                    $parentDetailModels[$i]->$countryCode = $motherContactInfo->country_code;
                    $parentDetailModels[$i]->$number = $motherContactInfo->number;
                    $parentDetailModels[$i]->$contactPrimaryId = $motherContactInfo->student_contact_number_id;
                    $id++;
                }
                
                $id = 1;
                foreach ($motherEmailInfos as $key => $motherEmailInfo) {
                    $email = 'email_id' . $id;
                    $emailPrimaryId = 'student_alternate_email_id' . $id;
                    $parentDetailModels[$i]->$email = $motherEmailInfo->email_id;
                    $parentDetailModels[$i]->$emailPrimaryId = $motherEmailInfo->student_alternate_email_id;
                    $id++;
                }
                $i++;
            }
            $guardianContactInfos = StudentContactNumber::getContactNumbersOfParent($userId, '4');
            $guardianEmailInfos = StudentAlternateEmail::getEmailsOfParent($tblUserMasterModel->login_ref_id, '4');
            if ($guardianContactInfos || $guardianEmailInfos || $tblUserMasterModel->guardian_first_name !='' || $tblUserMasterModel->guardian_last_name != '') {
                
                $parentDetailModels[$i] = new ParentDetail();
                $id = 1;
                $parentDetailModels[$i]->contact_type_ref_id = 4;
                $parentDetailModels[$i]->parent_first_name = $tblUserMasterModel->guardian_first_name;
                //$parentDetailModels[$i]->parent_last_name = $tblUserMasterModel->guardian_last_name;
                foreach ($guardianContactInfos as $key => $guardianContactInfo) {
                    $countryCode = 'country_code' . $id;
                    $number = 'number' . $id;
                    $contactPrimaryId = 'student_contact_number_id' . $id;
                    $parentDetailModels[$i]->$countryCode = $guardianContactInfo->country_code;
                    $parentDetailModels[$i]->$number = $guardianContactInfo->number;
                    $parentDetailModels[$i]->$contactPrimaryId = $guardianContactInfo->student_contact_number_id;
                    $id++;
                }
                $id = 1;
                foreach ($guardianEmailInfos as $key => $guardianEmailInfo) {
                    $email = 'email_id' . $id;
                    $emailPrimaryId = 'student_alternate_email_id' . $id;
                    $parentDetailModels[$i]->$email = $guardianEmailInfo->email_id;
                    $parentDetailModels[$i]->$emailPrimaryId = $guardianEmailInfo->student_alternate_email_id;
                    $id++;
                }
            }

            //print_r($parentDetailModels);die('dd');
            if (!$parentDetailModels) {
                $parentDetailModels[1] = new ParentDetail();
            }

            $contactTypeList = CHtml::listData(LookupContactType::getContactType(true), 'contact_type_id', 'contact_type');
        } else {
     
            $studentBasicPostData = Yii::app()->request->getPost('StudentEditProfile');
            $parentPostData = array();
            $parentPostData = Yii::app()->request->getPost('ParentDetail');

           
            $tblUserMasterModel = TblUserMaster::model()->with('schoolRef', 'loginRef')->findByPk($userId);
            $studentBasicInfoModel = new StudentEditProfile('basicInfo');
            $studentBasicInfoModel->attributes = $studentBasicPostData;

         

            $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
            if ($tblUserMasterModel->user_photo != '') {
                if (file_exists($userImagePath . $tblUserMasterModel->user_photo)) {
                    $this->userImage = $userImagePath . $tblUserMasterModel->user_photo;
                    $this->isUserImageAvailable = true;
                } else {
                    $this->userImage = $userImagePath . $this->defaultUserData[$tblUserMasterModel->gender]['defaultImage'];
                }
            }
            if ($this->userImage == '') {
                $this->userImage = $userImagePath . $this->defaultUserData[$tblUserMasterModel->gender]['defaultImage'];
            }
            $errorCounter = false;
            if (!$studentBasicInfoModel->validate()) {

                $errorCounter = true;
            }



            // if country code & number both have error, then block one error message
            if($studentBasicInfoModel->hasErrors('student_country_code')){
                $studentBasicInfoModel->clearErrors('student_number');
                $studentBasicInfoModel->addError('student_number','');
            }

            $parentArray = $parentEmailArray = $parentContactArray = array();
            $parentDetailModels = array();
          
            foreach ($parentPostData as $key => $data) {

               
                if ($data['contact_type_ref_id'] != '' ) {

                    $parentDetailModels[$key] = new ParentDetail('basicInfo');
                    $parentDetailModels[$key]->userId = $userId;
                    $parentDetailModels[$key]->loginId = $tblUserMasterModel->login_ref_id;
                    $parentDetailModels[$key]->attributes = $data;
                    if($parentDetailModels[$key]){
                        $parentDetailModels[$key]->validate();
                        if(!$parentDetailModels[$key]->validate()){
                            $errorCounter = true;
                        }
                    }

                    if(in_array($parentDetailModels[$key]->contact_type_ref_id, $parentArray)) {

                        $errorCounter = true;
                        $parentDetailModels[$key]->addError('contact_type_ref_id', '<div class="holder">You selected the same relation again.Please change</div>');
                        $customError = '<div class="holder">You selected the same relation again.Please change</div>';
                        $errorCounterParentUnique = 1;

                    } else {

                        $parentArray[] = $parentDetailModels[$key]->contact_type_ref_id;
                    }
                    // if first name & last name both have error, then block one error message
                    if($parentDetailModels[$key]->hasErrors('parent_first_name')){

                        //$parentDetailModels[$key]->clearErrors('parent_last_name');
                        //$parentDetailModels[$key]->addError('parent_last_name','');
                    }
                    // if country code & number both have error, then block one error message
                    if($parentDetailModels[$key]->hasErrors('country_code1')){

                        $parentDetailModels[$key]->clearErrors('number1');
                        $parentDetailModels[$key]->addError('number1','');
                    }
                    // if country code & number both have error, then block one error message
                    if($parentDetailModels[$key]->hasErrors('country_code2')){

                        $parentDetailModels[$key]->clearErrors('number2');
                        $parentDetailModels[$key]->addError('number2','');
                    }

                    if($parentDetailModels[$key]->hasErrors()){
                        if (trim($parentDetailModels[$key]->number1)!='' && in_array($parentDetailModels[$key]->number1, $parentContactArray)) {

                        $errorCounter = true;
                        $parentDetailModels[$key]->addError('number1', '<div class="holder">You have entered same contact number again.Please change</div>');

                        } else {

                            $parentContactArray[] = $parentDetailModels[$key]->number1;
                        }
                        if (trim($parentDetailModels[$key]->number2)!='' && in_array($parentDetailModels[$key]->number2, $parentContactArray)) {
                            $errorCounter = true;

                            $parentDetailModels[$key]->addError('number2', '<div class="holder">You have entered same contact number again.Please change</div>');
                        } else {

                            $parentContactArray[] = $parentDetailModels[$key]->number2;
                        }
                        if (strtolower(trim($parentDetailModels[$key]->email_id1))!='' && in_array(strtolower($parentDetailModels[$key]->email_id1), $parentEmailArray)) {
                            $errorCounter = true;

                            $parentDetailModels[$key]->addError('email_id1', '<div class="holder">You have entered same email address again.Please change</div>');
                        } else {
                            $parentEmailArray[] = strtolower($parentDetailModels[$key]->email_id1);
                        }
                        if (trim($parentDetailModels[$key]->email_id2)!='' && in_array($parentDetailModels[$key]->email_id2, $parentEmailArray)) {
                            $errorCounter = true;
                            $parentDetailModels[$key]->addError('email_id2', '<div class="holder">You have entered same email address again.Please change</div>');
                        } else {

                            $parentEmailArray[] = $parentDetailModels[$key]->email_id2;
                        }
                    }
                }

            }

            $ethnicityList = CHtml::listData(MasterEthnicity::getEthnicityDetails(), 'ethnicity_id', 'ethnicity_name');
            $citizenshipList = CHtml::listData(TblCountryMaster::getActiveCountriesList(), 'country_id', 'country_name');
            $contactTypeList = CHtml::listData(LookupContactType::getContactType(true), 'contact_type_id', 'contact_type');
            //$studentBasicInfoModel->gender = ($tblUserMasterModel->gender != '') ? $tblUserMasterModel->gender : 'M';
            $emailId = $tblUserMasterModel->loginRef->username;

            if(strlen($studentBasicInfoModel->introduce_yourself) && trim($studentBasicInfoModel->introduce_yourself)==''){
                $errorCounter = true;
                $studentBasicInfoModel->addError('introduce_yourself', '<div class="holder"><p>Enter valid text.</p></div>');
            }
            if(strlen($studentBasicInfoModel->address1) && trim($studentBasicInfoModel->address1)==''){
                $errorCounter = true;
                $studentBasicInfoModel->addError('address1', '<div class="holder"><p>Enter valid text.</p></div>');
            }
            if(strlen($studentBasicInfoModel->address2) && trim($studentBasicInfoModel->address2)==''){
                $errorCounter = true;
                $studentBasicInfoModel->addError('address2', '<div class="holder"><p>Enter valid text.</p></div>');
            }


            if (!$errorCounter) {
                $nameFlag = $genderFlag = $dobFlag = $schoolFlag = $citizenshipFlag = $studentContactFlag = 0;
                
                $tblUserMasterModel->attributes = $studentBasicInfoModel->attributes;
                $tblUserMasterModel->introduce_yourself = substr($studentBasicInfoModel->introduce_yourself, 0, 2000);

                if($studentBasicInfoModel->dob_year && $studentBasicInfoModel->dob_month && $studentBasicInfoModel->dob_date) {
                    $tblUserMasterModel->dob = implode('-', array($studentBasicInfoModel->dob_year, $studentBasicInfoModel->dob_month, $studentBasicInfoModel->dob_date));
                } else {
                    $tblUserMasterModel->dob = NULL;
                }
                
                if ($tblUserMasterModel->first_name != '') {
                    $nameFlag = 1;
                }
                if ($tblUserMasterModel->gender != '') {
                    $genderFlag = 1;
                }
                
                if ($studentBasicInfoModel->dob_year != '') {
                    $dobFlag = 1;
                }
                if($studentBasicInfoModel->school_name != ''){
                    $schoolExistID = LookupSchool::getSchoolID($studentBasicInfoModel->school_name);
                    if ($schoolExistID) {
                        $tblUserMasterModel->school_ref_id = $schoolExistID;
                    } else {
                        LookupSchool::addStudentSchool($studentBasicInfoModel->school_name);
                        $schoolExistID = LookupSchool::getSchoolID($studentBasicInfoModel->school_name);
                        $tblUserMasterModel->school_ref_id = $schoolExistID;
                    }
                }
                if ($tblUserMasterModel->school_ref_id != '') {
                    $schoolFlag = 1;
                }

                $tblUserMasterModel->modified_on = date('Y-m-d H:i:s');
                $tblUserMasterModel->first_name = ucwords(strtolower(trim($tblUserMasterModel->first_name)));
                $tblUserMasterModel->middle_name = ucwords(strtolower(trim($tblUserMasterModel->middle_name)));
                $tblUserMasterModel->last_name = ucwords(strtolower(trim($tblUserMasterModel->last_name)));
                $tblUserMasterModel->save(false);
                
                $studentCitizenshiplObj = new StudentCitizenship();
                $studentCitizenshiplObj->deleteStudentCitizenshipUserId($userId);
                
                if ($studentBasicInfoModel->citizenship_ref_id1) {
                    $studentCitizenshiplObj->insertCitizenshipByUserId($userId, $studentBasicInfoModel->citizenship_ref_id1);
                    $citizenshipFlag = 1;
                }

                if ($studentBasicInfoModel->citizenship_ref_id2) {
                    $studentCitizenshiplObj->insertCitizenshipByUserId($userId, $studentBasicInfoModel->citizenship_ref_id2);
                    $citizenshipFlag = 1;
                }
                
                $tblStudentContactModel = StudentContactNumber::model()->with('contactTypeRef')->find(array("condition" => "user_ref_id = " . $userId . ' AND contact_type_ref_id ="1"'));
                if (!$tblStudentContactModel) {
                    $tblStudentContactModel = new StudentContactNumber();
                }
                $tblStudentContactModel->country_code = $studentBasicInfoModel->student_country_code;
                $tblStudentContactModel->number = $studentBasicInfoModel->student_number;
                if ($tblStudentContactModel->number != '') {
                    $studentContactFlag = 1;
                    $tblStudentContactModel->contact_type_ref_id = 1;
                    $studentCountryInfo = TblCountryMaster::getCountryInfoByCode($studentBasicInfoModel->student_country_code);
                    $tblStudentContactModel->country_ref_id = $studentCountryInfo->country_id;
                    $tblStudentContactModel->user_ref_id = $userId;
                    $tblStudentContactModel->is_primary = 1;
                    if ($tblStudentContactModel->student_contact_number_id) {
                        $tblStudentContactModel->modified_by = $loginId;
                        $tblStudentContactModel->modified_on = date('Y-m-d H:i:s');
                        $tblStudentContactModel->setIsNewRecord(false);
                    } else {
                        $tblStudentContactModel->added_by = $loginId;
                    }
                    $tblStudentContactModel->save(false);
                }else{
                    StudentContactNumber::model()->deleteAll('user_ref_id='.$userId.' AND contact_type_ref_id = 1 AND is_primary = 1');
                }
                $userMasterModel = TblUserMaster::model()->findByPk($userId);
                $userMasterModel->father_first_name = NULL;
                $userMasterModel->father_last_name = NULL;
                $userMasterModel->mother_first_name = NULL;
                $userMasterModel->mother_last_name = NULL;
                $userMasterModel->guardian_first_name = NULL;
                $userMasterModel->guardian_last_name = NULL;


              
                foreach ($parentDetailModels as $key => $parentDetailModel) {

                    //$fatherContactModels = StudentContactNumber::model()->with('contactTypeRef')->findAll(array("condition" => "user_ref_id = " . $userId . ' AND contact_type_ref_id = "2"'));
                    if ($parentDetailModel->parent_first_name != '') {

                        if ($parentDetailModel->contact_type_ref_id == 2) {
                            
                            $userMasterModel->father_first_name = ucwords(strtolower(trim($parentDetailModel->parent_first_name)));
                            //$userMasterModel->father_last_name = ucwords(strtolower(trim($parentDetailModel->parent_last_name)));
                        } elseif ($parentDetailModel->contact_type_ref_id == 3) {
                            $userMasterModel->mother_first_name = ucwords(strtolower(trim($parentDetailModel->parent_first_name)));
                            //$userMasterModel->mother_last_name = ucwords(strtolower(trim($parentDetailModel->parent_last_name)));

                        } elseif ($parentDetailModel->contact_type_ref_id == 4) {
                            $userMasterModel->guardian_first_name = ucwords(strtolower(trim($parentDetailModel->parent_first_name)));
                            //$userMasterModel->guardian_last_name = ucwords(strtolower(trim($parentDetailModel->parent_last_name)));

                        }
                    }
                    if ($parentDetailModel->number1 != '') {
                        $fatherContactModel = new StudentContactNumber();
                        $id = 1;
                        $fatherContactModel->user_ref_id = $userId;
                        $fatherContactModel->is_primary = 0;
                        $fatherContactModel->contact_type_ref_id = $parentDetailModel->contact_type_ref_id;
                        $fatherContactModel->country_code = $parentDetailModel->country_code1;
                        $fatherContactModel->number = $parentDetailModel->number1;
                        $countryId = TblCountryMaster::getCountryInfoByCode($parentDetailModel->country_code1);
                        $fatherContactModel->country_ref_id = $countryId->country_id;
                        if ($parentDetailModel->student_contact_number_id1 > 0) {
                            $fatherContactModel->student_contact_number_id = $parentDetailModel->student_contact_number_id1;
                            $fatherContactModel->modified_by = $loginId;
                            $fatherContactModel->modified_on = date('Y-m-d H:i:s');
                            $fatherContactModel->setIsNewRecord(false);
                        } else {
                            $fatherContactModel->added_by = $loginId;
                        }
                        $fatherContactModel->save(false);
                    } elseif ($parentDetailModel->student_contact_number_id1 > 0) {
                        //delete contact
                        StudentContactNumber::model()->deleteByPk($parentDetailModel->student_contact_number_id1);
                    }
                    if ($parentDetailModel->number2 != '') {
                        $fatherContactModel1 = new StudentContactNumber();
                        $id = 1;
                        $fatherContactModel1->user_ref_id = $userId;
                        $fatherContactModel1->is_primary = 0;
                        $fatherContactModel1->contact_type_ref_id = $parentDetailModel->contact_type_ref_id;
                        $fatherContactModel1->country_code = $parentDetailModel->country_code2;
                        $fatherContactModel1->number = $parentDetailModel->number2;
                        $countryId = TblCountryMaster::getCountryInfoByCode($parentDetailModel->country_code2);
                        $fatherContactModel1->country_ref_id = $countryId->country_id;
                        if ($parentDetailModel->student_contact_number_id2 > 0) {
                            $fatherContactModel1->student_contact_number_id = $parentDetailModel->student_contact_number_id2;
                            $fatherContactModel1->modified_by = $loginId;
                            $fatherContactModel1->modified_on = date('Y-m-d H:i:s');
                            $fatherContactModel1->setIsNewRecord(false);
                        } else {
                            $fatherContactModel1->added_by = $loginId;
                        }
                        $fatherContactModel1->save(false);
                    } elseif ($parentDetailModel->student_contact_number_id2 > 0) {
                        //delete contact
                        StudentContactNumber::model()->deleteByPk($parentDetailModel->student_contact_number_id2);
                    }

                    if ($parentDetailModel->email_id1 != '') {
                        $fatherEmailModel = new StudentAlternateEmail();
                        $fatherEmailModel->login_ref_id = $userMasterModel->login_ref_id;
                        $fatherEmailModel->is_primary = 0;
                        $fatherEmailModel->is_active = 1;
                        $fatherEmailModel->contact_type_ref_id = $parentDetailModel->contact_type_ref_id;
                        $fatherEmailModel->email_id = trim($parentDetailModel->email_id1);
                        if ($parentDetailModel->student_alternate_email_id1 > 0) {
                            $fatherEmailModel->student_alternate_email_id = $parentDetailModel->student_alternate_email_id1;
                            $fatherEmailModel->modified_by = $loginId;
                            $fatherEmailModel->modified_on = date('Y-m-d H:i:s');
                            $fatherEmailModel->setIsNewRecord(false);
                        } else {
                            $fatherEmailModel->added_by = $loginId;
                        }
                        $fatherEmailModel->save(false);
                    } elseif ($parentDetailModel->student_alternate_email_id1 > 0) {
                        //delete contact email
                        StudentAlternateEmail::model()->deleteByPk($parentDetailModel->student_alternate_email_id1);
                    }
                    if ($parentDetailModel->email_id2 != '') {
                        $fatherEmailModel1 = new StudentAlternateEmail();
                        $fatherEmailModel1->login_ref_id = $userMasterModel->login_ref_id;
                        $fatherEmailModel1->is_primary = 0;
                        $fatherEmailModel1->is_active = 1;
                        $fatherEmailModel1->contact_type_ref_id = $parentDetailModel->contact_type_ref_id;
                        $fatherEmailModel1->email_id = trim($parentDetailModel->email_id2);
                        if ($parentDetailModel->student_alternate_email_id2 > 0) {
                            $fatherEmailModel1->student_alternate_email_id = $parentDetailModel->student_alternate_email_id2;
                            $fatherEmailModel1->modified_by = $loginId;
                            $fatherEmailModel1->modified_on = date('Y-m-d H:i:s');
                            $fatherEmailModel1->setIsNewRecord(false);
                        } else {
                            $fatherEmailModel1->added_by = $loginId;
                        }
                        $fatherEmailModel1->save(false);
                    } elseif ($parentDetailModel->student_alternate_email_id2 > 0) {
                        //delete contact email
                        StudentAlternateEmail::model()->deleteByPk($parentDetailModel->student_alternate_email_id2);
                    }
                }
                // Saving parent name into TblUserMaster

                $userMasterModel->save(false);

                $criticalFields = array(
                    'name' => $nameFlag,
                    'gender' => $genderFlag,
                    'dob'=> $dobFlag,
                    'school_name' => $schoolFlag,
                    'citizenship' => $citizenshipFlag,
                    'phone' => $studentContactFlag
                );
                TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
				
				$verify_score = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
				if (($verify_score->contact_number == 0) && $verify_score->profile_verification_score_id)
				{
					$verify_score->contact_number = 1;
					$verify_score->contact_number_date = date('Y-m-d H:i:s');
					$verify_score->save(false);
				}
				Yii::import('application.components.profilevalidation.*');
				$conditions_obj = new Conditions();
				$conditions_obj->userId = $userId;
				if($verify_score->profile_score == 0 && $verify_score->profile_verification_score_id) {
					$verify_score->profile_score = $conditions_obj->validateProfileCompletion();
					$verify_score->profile_score_date =  date('Y-m-d H:i(worry)');
					$verify_score->save(false);
				}
				
				$validate = new ValidateStudent();
				$user = TblUserMaster::model()->findByPk($userId);
				$validate->validate_after_confirmation($verify_score->profile_verification_score_id, $user);

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'basic information'));
                CommonUtils::calculateCriticalPercentage($userId);
                $this->redirect(Yii::app()->createUrl('student/profile/editEducation', $this->userParams));
            }
           
            if(!$parentDetailModels){
                $parentDetailModels[1] = new ParentDetail('basicInfo');
            }
        }
        
        $this->render('basicInfo', array('tblUserMasterModel' => $tblUserMasterModel, 'studentBasicInfoModel' => $studentBasicInfoModel, 'parentDetailModels' => $parentDetailModels, 'ethnicityList' => $ethnicityList, 'citizenshipList' => $citizenshipList, 'tblParentContactModel' => $tblParentContactModel,
            'tblParentEmailModel' => $tblParentEmailModel, 'contactTypeList' => $contactTypeList, 'parentRelationship' => $parentRelationship, 'emailId' => $emailId, 'tblStudentContactModel' => $tblStudentContactModel, 'customError' => $customError, 'studentAddressCountryCode' => $studentAddressCountryCode));
    }

    public function actionEditEducation() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->pageTitle = Yii::app()->name . ' - Education Detail';
        $loginId = Yii::app()->user->id;
        $userId = $this->userId;
        $customError = "";

       if(Yii::app()->session['falsh_message'] == true){
            setFlashMessage('error_notify', 'globalnotifications.notification_geniric',array('MESSAGE'=>'Curriculum missing. Please select your 12th(or equivalent) curriculum.'));
            unset(Yii::app()->session['falsh_message']);
        }


        $studentPreferredDepartmentIds = array();
        $userInfo = TblUserMaster::getUserDetails($userId);
        $studentPreferredDepartments = $userInfo->studentPreferredDepartments;
        if (count($studentPreferredDepartments) > 0) {
            foreach ($studentPreferredDepartments as $deptPref) {
                $studentPreferredDepartmentIds[] = $deptPref->attributes['main_dept_ref_id'];
            }
        }
        $studentPreferredDepartmentIds = array_filter($studentPreferredDepartmentIds);

        
        $preferredCountryListData = StudentPreferredCountry::getStudentPreferredCountryDetails($userId);
        if(count($preferredCountryListData) > 0) {
            foreach ($preferredCountryListData as $key => $value) {
                $studentPreferredCountryIds[] = $value->country_ref_id;
            }
        }

        $result1 = UserEntranceExam::getUserexams($userId);
        $result = EntranceExam::getTestDetailsByCountryDepartmentArr($studentPreferredCountryIds, $studentPreferredDepartmentIds);

        $examlist = CHtml::listData($result,'entrance_id','entrance_short_name');

        $examlist = $result1+$examlist;



        
        if (count($_POST) == 0) {
            $studentEducationInfoModel12 = new StudentEducationProfile();
            $tblUserMasterModel = TblUserMaster::model()->findByPk($userId);
            if ($tblUserMasterModel->class_status == 'Pursuing') {
                $classStatus = 'p';
            } elseif ($tblUserMasterModel->class_status == 'Completed') {
                $classStatus = 'c';
            }
            $studentEducationInfoModel12->present_class = $tblUserMasterModel->present_class . $classStatus;
            $studentEducationInfoModel12->passout_month = $tblUserMasterModel->passout_month;
            $studentEducationInfoModel12->passout_year = $tblUserMasterModel->passout_year;
            
            $yearList12 = UniversityHelper::completeYear($studentEducationInfoModel12->present_class, 1);
            
            $studentEducation12Profile = StudentEducation::getStudentEducationDetails($userId, '12');
            $boardId12 = $studentEducation12Profile->board_ref_id;
            $studentEducationInfoModel12->board_equivalent_id = $studentEducation12Profile->board_ref_id;
            $studentEducationInfoModel12->school_name = $studentEducation12Profile->school_name;
            if ($studentEducation12Profile->board_ref_id != '') {
                $boardDetail12 = LookupBoardEquivalent::getBoardDetailById($boardId12);

            }
            $subjectDetail12 = StudentEducation::getSubjectDetail('12', $userId);
            //$subjectDetail = array();
            if ($boardDetail12['overall_type'] == 'Marks' && $boardDetail12['board_ref_id'] != 7) {
                $studentEducationInfoModel12->overall_marks = (float) $studentEducation12Profile->overall_marks;
                foreach ($subjectDetail12 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels12[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels12[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels12[$key + 1]->marks = (float) $value->marks;
                        $marksDetailModels12[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail12['overall_type'] == 'Marks-GPA') {
                $studentEducationInfoModel12->overall_marks_gpa = (float) $studentEducation12Profile->overall_marks;
                foreach ($subjectDetail12 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels12[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels12[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels12[$key + 1]->grade_ref_id = $value->board_conversion_ref_id;
                        //$marksDetailModels12[$key + 1]->grade_ref_id = $value->grade_ref_id;
                        $marksDetailModels12[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail12['overall_type'] == 'Points') {
                $studentEducationInfoModel12->overall_points = (int) $studentEducation12Profile->overall_marks;
                foreach ($subjectDetail12 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels12[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels12[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels12[$key + 1]->points = (int) $value->marks;
                        $marksDetailModels12[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail12['overall_type'] == 'Grades' || $boardDetail12['board_ref_id'] == 7) {
                if($boardDetail12['board_ref_id'] == 7)
                {
                    $studentEducationInfoModel12->overall_marks = (float) $studentEducation12Profile->overall_marks;
                }
                /*$gradeDetail = StudentEducation::getGradeDetail('12', $userId);
                foreach ($gradeDetail as $k => $val) {
                    foreach ($val->studentGradeCounts as $key => $value) {
                        //$studentEducationInfoModel12->{'overall_grades_' . $value->gradeRef->grade_type} = $value->grade_count;
                    }
                }*/
                $grade_count = StudentGradeCount::model()->findAll(array('condition' => 'student_education_ref_id ='.$studentEducation12Profile->student_education_id));
                foreach ($grade_count as $grade) {
                    $ref = $grade['board_conversion_ref_id'];
                    $studentEducationInfoModel12->overall_grade_12[$ref] = $grade['grade_count'];
                }
                foreach ($subjectDetail12 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels12[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels12[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        //$marksDetailModels12[$key + 1]->grade_ref_id = $value->grade_ref_id;
                        $marksDetailModels12[$key + 1]->grade_ref_id = $value->board_conversion_ref_id;
                        $marksDetailModels12[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            }
            if (!$marksDetailModels12) {
                $marksDetailModels12[1] = new StudentSubjectDetail();
            } else {
                $marksDetailModels12[$key + 2] = new StudentSubjectDetail();
            }
            if($boardId12){
                $marksSubjectList12 = LookupStudentSubject::getPreferredSubjectsByDepartment($boardId12, $studentPreferredDepartmentIds);
            }else{
                $marksSubjectList12 = array();
            }
            //$marksSubjectList12 = CHtml::listData($modelSubjects12, 'student_subject_id', 'subject_name');
            // For 10th 
            $studentEducationInfoModel10 = new StudentEducationProfile();
            
            if($tblUserMasterModel->present_class == '10'){
                $yearList10 = UniversityHelper::complitionYearList('10',(date('Y')+5));
            }else{
                $yearList10 = UniversityHelper::complitionYearList('10',$tblUserMasterModel->passout_year);
            }
            $studentEducation10Profile = StudentEducation::getStudentEducationDetails($userId, '10');
            if($tblUserMasterModel->present_class == '10'){
                $studentEducation10Profile = StudentEducation::getStudentEducationDetails($userId, '9');
            }
            $boardId10 = $studentEducation10Profile->board_ref_id;
            $studentEducationInfoModel10->board_equivalent_id = $studentEducation10Profile->board_ref_id;
            $studentEducationInfoModel10->school_name = $studentEducation10Profile->school_name;
            $studentEducationInfoModel10->passout_year = $studentEducation10Profile->year;
            $studentEducationInfoModel10->passout_month = $studentEducation10Profile->month;
            if ($studentEducation10Profile->board_ref_id != '') {
                $boardDetail10 = LookupBoardEquivalent::getBoardDetailById($boardId10);
            }
            $subjectDetail10 = StudentEducation::getSubjectDetail('10', $userId);
            if($tblUserMasterModel->present_class == '10'){
                $subjectDetail10 = StudentEducation::getSubjectDetail('9', $userId);
            }

            if ($boardDetail10['overall_type'] == 'Marks' && $boardDetail10['board_ref_id'] != 7 ) {
                $studentEducationInfoModel10->overall_marks = (float) $studentEducation10Profile->overall_marks;
                foreach ($subjectDetail10 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels10[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels10[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels10[$key + 1]->marks = (float) $value->marks;
                        $marksDetailModels10[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail10['overall_type'] == 'Marks-GPA') {
                $studentEducationInfoModel10->overall_marks_gpa = (float) $studentEducation10Profile->overall_marks;
                foreach ($subjectDetail10 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels10[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels10[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        //$marksDetailModels10[$key + 1]->grade_ref_id = $value->grade_ref_id;
                        $marksDetailModels10[$key + 1]->grade_ref_id = $value->board_conversion_ref_id;
                        $marksDetailModels10[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail10['overall_type'] == 'Points') {
                $studentEducationInfoModel10->overall_points = (int) $studentEducation10Profile->overall_marks;
                foreach ($subjectDetail10 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels10[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels10[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        $marksDetailModels10[$key + 1]->points = (int) $value->marks;
                        $marksDetailModels10[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            } elseif ($boardDetail10['overall_type'] == 'Grades' || $boardDetail10['board_ref_id'] == 7) {
                if($boardDetail10['board_ref_id'] == 7){
                    $studentEducationInfoModel10->overall_marks = (float) $studentEducation10Profile->overall_marks;
                }
                $gradeDetail = StudentEducation::getGradeDetail('10', $userId);
                if($tblUserMasterModel->present_class == '10'){
                    $gradeDetail = StudentEducation::getGradeDetail('9', $userId);
                }
                /*foreach ($gradeDetail as $k => $val) {
                    foreach ($val->studentGradeCounts as $key => $value) {
                        //$studentEducationInfoModel10->{'overall_grades_' . $value->gradeRef->grade_type} = $value->grade_count;
                    }
                }*/
                $grade_count = StudentGradeCount::model()->findAll(array('condition' => 'student_education_ref_id ='.$studentEducation10Profile->student_education_id));
                foreach ($grade_count as $grade) {
                    $ref = $grade['board_conversion_ref_id'];
                    $studentEducationInfoModel10->overall_grade_10[$ref] = $grade['grade_count'];
                }
                foreach ($subjectDetail10 as $k => $val) {
                    foreach ($val->studentEducationDetails as $key => $value) {
                        $marksDetailModels10[$key + 1] = new StudentSubjectDetail();
                        $marksDetailModels10[$key + 1]->student_subject_ref_id = $value->student_subject_ref_id;
                        //$marksDetailModels10[$key + 1]->grade_ref_id = $value->grade_ref_id;
                        $marksDetailModels10[$key + 1]->grade_ref_id = $value->board_conversion_ref_id;
                        //$marksDetailModels10[$key + 1]->student_education_detail_id = $value->student_education_detail_id;
                    }
                }
            }
            if (!$marksDetailModels10) {
                $marksDetailModels10[1] = new StudentSubjectDetail();
            } else {
                $marksDetailModels10[$key + 2] = new StudentSubjectDetail();
            }
            $board_det = LookupBoardEquivalent::model()->findByPk($boardId10);
            //$boardId10 = $board_det->board_ref_id;
            $boardId10 = $board_det->board_equivalent_id;
            if($boardId10){
                //$marksSubjectList10 = LookupStudentSubject::getNinthPreferredSubjects($boardId10, $studentPreferredDepartmentIds);
                $marksSubjectList10 = LookupStudentSubject::getPreferredSubjectsByDepartment($boardId10, $studentPreferredDepartmentIds);
            }else{
                $marksSubjectList10 = array();
            }
            //$marksSubjectList10 = CHtml::listData($modelSubjects10, 'student_subject_id', 'subject_name');

            // Test Module

            $userTestInfo = UserEntranceExam::getUserExamsInfo($userId);
            if ($userTestInfo) {
                foreach ($userTestInfo as $key => $data) {
                    $userTestModels[$key + 1] = new StudentTestDetail();
                    $userTestModels[$key + 1]->attributes = $data->attributes;
                    $userTestModels[$key + 1]->overall_marks = $userTestModels[$key + 1]->overall_marks > 0 ? (float) $userTestModels[$key + 1]->overall_marks : '';

                    $entranceExam = EntranceExam::getTestAttributeById($data->entrance_exam_ref_id, 'max_marks');
                    $userTestModels[$key + 1]->entranceExamMaxMarks = $entranceExam->max_marks;

                    if ($data->userEntranceExamModules) {
                        foreach ($data->userEntranceExamModules as $k => $value) {
                            $userTestModels[$key + 1]->child[$k + 1] = new StudentTestModuleDetail();
                            $userTestModels[$key + 1]->child[$k + 1]->attributes = $value->attributes;
                            $userTestModels[$key + 1]->child[$k + 1]->marks = (float) $userTestModels[$key + 1]->child[$k + 1]->marks;
                        }
                    } else {
                        $userTestModels[$key + 1]->child[1] = new StudentTestModuleDetail();
                    }
                    if ($data->entrance_exam_ref_id) {
                        $testModulelist = EntranceExamModule::getEntranceModuleList($data->entrance_exam_ref_id);
                        $userTestModels[$key + 1]->moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
                    }
                }
            } else {
                $userTestModels[1] = new StudentTestDetail();
            }
        } else {
           
            $errorCounter = false;
            $studentEducationInfoData = $studentEducationMarksData = array();
            $studentEducationInfoData = Yii::app()->request->getPost('StudentEducationProfile');
            $studentEducationMarksData = Yii::app()->request->getPost('StudentSubjectDetail');
            // check if present class is not 10th
            if($studentEducationInfoData['12']['present_class'] && ($studentEducationInfoData['12']['present_class'] == '11p' || $studentEducationInfoData['12']['present_class'] == '12p' || $studentEducationInfoData['12']['present_class'] == '12c')){
                if ($studentEducationInfoData['12']['board_equivalent_id'] != '') {
                    $boardDetail12 = LookupBoardEquivalent::getBoardDetailById($studentEducationInfoData['12']['board_equivalent_id']);
                }
                if ($boardDetail12['overall_type'] == 'Marks' && $boardDetail12['board_ref_id'] != 7) {
                    $scenario = $boardDetail12['overall_type'];
                    unset($studentEducationMarksData['12']['Points']);
                    unset($studentEducationMarksData['12']['Grades']);
                    unset($studentEducationMarksData['12']['Marks-GPA']);
                } elseif ($boardDetail12['overall_type'] == 'Marks-GPA') {
                    $scenario = $boardDetail12['overall_type'];
                    unset($studentEducationMarksData['12']['Marks']);
                    unset($studentEducationMarksData['12']['Grades']);
                    unset($studentEducationMarksData['12']['Points']);
                } elseif ($boardDetail12['overall_type'] == 'Points') {
                    $scenario = $boardDetail12['overall_type'];
                    unset($studentEducationMarksData['12']['Marks']);
                    unset($studentEducationMarksData['12']['Grades']);
                    unset($studentEducationMarksData['12']['Marks-GPA']);
                } elseif ($boardDetail12['overall_type'] == 'Grades' || $boardDetail12['board_ref_id'] == 7) {
                    //$scenario = $boardDetail12['overall_type'];
                    $scenario = 'Grades';
                    unset($studentEducationMarksData['12']['Marks']);
                    unset($studentEducationMarksData['12']['Points']);
                    unset($studentEducationMarksData['12']['Marks-GPA']);
                }
                $studentEducationInfoModel12 = new StudentEducationProfile($scenario);
                $studentEducationInfoModel12->attributes = $studentEducationInfoData['12'];
                $studentEducationInfoModel12->educationDetail = '12';
                $schoolNameFlag = $passoutYearFlag = $boardFlag = $overallMarksFlag = $currentStudyFlag = 0;

                if ($studentEducationInfoModel12->present_class) {
                    $currentStudyFlag = 1;
                }
                if ($studentEducationInfoModel12->school_name) {
                    $schoolNameFlag = 1;
                }
                if ($studentEducationInfoModel12->passout_month && $studentEducationInfoModel12->passout_year) {
                    $passoutYearFlag = 1;
                }
                if ($studentEducationInfoModel12->board_equivalent_id) {
                    $boardFlag = 1;
                }
                if ($scenario == 'Marks' && $studentEducationInfoModel12->overall_marks != '') {
                    $overallMarksFlag = 1;
                } elseif ($scenario == 'Marks-GPA' && $studentEducationInfoModel12->overall_marks_gpa != '') {
                    $overallMarksFlag = 1;
                } elseif ($scenario == 'Points' && $studentEducationInfoModel12->overall_points != '') {
                    $overallMarksFlag = 1;
                }
                /*elseif ($scenario == 'Grades' && ($studentEducationInfoModel12->overall_grades_aa != '' || $studentEducationInfoModel12->overall_grades_a != '' || $studentEducationInfoModel12->overall_grades_b != '' || $studentEducationInfoModel12->overall_grades_c != '' || $studentEducationInfoModel12->overall_grades_d != '')) {
                    $overallMarksFlag = 1;
                }*/
                elseif ($scenario == 'Grades') {
                    $overallMarksFlag = 1;
                }
                if (!$studentEducationInfoModel12->validate()) {
                    $errorCounter = true;
                }
                $id = 1;
                $marksDetailModels12 = array();
                $subjectArray12 = array();
                $studentMarks = array();
                if($studentEducationInfoData['12']['board_equivalent_id'] != '') { // If student select board then process further
                    foreach ($studentEducationMarksData['12'][$scenario] as $key => $data) {
                        $marksDetailModels12[$id] = new StudentSubjectDetail();
                        $marksDetailModels12[$id]->attributes = $data;
                        $marksDetailModels12[$id]->class = 12;
                        $marksDetailModels12[$id]->scenario = $scenario;
                        if ($scenario == 'Marks' && $boardDetail12['board_ref_id'] != 7) {
                            $studentMarks[$id] = $marksDetailModels12[$id]->marks;
                        } elseif ($scenario == 'Grades'  || $boardDetail12['board_ref_id'] == 7) {
                            if ($boardDetail12['board_ref_id'] == 7) {
                                $studentMarks[$id] = $marksDetailModels12[$id]->marks;
                            }
                            /*$studentMarks[$id] = $marksDetailModels12[$id]->grade_ref_id;
                            if ($marksDetailModels12[$id]->grade_ref_id) {
                                $lookupGradeDetail = LookupGrade::model()->findByPk($marksDetailModels12[$id]->grade_ref_id);
                                $marksDetailModels12[$id]->grade = strtoupper($lookupGradeDetail->grade_type);
                            }*/
                            foreach($_POST['StudentEducationProfile']['overall_grade_12'] as $key=>$val){
                                if($val) {
                                    $studentEducationInfoModel12->overall_grade_12[$key] = $val['grade_count'];
                                }
                            }
                            $studentMarks[$id] = $marksDetailModels12[$id]->grade_ref_id;
                            if ($marksDetailModels12[$id]->grade_ref_id) {
                            $grade_det = LookupBoardConversion::model()->findByPk($marksDetailModels12[$id]->grade_ref_id);
                            $marksDetailModels12[$id]->student_subject_ref_id = $marksDetailModels12[$id]->student_subject_ref_id;
                            $marksDetailModels12[$id]->board_conversion_ref_id = $marksDetailModels12[$id]->grade_ref_id;
                            $marksDetailModels12[$id]->grade = $grade_det->board_marks;
                            //$marksDetailModels12[$id]->grade_ref_id = null;
                            }
                        } elseif ($scenario == 'Marks-GPA') {
                            $studentMarks[$id] = $marksDetailModels12[$id]->grade_ref_id;
                            if ($marksDetailModels12[$id]->grade_ref_id) {
                                $grade_det = LookupBoardConversion::model()->findByPk($marksDetailModels12[$id]->grade_ref_id);
                                $marksDetailModels12[$id]->student_subject_ref_id = $marksDetailModels12[$id]->student_subject_ref_id;
                                $marksDetailModels12[$id]->board_conversion_ref_id = $marksDetailModels12[$id]->grade_ref_id;
                                $marksDetailModels12[$id]->grade = $grade_det->board_marks;
                                //$marksDetailModels12[$id]->grade_ref_id = null;
                            }
                            /*if ($marksDetailModels12[$id]->grade_ref_id) {
                                $lookupGradeDetail = LookupGrade::model()->findByPk($marksDetailModels12[$id]->grade_ref_id);
                                $marksDetailModels12[$id]->grade = strtoupper($lookupGradeDetail->grade_type);
                            }*/
                        } elseif ($scenario == 'Points') {
                            $studentMarks[$id] = $marksDetailModels12[$id]->points;
                        }
                        $id++;
                    }
                }
                $id = 1;
                $duplicateFlag =false;
                foreach ($marksDetailModels12 as $key => $data) {
                    if (!$marksDetailModels12[$key]->validate()) {
                        $errorCounter = true;
                        $duplicateFlag = true;
                    }
                    
                    if (!$duplicateFlag && $marksDetailModels12[$id]->student_subject_ref_id != '' && $studentMarks[$id] != '') {
                        $marksDetailModels12[$id]->insertFlag = 1;
                        if (in_array($marksDetailModels12[$id]->student_subject_ref_id, $subjectArray12)) {
                            $errorCounter = true;
                            $marksDetailModels12[$id]->addError('student_subject_ref_id', '<div class="holder"><p>You selected the same subject again.</p></div>');
                        } else {
                            $subjectArray12[] = $marksDetailModels12[$id]->student_subject_ref_id;
                        }
                    }
                    $id++;
                }
            }else{
                // initilization for  10th
                $studentEducationInfoModel12 = new StudentEducationProfile($scenario);
                $studentEducationInfoModel12->attributes = $studentEducationInfoData['12'];
                if($studentEducationInfoModel12->present_class ==''){
                    $errorCounter = true;
                    $studentEducationInfoModel12->addError('present_class', '<div class="holder"><p>Your present class is required</p></div>');
                }
            }
            if ($studentEducationInfoData['10']['board_equivalent_id'] != '') {
                $boardDetail10 = LookupBoardEquivalent::getBoardDetailById($studentEducationInfoData['10']['board_equivalent_id']);
            }
            $scenario = '';
            if ($boardDetail10['overall_type'] == 'Marks' && $boardDetail10['board_ref_id'] != 7) {
                $scenario = $boardDetail10['overall_type'];
                unset($studentEducationMarksData['10']['Points']);
                unset($studentEducationMarksData['10']['Grades']);
                unset($studentEducationMarksData['10']['Marks-GPA']);
            } elseif ($boardDetail10['overall_type'] == 'Marks-GPA') {
                $scenario = $boardDetail10['overall_type'];
                unset($studentEducationMarksData['10']['Marks']);
                unset($studentEducationMarksData['10']['Grades']);
                unset($studentEducationMarksData['10']['Points']);
            } elseif ($boardDetail10['overall_type'] == 'Points') {
                $scenario = $boardDetail10['overall_type'];
                unset($studentEducationMarksData['10']['Marks']);
                unset($studentEducationMarksData['10']['Grades']);
                unset($studentEducationMarksData['10']['Marks-GPA']);
            } elseif ($boardDetail10['overall_type'] == 'Grades' || $boardDetail10['board_ref_id'] == 7) {
                //$scenario = $boardDetail10['overall_type'];
                $scenario = 'Grades';
                unset($studentEducationMarksData['10']['Marks']);
                unset($studentEducationMarksData['10']['Points']);
                unset($studentEducationMarksData['10']['Marks-GPA']);
            }
            $studentEducationInfoModel10 = new StudentEducationProfile($scenario);
            $studentEducationInfoModel10->attributes = $studentEducationInfoData['10'];
            $studentEducationInfoModel10->present_class = $studentEducationInfoData['12']['present_class'];
            $studentEducationInfoModel10->educationDetail = '10';
            if (!$studentEducationInfoModel10->validate()) {
                $errorCounter = true;
            }
            if($studentEducationInfoData['12']['present_class'] && ($studentEducationInfoData['12']['present_class'] == '11p' || $studentEducationInfoData['12']['present_class'] == '12p' || $studentEducationInfoData['12']['present_class'] == '12c')){
                if($studentEducationInfoModel10->passout_year != ''){
                    $differnceBetweenYears = $studentEducationInfoModel12->passout_year - $studentEducationInfoModel10->passout_year;
                    if($differnceBetweenYears < 2){
                        $errorCounter = true;
                        $studentEducationInfoModel10->addError('passout_year', '<div class="holder"><p>Atleast 2 years Less than 12th passout</p></div>');
                    }
                }
            }
            $id = 1;
            $marksDetailModels10 = array();
            $subjectArray = array();
            $studentMarks = array();
            if($studentEducationInfoData['10']['board_equivalent_id'] != '') { // If student select board then process further
                foreach ($studentEducationMarksData['10'][$scenario] as $key => $data) {
                    $marksDetailModels10[$id] = new StudentSubjectDetail();
                    $marksDetailModels10[$id]->attributes = $data;
                    $marksDetailModels10[$id]->class = 10;
                    if($tblUserMasterModel->present_class == '10'){
                        $marksDetailModels10[$id]->class = 9;
                    }
                    $marksDetailModels10[$id]->scenario = $scenario;
                    if ($scenario == 'Marks' && $boardDetail10['board_ref_id'] != 7) {
                        $studentMarks[$id] = $marksDetailModels10[$id]->marks;
                    } elseif ($scenario == 'Grades'  ||  $boardDetail10['board_ref_id'] == 7) {
                        $studentMarks[$id] = $marksDetailModels10[$id]->grade_ref_id;
                        foreach($_POST['StudentEducationProfile']['overall_grade_10'] as $key=>$val){
                            if($val) {
                                $studentEducationInfoModel10->overall_grade_10[$key] = $val['grade_count'];
                            }
                        }
                        if($marksDetailModels10[$id]->grade_ref_id) {
                        $grade_det = LookupBoardConversion::model()->findByPk($marksDetailModels10[$id]->grade_ref_id);
                        $marksDetailModels10[$id]->student_subject_ref_id = $marksDetailModels10[$id]->student_subject_ref_id;
                        $marksDetailModels10[$id]->board_conversion_ref_id = $marksDetailModels10[$id]->grade_ref_id;
                        $marksDetailModels10[$id]->grade = $grade_det->board_marks;
                        //$marksDetailModels10[$id]->grade_ref_id = null;
                        }
                        /*$studentMarks[$id] = $marksDetailModels10[$id]->grade_ref_id;
                        if ($marksDetailModels10[$id]->grade_ref_id) {
                            $lookupGradeDetail = LookupGrade::model()->findByPk($marksDetailModels10[$id]->grade_ref_id);
                            $marksDetailModels10[$id]->grade = strtoupper($lookupGradeDetail->grade_type);
                        }*/
                    } elseif ($scenario == 'Marks-GPA') {
                        $studentMarks[$id] = $marksDetailModels10[$id]->grade_ref_id;
                        if($marksDetailModels10[$id]->grade_ref_id) {
                            $grade_det = LookupBoardConversion::model()->findByPk($marksDetailModels10[$id]->grade_ref_id);
                            $marksDetailModels10[$id]->student_subject_ref_id = $marksDetailModels10[$id]->student_subject_ref_id;
                            $marksDetailModels10[$id]->board_conversion_ref_id = $marksDetailModels10[$id]->grade_ref_id;
                            $marksDetailModels10[$id]->grade = $grade_det->board_marks;
                            //$marksDetailModels10[$id]->grade_ref_id = null;
                        }
                        /*if ($marksDetailModels10[$id]->grade_ref_id) {
                            $lookupGradeDetail = LookupGrade::model()->findByPk($marksDetailModels10[$id]->grade_ref_id);
                            $marksDetailModels10[$id]->grade = strtoupper($lookupGradeDetail->grade_type);
                        }*/
                    } elseif ($scenario == 'Points') {
                        $studentMarks[$id] = $marksDetailModels10[$id]->points;
                    }
                    $id++;
                }
            }
            $id = 1;
            $duplicateFlag = false;
            foreach ($marksDetailModels10 as $key => $data) {
                if (!$marksDetailModels10[$key]->validate()) {
                    $errorCounter = true;
                    $duplicateFlag = true;
                }
                if (!$duplicateFlag && $marksDetailModels10[$id]->student_subject_ref_id != '' && $studentMarks[$id] != '') {
                    $marksDetailModels10[$id]->insertFlag = 1;
                    if (in_array($marksDetailModels10[$id]->student_subject_ref_id, $subjectArray)) {
                        $errorCounter = true;
                        $marksDetailModels10[$id]->addError('student_subject_ref_id', '<div class="holder"><p>You selected the same subject again.</p></div>');
                    } else {
                        $subjectArray[] = $marksDetailModels10[$id]->student_subject_ref_id;
                    }
                }
                $id++;
            }

            $studentTestInfoData = Yii::app()->request->getPost('StudentTestDetail');
            $studentTestModuleData = Yii::app()->request->getPost('StudentTestModuleDetail');
            if (!$studentTestModuleData) {
                $studentTestModuleData = array();
            }
            if (!$studentTestInfoData) {
                $studentTestInfoData = array();
            }
            $userTestModels = array();
            $testSubjectArray = $testArray = array();
            foreach ($studentTestInfoData as $key => $data) {
                $userTestModels[$key] = new StudentTestDetail();
                $userTestModels[$key]->attributes = $data;

                $entranceExam = EntranceExam::getTestAttributeById($data['entrance_exam_ref_id'], 'max_marks');
                $userTestModels[$key]->entranceExamMaxMarks = $entranceExam->max_marks;
                foreach ($studentTestModuleData[$key] as $k => $value) {
                    $userTestModels[$key]->child[$k] = new StudentTestModuleDetail();
                    $userTestModels[$key]->child[$k]->attributes = $value;
                    $userTestModels[$key]->child[$k]->user_entrance_exam_ref_id = $userTestModels[$key]->user_entrance_exam_id;
                }
                if ($data['entrance_exam_ref_id']) {
                    $testModulelist = EntranceExamModule::getEntranceModuleList($data['entrance_exam_ref_id']);
                    $userTestModels[$key]->moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
                }
            }
            foreach ($userTestModels as $key => $data) {
                $duplicateTestModuleFlag = false;
                $testSubjectArray = array();
                if ($userTestModels[$key]->entrance_exam_ref_id ) {
                    if (!$userTestModels[$key]->validate()) {
                        $errorCounter = true;
                    }
                }
                if ($userTestModels[$key]->entrance_exam_ref_id != '') {
                    if (in_array($userTestModels[$key]->entrance_exam_ref_id, $testArray)) {
                        $errorCounter = true;
                        $userTestModels[$key]->addError('entrance_exam_ref_id', '<div class="holder"><p>You selected the same test again.Please change</p></div>');
                    } else {
                        $testArray[] = $userTestModels[$key]->entrance_exam_ref_id;
                    }
                }
                foreach ($userTestModels[$key]->child as $k => $value) {
                    if ($userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id) {
                        if (!$userTestModels[$key]->child[$k]->validate()) {
                            $errorCounter = true;
                            $duplicateTestModuleFlag = true;
                        }
                    }
                    if (!$duplicateTestModuleFlag && $userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id != '' && $userTestModels[$key]->child[$k]->marks != '') {
                        if (in_array($userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id, $testSubjectArray)) {
                            $errorCounter = true;
                            $userTestModels[$key]->child[$k]->addError('entrance_exam_module_entrance_exam_ref_id', '<div class="holder"><p>You selected the same subject again.</p></div>');
                        } else {
                            $testSubjectArray[] = $userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id;
                        }
                    }
                }
            }


           
            foreach($studentTestInfoData as $key=>$value){
                $TestId=$value['entrance_exam_ref_id'];
                $marks = $studentTestModuleData[$key];
                $markscount=0;
                $subjectArray=array(); $sum = 0;
                if(($TestId == 137) || ($TestId == 78) || ($TestId == 93) ||  ($TestId == 77)){
                    if(!empty($marks)){
                        foreach($marks as $index=>$temp){
                            $error = false;
                            if($temp['entrance_exam_module_entrance_exam_ref_id'] != '' || $temp['marks']!= ''){
                                if($temp['entrance_exam_module_entrance_exam_ref_id'] == '' && $temp['marks']!= ''){
                                    $error = $errorCounter = true;
                                    $userTestModels[$key]->child[$index]->addError('entrance_exam_module_entrance_exam_ref_id', '<div class="holder"><p>Select your subject</p></div>');
                                    $skip_next=true;
                                }
                                if($temp['entrance_exam_module_entrance_exam_ref_id'] != '' && $temp['marks']== ''){
                                    $error = $errorCounter = true;
                                    $userTestModels[$key]->child[$index]->addError('marks', '<div class="holder"><p>Enter your individual score</p></div>');
                                    $skip_next=true;
                                }
                                if($temp['entrance_exam_module_entrance_exam_ref_id']!='' && in_array($temp['entrance_exam_module_entrance_exam_ref_id'],$subjectArray)){
                                    $error = $errorCounter = true;
                                    $userTestModels[$key]->child[$index]->addError('entrance_exam_module_entrance_exam_ref_id', '<div class="holder"><p>You selected the same subject again.</p></div>');
                                }
                                else{
                                    $subjectArray[]=$temp['entrance_exam_module_entrance_exam_ref_id'];
                                }
                                if ($error == false) {
                                    $sum = $sum +1*($temp['marks']);
                                    $markscount++;
                                }
                            }
                        }

                        switch($TestId){
                            case 137:
                            case 78://For ACT or IELTS

                                if($markscount > 4){
                                    $markscount=4;
                                }
                                if($sum != 0 && $markscount > 0 && (string)$value['overall_marks'] != (string)($sum/$markscount) ){
                                    $errorCounter = true;
                                    $userTestModels[$key]->addError('overall_marks', '<div class="holder"><p>Your individual score is not matched with your overall score</p></div>');
                                }
                                break;

                            case 93:
                            case 77://For SAT or TOEFL

                                if($sum && (string)$value['overall_marks'] != (string)$sum ){
                                    $errorCounter = true;
                                    $userTestModels[$key]->addError('overall_marks', '<div class="holder"><p>Your individual score is not matched with your overall score</p></div>');
                                }
                                break;
                        }
                    }

                }
            }

            if (!$errorCounter) {
                if($studentEducationInfoData['12']['present_class'] && ($studentEducationInfoData['12']['present_class'] == '11p' || $studentEducationInfoData['12']['present_class'] == '12p' || $studentEducationInfoData['12']['present_class'] == '12c')){
                        // saving 12th data
                $tblUserModelObj = TblUserMaster::model()->findByPk($userId);
                $presentClass = substr($studentEducationInfoModel12->present_class, 0, 2);
                $classStatus = substr($studentEducationInfoModel12->present_class, 2, 1);
                $classStatus = $classStatus == 'c' ? 'Completed' : 'Pursuing';

                $oldValueOfClassLevel = $tblUserModelObj->present_class . $tblUserModelObj->class_status;
                $tblUserModelObj->present_class = $presentClass;
                $tblUserModelObj->class_status = $classStatus;
                $newValueOfClassLevel = $tblUserModelObj->present_class . $tblUserModelObj->class_status;
                $getUserData = TblUserMaster::getUserDetails($userId);
                if ($oldValueOfClassLevel != $newValueOfClassLevel) {
                    if ($this->rbacRole == 'Student' || $this->rbacRole == 'SI') {
                        //$tblLoginMaster->is_class_status_confirmed = 0;
                    } else {
                        LoginMaster::updateProfileValidationField($getUserData->login_ref_id, 'is_class_status_confirmed', 1, $userId);
                    }
                    /*$tblLoginMaster = LoginMaster::model()->findByPk($getUserData->login_ref_id);
                    if ($this->rbacRole == 'Student') {

                        $tblLoginMaster->is_class_status_confirmed = 0;
                    } else {
                        $tblLoginMaster->is_class_status_confirmed = 1;
                    }
                    $tblLoginMaster->modified_on = date('Y-m-d H:i:s');
                    $tblLoginMaster->save(false);
                    StudentProfileValidationLog::saveLogData($userId, 'ClassLevel', $tblLoginMaster->is_class_status_confirmed, $loginId);*/
                }
                //$getUserData = TblUserMaster::getUserDetails($userId);
                if(Yii::app()->session->itemAt('studentProfileConfirmationId')){
                    LoginMaster::updateProfileValidationField($getUserData->login_ref_id, 'is_class_status_confirmed', 1, $userId);
                }


                        $studentEducationModel10 = StudentEducation::model()->findAll("user_ref_id=:Id",array(":Id"=>$userId));
                        $studentEducationModelIds = CHtml::listData($studentEducationModel10,"student_education_id","student_education_id");
                    if($studentEducationModelIds){
                        StudentGradeCount::model()->deleteAll('student_education_ref_id IN ('.implode(",",$studentEducationModelIds).')');
                        StudentEducationDetail::model()->deleteAll('student_education_ref_id IN ('.implode(",",$studentEducationModelIds).')');
                    }

                        StudentEducation::model()->deleteAll("user_ref_id=:Id",array(":Id"=>$userId));

                        $tblUserModelObj->passout_month = $studentEducationInfoModel12->passout_month;
                        $tblUserModelObj->passout_year = $studentEducationInfoModel12->passout_year;
                        $getBoardDetail = LookupBoardEquivalent::getBoardDetailById($studentEducationInfoModel12->board_equivalent_id);

                        $tblUserModelObj->present_board_ref_id = $getBoardDetail['board_ref_id'];
                        $tblUserModelObj->user_id = $userId;
                        $tblUserModelObj->modified_on = date('Y-m-d H:i:s');
                        $tblUserModelObj->setIsNewRecord(false);
                        $tblUserModelObj->save(false);
                        $studentEducationModel12 = new StudentEducation();
                        $studentData12['user_ref_id'] = $userId;
                        $studentData12['board_ref_id'] = $studentEducationInfoModel12->board_equivalent_id;
                        if ($studentEducationInfoModel12->getScenario() == 'Marks' && $boardDetail12['board_ref_id'] != 7) {
                            $studentData12['overall_marks'] = $studentEducationInfoModel12->overall_marks;
                            $studentData12['overall_points'] = NULL;
                        } elseif ($studentEducationInfoModel12->getScenario() == 'Marks-GPA') {
                            $studentData12['overall_marks'] = $studentEducationInfoModel12->overall_marks_gpa;
                            $studentData12['overall_points'] = NULL;
                        } elseif ($studentEducationInfoModel12->getScenario() == 'Points') {
                            $studentData12['overall_marks'] = $studentEducationInfoModel12->overall_points;
                            $studentData12['overall_points'] = NULL;
                        } elseif ($studentEducationInfoModel12->getScenario() == 'Grades' || $boardDetail12['board_ref_id'] == 7) {
                            $studentData12['overall_points'] = NULL;
                            $studentData12['overall_marks'] = NULL;
                            if($boardDetail12['board_ref_id'] == 7){
                                $studentData12['overall_marks'] = $studentEducationInfoModel12->overall_marks;
                            }
                        }
                        $studentData12['year'] = $studentEducationInfoModel12->passout_year;
                        $studentData12['month'] = $studentEducationInfoModel12->passout_month;
                        $studentData12['class_level'] = '12';
                        if($studentEducationInfoData['12']['present_class'] == '11p'){
                            $studentData12['status'] = 'Expected';
                        }else{
                            $studentData12['status'] = $classStatus;
                        }
                        $studentData12['school_name'] = $studentEducationInfoModel12->school_name;
                        $studentEducation12 = StudentEducation::getStudentEducationDetails($userId,'12');
                        if ($studentEducation12->student_education_id) {
                            $studentEducationModel12->attributes = $studentData12;

                            $studentEducationModel12->student_education_id = $studentEducation12->student_education_id;
                            $studentEducationModel12->added_on = date('Y-m-d H:i:s');
                            $studentEducationModel12->setIsNewRecord(false);
                            $studentEducationModel12->save(false);
                        } else {
                           
                            $studentEducationModel12->attributes = $studentData12;
                            $studentEducationModel12->insert();
                        }
                        // StudentGradeCount::model()->deleteAll('student_education_ref_id=' . $studentEducationModel12->student_education_id);
                        if ($studentEducationInfoModel12->getScenario() == 'Grades' || $boardDetail12['board_ref_id'] == 7) {
                            foreach($_POST['StudentEducationProfile']['overall_grade_12'] as $key=>$val){
                                if($val) {
                                    StudentGradeCount::setStudentGrades($studentEducationModel12->student_education_id, $key, $val);
                                }
                            }
                            /*if ($studentEducationInfoModel12->overall_grades_aa) {
                                StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 1, $studentEducationInfoModel12->overall_grades_aa);
                            }
                            if ($studentEducationInfoModel12->overall_grades_a) {
                                StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 2, $studentEducationInfoModel12->overall_grades_a);
                            }
                            if ($studentEducationInfoModel12->overall_grades_b) {
                                StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 3, $studentEducationInfoModel12->overall_grades_b);
                            }
                            if ($studentEducationInfoModel12->overall_grades_c) {
                                StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 4, $studentEducationInfoModel12->overall_grades_c);
                            }
                            if ($studentEducationInfoModel12->overall_grades_d) {
                                StudentGradeCount::setStudentGradeInfo($studentEducationModel12->student_education_id, 5, $studentEducationInfoModel12->overall_grades_d);
                            }*/
                        }
                        // StudentEducationDetail::model()->deleteAll('student_education_ref_id=' . $studentEducationModel12->student_education_id);
                   //echo '<pre>'; print_r($marksDetailModels12); exit;
                        foreach ($marksDetailModels12 as $key => $value) {
                            if ($marksDetailModels12[$key]->insertFlag == 1) {
                                $marksDetailModels12[$key]->grade_ref_id = null;
                                $studentSubjectModel[$key] = new StudentEducationDetail();
                                $studentSubjectModel[$key]->attributes = $marksDetailModels12[$key]->attributes;
                                if($studentEducationInfoModel12->getScenario()=='Points'){
                                    $studentSubjectModel[$key]->marks = $marksDetailModels12[$key]->points;
                                    $studentSubjectModel[$key]->ib_level = 'HL';
                                    $studentSubjectModel[$key]->points = NULL;
                                }
                                $studentSubjectModel[$key]->student_education_ref_id = $studentEducationModel12->student_education_id;
                                $studentSubjectModel[$key]->save(false);
                            }
                        }
                    }
                    elseif($studentEducationInfoData['12']['present_class'] == '10p' || $studentEducationInfoData['12']['present_class'] == '9p'){

                        $studentEducationModel10 = StudentEducation::model()->findAll("user_ref_id=:Id",array(":Id"=>$userId));
                        $studentEducationModelIds = CHtml::listData($studentEducationModel10,"student_education_id","student_education_id");
                       if($studentEducationModelIds){
                           StudentGradeCount::model()->deleteAll('student_education_ref_id IN ('.implode(",",$studentEducationModelIds).')');
                           StudentEducationDetail::model()->deleteAll('student_education_ref_id IN ('.implode(",",$studentEducationModelIds).')');
                       }
                       StudentEducation::model()->deleteAll("user_ref_id=:Id",array(":Id"=>$userId));


                        $tblUserModelObj = TblUserMaster::model()->findByPk($userId);
                        $presentClass = ($studentEducationInfoModel10->present_class == '10p') ? substr($studentEducationInfoModel10->present_class, 0, 2) : substr($studentEducationInfoModel10->present_class, 0, 1);
                        $classStatus = substr($studentEducationInfoModel10->present_class, 2, 1);
                        $classStatus = $classStatus == 'c' ? 'Completed' : 'Pursuing';
                        $oldValueOfClassLevel = $tblUserModelObj->present_class . $tblUserModelObj->class_status;

                        $newValueOfClassLevel = $tblUserModelObj->present_class . $tblUserModelObj->class_status;
                        $getUserData = TblUserMaster::getUserDetails($userId);
                        if ($oldValueOfClassLevel != $newValueOfClassLevel) {
                            if ($this->rbacRole == 'Student' || $this->rbacRole == 'SI') {
                                //$tblLoginMaster->is_class_status_confirmed = 0;
                            } else {
                                LoginMaster::updateProfileValidationField($getUserData->login_ref_id, 'is_class_status_confirmed', 1, $userId);
                            }
                        }
                        //$getUserData = TblUserMaster::getUserDetails($userId);
                        if(Yii::app()->session->itemAt('studentProfileConfirmationId')){
                            LoginMaster::updateProfileValidationField($getUserData->login_ref_id, 'is_class_status_confirmed', 1, $userId);
                        }

                       
                        $tblUserModelObj->user_id = $userId;
                        $tblUserModelObj->modified_on = date('Y-m-d H:i:s');
                        $tblUserModelObj->present_class = $presentClass;
                        $tblUserModelObj->class_status = $classStatus;
                        $tblUserModelObj->passout_year = $studentEducationInfoData['10']['passout_year'] + 2;
                        $getBoardDetail = LookupBoardEquivalent::getBoardDetailById($studentEducationInfoModel10->board_equivalent_id);
                        $tblUserModelObj->passout_month = $studentEducationInfoData['10']['passout_month'];
                        $tblUserModelObj->present_board_ref_id = $getBoardDetail['board_ref_id'];
                        $tblUserModelObj->setIsNewRecord(false);
                        $tblUserModelObj->save(false);
                    }

                // saving 10th data

                $studentEducationModel10 = new StudentEducation();
                $studentData10['user_ref_id'] = $userId;
                $studentData10['board_ref_id'] = $studentEducationInfoModel10->board_equivalent_id;
                if ($studentEducationInfoModel10->getScenario() == 'Marks' && $boardDetail10['board_ref_id'] != 7) {
                    $studentData10['overall_marks'] = $studentEducationInfoModel10->overall_marks;
                    $studentData10['overall_points'] = NULL;
                } elseif ($studentEducationInfoModel10->getScenario() == 'Marks-GPA') {
                    $studentData10['overall_marks'] = $studentEducationInfoModel10->overall_marks_gpa;
                    $studentData10['overall_points'] = NULL;
                } elseif ($studentEducationInfoModel10->getScenario() == 'Points') {
                    $studentData10['overall_marks'] = $studentEducationInfoModel10->overall_points;
                    $studentData10['overall_points'] = NULL;
                } elseif ($studentEducationInfoModel10->getScenario() == 'Grades' || $boardDetail10['board_ref_id'] == 7) {
                    $studentData10['overall_points'] = NULL;
                    $studentData10['overall_marks'] = NULL;
                    if($boardDetail10['board_ref_id'] == 7){
                    $studentData10['overall_marks'] = $studentEducationInfoModel10->overall_marks;
                    }
                }
                $studentData10['year'] = $studentEducationInfoModel10->passout_year;
                $studentData10['month'] = $studentEducationInfoModel10->passout_month;

                $studentData10['class_level'] = '10';
                if($tblUserModelObj->present_class == '10'){
                    $studentData10['class_level'] = '9';
                }
                if($studentEducationInfoData['12']['present_class'] == '10p'){
                    $studentData10['status'] = 'Pursuing';
                }else{
                    $studentData10['status'] = 'Completed';
                }
                $studentData10['school_name'] = $studentEducationInfoModel10->school_name;
                $studentEducation10 = StudentEducation::getStudentEducationDetails($userId, '10');
                if($tblUserMasterModel->present_class == '10'){
                    $studentEducation10 = StudentEducation::getStudentEducationDetails($userId, '9');
                }
                if ($studentEducation10->student_education_id) {
                    $studentEducationModel10->attributes = $studentData10;
                    $studentEducationModel10->student_education_id = $studentEducation10->student_education_id;
                    $studentEducationModel10->added_on = date('Y-m-d H:i:s');
                    $studentEducationModel10->setIsNewRecord(false);
                    $studentEducationModel10->save(false);
//                    Yii::app()->user->setFlash('error', "Data saving failed due to some technical issues. Kindly report a bug to site admin.");
//                    $this->redirect(Yii::app()->createUrl('student/profile/editEducation'));
                } else {
                   
                    $studentEducationModel10->attributes = $studentData10;
                    $studentEducationModel10->insert();
                }
            // StudentGradeCount::model()->deleteAll('student_education_ref_id=' . $studentEducationModel10->student_education_id);
                if ($studentEducationInfoModel10->getScenario() == 'Grades') {
                    foreach($_POST['StudentEducationProfile']['overall_grade_10'] as $key=>$val){
                        if($val) {
                            StudentGradeCount::setStudentGrades($studentEducationModel10->student_education_id, $key, $val);
                        }
                    }
                    /*if ($studentEducationInfoModel10->overall_grades_aa) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 1, $studentEducationInfoModel10->overall_grades_aa);
                    }
                    if ($studentEducationInfoModel10->overall_grades_a) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 2, $studentEducationInfoModel10->overall_grades_a);
                    }
                    if ($studentEducationInfoModel10->overall_grades_b) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 3, $studentEducationInfoModel10->overall_grades_b);
                    }
                    if ($studentEducationInfoModel10->overall_grades_c) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 4, $studentEducationInfoModel10->overall_grades_c);
                    }
                    if ($studentEducationInfoModel10->overall_grades_d) {
                        StudentGradeCount::setStudentGradeInfo($studentEducationModel10->student_education_id, 5, $studentEducationInfoModel10->overall_grades_d);
                    }*/
                }
                //StudentEducationDetail::model()->deleteAll('student_education_ref_id=' . $studentEducationModel10->student_education_id);
                foreach ($marksDetailModels10 as $key => $value) {
                    //print_r($marksDetailModels10[$key]->attributes);
                    if ($marksDetailModels10[$key]->insertFlag == 1) {
                        $marksDetailModels10[$key]->grade_ref_id = null;

                        $studentSubjectModel[$key] = new StudentEducationDetail();
                        $studentSubjectModel[$key]->attributes = $marksDetailModels10[$key]->attributes;
                        if($studentEducationInfoModel10->getScenario()=='Points'){
                            $studentSubjectModel[$key]->marks = $marksDetailModels10[$key]->points;
                            $studentSubjectModel[$key]->points = NULL;
                        }
                        $studentSubjectModel[$key]->student_education_ref_id = $studentEducationModel10->student_education_id;
                        $studentSubjectModel[$key]->save(false);
                    }
                }




                // Saving Test Data
                $resultCount = UserEntranceExam::deleteUserAllExamData($userId);
             
                foreach ($userTestModels as $key => $data) {
                    if ($data->entrance_exam_ref_id) {
                        $userEntranceExamModel = new UserEntranceExam();
                        $userEntranceExamModel->user_ref_id = $userId;
                        $userEntranceExamModel->attributes = $data->attributes;
                        $userEntranceExamModel->added_by = $loginId;
                        $userEntranceExamModel->save(false);

                        foreach ($data->child as $k => $value) {
                            if ($value->entrance_exam_module_entrance_exam_ref_id != '' && $value->marks != '') {
                                $userEntranceExamModuleModel = new UserEntranceExamModule();
                                $userEntranceExamModuleModel->attributes = $value->attributes;
                                $userEntranceExamModuleModel->user_entrance_exam_ref_id = $userEntranceExamModel->user_entrance_exam_id;
                                $userEntranceExamModuleModel->added_by = $loginId;
                                $userEntranceExamModuleModel->save(false);
                            }
                        }
                    }
                }




                $criticalFields = array(
                    'edu_study_level' => $currentStudyFlag,
                    'school_name' => $schoolNameFlag,
                    'completion_year' => $passoutYearFlag,
                    'board' => $boardFlag,
                    'overall_marks' => $overallMarksFlag,
                );
                TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
				
				$verify_score = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
				
				
				if ((($verify_score->board_10 == 0) || ($verify_score->board_12 == 0) || ($verify_score->marks_10 == 0) || ($verify_score->marks_12 == 0) || ($verify_score->marks_100 == 0) || ($verify_score->marks_above_95 == 0)  || ($verify_score->marks_diff == 0)  || ($verify_score->subject_marks_10_100 == 0) || ($verify_score->subject_marks_12_100 == 0)) && $verify_score->profile_verification_score_id)
				{
				if($studentEducationModel10->student_education_id && $studentEducationModel12->student_education_id){
					$verify_score->board_10 = 1;
					$verify_score->board_10_date = date('Y-m-d H:i:s');
					$verify_score->board_12 = 1;
					$verify_score->board_12_date = date('Y-m-d H:i:s');
					$verify_score->marks_10 = 1;
					$verify_score->marks_10_date = date('Y-m-d H:i:s');
					$verify_score->marks_12 = 1;
					$verify_score->marks_12_date = date('Y-m-d H:i:s');
					$verify_score->marks_100 = 1;
					$verify_score->marks_100_date =  date('Y-m-d H:i:s');
					$verify_score->marks_above_95 = 1;
					$verify_score->marks_above_95_date = date('Y-m-d H:i:s');
					$verify_score->marks_diff = 1;
					$verify_score->marks_diff_date = date('Y-m-d H:i:s');
					$verify_score->subject_marks_10_100 = 1;
					$verify_score->subject_marks_10_100_date = date('Y-m-d H:i:s');
					$verify_score->subject_marks_12_100 = 1;
					$verify_score->subject_marks_12_100_date = date('Y-m-d H:i:s');
					$verify_score->save(false);
					}
				}
				if(($verify_score->passout_year == 0) && $verify_score->profile_verification_score_id)
				{
					$verify_score->passout_year = 1;
					$verify_score->passout_year_date = date('Y-m-d H:i:s');
					$verify_score->save(false);
				}
				Yii::import('application.components.profilevalidation.*');
				$conditions_obj = new Conditions();
				$conditions_obj->userId = $userId;
				if($verify_score->profile_score == 0 && $verify_score->profile_verification_score_id){
					$verify_score->profile_score = $conditions_obj->validateProfileCompletion();
					$verify_score->profile_score_date =  date('Y-m-d H:i:s)');
					$verify_score->save(false);
				}

				$validate = new ValidateStudent();
				$user = TblUserMaster::model()->findByPk($userId);
				$validate->validate_after_confirmation($verify_score->profile_verification_score_id, $user);
				
                $shortList = new ShortListEngine();
                $shortList->profileUpdated();

                //Remove from Cache
                Yii::app()->cache->delete($userId);

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'education information'));
                CommonUtils::calculateCriticalPercentage($userId);
                $this->redirect(Yii::app()->createUrl('student/profile/editPreferences', $this->userParams));
            }

            
            /*$boardLookup12 = LookupBoardEquivalent::GetSchoolBoardList('12');
            $boardList12 = CHtml::listData($boardLookup12, 'board_equivalent_id', 'board_desc');*/
            $boardList12 = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);

            $yearList12 = UniversityHelper::completeYear($studentEducationInfoModel12->present_class, 1);



            $boardId12 = $studentEducationInfoModel12->board_equivalent_id;

            if($boardId12){
                $marksSubjectList12 = LookupStudentSubject::getPreferredSubjectsByDepartment($boardId12, $studentPreferredDepartmentIds);
            }else{
                $marksSubjectList12 = array();
            }
            $boardLookup10 = LookupBoardEquivalent::GetSchoolBoardList('10');
            if($tblUserMasterModel->present_class == '10'){
                $boardLookup10 = LookupBoardEquivalent::GetSchoolBoardList('9');
            }
            //$boardList10 = CHtml::listData($boardLookup10, 'board_equivalent_id', 'board_desc');
            $boardList10 = LookupBoardEquivalent::getBoardCategoryByClass('10','',true);
            if($studentEducationInfoModel12->present_class == '10p'){
                $yearList10 = UniversityHelper::complitionYearList('10',(date('Y')+5));
            }else{
                $yearList10 = UniversityHelper::complitionYearList('10',$studentEducationInfoModel12->passout_year);
            }
            $boardId10 = $studentEducationInfoModel10->board_equivalent_id;
            $board_det = LookupBoardEquivalent::model()->findByPk($boardId10);
            //$boardId10 = $board_det->board_ref_id;
            $boardId10 = $board_det->board_equivalent_id;
            if($boardId10){
                //$marksSubjectList10 = LookupStudentSubject::getNinthPreferredSubjects($boardId10, $studentPreferredDepartmentIds);
                $marksSubjectList10 = LookupStudentSubject::getPreferredSubjectsByDepartment($boardId10, $studentPreferredDepartmentIds);
            }else{
                $marksSubjectList10 = array();
            }
            // Test module
        }
        if ($userInfo->membership_ref_id == 2 || $userInfo->membership_ref_id == 4) {
            $instData = TblSiDi::GetInstIdFromSchoolId($userInfo->school_ref_id);
            if ($instData->inst_id) {
                /*$boardData = TblSiBoard::getSchoolBoardEquivalentList($instData->inst_id, '12');
                $boardList12 = CHtml::listData($boardData, 'board_equivalent_id', 'board_desc');*/
                $boardList12 = TblSiBoard::getSchoolBoardByCategory($instData->inst_id, '12');
            } else {
                //$boardList12 = CHtml::listData(LookupBoardEquivalent::GetSchoolBoardList('12'), 'board_equivalent_id', 'board_desc');
                $boardList12 = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);
            }
        } else {
            //$boardList12 = CHtml::listData(LookupBoardEquivalent::GetSchoolBoardList('12'), 'board_equivalent_id', 'board_desc');
            $boardList12 = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);
        }

        
        // remove by anshul show all board in list
//        if ($userInfo->present_class !='10' && ($userInfo->membership_ref_id == 2 || $userInfo->membership_ref_id == 4)) {
//            $instData = TblSiDi::GetInstIdFromSchoolId($userInfo->school_ref_id);
//            if ($instData->inst_id) {
//                $boardData = TblSiBoard::getSchoolBoardEquivalentList($instData->inst_id, '10');
//                $boardList10 = CHtml::listData($boardData, 'board_equivalent_id', 'board_desc');
//            } else {
//                $boardList10 = CHtml::listData(LookupBoardEquivalent::GetSchoolBoardList('10'), 'board_equivalent_id', 'board_desc');
//            }
//        } else {
//            $boardList10 = CHtml::listData(LookupBoardEquivalent::GetSchoolBoardList('10'), 'board_equivalent_id', 'board_desc');
//        }
        
        /*$gradeData = LookupGrade::getgradeList();
        $gradeArray = CHtml::listData($gradeData, 'grade_id', 'grade_type');
        $gradeArray = str_replace('aa', 'a*', $gradeArray);*/

        $gradeArray = array();
        if($boardId12){
            $gradeArray = LookupBoardConversion::getGradesByBoard($boardId12,true);
        }
        //$americanGradeData = LookupGrade::getgradeList(8);
        //$americanGradeArray = CHtml::listData($americanGradeData, 'grade_id', 'grade_type');
        $americanGradeArray = LookupBoardConversion::getGradesByBoard(31);


        //$boardList10 = CHtml::listData(LookupBoardEquivalent::GetSchoolBoardList('10'), 'board_equivalent_id', 'board_desc');
        $boardList10 = LookupBoardEquivalent::getBoardCategoryByClass('10','',true);
        if($tblUserMasterModel->present_class == '10'){
            //$boardList10 = CHtml::listData(LookupBoardEquivalent::GetSchoolBoardList('9'), 'board_equivalent_id', 'board_desc');
            $boardList10 = LookupBoardEquivalent::getBoardCategoryByClass('9','',true);
        }
        
        $this->render('educationDetail', array(
                                'studentEducationInfoModel12' => $studentEducationInfoModel12, 
                                'marksDetailModels12' => $marksDetailModels12, 
                                'marksSubjectList12' => $marksSubjectList12, 
                                'gradeArray' => $gradeArray,
                                'americanGradeArray' => $americanGradeArray,
                                'yearList12' => $yearList12, 
                                'boardList12' => $boardList12, 
                                'boardDetail12' => $boardDetail12,
                                'studentEducationInfoModel10' => $studentEducationInfoModel10, 
                                'marksDetailModels10' => $marksDetailModels10, 
                                'marksSubjectList10' => $marksSubjectList10, 
                                'yearList10' => $yearList10, 
                                'boardList10' => $boardList10, 
                                'boardDetail10' => $boardDetail10,
                                'userTestModels' => $userTestModels, 
                                'examlist' => $examlist, 
                                'testYearList' => $testYearList,
                                'userId' => $userId
                        ));
						
		
    }

    public function actionUploadUserImage() {
        $userId = $this->userId;
        $latestUrlForRedirection = CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');
        $this->isUserImageAvailable = false;

        $path = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        $valid_formats = array(".jpg", ".png", ".gif");
        if (isset($_POST) and $_SERVER['REQUEST_METHOD'] == "POST") {
            $name = $_FILES['photoimg']['name'];
            $size = $_FILES['photoimg']['size'];

            if (strlen($name)) {
                //list($txt, $ext) = strrchr($name, '.');//explode(".", $name);
                $ext = strrchr($name, '.');
                $ext = strtolower($ext);
                if (in_array($ext, $valid_formats)) {
                    if ($size < (1024 * 1024)) {
                        $actual_image_name = 'img_U_' . time() . $ext; //time() . substr(str_replace(" ", "_", $txt), 5) . "." . $ext;
                        $tmp = $_FILES['photoimg']['tmp_name'];
                        if (move_uploaded_file($tmp, $path . $actual_image_name)) {
                            $this->actionDeleteUserImage(false);
                            $this->isUserImageAvailable = true;
                            $this->userImage = $actual_image_name;

                            $studentModel = TblUserMaster::model()->findByPk($userId);
                            $studentModel->setAttributes(array('user_photo' => $this->userImage));
                            $studentModel->save(false);
                            $imgPath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/' . $actual_image_name;
                            $imgPathThumb = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/thumb_90x90/' . $actual_image_name;
                            Yii::import('application.extensions.image.Image');
                            $image = new Image($imgPath); // Instantiate the library

                            list($width, $height) = getimagesize($imgPath);

                            $newWidth = 90;
                            $newHeight = 90;
                            if ($width > 90 || $height > 90) {
                                $image->resize($newWidth, $newHeight);
                            }
                            $image->save($imgPathThumb);
                            $criticalFields = array(
                                'picture' => 1,
                            );
                            TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
                        } else {
                            $this->isUploading = true;
                            $this->imageUploadErrorMessage = "<div class='errorMessage popup'><div class='holder'><p>Image upload failed</p></div></div>";
                        }
                    } else {
                        $this->isUploading = true;
                        $this->imageUploadErrorMessage = "<div class='errorMessage popup'><div class='holder'><p>Image file size max 1 MB</p></div></div>";
                    }
                } else {
                    $this->isUploading = true;
                    $this->imageUploadErrorMessage = "<div class='errorMessage popup'><div class='holder'><p>Invalid file format</p></div></div>";
                }
            } else {
                $this->isUploading = true;
                $this->imageUploadErrorMessage = "<div class='errorMessage popup'><div class='holder'><p>Please select image!</p></div></div>";
            }

            $this->userData = TblUserMaster::getUserDetails($userId);
            $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
            if ($this->userData->user_photo != '') {
                if (file_exists($userImagePath . $this->userData->user_photo)) {
                    $this->isUserImageAvailable = true;
                    $this->userImage = $userImagePath . $this->userData->user_photo;
                } else {
                    $this->isUserImageAvailable = false;
                    $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
                }
            } else {
                $this->isUserImageAvailable = false;
                $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
            }
            $this->renderPartial('_studentImage');
            exit;
        }
    }

    public function actionDeleteUserImage($useSubView = true) {
        $userId = $this->userId;
        $this->isUserImageAvailable = false;
        $latestUrlForRedirection = CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');

        $this->userData = TblUserMaster::getUserDetails($userId);
        //$studentModel = TblUserMaster::model()->find()
        $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        if ($this->userData->user_photo != '') {
            if (file_exists($userImagePath . $this->userData->user_photo)) {
                if (unlink($userImagePath . $this->userData->user_photo)) {
                    @unlink($userImagePath.'thumb_90x90/' . $this->userData->user_photo);
                    $this->isUserImageAvailable = false;
                    $studentModel = TblUserMaster::model()->findByPk($userId);
                    $studentModel->setAttributes(array('user_photo' => ''));
                    $studentModel->save(false);
                    $criticalFields = array(
                        'picture' => 0,
                    );
                    TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
                    $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
                } else {
                    $this->userImage = $userImagePath . $this->userData->user_photo;
                    $this->isUserImageAvailable = true;
                }
            }
        } else {
            $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
        }
        if ($useSubView) {
            $this->renderPartial('_studentImage');
        }
    }


    public function actionGetSchoolList() {
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        if ($term) {
            $res = LookupSchool::model()->findAll(array('condition' => 'school_name like "%' . $term . '%" AND user_entered <> 1 ', 'limit' => '10', 'order' => 'CASE WHEN school_name LIKE "' . $term . '%" THEN 0 ELSE 1 END, length(school_name), school_name'));
            $val = array();
            if ($res) {
                foreach ($res as $r) {
                    $val[] = array(
                        'id' => $r->attributes['school_id'],
                        'label' => $r->attributes['school_name'],
                    );
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function actionGetStatesList() {
        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblState::getStateByCountry($countryId);
        echo json_encode($result);
    }

    public function actionGetCountryCode() {
        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblCountryMaster::getPhoneCode($countryId);
        echo $result;
    }

    public function actionGetCityList() {
        $countryId = Yii::app()->request->getQuery('countryId');
        $stateId = Yii::app()->request->getQuery('stateId');
        $result = array();
        if ($stateId > 0) {
            //$result = TblCityMaster::getCityListByState($stateId);
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND state_ref_id = '" . $stateId . "'", "order" => "city_name"));
        } else if ($countryId > 0) {
            //$result = TblCityMaster::getCityListByCountry($countryId);
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND country_id = '" . $countryId . "' GROUP BY city_name ", "order" => "city_name"));
        }
        $cityResults = array();
        foreach ($result as $city) {
            $cityResults[$city->attributes['city_id']] = $city->attributes['city_name'];
        }
        //sort($cityResults);
        echo json_encode($cityResults);
    }

    public function actionGetBoardList() {
        $class = Yii::app()->request->getParam('class');
        $status = Yii::app()->request->getParam('status');
        //$boardlookup = LookupBoardEquivalent::GetSchoolBoardList($class);
        //$boardList = CHtml::listData($boardlookup, 'board_equivalent_id', 'board_desc');
        $yearList = UniversityHelper::completeYear($class . $status, 1);
        //$data['boardList'] =$boardList;
        $data['yearList'] = $yearList;
        echo json_encode($data);
    }

    public function actionDeleteSubject() {
        $id = Yii::app()->request->getPost('id');
        $count = StudentEducationDetail::model()->deleteByPk($id);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteTest() {
        $id = Yii::app()->request->getPost('id');
        $count = UserEntranceExam::deleteUserExamData($id);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteTestModule() {
        $id = Yii::app()->request->getPost('id');
        $count = UserEntranceExamModule::model()->deleteByPk($id);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteContact() {
        $id = Yii::app()->request->getPost('id');
        StudentContactNumber::model()->deleteByPk($id);
    }

    public function actionDeleteEmail() {
        $id = Yii::app()->request->getPost('id');
        StudentAlternateEmail::model()->deleteByPk($id);
    }

    public function actionGetSubjectsList() {
        $boardId = Yii::app()->request->getParam('boardId');
        $userInfo = TblUserMaster::getUserDetails($this->userId);
        $studentPreferredDepartments = $userInfo->studentPreferredDepartments;
        $studentPreferredDepartmentIds = array();
        if (count($studentPreferredDepartments) > 0) {
            foreach ($studentPreferredDepartments as $deptPref) {
                $studentPreferredDepartmentIds[] = $deptPref->attributes['main_dept_ref_id'];
            }
        }
        $studentPreferredDepartmentIds = array_filter($studentPreferredDepartmentIds);
        $board_det = LookupBoardEquivalent::model()->findByPk($boardId);

        //$subjectList = LookupStudentSubject::getNinthPreferredSubjects($board_det->board_ref_id, $studentPreferredDepartmentIds);
        $subjectList = LookupStudentSubject::getPreferredSubjectsByDepartment($boardId, $studentPreferredDepartmentIds);
        //$modelSubjects = LookupSubjectMaster::getSubjectsList($boardId);
        //$subjectList = CHtml::listData($modelSubjects, 'student_subject_id', 'subject_name');
        $boardDetail = LookupBoardEquivalent::getBoardDetailById($boardId);
        $data['subjectList'] = $subjectList;
        $data['boardData'] = $boardDetail;
        $gradeArray = LookupBoardConversion::getGradesByBoard($boardId,true);
        $data['gradeArray'] = $gradeArray;
        echo json_encode($data);
    }

    public function actionGetModuleList() {
        $testId = Yii::app()->request->getParam('testId');
        $testModulelist = EntranceExamModule::getEntranceModuleList($testId);
        $moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
        $data['moduleList'] = $moduleList;
        $entranceExam = EntranceExam::getTestAttributeById($testId, 'max_marks');
        $data['maxMarks'] = $entranceExam->max_marks;
        Yii::app()->session['dropdownOptionsCount']=count($data['moduleList']);
        echo json_encode($data);
    }

    public function actionGetMarksBlock() {
        $boardId = Yii::app()->request->getParam('boardId');
        $class = Yii::app()->request->getParam('class');
    }

    public function actionEditPreferences() {
/*        if ($this->rbacRole == 'Student') {
            $this->breadcrumbs = array(
                'Home' => array('/home'),
                'My Profile' => array('/student/profile'),
                'Edit Preferences',
            );
        }*/

        if($this->rbacRole != 'Student' && $this->rbacRole != 'DI'){
            $studentName = implode(' ', array($this->userData->first_name, $this->userData->last_name));
/*            $this->breadcrumbs=array(
                'Home'=>array('/../mainadmin/admin_home.php'),
                (($studentName == ' ')? 'Unknown' : $studentName) => array('/student/profile/index/uid/'.$this->userId),
                'Edit Preferences',
            );*/
        }

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->pageTitle = Yii::app()->name . ' - Preferences';
        //Collect student data
        $userId = $this->userId;
        $loginId = Yii::app()->user->id;
        $userData = TblUserMaster::getUserDetails($userId);
        if($userData->present_class == '10' || $userData->present_class == '9'){
            $subDeptList1 = $subDeptList2 = $subDeptList3 = array();

            $studentPreferencesModel10 = new StudentPreferencesForm10();
            // Get student interested study stream
            $studentEducationDetail10 = StudentEducation::getStudentEducationDetails($userId, '10');
            if($studentEducationDetail10){
                $studentPreferencesModel10->interested_stream = $studentEducationDetail10->interested_stream;
                $studentPreferencesModel10->change_school = $studentEducationDetail10->change_school;
            }
            
            // Get countries list
            $studentPreferredCountries = StudentPreferredCountry::getStudentPreferredCountryDetails($userId);
            $counter = 1;
            foreach ($studentPreferredCountries as $studentPreferredCountry) {
                if ($counter <= 3) {
                    $studentPreferencesModel10->{countryPreference . $counter} = $studentPreferredCountry['country_ref_id'];
                    $counter++;
                }
                $studentPreferencesModel10->{countryPreferenceNotSure} = $studentPreferredCountry['not_sure'];
            }
            
            // get preferred career list
            $studentPreferredCareers = StudentPreferredCareer::getStudentPreferredCareerDetails($userId);
            $counter = 1;
            foreach ($studentPreferredCareers as $studentPreferredCareer) {
                if ($counter <= 3) {
                    $studentPreferencesModel10->{careerPreference . $counter} = $studentPreferredCareer['career_ref_id'];
                    $counter++;
                }
                $studentPreferencesModel10->{careerPreferenceNotSure} = $studentPreferredCareer['not_sure'];
            }
            // Get preferred subject list
            $studentPreferredSubjects = StudentPreferredSubject::getStudentPreferredSubjects($userId);
            $counter = 1;
            foreach ($studentPreferredSubjects as $studentPreferredSubject) {
                if ($counter <= 3) {
                    $studentPreferencesModel10->{subjectPreference . $counter} = $studentPreferredSubject['student_subject_ref_id'];
                    $counter++;
                }
                $studentPreferencesModel10->{subjectPreferenceNotSure} = $studentPreferredSubject['not_sure'];
            }

            // Get preferred Weak subject list
            $studentPreferredSubjects = StudentPreferredSubject::getStudentPreferredWeakSubjects($userId);
            $counter = 1;
            foreach ($studentPreferredSubjects as $studentPreferredSubject) {
                if ($counter <= 3) {
                    $studentPreferencesModel10->{weakSubjectPreference . $counter} = $studentPreferredSubject['student_subject_ref_id'];
                    $counter++;
                }
            }

            $studentPreferredDepartments = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($userId);
            $counter = 1;
            foreach ($studentPreferredDepartments as $studentPreferredDept) {
                $studentPreferencesModel10->{departmentPreferenceNotSure} = $studentPreferredDept['not_sure'];
                if ($counter <= 3) {
                    $studentPreferencesModel10->{departmentPreference . $counter} = $studentPreferredDept['main_dept_ref_id'];
                    $studentPreferencesModel10->{subDepartmentPreference . $counter} = $studentPreferredDept['sub_dept_ref_id'];

                    if ($counter == 1)
                        $deptId1 = $studentPreferredDept['main_dept_ref_id'];
                    if ($counter == 2)
                        $deptId2 = $studentPreferredDept['main_dept_ref_id'];
                    if ($counter == 3)
                        $deptId3 = $studentPreferredDept['main_dept_ref_id'];
                }
                $counter++;
            }

            // Get preferred likeley periods
            $studentPreferredLikelyPeriods = StudentPreferredPeriod::getStudentPreferredPeriods($userId);
            $counter = 1;
            foreach ($studentPreferredLikelyPeriods as $studentPreferredLikelyPeriod) {
                $studentPreferencesModel10->{likelyStartPeriod . $counter} = $studentPreferredLikelyPeriod['period_ref_id'];
                $studentPreferencesModel10->{likelyStartPeriodYear . $counter} = $studentPreferredLikelyPeriod['year'];
                $counter++;
            }

            $countryList = TblCountryMaster::getStudentInterestedCountryList();
            $countryList = CHtml::listData($countryList, 'country_id', 'country_name');

            $allCountryList = TblCountryMaster::getCountryList();
            $uniqueCountryList = array_diff($allCountryList, $countryList);
            $countryList['Others'] = $uniqueCountryList;

            $careerList = LookupCareer::getCareerList();
        
            $boardId = $userData->present_board_ref_id;
            $boardEquiValentData = LookupBoardEquivalent::GetSchoolBoardEquivalentId('10',$boardId);
            $subjectListData = LookupStudentSubject::getSubjectListByBoard($userData->present_board_ref_id);
            $subjectList = CHtml::listData($subjectListData, 'student_subject_id', 'subject_name');

            $likelyperiod = LookupLikelyPeriod::model()->findAll();
            $likelyperiod = CHtml::listData($likelyperiod, 'period_id', 'months');

            $userDetail = TblUserMaster::getUserDetails($userId);
            $likelyperiodYear = UniversityHelper::LikelyStartYearList($userDetail['passout_year']);
            $departmentList = LookupDepartment::getMainDepartmentList();


            $postData = Yii::app()->request->getParam('StudentPreferencesForm10');

            $deptId1 = $postData['departmentPreference1'] ? $postData['departmentPreference1'] : $deptId1;
            if ($deptId1) {
                $subDeptList1 = LookupDepartment::getSubDepartmentsList($deptId1);
                $subDeptList1 = CHtml::listData($subDeptList1, 'department_id', 'department_name');
            }

            $deptId2 = $postData['departmentPreference2'] ? $postData['departmentPreference2'] : $deptId2;
            if ($deptId2) {
                $subDeptList2 = LookupDepartment::getSubDepartmentsList($deptId2);
                $subDeptList2 = CHtml::listData($subDeptList2, 'department_id', 'department_name');
            }

            $deptId3 = $postData['departmentPreference3'] ? $postData['departmentPreference3'] : $deptId3;
            if ($deptId3) {
                $subDeptList3 = LookupDepartment::getSubDepartmentsList($deptId3);
                $subDeptList3 = CHtml::listData($subDeptList3, 'department_id', 'department_name');
            }

            if (isset($postData)) {
                $studentPreferencesModel10->attributes = $postData;
                if($studentPreferencesModel10->validate()){
                   // print_r($studentPreferencesModel10->getErrors());die;
                    
                    $studentEducationModel = StudentEducation::model()->find('user_ref_id='.$userId.' AND class_level="10"');
                    if($studentEducationModel){
                        $studentEducationModel->interested_stream = $studentPreferencesModel10->interested_stream;
                        $studentEducationModel->change_school = $studentPreferencesModel10->change_school;
                        $studentEducationModel->save(false);
                    }
                    // Saving preferred Country Section
                    $countryPreferenceObj = new StudentPreferredCountry();
                    $getListOfStudentPreferredCountries = StudentPreferredCountry::getStudentPreferredCountries($userId);
                    foreach ($getListOfStudentPreferredCountries as $key => $data) {
                        //var_dump($data);
                        if($data->not_sure){
                            $oldListOfPreferredCountries['not_sure'] = true;
                        }else{
                            $oldListOfPreferredCountries[$data->preference_order] = $data->country_ref_id;
                        }

                    }
                    
                    $countryPreferenceObj->deleteCountryPreferenceByUserId($userId);

                    if ($postData['countryPreference1']) {
                        $countryPreferenceObj->insertCountryPreferenceByUserId($userId, $postData['countryPreference1'], 1);
                        $newListOfPreferredCountries['1'] = $postData['countryPreference1'];
                    }

                    if ($postData['countryPreference2']) {
                        $countryPreferenceObj->insertCountryPreferenceByUserId($userId, $postData['countryPreference2'], 2);
                        $newListOfPreferredCountries['2'] = $postData['countryPreference2'];
                    }

                    if ($postData['countryPreference3']) {
                        $countryPreferenceObj->insertCountryPreferenceByUserId($userId, $postData['countryPreference3'], 3);
                        $newListOfPreferredCountries['3'] = $postData['countryPreference3'];
                    }

                    $flagCriticalCountry = 0;
                    if ($postData['countryPreference1'] || $postData['countryPreference2'] || $postData['countryPreference3'] || $studentPreferencesModel10->countryPreferenceNotSure) {
                        $flagCriticalCountry = 1;
                    }
                    
                    // Saving prefered career Section
                    $careerPreferenceObj = new StudentPreferredCareer();
                    $getListOfStudentPreferredCareers = StudentPreferredCareer::getStudentPreferredCareerDetails($userId);
                    foreach ($getListOfStudentPreferredCareers as $key => $data) {
                        $oldListOfPreferredCareers[$data->preference] = $data->career_ref_id;
                    }


                    if ($postData['careerPreference1']) {
                        $careerPreferenceObj->deleteCareerPreferenceByUserId($userId);
                        $careerPreferenceObj->insertCareerPreferenceByUserId($userId, $postData['careerPreference1'], 1);
                        $newListOfPreferredcareers['1'] = $postData['careerPreference1'];
                    }
                    if ($postData['careerPreference2']) {
                        $careerPreferenceObj->insertCareerPreferenceByUserId($userId, $postData['careerPreference2'], 2);
                        $newListOfPreferredcareers['2'] = $postData['careerPreference2'];
                    }
                    if ($postData['careerPreference3']) {
                        $careerPreferenceObj->insertCareerPreferenceByUserId($userId, $postData['careerPreference3'], 3);
                        $newListOfPreferredcareers['3'] = $postData['careerPreference3'];
                    }

                    $flagCriticalCareer = 0;
                    if ($postData['careerPreference1'] || $postData['careerPreference2'] || $postData['careerPreference3'] || $studentPreferencesModel10->careerPreferenceNotSure) {
                        $flagCriticalCareer = 1;
                    }


                    // Saving prefered Department Section
                    $departmentPreferenceObj = new StudentPreferredDepartment;
                    $getListOfStudentPreferredDepartments = StudentPreferredDepartment::getStudentPreferredDepartments($userId);
                    foreach ($getListOfStudentPreferredDepartments as $key => $data) {
                        $oldListOfPreferredDepartments[$data->preference_order] = $data->main_dept_ref_id;
                    }

                    if ($postData['departmentPreference1']) {
                        $departmentPreferenceObj->deleteDepartmentPreferenceByUserId($userId);

                        $subDeptId = $postData['subDepartmentPreference1'] ? $postData['subDepartmentPreference1'] : NULL;
                        $departmentPreferenceObj->insertDepartmentPreferenceByUserId($userId, $postData['departmentPreference1'], $subDeptId, 1);
                        $newListOfPreferredDepartments['1'] = $postData['departmentPreference1'];
                    }
                    if ($postData['departmentPreference2']) {
                        $subDeptId = $postData['subDepartmentPreference2'] ? $postData['subDepartmentPreference2'] : NULL;
                        $departmentPreferenceObj->insertDepartmentPreferenceByUserId($userId, $postData['departmentPreference2'], $subDeptId, 2);
                        $newListOfPreferredDepartments['2'] = $postData['departmentPreference2'];
                    }
                    if ($postData['departmentPreference3']) {
                        $subDeptId = $postData['subDepartmentPreference3'] ? $postData['subDepartmentPreference3'] : NULL;
                        $departmentPreferenceObj->insertDepartmentPreferenceByUserId($userId, $postData['departmentPreference3'], $subDeptId, 3);
                        $newListOfPreferredDepartments['3'] = $postData['departmentPreference3'];
                    }
                    $flagCriticalDepartment = 0;
                    if ($postData['departmentPreference1'] || $postData['departmentPreference2'] || $postData['departmentPreference3'] || $studentPreferencesModel10->departmentPreferenceNotSure) {
                        $flagCriticalDepartment = 1;
                    }

                    // Saving prefered subject Section
                    $subjectPreferenceObj = new StudentPreferredSubject();
                    $getListOfStudentPreferredSubjects = StudentPreferredSubject::getStudentPreferredSubjects($userId);
                    foreach ($getListOfStudentPreferredSubjects as $key => $data) {
                        $oldListOfPreferredSubjects[$data->preference] = $data->student_subject_ref_id;
                    }

                    // Saving Strong subjects
                    if ($postData['subjectPreference1']) {
                        $subjectPreferenceObj->deleteSubjectPreferenceByUserId($userId);
                        $subjectPreferenceObj->insertSubjectPreferenceByUserId($userId, $postData['subjectPreference1'], 1);
                        $newListOfPreferredSubjects['1'] = $postData['subjectPreference1'];
                    }
                    if ($postData['subjectPreference2']) {
                        $subjectPreferenceObj->insertSubjectPreferenceByUserId($userId, $postData['subjectPreference2'], 2);
                        $newListOfPreferredSubjects['2'] = $postData['subjectPreference2'];
                    }
                    if ($postData['subjectPreference3']) {
                        $subjectPreferenceObj->insertSubjectPreferenceByUserId($userId, $postData['subjectPreference3'], 3);
                        $newListOfPreferredSubjects['3'] = $postData['subjectPreference3'];
                    }

                    // Saving Weak subjects
                    if ($postData['weakSubjectPreference1'] || $postData['weakSubjectPreference2'] || $postData['weakSubjectPreference3']){
                        $subjectPreferenceObj->deleteWeakSubjectPreferenceByUserId($userId);
                    }
                    if ($postData['weakSubjectPreference1']) {
                        $subjectPreferenceObj->insertWeakSubjectPreferenceByUserId($userId, $postData['weakSubjectPreference1'], 1);
                        $newListOfPreferredSubjects['1'] = $postData['weakSubjectPreference1'];
                    }
                    if ($postData['weakSubjectPreference2']) {
                        $subjectPreferenceObj->insertWeakSubjectPreferenceByUserId($userId, $postData['weakSubjectPreference2'], 2);
                        $newListOfPreferredSubjects['2'] = $postData['weakSubjectPreference2'];
                    }
                    if ($postData['weakSubjectPreference3']) {
                        $subjectPreferenceObj->insertWeakSubjectPreferenceByUserId($userId, $postData['weakSubjectPreference3'], 3);
                        $newListOfPreferredSubjects['3'] = $postData['weakSubjectPreference3'];
                    }

                    $flagCriticalSubject = 0;
                    if ($postData['subjectPreference1'] || $postData['subjectPreference2'] || $postData['subjectPreference3'] || $studentPreferencesModel10->subjectPreferenceNotSure) {
                        $flagCriticalSubject = 1;
                    }

                    // Saving Preferred Period
                    $preferredPeriodObj = new StudentPreferredPeriod();
                    $preferredPeriodObj->deletePreferredPeriodByUserId($userId);

                    if ($postData['likelyStartPeriod1']) {
                        $preferredPeriodObj->insertPreferredPeriodByUserId($userId, $postData['likelyStartPeriod1'], $postData['likelyStartPeriodYear1']);
                    }

                    if ($postData['likelyStartPeriod2']) {
                        $preferredPeriodObj->insertPreferredPeriodByUserId($userId, $postData['likelyStartPeriod2'], $postData['likelyStartPeriodYear2']);
                    }

                    if ($postData['likelyStartPeriod3']) {
                        $preferredPeriodObj->insertPreferredPeriodByUserId($userId, $postData['likelyStartPeriod3'], $postData['likelyStartPeriodYear3']);
                    }

                    $flagCriticalLikelyStartPeriod = 0;
                    if ($postData['likelyStartPeriod1'] || $postData['likelyStartPeriod2'] || $postData['likelyStartPeriod3']) {
                        $flagCriticalLikelyStartPeriod = 1;
                    }

                    $flagForPreferenceChange = false;
                    for ($i = 1; $i <= 3; $i++) {
                        if ($oldListOfPreferredCountries[$i] != $newListOfPreferredCountries[$i] || $oldListOfPreferredCareers[$i] != $newListOfPreferredcareers[$i] || $oldListOfPreferredSubjects[$i] != $newListOfPreferredSubjects[$i]) {
                            $flagForPreferenceChange = true;
                        }
                    }
                    
                    $getUserData = TblUserMaster::getUserDetails($userId);
                    if ($flagForPreferenceChange) {

                        if ($this->rbacRole == 'Student' || $this->rbacRole == 'SI') {
                            //$tblLoginMaster->is_preference_confirmed = 0;
                        } else {
                            LoginMaster::updateProfileValidationField($getUserData->login_ref_id, 'is_preference_confirmed', 1, $userId);
                        }
                       
                    }
                    //$getUserData = TblUserMaster::getUserDetails($userId);
                    if(Yii::app()->session->itemAt('studentProfileConfirmationId')){
                        LoginMaster::updateProfileValidationField($getUserData->login_ref_id, 'is_preference_confirmed', 1, $userId);
                    }
                    $tblUserMasterModel = TblUserMaster::model()->find('user_id=' . $userId);
                    $tblUserMasterModel->modified_on = date('Y-m-d H:i:s');
                    $tblUserMasterModel->save(false);
                    $criticalFields = array(
                        'country' => $flagCriticalCountry,
                    );
                    TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);				

                    $shortList = new ShortListEngine();
                    $shortList->profileUpdated();
                    setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'preferences information'));
                    CommonUtils::calculateCriticalPercentage($userId);
                    $this->redirect(Yii::app()->createUrl('student/profile/editCurricularActivities', $this->userParams));

                }
                
            }

            $milesRes = UserMilestone::getUserConfirmedMilestoneDetails($userId);
            $isFinalise = 0;
            foreach($milesRes as $res)
            {
                if($res->milestone_id == 2 && $res->status == 'Confirmed')
                {
                    $isFinalise = 1;
                }
            }
            $this->render('preferences10', array(
                'studentPreferencesModel' => $studentPreferencesModel10,
                'countryList' => $countryList,
                'careerList' => $careerList,
                'subjectList' => $subjectList,
                'customError' => $customError,
                'likelyperiod' => $likelyperiod,
                'likelyperiodYear' => $likelyperiodYear,
                'departmentList' => $departmentList,
                'subDeptList1' => $subDeptList1,
                'subDeptList2' => $subDeptList2,
                'subDeptList3' => $subDeptList3,
                'isFinalise' => $isFinalise,
            ));
        }else{
        
        $subDeptList1 = $subDeptList2 = $subDeptList3 = array();

        $studentPreferencesModel = new StudentPreferencesForm();

        
        $studentPreferredCountries = StudentPreferredCountry::getStudentPreferredCountryDetails($userId);
        $counter = 1;
        foreach ($studentPreferredCountries as $studentPreferredCountry) {
            if ($counter <= 3) {
                $studentPreferencesModel->{countryPreference . $counter} = $studentPreferredCountry['country_ref_id'];
                $counter++;
            }
            $studentPreferencesModel->{countryPreferenceNotSure} = $studentPreferredCountry['not_sure'];
        }

        $studentPreferredDepartments = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($userId);
        $counter = 1;
        foreach ($studentPreferredDepartments as $studentPreferredDept) {
            $studentPreferencesModel->{departmentPreferenceNotSure} = $studentPreferredDept['not_sure'];
            if ($counter <= 3) {
                $studentPreferencesModel->{departmentPreference . $counter} = $studentPreferredDept['main_dept_ref_id'];
                $studentPreferencesModel->{subDepartmentPreference . $counter} = $studentPreferredDept['sub_dept_ref_id'];

                if ($counter == 1)
                    $deptId1 = $studentPreferredDept['main_dept_ref_id'];
                if ($counter == 2)
                    $deptId2 = $studentPreferredDept['main_dept_ref_id'];
                if ($counter == 3)
                    $deptId3 = $studentPreferredDept['main_dept_ref_id'];
            }
            $counter++;
        }

        $studentPreferredStudyLevel = StudentPreferredStudyLevel::getStudyLevelsByUserId($userId);
        //$levelIds = LookupCourseLevel::getParentIdByLevelId($studentPreferredStudyLevel->course_level_ref_id);

        $counter = 1;
        foreach ($studentPreferredStudyLevel as $data) {
            $studentPreferencesModel->{levelOfStudy . $counter} = $data->course_level_ref_id;
            $studentPreferencesModel->{levelOfStudyId . $counter} = $data->preferred_study_level_id;
            $counter++;
        }

        $studentPreferredLikelyPeriods = StudentPreferredPeriod::getStudentPreferredPeriods($userId);
        $counter = 1;
        foreach ($studentPreferredLikelyPeriods as $studentPreferredLikelyPeriod) {
            $studentPreferencesModel->{likelyStartPeriod . $counter} = $studentPreferredLikelyPeriod['period_ref_id'];
            $studentPreferencesModel->{likelyStartPeriodYear . $counter} = $studentPreferredLikelyPeriod['year'];
            $counter++;
        }

        $studentStudyDurations = StudentPreferredDuration::getStudentStudyDuration($userId);
        $counter = 1;
        foreach ($studentStudyDurations as $studentStudyDuration) {
            $studentPreferencesModel->{studyDuration . $counter} = $studentStudyDuration->duration_ref_id;
            $studentPreferencesModel->{studyDurationId . $counter} = $studentStudyDuration->preferred_duration_id;
            $counter++;
        }


        $studyLevel = LookupCourseLevel::getParentCourseLevel(array(14));
        $studyLevel = CHtml::listData($studyLevel, 'level_id', 'course_level');

        $countryList = TblCountryMaster::getStudentInterestedCountryList();
        $countryList = CHtml::listData($countryList, 'country_id', 'country_name');

        $allCountryList = TblCountryMaster::getCountryList();
        $uniqueCountryList = array_diff($allCountryList, $countryList);
        $countryList['Others'] = $uniqueCountryList;
        
        $departmentList = LookupDepartment::getMainDepartmentList();

        $likelyperiod = LookupLikelyPeriod::model()->findAll();
        $likelyperiod = CHtml::listData($likelyperiod, 'period_id', 'months');

        $userDetail = TblUserMaster::getUserDetails($userId);
        $likelyperiodYear = UniversityHelper::LikelyStartYearList($userDetail['passout_year']);
        $studyDuration = LookupDuration::getDurations();
        $studyDuration = CHtml::listData($studyDuration, 'duration_id', 'name');


        $postData = Yii::app()->request->getParam('StudentPreferencesForm');

        $deptId1 = $postData['departmentPreference1'] ? $postData['departmentPreference1'] : $deptId1;
        if ($deptId1) {
            $subDeptList1 = LookupDepartment::getSubDepartmentsList($deptId1);
            $subDeptList1 = CHtml::listData($subDeptList1, 'department_id', 'department_name');
        }

        $deptId2 = $postData['departmentPreference2'] ? $postData['departmentPreference2'] : $deptId2;
        if ($deptId2) {
            $subDeptList2 = LookupDepartment::getSubDepartmentsList($deptId2);
            $subDeptList2 = CHtml::listData($subDeptList2, 'department_id', 'department_name');
        }

        $deptId3 = $postData['departmentPreference3'] ? $postData['departmentPreference3'] : $deptId3;
        if ($deptId3) {
            $subDeptList3 = LookupDepartment::getSubDepartmentsList($deptId3);
            $subDeptList3 = CHtml::listData($subDeptList3, 'department_id', 'department_name');
        }

        if (isset($_POST['StudentPreferencesForm'])) {
            $studentPreferencesModel->attributes = $postData;

            if ($studentPreferencesModel->validate()) {

                // Saving preferred Country Section
                $countryPreferenceObj = new StudentPreferredCountry();
                $getListOfStudentPreferredCountries = StudentPreferredCountry::getStudentPreferredCountries($userId);
                foreach ($getListOfStudentPreferredCountries as $key => $data) {
                    //var_dump($data);
                    if($data->not_sure){
                        $oldListOfPreferredCountries['not_sure'] = true;
                    }else{
                        $oldListOfPreferredCountries[$data->preference_order] = $data->country_ref_id;
                    }

                }

                if($postData['countryPreference1'] != ''){
                    $countryPreferenceObj->deleteCountryPreferenceByUserId($userId);
                }


                if ($postData['countryPreference1']) {
                    $countryPreferenceObj->insertCountryPreferenceByUserId($userId, $postData['countryPreference1'], 1);
                    $newListOfPreferredCountries['1'] = $postData['countryPreference1'];
                }

                if ($postData['countryPreference2']) {
                    $countryPreferenceObj->insertCountryPreferenceByUserId($userId, $postData['countryPreference2'], 2);
                    $newListOfPreferredCountries['2'] = $postData['countryPreference2'];
                }

                if ($postData['countryPreference3']) {
                    $countryPreferenceObj->insertCountryPreferenceByUserId($userId, $postData['countryPreference3'], 3);
                    $newListOfPreferredCountries['3'] = $postData['countryPreference3'];
                }

                $flagCriticalCountry = 0;
                if ($postData['countryPreference1'] || $postData['countryPreference2'] || $postData['countryPreference3'] || $studentPreferencesModel->countryPreferenceNotSure) {
                    $flagCriticalCountry = 1;
                }

                // Saving prefered Department Section
                $departmentPreferenceObj = new StudentPreferredDepartment;
                $getListOfStudentPreferredDepartments = StudentPreferredDepartment::getStudentPreferredDepartments($userId);
                foreach ($getListOfStudentPreferredDepartments as $key => $data) {
                    $oldListOfPreferredDepartments[$data->preference_order] = $data->main_dept_ref_id;
                }


                if ($postData['departmentPreference1']) {
                    $departmentPreferenceObj->deleteDepartmentPreferenceByUserId($userId);

                    $subDeptId = $postData['subDepartmentPreference1'] ? $postData['subDepartmentPreference1'] : NULL;
                    $departmentPreferenceObj->insertDepartmentPreferenceByUserId($userId, $postData['departmentPreference1'], $subDeptId, 1);
                    $newListOfPreferredDepartments['1'] = $postData['departmentPreference1'];
                }
                if ($postData['departmentPreference2']) {
                    $subDeptId = $postData['subDepartmentPreference2'] ? $postData['subDepartmentPreference2'] : NULL;
                    $departmentPreferenceObj->insertDepartmentPreferenceByUserId($userId, $postData['departmentPreference2'], $subDeptId, 2);
                    $newListOfPreferredDepartments['2'] = $postData['departmentPreference2'];
                }
                if ($postData['departmentPreference3']) {
                    $subDeptId = $postData['subDepartmentPreference3'] ? $postData['subDepartmentPreference3'] : NULL;
                    $departmentPreferenceObj->insertDepartmentPreferenceByUserId($userId, $postData['departmentPreference3'], $subDeptId, 3);
                    $newListOfPreferredDepartments['3'] = $postData['departmentPreference3'];
                }

                $flagCriticalDepartment = 0;
                if ($postData['departmentPreference1'] || $postData['departmentPreference2'] || $postData['departmentPreference3'] || $studentPreferencesModel->departmentPreferenceNotSure) {
                    $flagCriticalDepartment = 1;
                }
                $flagForPreferenceChange = false;
                for ($i = 1; $i <= 3; $i++) {
                    if ($oldListOfPreferredCountries[$i] != $newListOfPreferredCountries[$i] || $oldListOfPreferredDepartments[$i] != $newListOfPreferredDepartments[$i]) {
                        $flagForPreferenceChange = true;
                    }
                }

                $getUserData = TblUserMaster::getUserDetails($userId);
                if ($flagForPreferenceChange) {

                    if ($this->rbacRole == 'Student' || $this->rbacRole == 'SI') {
                        //$tblLoginMaster->is_preference_confirmed = 0;
                    } else {
                        LoginMaster::updateProfileValidationField($getUserData->login_ref_id, 'is_preference_confirmed', 1, $userId);
                    }
                    /*$tblLoginMaster = LoginMaster::model()->findByPk($getUserData->login_ref_id);
                    if ($this->rbacRole == 'Student') {
                        $tblLoginMaster->is_preference_confirmed = 0;
                    } else {
                        $tblLoginMaster->is_preference_confirmed = 1;
                    }
                    $tblLoginMaster->modified_on = date('Y-m-d H:i:s');
                    $tblLoginMaster->save(false);
                    StudentProfileValidationLog::saveLogData($userId, 'Preference', $tblLoginMaster->is_preference_confirmed, $loginId);*/
                }
                //$getUserData = TblUserMaster::getUserDetails($userId);
                if(Yii::app()->session->itemAt('studentProfileConfirmationId')){
                    LoginMaster::updateProfileValidationField($getUserData->login_ref_id, 'is_preference_confirmed', 1, $userId);
                }

                // Saving Preferred Period
                $preferredPeriodObj = new StudentPreferredPeriod();
                $preferredPeriodObj->deletePreferredPeriodByUserId($userId);

                if ($postData['likelyStartPeriod1']) {
                    $preferredPeriodObj->insertPreferredPeriodByUserId($userId, $postData['likelyStartPeriod1'], $postData['likelyStartPeriodYear1']);
                }

                if ($postData['likelyStartPeriod2']) {
                    $preferredPeriodObj->insertPreferredPeriodByUserId($userId, $postData['likelyStartPeriod2'], $postData['likelyStartPeriodYear2']);
                }

                if ($postData['likelyStartPeriod3']) {
                    $preferredPeriodObj->insertPreferredPeriodByUserId($userId, $postData['likelyStartPeriod3'], $postData['likelyStartPeriodYear3']);
                }

                $flagCriticalLikelyStartPeriod = 0;
                if ($postData['likelyStartPeriod1'] || $postData['likelyStartPeriod2'] || $postData['likelyStartPeriod3']) {
                    $flagCriticalLikelyStartPeriod = 1;
                }

                $preferredStudyLevelObj = new StudentPreferredStudyLevel();
                $preferredStudyLevelObj->deletePreferredStudyLevelUserId($userId);

                if ($postData['levelOfStudy1']) {
                    $preferredStudyLevelObj->insertPreferredStudyLevelByUserId($userId, $postData['levelOfStudy1']);
                }

                if ($postData['levelOfStudy2']) {
                    $preferredStudyLevelObj->insertPreferredStudyLevelByUserId($userId, $postData['levelOfStudy2']);
                }

                $flagCriticalStudyLevel = 0;
                if ($postData['levelOfStudy1'] || $postData['levelOfStudy2']) {
                    $flagCriticalStudyLevel = 1;
                }

                $studyDurationObj = new StudentPreferredDuration();
                $studyDurationObj->deleteStudyDurationByUserId($userId);

                if ($postData['studyDuration1']) {
                    $studyDurationObj->insertStudyDurationByUserId($userId, $postData['studyDuration1']);
                }

                if ($postData['studyDuration2']) {
                    $studyDurationObj->insertStudyDurationByUserId($userId, $postData['studyDuration2']);
                }

                $flagCriticalStudyDuration = 0;
                if ($postData['studyDuration1'] || $postData['studyDuration2']) {
                    $flagCriticalStudyDuration = 1;
                }
                $tblUserMasterModel = TblUserMaster::model()->find('user_id=' . $userId);
                $tblUserMasterModel->modified_on = date('Y-m-d H:i:s');
                $tblUserMasterModel->save(false);
                $criticalFields = array(
                    'country' => $flagCriticalCountry,
                    'intended_subjects' => $flagCriticalDepartment,
                    'likely_start_period' => $flagCriticalLikelyStartPeriod,
                    'study_level' => $flagCriticalStudyLevel,
                    'preferred_course_duration' => $flagCriticalStudyLevel
                );
                TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);	
				
				$verify_score = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$userId));
				if(((($verify_score->pref_dept == 0) ||($verify_score->pref_dept_score == 0)) && $verify_score->profile_verification_score_id )  && $verify_score->profile_verification_score_id)
				{
					$verify_score->pref_dept = 1;
                    $verify_score->pref_dept_date = date('Y-m-d H:i:s');
					$verify_score->pref_dept_score = 1;
					$verify_score->pref_dept_score_date = date('Y-m-d H:i:s');
					$verify_score->save(false);
				}
				
				if (((($verify_score->pref_country == 0) ||($verify_score->pref_country_score == 0)) && $verify_score->profile_verification_score_id )  && $verify_score->profile_verification_score_id)
					{
						$verify_score->pref_country = 1;
						$verify_score->pref_country_date = date('Y-m-d H:i:s');
						$verify_score->pref_country_score = 1;
						$verify_score->pref_country_score_date = date('Y-m-d H:i:s');
						$verify_score->save(false);
					}
				Yii::import('application.components.profilevalidation.*');		
				$conditions_obj = new Conditions();
				$conditions_obj->userId = $userId;
				if($verify_score->profile_score == 0  && $verify_score->profile_verification_score_id){
					$verify_score->profile_score = $conditions_obj->validateProfileCompletion();
					$verify_score->profile_score_date =  date('Y-m-d H:i:s');
					$verify_score->save(false);
				}
				
				$validate = new ValidateStudent();
				$user = TblUserMaster::model()->findByPk($userId);
				$validate->validate_after_confirmation($verify_score->profile_verification_score_id, $user);				
                $shortList = new ShortListEngine();
                $shortList->profileUpdated();
                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'preferences information'));
                CommonUtils::calculateCriticalPercentage($userId);
                $this->redirect(Yii::app()->createUrl('student/profile/editCurricularActivities', $this->userParams));
            }
        }

        $this->render('preferences', array(
            'studentPreferencesModel' => $studentPreferencesModel,
            'studyLevel' => $studyLevel,
            'studyDuration' => $studyDuration,
            'countryList' => $countryList,
            'departmentList' => $departmentList,
            'likelyperiod' => $likelyperiod,
            'likelyperiodYear' => $likelyperiodYear,
            'subDeptList1' => $subDeptList1,
            'subDeptList2' => $subDeptList2,
            'subDeptList3' => $subDeptList3,
            'customError' => $customError,
        ));
        }
    }

    public function actionGetSubDeptList() {
        $deptId = Yii::app()->request->getParam('deptId');
        echo CHtml::tag('option', array('value' => ''), CHtml::encode('CHOOSE DEPARTMENT'), true);
        $modelSubDept = LookupDepartment::getSubDepartmentsList($deptId);
        $subDeptList = CHtml::listData($modelSubDept, 'department_id', 'department_name');
        foreach ($subDeptList as $key => $value) {
            echo CHtml::tag('option', array('value' => $key), CHtml::encode($value), true);
        }
    }

    public function actionEditCurricularActivities() {
       /* if ($this->rbacRole == 'Student') {
            $this->breadcrumbs = array(
                'Home' => array('/home'),
                'My Profile' => array('/student/profile'),
                'Edit Extra Curricular',
            );
        }

        if($this->rbacRole != 'Student' && $this->rbacRole != 'DI'){
            $studentName = implode(' ', array($this->userData->first_name, $this->userData->last_name));
            $this->breadcrumbs=array(
                'Home'=>array('/../mainadmin/admin_home.php'),
                (($studentName == ' ')? 'Unknown' : $studentName) => array('/student/profile/index/uid/'.$this->userId),
                'Edit Extra Curricular',
            );
        }*/

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->pageTitle = Yii::app()->name . ' -  Extra Curricular';
        $loginId = Yii::app()->user->id;
        $userId = $this->userId;
        $interestData = LookupUserInterest::model()->findAll();
        foreach ($interestData as $key => $data) {
            $interestArray[$data->user_interest_id]['name'] = $data->interest;
            $interestArray[$data->user_interest_id]['id'] = $data->user_interest_id;
        }
        $tblUserMasterModel = TblUserMaster::model()->find('user_id=' . $userId);
        if (!count($_POST)) {

            foreach ($interestData as $key => $data) {
                $userInterestData = TblUserInterest::getUserInterestsByInterestId($userId, $data->user_interest_id);
                foreach ($userInterestData as $k => $value) {
                    $models[$data->user_interest_id][$k + 1] = new StudentCurricular();
                    $models[$data->user_interest_id][$k + 1]->attributes = $value->attributes;
                }
                if ($models[$data->user_interest_id]) {
                    $models[$data->user_interest_id][$k + 2] = new StudentCurricular();
                } else {
                    $models[$data->user_interest_id][1] = new StudentCurricular();
                }
            }
        } else {


            $errorCounter = false;

            $studentCurricularPostData = Yii::app()->request->getPost('StudentCurricular');
            $userMasterData = Yii::app()->request->getPost('TblUserMaster');



            foreach ($studentCurricularPostData as $key => $data) {

                foreach ($data as $k => $value) {
                    $models[$key][$k] = new StudentCurricular();
                    $models[$key][$k]->attributes = $value;
                }
            }
            foreach ($models as $key => $data) {
                $interestTypeArray = array();
                foreach ($data as $k => $value) {
                    if ($models[$key][$k]->user_interest_type_ref_id != '') {
                        if (in_array($models[$key][$k]->user_interest_type_ref_id, $interestTypeArray)) {
                            $errorCounter = true;
                            $models[$key][$k]->addError('user_interest_type_ref_id', '<div class="holder"><p>You selected the same interest again.Please change</p></div>');
                        } else {
                            $interestTypeArray[] = $models[$key][$k]->user_interest_type_ref_id;
                        }
                    }
                }
            }


            $tblUserMasterModel->ps_leadership = substr($userMasterData['ps_leadership'], 0, 2000);
            $tblUserMasterModel->other_activities = substr($userMasterData['other_activities'], 0, 2000);

            if(strlen($tblUserMasterModel->ps_leadership) && trim($tblUserMasterModel->ps_leadership)==''){
                $errorCounter = true;
                $tblUserMasterModel->addError('ps_leadership', '<div class="holder"><p>Enter valid text.</p></div>');
            }

            if(strlen($tblUserMasterModel->other_activities) && trim($tblUserMasterModel->other_activities)==''){
                $errorCounter = true;
                $tblUserMasterModel->addError('other_activities', '<div class="holder"><p>Enter valid text.</p></div>');
            }



         if (!$errorCounter){
                $tblUserMasterModel->modified_on = date('Y-m-d H:i:s');
                $tblUserMasterModel->save(false);

                TblUserInterest::model()->deleteAll('user_ref_id=' . $userId);
                foreach ($models as $key => $data) {
                    foreach ($data as $k => $value) {
                        if ($models[$key][$k]->user_interest_type_ref_id != '') {
                            $tblUserInterest = new TblUserInterest();
                            $tblUserInterest->attributes = $models[$key][$k]->attributes;
                            $tblUserInterest->user_ref_id = $userId;
                            $tblUserInterest->user_interest_ref_id = $key;
                            $tblUserInterest->save();
                        }
                    }
                }
                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'extra curricular information'));
                $this->redirect(Yii::app()->createUrl('student/profile', $this->userParams));
           }
        }


        $this->render('extraCurricular', array('interestData' => $interestData, 'models' => $models, 'interestArray' => $interestArray, 'tblUserMasterModel' => $tblUserMasterModel, 'customError' => $customError));
    }

    public function actionDeleteInterest() {
        $userId = $this->userId;
        $id = Yii::app()->request->getPost('id');
        $count = TblUserInterest::model()->deleteByPk($id, 'user_ref_id=' . $userId);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteStudyLevel() {
        $userId = $this->userId;
        $id = Yii::app()->request->getPost('id');
        $count = StudentPreferredStudyLevel::model()->deleteByPk($id, 'user_ref_id=' . $userId);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteCitizenship() {
        $userId = $this->userId;
        $id = Yii::app()->request->getPost('id');
        $count = StudentCitizenship::model()->deleteByPk($id, 'user_ref_id=' . $userId);
        echo $count;
        Yii::app()->end();
    }

    public function actionDeleteStudyDuration() {
        $userId = $this->userId;
        $id = Yii::app()->request->getPost('id');
        $count = StudentPreferredDuration::model()->deleteByPk($id, 'user_ref_id=' . $userId);
        echo $count;
        Yii::app()->end();
    }  
    
    public function actionDeleteParentInfo() {
        $userId = $this->userId;
        $getUserData = TblUserMaster::getUserDetails($userId);
        $id = Yii::app()->request->getPost('id');
        $count1 = StudentAlternateEmail::deleteAlternateEmail($getUserData->login_ref_id, $id);
        echo $count1;
        $count2 = StudentContactNumber::deleteContactNumbers($userId, $id);
        echo $count2;
        $userMasterModel = TblUserMaster::model()->findByPk($userId);
        if ($id == 2) {
            $userMasterModel->father_first_name = NULL;
            $userMasterModel->father_last_name = NULL;
        } elseif ($id == 3) {
            $userMasterModel->mother_first_name = NULL;
            $userMasterModel->mother_last_name = NULL;
            ;
        } elseif ($id == 4) {
            $userMasterModel->guardian_first_name = NULL;
            $userMasterModel->guardian_last_name = NULL;
            ;
        }
        $userMasterModel->save(false);
        Yii::app()->end();
    }

//    This is migrated with notes on profile page
    
//    public function actionNotes(){
//        $studentNotesModel = new StudentEditProfile('note');
//        $this->performAjaxValidation($studentNotesModel);
//
//        $userId = Yii::app()->request->getParam('uid');
//        $userDataPoints = UserDataPoint::getUserDataPoints($userId);
//        $this->renderPartial('notes', array('model' => $studentNotesModel, 'userDataPoints' => $userDataPoints));//, false, true
//    }
//
//    public function actionSaveNotes(){
//
//        //$adminId = CommonUtils::getSessionValue('sAdminUnivarietyContent', 'adminId');
//        $loginId = Yii::app()->user->id;
//        $userId = Yii::app()->request->getParam('uid');
//
//        if (isset($_POST['StudentEditProfile'])) {
//            $post = $_POST['StudentEditProfile'];
//            $attributes = array('user_ref_id' => $userId, 'added_by' => $loginId, 'comments' => CHtml::encode($post['note']), 'added_on' => date('Y-m-d H:i:s'));
//            UserDataPoint::addUserDataPoint($attributes);
//        }
//        $userDataPoints = UserDataPoint::getUserDataPoints($userId);
//        $this->renderPartial('_notes_list', array('userDataPoints' => $userDataPoints));
//    }
    
    public function actionGetTenthYearList(){
        $year = Yii::app()->request->getPost('year');
        $yearList10 = UniversityHelper::complitionYearList('10', $year);
        echo json_encode($yearList10);
        Yii::app()->end();
    }    

    public function actionGetTestYearOfAppear() {
        $testStatus = Yii::app()->request->getParam('testStatus');
        $testYearList = UniversityHelper::testYearList($testStatus);
        echo json_encode($testYearList);
        Yii::app()->end();
    }

    public function actionMilestones() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        
         if ($this->rbacRole == 'Student') {
             $this->redirect(Yii::app()->createUrl('student/profile/index'));
         }
        
       $studentName = implode(' ', array($this->userData->first_name, $this->userData->last_name));

        $this->pageTitle = Yii::app()->name .' - '.$studentName . ' - ' . 'Milestones';

        $userId = Yii::app()->request->getParam('uid');

        $userData = TblUserMaster::getUserDetails($userId);
        $milestoneCats = LookupMilestone::getMileStoneCategories($userData->present_class);
        $criteria = new CDbCriteria();
        $criteria->addCondition("t.user_ref_id='".$userData->user_id."'", "AND");
        $criteria->addInCondition("t.milestone_ref_id", array_keys($milestoneCats), "AND");
        $userMilestoneModel = UserMilestoneTracking::model()->findAll($criteria);
        $userMilestone = array();
        foreach($userMilestoneModel as $Data){
            $userMilestone[$Data->milestone_ref_id] = $Data;
        }

        $this->render('milestones', array('userMilestone' => $userMilestone, 'milestoneCats'=>$milestoneCats));
    }

    public function actionCaNotes() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        
        if ($this->rbacRole == 'Student') {
             $this->redirect(Yii::app()->createUrl('student/profile/index'));
         }
        
        $studentName = implode(' ', array($this->userData->first_name, $this->userData->last_name));
/*        $this->breadcrumbs=array(
            //'Home'=>array('/../mainadmin/admin_home.php'),
            (($studentName == ' ')? 'Unknown' : $studentName) => array('/student/profile/index/uid/'.$this->userId),
            'Notes',
        );*/


        
        $this->pageTitle = Yii::app()->name .' - '.$studentName . ' - ' . 'Notes';

        $userId = Yii::app()->request->getParam('uid');

        if ($this->rbacRole == 'SI') {
            $instId = CommonUtils::getSessionValue('sPartnersSlug', 'instituteID');
            $userDataPoints = UserDataPoint::getUserDataPointsForCSSAdvisor($userId, $instId);
        } else {
            $userDataPoints = UserDataPoint::getUserDataPointsForCSSAdvisor($userId);
        }
        $this->render('canotes', array('userDataPoints' => $userDataPoints) );
    }
    
    public function actionCreateNotes() {
        $this->renderPartial("createnote", array(), false, true);
    }
    
    public function actionDeleteNotes() {

      

        $loginId = Yii::app()->user->id;
        $userId = Yii::app()->request->getParam('uid');
        $notesId = Yii::app()->request->getParam('nId');
        if($userId && $notesId && $loginId) {
            UserDataPoint::model()->deleteByPk($notesId,'user_ref_id = '.$userId);
        }
    }

    public function actionAddNotes() {


        $userId = Yii::app()->request->getParam('uid');
        $loginId = Yii::app()->user->id;
        
        if($userId && $loginId) {
            if (isset($_POST['StudentEditProfile'])) {
                $post = $_POST['StudentEditProfile'];
                $attributes = array('user_ref_id' => $userId, 'added_by' => $loginId, 'comments' => CHtml::encode($post['note']), 'added_on' => date('Y-m-d H:i:s'));
                UserDataPoint::addUserDataPoint($attributes);
                setFlashMessage('success_notify', 'globalnotifications.NotesAdded');
            }
        }
    }
    
    public function actionEditNotes() {
        $loginId = Yii::app()->user->id;
        $userId = Yii::app()->request->getParam('uid');
        $notesId = Yii::app()->request->getParam('nId');

        if($notesId && $loginId) {
            if (isset($_POST['StudentEditProfile'])) {
                $post = $_POST['StudentEditProfile'];
                UserDataPoint::model()->updateAll(array('comments' => CHtml::encode($post['note'])), 'user_data_point_id = '. $notesId .' AND user_ref_id = '.$userId);
                echo UniversityHelper::chopString($post['note'],50);
            }
        }
    }

    public function actionCreateReminder(){

    

        $userId = Yii::app()->request->getParam('uid');
        
        if ($this->rbacRole == 'SI') {
            $loginId = Yii::app()->user->id;
            $instId = CommonUtils::getSessionValue('sPartnersSlug', 'instituteID');
            $siList = TblAdmin::getSiAllAdminDetails($instId);
            $siList = CHtml::listData($siList, 'login_ref_id', 'admin_name');
            //$userReminders = UserProfileReminder::getReminderForCSSAdvisor($userId, $loginId, $instId);
        } else {
            if($this->userData->membership_ref_id) {
                $siList = TblAdmin::getAllCssAdvisorAdmin(84);
                $siList = CHtml::listData($siList, 'login_ref_id', 'admin_name');
            } else {
                $siList = TblAdmin::getAllCssAdvisorAdmin();
                $siList = CHtml::listData($siList, 'login_ref_id', 'admin_name');
            }
            //$userReminders = UserProfileReminder::getReminderForCSSAdvisor($userId, $loginId);
        }

        $this->renderPartial("addnewreminder", array('siList' => $siList), false, true);
    }
    
    public function actionReminders() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        
         if ($this->rbacRole == 'Student') {
             $this->redirect(Yii::app()->createUrl('student/profile/index'));
         }
        
        $studentName = implode(' ', array($this->userData->first_name, $this->userData->last_name));
/*        $this->breadcrumbs=array(
            //'Home'=>array('/../mainadmin/admin_home.php'),
            (($studentName == ' ')? 'Unknown' : $studentName) => array('/student/profile/index/uid/'.$this->userId),
            'Reminders',
        );*/
        
        $this->pageTitle = Yii::app()->name .' - '.$studentName . ' - ' . 'Reminders';

        $userId = Yii::app()->request->getParam('uid');

        $loginId = Yii::app()->user->id;
        $userReminders = $siList = array();
        if ($this->rbacRole == 'SI') {
            $instId = CommonUtils::getSessionValue('sPartnersSlug', 'instituteID');
            $siList = TblAdmin::getSiAllAdminDetails($instId);
            $siList = CHtml::listData($siList, 'login_ref_id', 'admin_name');
            $userReminders = UserProfileReminder::getReminderForCSSAdvisor($userId, $loginId, $instId);
        } else {
            if($this->userData->membership_ref_id) {
                $siList = TblAdmin::getAllCssAdvisorAdmin(84);
                $siList = CHtml::listData($siList, 'login_ref_id', 'admin_name');
            } else {
                $siList = TblAdmin::getAllCssAdvisorAdmin();
                $siList = CHtml::listData($siList, 'login_ref_id', 'admin_name');
            }

            $userReminders = UserProfileReminder::getReminderForCSSAdvisor($userId, $loginId);
        }
        $this->render('reminders', array('userReminders' => $userReminders, 'siList' => $siList));
    }

    public function actionDeleteReminders() {

        $loginId = Yii::app()->user->id;
        $userId = Yii::app()->request->getParam('uid');
        $reminderId = Yii::app()->request->getParam('rId');
        if($userId && $reminderId && $loginId) {
            UserProfileReminder::model()->deleteByPk($reminderId,'user_ref_id = '.$userId);
        }
    }

    public function actionEditReminders() {

 

        $loginId = Yii::app()->user->id;
        $userId = Yii::app()->request->getParam('uid');
        $reminderId = Yii::app()->request->getParam('rId');

        if($reminderId && $loginId) {
            if (isset($_POST['UserReminder'])) {
                $post = $_POST['UserReminder'];
                UserProfileReminder::model()->updateAll(
                            array(
                                'reminder_text' => CHtml::encode($post['reminder']),
                                'subject' => CHtml::encode($post['subject']),
                                'assigned_to' => $post['assigned_to'],
                                'remind_date' => $post['remind_date'],
                                'remind_time' => $post['remind_time'],
                                ), 
                                'reminder_id = '. $reminderId .' AND user_ref_id = '.$userId);
            }
        }
    }
    public function actionAddReminders() {

    

        $userId = Yii::app()->request->getParam('uid');
        $loginId = Yii::app()->user->id;
        if($userId && $loginId) {
            if (isset($_POST['UserReminder'])) {
                $post = $_POST['UserReminder'];
                $attributes = array(
                        'user_ref_id' => $userId, 
                        'added_by' => $loginId, 
                        'subject' => CHtml::encode($post['subject']), 
                        'reminder_text' => CHtml::encode($post['reminder']), 
                        'assigned_to' => $post['assigned_to'], 
                        'remind_date' => $post['remind_date'],
                        'remind_time' => $post['remind_time'],
                        'added_on' => date('Y-m-d H:i:s')
                    );
                    UserProfileReminder::addUserReminder($attributes);
                    setFlashMessage('success_notify', 'globalnotifications.ReminderAdded');
            }
        }
    }

    public function actionMonetization() {


       Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        
         if ($this->rbacRole == 'Student') {
             $this->redirect(Yii::app()->createUrl('student/profile/index'));
         }
        
        $studentName = implode(' ', array($this->userData->first_name, $this->userData->last_name));
        $this->breadcrumbs=array(
            //'Home'=>array('/../mainadmin/admin_home.php'),
            (($studentName == ' ')? 'Unknown' : $studentName) => array('/student/profile/index/uid/'.$this->userId),
            'Monetization',
        );
        
        $this->pageTitle = Yii::app()->name .' - '.$studentName . ' - ' . 'Monetization';

        $userId = Yii::app()->request->getParam('uid');
        
        $accor1 = $accor2 = $accor3 = array();
        $accor1 = DiUserCounsellorSuggested::getStudentBoughtProfile($userId);

        $accor2 = DiUserEoi::getStudentEoiDetail($userId);
        
        $accor3 = DiUserCounsellorSuggested::getSuggestedProfile($userId);
        
        $this->render('monetization', array('accor1' => $accor1, 'accor2' => $accor2, 'accor3' => $accor3));
    }
    
    public function actionMonetizationCollege(){


        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $userId = Yii::app()->request->getParam('uid');
        $uniId = Yii::app()->request->getParam('uniId');
        $diId = Yii::app()->request->getParam('diId');
        
        $userInfo = TblUserMaster::getUserDetails($userId);
        $studentPreferredDepartments = $userInfo->studentPreferredDepartments;
        
        $eoiData = DiUserEoi::getMonetizationPopupDetail($userId, $diId);
        $eoiDetails = array();
        foreach($eoiData as $key => $value) {
            $eoiDetails[$value['main_department_ref_id']] =  $value;
        }

        $uni_data = TblUniversityMaster::getUniversityAttributeById($uniId);

        $university_data['name'] = $uni_data->uni_name;
        $university_data['logo'] = $uni_data->url_primary_key."_logo.jpg";        
        $university_data['country'] = $uni_data->countryRef->country_name;                
        $university_data['state'] = $uni_data->stateRef->name;                
        $university_data['city'] = $uni_data->cityRef->city_name;

        $this->renderPartial("monetization_college_view", array('eoiDetails' => $eoiDetails, 'studentPreferredDepartments' => $studentPreferredDepartments, 'university_data' => $university_data), false, true);
    }
    
    public function actionViewpdfdownload() {

        $env = '';
        $fileType = Yii::app()->request->getParam('type');
        $html = CBaseController::renderInternal(Yii::app()->basePath . '/modules/student/views/profile/profile_pdf.php',array(),true);

        if($fileType == 'doc'){
            header('Content-Type: application/ms word');
            header("Content-Disposition: attachment; filename=".$this->userData->first_name."_StudentProfile.doc");
            echo $html;
            exit;
        }

        $path = dirname(__FILE__).'/../../../../../uploads/';
        if(ACTUALHOST != 'univariety.in' && ACTUALHOST != 'univarit.com' && ACTUALHOST != 'univariety.com'){
            $wkhtmltopdfPath = 'c:\wkhtmltopdf\wkhtmltopdf.exe';
            $env = 'Windows';
        }else{
            $wkhtmltopdfPath = 'wkhtmltopdf';
            $env = 'Linux';
        }
		
		//echo "<pre>"; print_r($wkhtmltopdfPath); exit;
		
        if(!is_executable($wkhtmltopdfPath)){
            if($env == 'Windows'){
                $message = '<h1 style="color:red">WKHTMLTOPDF is not configured in your system</h1>';
                $message .= '<br><br>Click <a href="http://code.google.com/p/wkhtmltopdf/downloads/detail?name=wkhtmltopdf-0.9.9-installer.exe&can=2&q" target="_blank">here</a>';
                $message .= 'to download WKHTMLTOPDF installer file and configure it in ';
                $message .= '<strong>C:\wkhtmltopdf</strong> (i.e, C:\wkhtmltopdf\wkhtmltopdf.exe)';
                die($message);
            }
        }
        $htmlExt = '.html';
        $pdfExt = '.pdf';
        $outputFile = 'student_profile_'.rand(10,100000);
		
		$fp = fopen($path.$outputFile.$htmlExt, 'w');
        fwrite($fp, $html);

			
		
        //$commandPath = 'wkhtmltopdf '.$path.' d:\test2.pdf 2> d:\errors.txt';
        $commandPath = $wkhtmltopdfPath.' '.$path.$outputFile.$htmlExt.' '.$path.$outputFile.$pdfExt;
		shell_exec($commandPath);
		
        //sleep(2);
        header('Content-type: application/pdf');
        header('Content-Disposition: attachment; filename="'.$this->userData->first_name.'_StudentProfile.pdf"');
        readfile($path.$outputFile.$pdfExt);
    }

    public function actionGetDeptName()
    {
        $careerId = Yii::app()->request->getParam('cId');
        $res = LookupCareer::getCareerUrlData($careerId);
        if($res['dept']){
            echo 'This Career is related to '.$res['dept'].' department';
        }
    }

    public function printr($array = array()){
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }


}