<?php

class CreateProfileController extends Controller {

    public $instId = '';
    public $isCssAccess = false;
    public $cssStudentNames = array();
    public $cssStudentNamesList = array();

    public $currentStudyLevelArray = array(
        '9p' => '9th',
        '10p' => '10th',
        '11p' => '11th',
        '12p' => '12th',
        '12c' => '12th Completed',
    );
    public $current_class;
    public $loginRefId;

    public function init() {
        parent::init();
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_signup";
    }

    public function actionIndex() {
        $this->canonicalUrl = 'https://www.univariety.com/app/student/createProfile';
        $this->setPageTitle(Yii::app()->name ." - Create an Account");

        $res = explode(".",$_SERVER['HTTP_HOST']);
        $redirect_signup = 0;
        if (($res[0] != 'www') && (count($res) > 2)) {
            //$this->redirect('/app/student/signup');
        }

        if (Yii::app()->session->itemAt('sUserUnivariety') != '') {
            $userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
            $userId = $userSession['UserId'];
            CommonUtils::checkUserRedirection($userId);
        }

        $model = new StudentSignupB2C('firstPage');

        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (!empty($_POST)) {
            $postData = Yii::app()->request->getPost('StudentSignupB2C');


            $model->attributes=$_POST['StudentSignupB2C'];
            if ($model->validate()) {
                if ($_COOKIE['url']) {
                    $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'corePHP', 'label' => 'dashboard',), 1);
                } else {
                    if((Yii::app()->session['boardId'] != '') && (Yii::app()->session['countryId'] != '') && (Yii::app()->session['departmentId'] != '') && (Yii::app()->session['educationType'] != '')  &&   (Yii::app()->session['overallMarks'] != '') )
                    {
                        $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_ideal_list',), 1);
                    } else {
                        $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_finish',), 1);
                    }
                }

                //echo $urlDetails[0]['url_id']; exit;
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                $afterSignupRedirectUrl = $urlDetails[0]['url'];

                $postData = Yii::app()->request->getPost('StudentSignupB2C');
                $studentSignupModel = new StudentSignup('firstPage');
                $uniqueId = md5($studentSignupModel->getUniqueID("uid"));
                $studentSignupModel->set_session("unique_id", $uniqueId);
                $this->current_class = $postData['present_class'];

                $loginMasterData = array('username' => $postData['username'], 'pass_word' => $postData['password'],
                    'user_type_ref_id' => 1, 'is_active' => 1, 'is_email_confirmed' => 0,'added_on' => date('Y-m-d H:i:s'));

                $loginMasterModel = new LoginMaster;
                $loginMasterModel->setAttributes($loginMasterData);
                $loginMasterModel->save();
                $this->loginRefId = $loginMasterModel->login_id;

                $userUNO = $studentSignupModel->generateUserUNO('IN');
                $userMembershipRefId = $studentSignupModel->getMembershipId('Guest');
                $class_data = $this->DynamicPassoutYearAndMonth();

                $userMasterData = array('login_ref_id' => $this->loginRefId, 'uno' => $userUNO,
                    'first_name' => ucwords(strtolower(trim($postData['first_name']))), 'last_name' => ucwords(strtolower(trim($postData['last_name']))),
                    'membership_ref_id' => $userMembershipRefId['membership_id'], 'gender' => $postData['gender'],
                    'present_class' => $class_data['present_class'],
                    'class_status' => $class_data['class_status'],
                    'redirect_url_ref_id' => $redirectUrlRefId,
                    'profile_status_ref_id' => '3', 'passout_year' => $class_data['passout_year'],
                    'passout_month' => $class_data['passout_month'],
                    'added_on' => date('Y-m-d H:i:s'),
                );

                $userMasterModel = new TblUserMaster;				
				$userMasterModel->scenario='register';
                $userMasterModel->attributes = $userMasterData;
                $userMasterModel->save(false);

                $student_det = TblUserMaster::model()->findByAttributes(array('login_ref_id'=>$this->loginRefId));
                StudentPreferredStudyLevel::addStudentPreferences($student_det->user_id, array(5));

                $studyDurationObj = new StudentPreferredDuration();
                $studyDurationObj->deleteStudyDurationByUserId($student_det->user_id);
                $studyDurationObj->insertStudyDurationByUserId($student_det->user_id, 4);
                $studyDurationObj->insertStudyDurationByUserId($student_det->user_id, 5);

                $criticalFields = array(
                    'name' => 1,
                    'gender' => 1,
                    'study_level'=>1,
                    'preferred_course_duration'=>1,
                    'edu_study_level'=>1,
                    'completion_year'=>1,
                );

                if(Yii::app()->session['countryId'] != '') {
                    // add country preference
                    $criteria = new CDbCriteria;
                    $criteria->condition = "user_ref_id = '".$student_det->user_id."'";
                    StudentPreferredCountry::model()->deleteAll($criteria);

                    $obj = new StudentPreferredCountry();
                    $obj->{user_ref_id} = $student_det->user_id;
                    $obj->{country_ref_id} = Yii::app()->session['countryId'];
                    $obj->{preference_order} = 1;
                    $obj->save();

                    Yii::app()->session['countryId'] = null;
                    $criticalFields['country'] = 1;
                }

                if(Yii::app()->session['departmentId'] != '') {
                    // add department preference
                    $criteria = new CDbCriteria;
                    $criteria->condition = "user_ref_id = '".$student_det->user_id."'";
                    StudentPreferredDepartment::model()->deleteAll($criteria);

                    $obj = new StudentPreferredDepartment();
                    $obj->{user_ref_id} = $student_det->user_id;
                    $obj->{main_dept_ref_id} = Yii::app()->session['departmentId'];
                    $obj->{sub_dept_ref_id} = '';
                    $obj->{preference_order} = 1;
                    $obj->{course_ref_id} = null;
                    $obj->save(false);

                    Yii::app()->session['departmentId'] = null;
                    $criticalFields['intended_subjects'] = 1;
                }


                if((Yii::app()->session['educationType'] != '') && (Yii::app()->session['overallMarks'] != '') && (Yii::app()->session['boardId'] != '') ) {
                    $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$student_det->user_id, 'class_level'=>'12'));
                    if ($edu_det->student_education_id) {
                        $criteria = new CDbCriteria;
                        $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
                        StudentGradeCount::model()->deleteAll($criteria);

                        $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);
                    } else {
                        $edu_obj = new StudentEducation();
                        $edu_obj->user_ref_id = $student_det->user_id;
                        $edu_obj->class_level = 12;
                        $edu_obj->added_on = date('Y-m-d H:i:s');
                    }
                    $edu_obj->board_ref_id = Yii::app()->session['boardId'];

                    switch(Yii::app()->session['educationType']) {
                        case 'grades':
                            $edu_obj->overall_marks = NULL;
                            break;
                        case 'marks':
                        case 'points':
                        case 'marks-gpa':
                            $edu_obj->overall_marks =Yii::app()->session['overallMarks'];
                            break;
                    }
                    $edu_obj->save(false);

                   if (!$student_det->present_board_ref_id) {
                       $boardDetail = LookupBoardEquivalent::getBoardDetailById(Yii::app()->session['boardId']);
                       $student_det->present_board_ref_id = $boardDetail['board_ref_id'];
                       $student_det->save(false);
                   }
                    if (Yii::app()->session['educationType'] == 'grades') {
                        $gradeArr = json_decode(Yii::app()->session['overallMarks'],true);
                        $edu_det_new = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$student_det->user_id, 'class_level'=>'12'));
                        if ($edu_det_new->student_education_id) {
                            if ($gradeArr['aa']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 1;$grade_model->grade_count = $gradeArr['aa'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }
                            if ($gradeArr['a']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 2;$grade_model->grade_count = $gradeArr['a'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }if ($gradeArr['b']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 3;$grade_model->grade_count = $gradeArr['b'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }if ($gradeArr['c']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 4;$grade_model->grade_count = $gradeArr['c'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }if ($gradeArr['d']) {
                                $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                                $grade_model->grade_ref_id = 5;$grade_model->grade_count = $gradeArr['d'];
                                $grade_model->added_on = date('Y-m-d H:i:s');
                                $grade_model->save(false);
                            }
                        }


                    }
                    Yii::app()->session['educationType'] = null;
                    Yii::app()->session['overallMarks'] = null;
                    Yii::app()->session['boardId'] = null;
                    $criticalFields['board'] = 1;
                    $criticalFields['overall_marks'] = 1;

                }
                TblUserProfCriticalCompletion::updateCriticalFields($student_det->user_id, $criticalFields);
                $studentSignupModel->setRbacAssignment('Student', $this->loginRefId);
                $this->sendConfirmationEmail($postData['first_name'], $postData['username'], $student_det->user_id);
                Yii::app()->session['signupProcess'] = 'guestSignup';

                setFlashMessage('success_notify', 'globalnotifications.profile_created');
                $loginModel = new LoginMaster();
                if ($_COOKIE['url']) {
                    $loginModel->loginWithRedirect($postData['username'], $postData['password'], $_COOKIE['url']);
                } else {
                    $loginModel->loginWithRedirect($postData['username'], $postData['password'], $afterSignupRedirectUrl);
                }
            }
        }

        $this->render('index', array('model'=>$model));
    }
	
	public function actionlogintrack()
	{
		try{
			if(isset(Yii::app()->session['login_track']) && Yii::app()->session['login_track']=="Test page")
			{
				Yii::app()->session['login_track']="Test page";
			}
			else Yii::app()->session['login_track']="createProfile";
			exit;
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}
	
    /*public function actionSignUp() {
        if($this->isMobile){
            $this->redirect('MSignUp');
            Yii::app()->end();
        }
        $this->canonicalUrl = 'https://www.univariety.com/app/student/createProfile/signup';
        $this->setPageTitle(Yii::app()->name ." - Create an Account");

        $res = explode(".",$_SERVER['HTTP_HOST']);
        $redirect_signup = 0;
        if (($res[0] != 'www') && (count($res) > 2)) {
            $this->redirect('/app/student/signup');
        }

        if (Yii::app()->session->itemAt('sUserUnivariety') != '') {
            $userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
            $userId = $userSession['UserId'];
            CommonUtils::checkUserRedirection($userId);
        }

        $model = new StudentSignupB2C('new_signup');


        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (!empty($_POST)) {

            $model->attributes=$_POST['StudentSignupB2C'];
            if ($model->validate()) {

                if((Yii::app()->session['boardId'] != '') &&  (Yii::app()->session['departmentId'] != '') && (Yii::app()->session['educationType'] != '')  &&   (Yii::app()->session['overallMarks'] != '') )
                {
                    $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_ideal_list',), 1);
                } else {
                    $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'corePHP', 'label' => 'dashboard',), 1);
                }

                $redirectUrlRefId = $urlDetails[0]['url_id'];
                $afterSignupRedirectUrl = $urlDetails[0]['url'];

                $postData = Yii::app()->request->getPost('StudentSignupB2C');
                $studentSignupModel = new StudentSignup('firstPage');
                $uniqueId = md5($studentSignupModel->getUniqueID("uid"));
                $studentSignupModel->set_session("unique_id", $uniqueId);
                $this->current_class = $postData['present_class'];

                $loginMasterData = array('username' => $postData['username'], 'pass_word' => $postData['password'],
                    'user_type_ref_id' => 1, 'is_active' => 1, 'is_email_confirmed' => 0,'added_on' => date('Y-m-d H:i:s'));

                $loginMasterModel = new LoginMaster;
                $loginMasterModel->setAttributes($loginMasterData);
                $loginMasterModel->save();
                $this->loginRefId = $loginMasterModel->login_id;

                $userUNO = $studentSignupModel->generateUserUNO('IN');
                $userMembershipRefId = $studentSignupModel->getMembershipId('Guest');
                $class_data = $this->DynamicPassoutYearAndMonth();

                $userMasterData = array('login_ref_id' => $this->loginRefId, 'uno' => $userUNO,
                    'first_name' => ucwords(strtolower(trim($postData['first_name']))), 'last_name' => ucwords(strtolower(trim($postData['last_name']))),
                    'membership_ref_id' => $userMembershipRefId['membership_id'], 'gender' => $postData['gender'],
                    'present_class' => $class_data['present_class'],
                    'class_status' => $class_data['class_status'],
                    'redirect_url_ref_id' => $redirectUrlRefId,
                    'profile_status_ref_id' => '3', 'passout_year' => $class_data['passout_year'],
                    'passout_month' => $class_data['passout_month'],					
                    'added_on' => date('Y-m-d H:i:s'),
                );

                $userMasterModel = new TblUserMaster;
				$userMasterModel->scenario='register';
                $userMasterModel->attributes = $userMasterData;
				
                $userMasterModel->save(false);

                $student_det = TblUserMaster::model()->findByAttributes(array('login_ref_id'=>$this->loginRefId));
                StudentPreferredStudyLevel::addStudentPreferences($student_det->user_id, array(5));

                $studyDurationObj = new StudentPreferredDuration();
                $studyDurationObj->deleteStudyDurationByUserId($student_det->user_id);
                $studyDurationObj->insertStudyDurationByUserId($student_det->user_id, 4);
                $studyDurationObj->insertStudyDurationByUserId($student_det->user_id, 5);

                $criticalFields = array(
                    'name' => 1,
                    'gender' => 1,
                    'study_level'=>1,
                    'preferred_course_duration'=>1,
                    'edu_study_level'=>1,
                    'completion_year'=>1,
                );

                $criteria = new CDbCriteria;
                $criteria->condition = "user_ref_id = '".$student_det->user_id."'";
                StudentPreferredCountry::model()->deleteAll($criteria);

                $obj = new StudentPreferredCountry();
                $obj->{user_ref_id} = $student_det->user_id;
                $obj->{country_ref_id} = $postData['country'];
                $obj->{preference_order} = 1;
                $obj->save();
                $criticalFields['country'] = 1;


                $criteria = new CDbCriteria;
                $criteria->condition = "user_ref_id = '".$student_det->user_id."'";
                StudentPreferredDepartment::model()->deleteAll($criteria);

                $obj = new StudentPreferredDepartment();
                $obj->{user_ref_id} = $student_det->user_id;
                $obj->{main_dept_ref_id} = $postData['department'];
                $obj->{sub_dept_ref_id} = '';
                $obj->{preference_order} = 1;
                $obj->{course_ref_id} = null;
                $obj->save(false);

                $criticalFields['intended_subjects'] = 1;
                if ($postData['phone']) {
                    $contactDetails = array(
                        'contact_type_ref_id' => 1,
                        'country_code' => $postData['country_code'],
                        'number' => $postData['phone'],
                        'user_ref_id' => $student_det->user_id,
                        'is_primary' => 1,
                        'added_on' => date('Y-m-d H:i:s'),
                        'added_by' => $this->loginRefId,
                        'phone_type' => 'Mobile',
                    );
                    $studentContactModel = StudentContactNumber::model()->find(array("condition" => "user_ref_id = $student_det->user_id AND contact_type_ref_id = 1 AND is_primary = 1"));
                    if(!$studentContactModel){
                        $studentContactModel = new StudentContactNumber();
                        $studentContactModel->setAttributes($contactDetails);
                        $studentContactModel->added_on = date('Y-m-d H:i:s');
                        $studentContactModel->save(false);
                    }else{
                        $studentContactModel->setAttributes($contactDetails);
                        $studentContactModel->added_on = date('Y-m-d H:i:s');
                        $studentContactModel->save();
                    }
                    $criticalFields['phone'] = 1;
                }

                if (!$student_det->present_board_ref_id) {
                    $boardDetail = LookupBoardEquivalent::getBoardDetailById($postData['board']);
                    $student_det->present_board_ref_id = $boardDetail['board_ref_id'];
                    $student_det->save(false);
                }

                $boardDetails = LookupBoardEquivalent::GetBoardDetails(12, $postData['board']);

                $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$student_det->user_id, 'class_level'=>'12'));
                if ($edu_det->student_education_id) {
                    $criteria = new CDbCriteria;
                    $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
                    StudentGradeCount::model()->deleteAll($criteria);

                    $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);
                } else {
                    $edu_obj = new StudentEducation();
                    $edu_obj->user_ref_id = $student_det->user_id;
                    $edu_obj->class_level = 12;
                    $edu_obj->added_on = date('Y-m-d H:i:s');
                }
                $edu_obj->board_ref_id = $postData['board'];
                $board_type = strtolower($boardDetails['overall_type']);
                switch($board_type) {
                    case 'grades':
                        $edu_obj->overall_marks = NULL;
                        break;
                    case 'marks':
                        $edu_obj->overall_marks =$postData['overall_marks'];
                        break;
                    case 'points':
                        $edu_obj->overall_marks =$postData['overall_points'];
                        break;
                    case 'marks-gpa':
                        $edu_obj->overall_marks =$postData['overall_marks_gpa'];
                        break;
                }
                $edu_obj->save(false);

                if ($board_type == 'grades') {
                    $edu_det_new = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$student_det->user_id, 'class_level'=>'12'));
                    if ($edu_det_new->student_education_id) {
                        if ($postData['overall_aa']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 1;$grade_model->grade_count = $postData['overall_aa'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                        if ($postData['overall_a']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 2;$grade_model->grade_count = $postData['overall_a'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($postData['overall_b']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 3;$grade_model->grade_count = $postData['overall_b'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($postData['overall_c']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 4;$grade_model->grade_count = $postData['overall_c'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($postData['overall_d']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 5;$grade_model->grade_count = $postData['overall_d'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                    }
                }
                $criticalFields['board'] = 1;
                $criticalFields['overall_marks'] = 1;


                TblUserProfCriticalCompletion::updateCriticalFields($student_det->user_id, $criticalFields);
                $studentSignupModel->setRbacAssignment('Student', $this->loginRefId);
                $this->sendConfirmationEmail($postData['first_name'], $postData['username'], $student_det->user_id);
                Yii::app()->session['signupProcess'] = 'guestSignup';

                setFlashMessage('success_notify', 'globalnotifications.profile_created');
                $loginModel = new LoginMaster();
                
                $redirectURL = Yii::app()->request->getParam('redirectURL',null);
                
                if($redirectURL){
                    $loginModel->loginWithRedirect($postData['username'], $postData['password'], $redirectURL);
                }elseif($_COOKIE['url']){
                    $loginModel->loginWithRedirect($postData['username'], $postData['password'], $_COOKIE['url']);
                } else {
                    $loginModel->loginWithRedirect($postData['username'], $postData['password'], $afterSignupRedirectUrl);
                }
            }
        }

        $model->department = Yii::app()->session['departmentId'];
        $model->country = Yii::app()->session['countryId'];
        $model->board = Yii::app()->session['boardId'];
        $educationType = Yii::app()->session['educationType'];
        if((Yii::app()->session['boardId'] != '') &&  (Yii::app()->session['departmentId'] != '') && (Yii::app()->session['educationType'] != '')  &&   (Yii::app()->session['overallMarks'] != '') )
        { $displayNewMessage = true; }
        
        switch($educationType) {
            case 'grades':
                $model->overall_marks = NULL;
                break;
            case 'marks':
                $model->overall_marks=Yii::app()->session['overallMarks'];
                break;
            case 'points':
                $model->overall_points =Yii::app()->session['overallMarks'];
                break;
            case 'marks-gpa':
                $model->overall_marks_gpa=Yii::app()->session['overallMarks'];
                break;
        }

        if($educationType == "grades") {
            $marksArray = json_decode(Yii::app()->session['overallMarks'], true);
            foreach ($marksArray as $grade => $count) {
                if ($count == '') {
                    continue;
                }
                switch ($grade) {
                    case 'aa': $model->overall_aa = $count;
                        break;
                    case 'a': $model->overall_a = $count;
                        break;
                    case 'b': $model->overall_b = $count;
                        break;
                    case 'c': $model->overall_c = $count;
                        break;
                    case 'd': $model->overall_d = $count;
                        break;
                }
            }
        }

        $countriesList = TblCountryMaster::getUnivarietyCountries();
        $countries = CHtml::listData($countriesList,'country_id', 'country_name');
        $allCountryList = TblCountryMaster::getCountryList();
        $uniqueCountryList = array_diff($allCountryList, $countries);
 
        $countries['Others'] = $uniqueCountryList;
        $dept_list = LookupDepartment::getMainDepartmentList();

        $countryData = Yii::app()->db->createCommand()
            ->from('tbl_country_master as tcm')
            ->select('phone_code, country_name')
            ->where('is_active= "Y" AND country_code <> "" ')
            ->order('country_name ASC')
            ->queryAll();
        $country_list = array();
        foreach ($countryData as $country) {
            $phone_code = $country['phone_code'];
            $country_list[$phone_code] = $country['country_name']." (+$phone_code)";
        }
        asort($country_list);

        $this->render('signup', array('model'=>$model, 'countries'=>$countries, 'dept_list'=>$dept_list, 'country_list'=>$country_list, 'displayNewMessage' => $displayNewMessage));
    }*/



    public function actionSignUp() {
        if($this->isMobile){
            $this->redirect('MSignUp');
            Yii::app()->end();
        }
        $this->canonicalUrl = 'https://www.univariety.com/app/student/createProfile/signup';
        $this->setPageTitle(Yii::app()->name ." - Create an Account");

        $res = explode(".",$_SERVER['HTTP_HOST']);
        $redirect_signup = 0;
        if (($res[0] != 'www') && (count($res) > 2)) {
            //$this->redirect('/app/student/signup');
        }

        $this->checkCssAccess();
        $instId = '';

        if (Yii::app()->session->itemAt('sUserUnivariety') != '') {
            $userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
            $userId = $userSession['UserId'];
            CommonUtils::checkUserRedirection($userId);
        }

        $model = new StudentSignupB2C('old_signup');

        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (!empty($_POST)) {

            $model->attributes=$_POST['StudentSignupB2C'];
            if ($model->validate()) {
                $postData = Yii::app()->request->getPost('StudentSignupB2C');

                $emailHash = (@$postData['username'] != '') ? md5(@$postData['username']) : Yii::app()->request->getParam('hashkey');
                if ($emailHash != '') {
                    $studentSignupModel = new StudentSignup();
                    $result = $studentSignupModel->getInvitedStudentsBasicInfo($emailHash);

                    if ($result) {
                        $invitedStudentInfo = $result->attributes;
                        $instId = $invitedStudentInfo['inst_ref_id'];
                    }
                }
                if ($instId > 0) {
                    $result = TblSiDi::GetSchoolLookupId($instId);
                    $instInfo = $result->attributes;
                } elseif (0 !== strpos($_SERVER['HTTP_HOST'], 'www')) { // not start with www
                    $hostName = explode(".", $_SERVER['HTTP_HOST']);
                    if($hostName[1] != "com") {
                        $subDomainName = $hostName[0];
                        $schoolData = $studentSignupModel->getSchoolNameBySubdomain($subDomainName)->attributes;
                        if($schoolData['school_id']){
                            $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolData['school_id']);
                            $instId = $siDiData->inst_id;
                        }
                    }
                } else {
                    $instId = 'null';
                }

                $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,'label' => 'new_profile',), 1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                //$redirectUrlRefId = '/app/myProfile';
                $afterSignupRedirectUrl = $urlDetails[0]['url'];

                $studentSignupModel = new StudentSignup('firstPage');
                $uniqueId = md5($studentSignupModel->getUniqueID("uid"));
                $studentSignupModel->set_session("unique_id", $uniqueId);
                $this->current_class = $postData['present_class'];

                $loginMasterData = array('username' => $postData['username'], 'pass_word' => $postData['password'],
                    'user_type_ref_id' => 1, 'is_active' => 1, 'is_email_confirmed' => 0,'added_on' => date('Y-m-d H:i:s'));

                $loginMasterModel = new LoginMaster;
                $loginMasterModel->setAttributes($loginMasterData);
                $loginMasterModel->save();
                $this->loginRefId = $loginMasterModel->login_id;

                $userUNO = $studentSignupModel->generateUserUNO('IN');
                $userMembershipRefId = ($instId > 0) ? $studentSignupModel->getMembershipId('SI Student') :$studentSignupModel->getMembershipId('Guest');
                $class_data = $this->DynamicPassoutYearAndMonth();

                $schoolRefId = '';
                if($instId > 0){
                    $siRes = TblSiDi::model()->findByPk($instId);
                    $schoolRefId = $siRes->school_ref_id;
                }

                $userMasterData = array('login_ref_id' => $this->loginRefId, 'uno' => $userUNO,

                    'membership_ref_id' => $userMembershipRefId['membership_id'],
                    'present_class' => $class_data['present_class'],
                    'class_status' => $class_data['class_status'],
                    'passout_year' => $class_data['passout_year'],
                    'passout_month' => 6,
                    'profile_status_ref_id' => '3',
                    'added_on' => date('Y-m-d H:i:s'),
                );

                $userMasterModel = new TblUserMaster;
				$userMasterModel->scenario='register';
                if($schoolRefId){
                    $userMasterModel->school_ref_id = $schoolRefId;
                }
                $userMasterModel->attributes = $userMasterData;

                $userMasterModel->save(false);

                $student_det = TblUserMaster::model()->findByAttributes(array('login_ref_id'=>$this->loginRefId));

                $criticalFields = array(
                    'study_level'=>1,
                    'edu_study_level'=>1,
                );
                if($student_det->user_id){
                $preferredStudyLevelObj = new StudentPreferredStudyLevel();
                $preferredStudyLevelObj->insertPreferredStudyLevelByUserId($student_det->user_id, 5);
                }

                TblUserProfCriticalCompletion::updateCriticalFields($student_det->user_id, $criticalFields);
                $studentSignupModel->setRbacAssignment('Student', $this->loginRefId);
                $this->sendConfirmationEmail('', $postData['username'], $student_det->user_id);
                Yii::app()->session['signupProcess'] = 'guestSignup';

                TblUserMaster::updateUserFields($student_det->user_id, array('redirect_url_ref_id' => $redirectUrlRefId));

                //inserting to tbl_si_students if he is related to a School
                if ($instId > 0) {
                    $studentSignupModel->setSiStudents($student_det->user_id, $instId);
                }

                $loginModel = new LoginMaster();

                $redirectURL = Yii::app()->request->getParam('redirectURL',null);

                if($redirectURL){
                    $loginModel->loginWithRedirect($postData['username'], $postData['password'], $redirectURL);
                }elseif($_COOKIE['url']){
                    $loginModel->loginWithRedirect($postData['username'], $postData['password'], $_COOKIE['url']);
                } else {
                    $loginModel->loginWithRedirect($postData['username'], $postData['password'], $afterSignupRedirectUrl);
                }
            }
        }

        $this->render('signup', array('model'=>$model));
        //$this->render('signup', array('model'=>$model, 'displayNewMessage' => $displayNewMessage));
    }


    public function actionFinish() {
        $this->setPageTitle(Yii::app()->name ." - SignUp Completed");

        if (Yii::app()->session->itemAt('sUserUnivariety') == '') {
            $this->redirect('/app/student/createProfile');
        }

        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
        $url_det = LookupUrl::model()->findByPK($user->redirect_url_ref_id);
        if ($url_det) {
            if ($url_det->url == '/app/dashboard') {
                $this->redirect($url_det->url);
            }
        }

        $this->render('finish');
    }

    public function DynamicPassoutYearAndMonth() {
        $current_month = date('n');
        $year = date('Y');
        $return = array();
        switch ($this->current_class) {
            case '9p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year + 3;
                } else {
                    $return['passout_year'] = $year + 4;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 9;
                $return['class_status'] = 'Pursuing';
                break;
            case '10p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year + 2;
                } else {
                    $return['passout_year'] = $year + 3;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 10;
                $return['class_status'] = 'Pursuing';
                break;
            case '11p':
                    if ($current_month < 6) {
                        $return['passout_year'] = $year + 1;
                    } else {
                        $return['passout_year'] = $year + 2;
                    }
                    $return['passout_month'] = 6;
                    $return['present_class'] = 11;
                    $return['class_status'] = 'Pursuing';
                break;
            case '12p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year;
                } else {
                    $return['passout_year'] = $year + 1;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 12;
                $return['class_status'] = 'Pursuing';
                break;
            case '12c':
                $return['passout_year'] = 0;
                $return['passout_month'] = 0;
                $return['present_class'] = 12;
                $return['class_status'] = 'Completed';
                break;
        }
        return $return;
    }

    public function sendConfirmationEmail($firstName = false, $email = false, $userId) {
        Yii::import('application.components.StudentRegistration.php');
        $obj = new StudentRegistration();
        $obj->sendConfirmationEmail($userId);
        /*
        $s = empty($_SERVER['HTTPS']) ? '' : ($_SERVER['HTTPS'] == 'on') ? 's' : '';
        $protocol = strtolower($_SERVER['SERVER_PROTOCOL']);
        $protocol =  substr($protocol, 0, strpos($protocol, '/')). $s;
        $port = ($_SERVER['SERVER_PORT'] == '80') ? '' : (':'.$_SERVER['SERVER_PORT']);
        $siteURL = $protocol . '://' . $_SERVER['SERVER_NAME'];

        $msg = $this->renderPartial('../signup/confirmationTemplateMail', array('firstName' => $firstName, 'email' => $email, 'siteURL' => $siteURL), true);

        $params = array();
        $params['EmailMessage']['subject'] = 'Registration Confirmation';
        $params['EmailMessage']['body'] = $msg;
        $params['EmailMessage']['type'] = 'Signup';
        $params['EmailMessage']['siteUrl'] = '';
        $params['EmailMessage']['cc'] = '';
        $params['EmailMessage']['toName'] = $firstName;
        $params['EmailMessage']['toEmail'] = $email;
        $params['EmailMessage']['apiKey'] = Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', $url);

        $status = Yii::app()->runController("sms/email/addMessage"); */
    }


    public function getSchoolInfoBySubDomain($subDomainSlugName = ''){

        $criteria = new CDbCriteria();
        $criteria->condition = 'tsd.subdomain_slug_name=:name';
        $criteria->join = 'INNER JOIN tbl_si_di tsd on t.school_id = tsd.school_ref_id';
        $criteria->params = array(':name' => $subDomainSlugName);
        return LookupSchool::model()->with('tblSiDis')->find($criteria);
    }

    private function getSubDomainFromUrl($url = ''){

        $url = str_replace("www.","",parse_url($url,PHP_URL_HOST));
        $aUrl = explode('.', $url);
        return count($aUrl) > 2 ? $aUrl[0] : false;
    }

    public function actionMSignUp(){

        //check if the user is already filled form
        if($pages = Yii::app()->session->get('pagesCompleted')) {
            if(in_array('firstPage', $pages)){
                $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,'label' => 'new_profile',), 1);
                $afterSignupRedirectUrl = $urlDetails[0]['url'];
                $this->redirect($afterSignupRedirectUrl);
                //$this->redirect('MEducation');
                Yii::app()->end();
            }
        }

        $model = new StudentSignupB2CMobile('firstPage');
        if (Yii::app()->request->isAjaxRequest){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if(Yii::app()->request->isPostRequest){
            $model->attributes = $_POST['StudentSignupB2CMobile'];
            if($model->validate()){
                // do the registration
                $loginMasterModel = new LoginMaster;
                $loginMasterModel->setAttributes(array(
                    'username' => $model->username, 'pass_word' => $model->password,
                    'user_type_ref_id' => 1, 'is_active' => 1, 'added_on' => date('Y-m-d H:i:s')
                ));
                $loginMasterModel->save();

                $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'corePHP', 'label' => 'dashboard',), 1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];

                $studentSignupModel = new StudentSignup('firstPage');
                $userUNO = $studentSignupModel->generateUserUNO('IN');
                $currentPageUrl = Yii::app()->createAbsoluteUrl(str_replace("app/","",Yii::app()->request->url));
                $subDomain = $this->getSubDomainFromUrl($currentPageUrl);
                $userMembershipRefId = $studentSignupModel->getMembershipId($subDomain ? 'SI Student' : 'Guest');

                $userMasterModel = new TblUserMaster;
				$userMasterModel->scenario='register';
                $userMasterModel->setAttributes(array(
                    'login_ref_id' => $loginMasterModel->login_id,
                    'uno' => $userUNO,
                    'first_name' => ucwords(strtolower(trim($model->first_name))),
                    'last_name' => ucwords(strtolower(trim($model->last_name))),
                    'membership_ref_id' => $userMembershipRefId['membership_id'],
                    'redirect_url_ref_id' => $redirectUrlRefId,
                    'profile_status_ref_id' => '3',
                    'added_on' => date('Y-m-d H:i:s'),
                ), false);

                if ($subDomain) {
                    $schoolData = $this->getSchoolInfoBySubDomain($subDomain);
                    if($schoolData){
                        $userMasterModel['school_ref_id'] = $schoolData->school_id;
                        $userMasterModel->save(false);
                        $studentSignupModel->setSiStudents($userMasterModel->user_id, $schoolData->tblSiDis[0]->inst_id);
                    }
                }else{
                    $userMasterModel->save(false);
                }

                $criticalFields = array('name' => 1);
                TblUserProfCriticalCompletion::updateCriticalFields($userMasterModel->user_id, $criticalFields);
                $studentSignupModel->setRbacAssignment('Student', $loginMasterModel->login_id);
                Yii::app()->session['pagesCompleted'] = array('firstPage');
                $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,'label' => 'new_profile',), 1);
                $afterSignupRedirectUrl = $urlDetails[0]['url'];
                $loginMasterModel->loginWithRedirect($model->username, $model->password, $afterSignupRedirectUrl);
                //$loginMasterModel->loginWithRedirect($model->username, $model->password, 'MEducation');
            }
        }
        $this->pageTitle = Yii::app()->name .' - Sign Up';
        $this->render('signup', array('model'=>$model));
    }

    public function actionMEducation(){

        if($pages = Yii::app()->session->get('pagesCompleted')) {
            if(in_array('secondPage', $pages)){
                $this->redirect('MContactInfo');
                Yii::app()->end();
            }
        }

        $model = new StudentSignupB2CMobile('secondPage');
        if (Yii::app()->request->isAjaxRequest){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
        if(Yii::app()->request->isPostRequest){
            $model->attributes = $_POST['StudentSignupB2CMobile'];
            if($model->validate()){
                // process education info
                $this->current_class = $model->present_class;
                $class_data = $this->DynamicPassoutYearAndMonth();

                $userMasterModel = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
                $userMasterModel->setAttributes(array(
                    'gender' => $model->gender,
                    'present_class' => $class_data['present_class'],
                    'class_status' => $class_data['class_status'],
                    'passout_year' => $class_data['passout_year'],
                    'passout_month' => $class_data['passout_month'],
                ), false);
                $userMasterModel->save(false);

                StudentPreferredStudyLevel::addStudentPreferences($userMasterModel->user_id, array(5));
                $studyDurationObj = new StudentPreferredDuration();
                $studyDurationObj->deleteStudyDurationByUserId($userMasterModel->user_id);
                $studyDurationObj->insertStudyDurationByUserId($userMasterModel->user_id, 4);
                $studyDurationObj->insertStudyDurationByUserId($userMasterModel->user_id, 5);

                // countryInfo
                $obj = new StudentPreferredCountry();
                $obj->setAttributes(array(
                    'user_ref_id' => $userMasterModel->user_id,
                    'country_ref_id' => $model->country,
                    'preference_order' => 1
                ), false);
                $obj->save(false);

                // departmentInfo
                $obj = new StudentPreferredDepartment();
                $obj->setAttributes(array(
                    'user_ref_id' => $userMasterModel->user_id,
                    'main_dept_ref_id' => $model->department,
                    'preference_order' => 1
                ), false);
                $obj->save(false);

                // board info
                $boardDetails = LookupBoardEquivalent::GetBoardDetails(12, $model->board);
                $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userMasterModel->user_id, 'class_level'=>'12'));
                if ($edu_det->student_education_id) {
                    $criteria = new CDbCriteria;
                    $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
                    StudentGradeCount::model()->deleteAll($criteria);

                    $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);
                } else {
                    $edu_obj = new StudentEducation();
                    $edu_obj->user_ref_id = $userMasterModel->user_id;
                    $edu_obj->class_level = 12;
                    $edu_obj->added_on = date('Y-m-d H:i:s');
                }
                $edu_obj->board_ref_id = $model->board;
                $board_type = strtolower($boardDetails['overall_type']);
                switch($board_type) {
                    case 'grades':
                        $edu_obj->overall_marks = NULL;
                        break;
                    case 'marks':
                        $edu_obj->overall_marks = $model->overall_marks;
                        break;
                    case 'points':
                        $edu_obj->overall_marks =$model->overall_points;
                        break;
                    case 'marks-gpa':
                        $edu_obj->overall_marks =$model->overall_marks_gpa;
                        break;
                }
                $edu_obj->save(false);

                if ($board_type == 'grades') {
                    $edu_det_new = StudentEducation::model()->findByAttributes(array(
                        'user_ref_id'=>$userMasterModel->user_id, 'class_level'=>'12'));
                    if ($edu_det_new->student_education_id) {
                        if ($model->overall_aa) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 1;$grade_model->grade_count = $model->overall_aa;
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                        if ($model->overall_a) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 2;$grade_model->grade_count = $model->overall_a;
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($model->overall_b) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 3;$grade_model->grade_count = $model->overall_b;
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($model->overall_c) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 4;$grade_model->grade_count = $model->overall_c;
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($model->overall_d) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 5;$grade_model->grade_count = $model->overall_d;
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                    }
                }
                $criticalFields = array(
                    'gender'=>1,
                    'study_level'=>1,
                    'preferred_course_duration'=>1,
                    'edu_study_level'=>1,
                    'completion_year'=>1,
                    'country'=>1,
                    'intended_subjects'=>1,
                    'board'=>1,
                    'overall_marks'=>1,
                );
                TblUserProfCriticalCompletion::updateCriticalFields($userMasterModel->user_id, $criticalFields);
                Yii::app()->session['pagesCompleted'] = array('firstPage', 'secondPage');
                $this->redirect('MContactInfo');
            }
        }
        $countriesList = TblCountryMaster::getUnivarietyCountries();
        $countries = CHtml::listData($countriesList,'country_id', 'country_name');
        $allCountryList = TblCountryMaster::getCountryList();
        $uniqueCountryList = array_diff($allCountryList, $countries);
        $countries['Others'] = $uniqueCountryList;
        $dept_list = LookupDepartment::getMainDepartmentList();

        $this->pageTitle = Yii::app()->name .' - Education Details';
        $this->render('education', array('model'=>$model, 'countries'=>$countries,'dept_list'=>$dept_list,));
    }

    public function actionMContactInfo(){

        $model = new StudentSignupB2CMobile('thirdPage');
        if (Yii::app()->request->isAjaxRequest){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
        if(Yii::app()->request->isPostRequest){
            $model->attributes = $_POST['StudentSignupB2CMobile'];
            if($model->validate()){
                // process contact info
                $student_det = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
                $contactDetails = array(
                    'contact_type_ref_id' => 1,
                    'country_code' => $model->country_code,
                    'number' => $model->phone,
                    'user_ref_id' => $student_det->user_id,
                    'is_primary' => 1,
                    'added_on' => date('Y-m-d H:i:s'),
                    'added_by' => Yii::app()->user->id,
                    'phone_type' => 'Mobile',
                );
                $studentContactModel = StudentContactNumber::model()->find(array("condition" => "user_ref_id = $student_det->user_id AND contact_type_ref_id = 1 AND is_primary = 1"));
                if(!$studentContactModel){
                    $studentContactModel = new StudentContactNumber();
                    $studentContactModel->setAttributes($contactDetails);
                    $studentContactModel->added_on = date('Y-m-d H:i:s');
                    $studentContactModel->save(false);
                }else{
                    $studentContactModel->setAttributes($contactDetails);
                    $studentContactModel->added_on = date('Y-m-d H:i:s');
                    $studentContactModel->save();
                }
                $criticalFields = array('phone' => 1);
                TblUserProfCriticalCompletion::updateCriticalFields($student_det->user_id, $criticalFields);
                $this->redirect(Yii::app()->user->redirectUrl);
            }
        }
        $this->pageTitle = Yii::app()->name .' - Contact Details';
        $this->render('contact', array('model'=>$model, 'country_list'=>$model->getCountryCodes()));
    }


    public function checkCssAccess(){

        $domainArray = explode('.', $_SERVER['HTTP_HOST'], 2);
        $subDomain = strtolower($domainArray[0]);

        if(!UNI_LOCAL)
            $this->instId = TblSiDi::isCssSchool($subDomain);

        if(Yii::app()->request->getParam('career_plan_code')){
            $instId = Yii::app()->db->createCommand()
                    ->select('inst_ref_id')
                    ->from(StudentCareerPlanCode::model()->tableSchema->name)
                    ->where('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => Yii::app()->request->getParam('career_plan_code')))
                    ->queryScalar();
            if($instId) $this->instId = $instId;
        }

        
        if($this->instId){
            $this->isCssAccess = TRUE;
            $result = StudentUploadMasterNoEmail::getPendingStudentDetailByClass($this->instId);
            foreach($result as $studentDetails){
                if($studentDetails['first_name'] != ''){
                    $this->cssStudentNames[$studentDetails['student_upload_master_no_email_id']]['first_name'] = $studentDetails['first_name'];
                    $this->cssStudentNames[$studentDetails['student_upload_master_no_email_id']]['last_name'] = $studentDetails['last_name'];
                    $this->cssStudentNamesList[$studentDetails['student_upload_master_no_email_id']] = $studentDetails['first_name'].' '.$studentDetails['last_name'];
                }
            }

        }
        if(!UNI_LOCAL) {
            if($subDomain != '' && $subDomain != 'www' && $subDomain != VHOST && !$this->isCssAccess){
                $this->redirect(PROTOCOL.$domainArray[1].'/app/home');
            }
        }
    }

    public function actionPopupSignUp() {

        if($this->isMobile){
            $this->redirect('MSignUp');
            Yii::app()->end();
        }
        $this->canonicalUrl = 'https://www.univariety.com/app/student/createProfile/signup';
        $this->setPageTitle(Yii::app()->name ." - Create an Account");

        $this->checkCssAccess();
        $instId = '';

        if (0 !== strpos($_SERVER['HTTP_HOST'], 'www')) { // not start with www
            $hostName = explode(".", $_SERVER['HTTP_HOST']);
            if($hostName[1] != "com") {
                $subDomainName = $hostName[0];
                $signupModel = new StudentSignup();
                $schoolData = $signupModel->getSchoolNameBySubdomain($subDomainName)->attributes;
                if($schoolData['school_id']){
                    $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolData['school_id']);
                    $instId = $siDiData->inst_id;
                }
            }
        }

        if (Yii::app()->session->itemAt('sUserUnivariety') != '') {
            $userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
            $userId = $userSession['UserId'];
            CommonUtils::checkUserRedirection($userId);
        }

        $model = new StudentSignupB2C('profile');

        if(Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest){
            $errors = json_decode(CActiveForm::validate($model));
            if (isset($errors->StudentSignupB2C_username) && Yii::app()->request->getParam('carrer-plan') && preg_match('/Email address already registered/i', $errors->StudentSignupB2C_username[0])) {
                $errors->StudentSignupB2C_username[0] = '<div class="holder"><p>Email already registered. <a href="/app/login/PopupLogin?carrer-plan=yes">Login</a></p></div>';
            }

            if(Yii::app()->request->getParam('career_plan_code') && !StudentCareerPlanCode::model()->find('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => Yii::app()->request->getParam('career_plan_code')))){
                if($errors){
                    $errors->career_plan_code = array('<div class="holder"><p>Invalid coupon code</p></div>');
                }else{
                    $errors['career_plan_code'] = array('<div class="holder"><p>Invalid coupon code</p></div>');
                }
            }
            echo json_encode($errors);
            Yii::app()->end();
        }

        if(Yii::app()->request->isPostRequest){

            $model->attributes = Yii::app()->request->getParam('StudentSignupB2C', array());
            if($model->validate()){
                $postData = Yii::app()->request->getPost('StudentSignupB2C');

                $emailHash = (!empty($postData['username'])) ? md5($postData['username']) : Yii::app()->request->getParam('hashkey');
                if(!empty($emailHash)){
                    $studentSignupModel = new StudentSignup();
                    $result = $studentSignupModel->getInvitedStudentsBasicInfo($emailHash);

                    if ($result) {
                        $invitedStudentInfo = $result->attributes;
                        $instId = $invitedStudentInfo['inst_ref_id'];
                    }
                }

                if(Yii::app()->request->getParam('coupon_code')){ //career_plan_code
                    $StudentCareerPlanCode = StudentCareerPlanCode::model()->find('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => Yii::app()->request->getParam('coupon_code')));
                    if($StudentCareerPlanCode){
                        $instId = $StudentCareerPlanCode->inst_ref_id;
                        $StudentCareerPlanCode->used_on = date('Y-m-d H:i:s');
                        $StudentCareerPlanCode->band_ref_id = Yii::app()->request->getParam('career_band_name');
                    }
                }

                if ($instId > 0) {
                    $result = TblSiDi::GetSchoolLookupId($instId);
                    $instInfo = $result->attributes;
                } elseif (0 !== strpos($_SERVER['HTTP_HOST'], 'www')) { // not start with www
                    $hostName = explode(".", $_SERVER['HTTP_HOST']);
                    if($hostName[1] != "com") {
                        $subDomainName = $hostName[0];
                        $schoolData = $studentSignupModel->getSchoolNameBySubdomain($subDomainName)->attributes;
                        if($schoolData['school_id']){
                            $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolData['school_id']);
                            $instId = $siDiData->inst_id;
                        }
                    }
                } else {
                    $instId = 'null';
                }

                $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,'label' => 'new_profile',), 1);
                if($postData['is_visited_school'] == 'N' && in_array($postData['present_class'], array(11, 12))) {
                    $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,'label' => 'new_b2csignup',), 1);
                }
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                //$redirectUrlRefId = '/app/myProfile';
                $afterSignupRedirectUrl = $urlDetails[0]['url'];

                $studentSignupModel = new StudentSignup('firstPage');
                $uniqueId = md5($studentSignupModel->getUniqueID("uid"));
                $studentSignupModel->set_session("unique_id", $uniqueId);
                $this->current_class = $postData['present_class'];

                $loginMasterData = array('username' => $postData['username'], 'pass_word' => md5($postData['password']),
                    'user_type_ref_id' => 1, 'is_active' => 1, 'is_email_confirmed' => 0,'added_on' => date('Y-m-d H:i:s'));

                $loginMasterModel = new LoginMaster;
                $loginMasterModel->setAttributes($loginMasterData);
                $loginMasterModel->save();
                $this->loginRefId = $loginMasterModel->login_id;

                $userUNO = $studentSignupModel->generateUserUNO('IN');
                $userMembershipRefId = ($instId > 0) ? $studentSignupModel->getMembershipId('SI Student') :$studentSignupModel->getMembershipId('Guest');

                $class_data = $this->DynamicPassoutYearAndMonth();

                $schoolRefId = NULL;
                if($instId > 0){
                    $siRes = TblSiDi::model()->findByPk($instId);
                    $schoolRefId = $siRes->school_ref_id;
                }

                if($postData['city_id']){
                    $cityRes = TblCityMaster::model()->findByPk($postData['city_id']);
                    $city = $postData['city_id'];
                } else{
                    $cityRes = TblCityMaster::model()->findByAttributes(array('city_name'=> $postData['city']));
                    $city = $cityRes->city_id;
                }
                $userMasterData = array('login_ref_id' => $this->loginRefId, 'uno' => $userUNO,

                    'membership_ref_id' => $userMembershipRefId['membership_id'],
                    'present_class' => $class_data['present_class'],
                    'class_status' => $class_data['class_status'],
                    'passout_year' => $class_data['passout_year'],
                    'passout_month' => 6,
                    'gender' => $postData['gender'],
                    'is_visited_school' => $postData['is_visited_school'],
                    'city_ref_id' => $city ? $city : null,
                    'country_ref_id' => $cityRes->country_id ? $cityRes->country_id : null,
                    'profile_status_ref_id' => '3',
                    'signup_source_ref_id' => '148',
                    'added_on' => date('Y-m-d H:i:s'),
                );
                if($postData['full_name']) {
                    Yii::import('application.controllers.MyProfileController');
                    $obj = new MyProfileController(); // preparing object
                    $name = $obj->separateFirstAndLastName($postData['full_name']);
                    $userMasterData['last_name']  = $name['last_name'];
                    $userMasterData['first_name']  = $name['first_name'];
                }
                $userMasterModel = new TblUserMaster;
                $userMasterModel->scenario='register';
                if($schoolRefId){
                    $userMasterData['school_ref_id'] = $schoolRefId;
                }
                $userMasterModel->setAttributes($userMasterData, FALSE);

                $userMasterModel->save(false);

                $userModel = TblUserMaster::model()->findByPk($userMasterModel->user_id);
                $userModel->signup_source_ref_id = 148;
                $userModel->save(false);

                $student_det = TblUserMaster::model()->findByAttributes(array('login_ref_id'=>$this->loginRefId));

                if($postData['is_visited_school'] == 'Y') {
                    if(trim($postData['school_name']) != ''){
                        $this->SaveB2BInfo($student_det->user_id);
                    }
                }
                if($StudentCareerPlanCode && $userMasterModel->user_id){
                    $StudentCareerPlanCode->user_ref_id = $userMasterModel->user_id;
                    $StudentCareerPlanCode->save(FALSE);
                }
                $criticalFields = array(
                    'study_level'=>1,
                    'edu_study_level'=>1,
                    'name' => 1,
                    'gender' => 1,
                    'completion_year' => 1
                );

                if($student_det->user_id){
                    $preferredStudyLevelObj = new StudentPreferredStudyLevel();
                    $preferredStudyLevelObj->insertPreferredStudyLevelByUserId($student_det->user_id, 5);
                }

                TblUserProfCriticalCompletion::updateCriticalFields($student_det->user_id, $criticalFields);
                $studentSignupModel->setRbacAssignment('Student', $this->loginRefId);
                $this->sendConfirmationEmail('', $postData['username'], $student_det->user_id);
                Yii::app()->session['signupProcess'] = 'guestSignup';

                TblUserMaster::updateUserFields($student_det->user_id, array('redirect_url_ref_id' => $redirectUrlRefId));

                //inserting to tbl_si_students if he is related to a School
                if ($instId > 0) {
                    //$studentSignupModel->setSiStudents($student_det->user_id, $instId);
                }

                // Saving signup step
                if(in_array($student_det->present_class, array(11, 12)) && $postData['is_visited_school'] == 'N') {
                    $step = new SignupSteps();
                    $step->added_on = date('Y-m-d H:i:s');
                    $step->user_ref_id = $student_det->user_id;
                    $step->step_no = 1;
                    $step->save();
                }
                $loginModel = new LoginMaster();

                $redirectURL = Yii::app()->request->getParam('redirectURL',null);

                if($redirectURL){
                    $loginModel->loginWithRedirectPopup($postData['username'], $postData['password'], $redirectURL);

                }elseif($_COOKIE['url']){
                    $loginModel->loginWithRedirectPopup($postData['username'], $postData['password'], $_COOKIE['url']);
                } else {
                    $loginModel->loginWithRedirectPopup($postData['username'], $postData['password'], $afterSignupRedirectUrl);
                }
            }
        }

        $template = Yii::app()->request->getParam('carrer-plan') ? 'popup_signup_plan' : 'popup_signup';

        $this->renderPartial($template,array('model'=>$model,'siDiData'=>$siDiData),false, true);
    }

    public function actionGetSchoolList() {
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        $cityId = Yii::app()->getRequest()->getParam('cityId', false);
        if ($term) {
            $res = LookupSchool::getSchoolList($term,$cityId);
            $val = array();
            if ($res) {$i = 1;
                foreach ($res as $r) {
                    $val[] = array(
                        'id' => $r['school_id'],
                        'label' => $r['school_name'],
                    );
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function SaveB2BInfo($user_id) {
        $postData = Yii::app()->request->getPost('StudentSignupB2C');
        $schoolExistID = $postData['school_id'];
        if(!$schoolExistID){
            $schoolExistID = LookupSchool::getSchoolID(trim($postData['school_name']));
        }
        $userInfo = TblUserMaster::model()->findByPk($user_id);
        // priority school code,coupon code and next is the school name enter
        $schoolCodeData = TblSiDi::getInstIdFromSchoolCode($postData['school_code']);
        $couponCodeData = StudentCareerPlanCode::model()->find('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => $postData['coupon_code']));
        $siDiRes = TblSiDi::GetInstIdFromSchoolId($schoolExistID);
        if($schoolCodeData->school_ref_id == $schoolExistID && $postData['school_code']){
            $siDiData = TblSiDi::getInstIdFromSchoolCode($postData['school_code']);
            if($siDiData->inst_id){
                $instId = $siDiData->inst_id;
                $schoolExistID = $siDiData->school_ref_id;
                $userInfo->user_entered_code = 'SchoolCode';
                //inserting to tbl_si_students if he is related to a School
                $studentSignupModel = new StudentSignup('firstPage');
                $studentSignupModel->setSiStudents($user_id, $instId);
            }
        }
        else if($schoolCodeData && $postData['school_code']){
            $siDiData = TblSiDi::getInstIdFromSchoolCode($postData['school_code']);
            if($siDiData->inst_id){
                $instId = $siDiData->inst_id;
                $schoolExistID = $siDiData->school_ref_id;
                $studentSignupModel = new StudentSignup('firstPage');
                $studentSignupModel->setSiStudents($user_id, $instId);
            }
        }
        else if($couponCodeData->inst_ref_id == $siDiRes->inst_id){
            $siDiData = StudentCareerPlanCode::model()->find('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => $postData['coupon_code']));
            if($siDiData->inst_ref_id){
                $instId = $siDiData->inst_ref_id;
                $schoolExistID = $siDiData->instRef->school_ref_id;
                $userInfo->user_entered_code = 'CouponCode';
                //inserting to tbl_si_students if he is related to a School
                $studentSignupModel = new StudentSignup('firstPage');
                $studentSignupModel->setSiStudents($user_id, $instId);
            }
        }
        else if($couponCodeData){
            $siDiData = StudentCareerPlanCode::model()->find('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => $postData['coupon_code']));
            if($siDiData->inst_ref_id){
                $instId = $siDiData->inst_ref_id;
                $schoolExistID = $siDiData->instRef->school_ref_id;
                $studentSignupModel = new StudentSignup('firstPage');
                $studentSignupModel->setSiStudents($user_id, $instId);
            }
        }
        else if($schoolExistID){
            $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolExistID);
            if($siDiData->inst_id){
                $instId = $siDiData->inst_id;
                if($_POST['sub_domain']){
                    $userInfo->user_entered_code = 'SubDomain';
                }
                //inserting to tbl_si_students if he is related to a School
                $studentSignupModel = new StudentSignup('firstPage');
                $studentSignupModel->setSiStudents($user_id, $instId);
            } else {
                $instId = 'null';
            }
        }
        $userMembershipRefId = ($instId > 0) ? 2 : 1; // 2 for SI and 1 for guest
        $userInfo->membership_ref_id = $userMembershipRefId;
        if($schoolCodeData && $couponCodeData && $postData['school_code'] && $postData['coupon_code']){
            $userInfo->user_entered_code = 'Both';
        }

        if ($schoolExistID) {
            $userInfo->school_ref_id = $schoolExistID;
        } else {
            $checkSchool = LookupSchool::getUserSchoolID(trim($postData['school_name']));
            if(!$checkSchool){
                LookupSchool::addStudentSchool(trim($postData['school_name']));
            }
            $schoolExistID = LookupSchool::getUserSchoolID(trim($postData['school_name']));
            $userInfo->school_ref_id = $schoolExistID;
        }
        $userInfo->save(false);

        if($postData['coupon_code']) {
            $couponCode = StudentCareerPlanCode::model()->find('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => $postData['coupon_code']));
            if($couponCode){
                $couponCode->user_ref_id = $user_id;
                $couponCode->band_ref_id = $postData['band'];
                $couponCode->used_on = date('Y-m-d H:i:s');
                $couponCode->save(false);
            }
        }
    }

    public function actionGetPopulateAllCities()
    {
        $term = Yii::app()->request->getParam('term');
        $cities = array();

        $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND (city_name LIKE '".$term."%' OR synonym_names LIKE '".$term."%') GROUP BY city_name ", "order" => "city_name","limit"=>10));
        foreach ($result as $city) {
            $cities[] = array('id' => $city->city_id, 'value' => $city->city_name);
        }
        echo CJSON::encode($cities);

        Yii::app()->end();

    }
}