<?php
class CareerplanController extends Controller {

    public $layout = "//layouts/new_grid_inner";
    public $studentID;

    public function init(){
        parent::init();
        Yii::app()->theme = 'new_grid_theme';
        $this->studentID =  Yii::app()->request->getParam('uid', Yii::app()->session->get('studentID'));

        // force logger off
        foreach (Yii::app()->log->routes as $route){
            if ($route instanceof CWebLogRoute){
                $route->enabled = false;
            }
        }
    }

    public function actionDataPlan(){

        $studentID = $this->studentID;
        $userModel = TblUserMaster::model()->findByPk($studentID);
        $careerPlan = new CustomCareerPlan($userModel->user_id);
        $steps = $careerPlan->getPlanningSteps();
        if(in_array($userModel->present_class, array(11, 12))){
            $profilePercentage = CommonUtils::calculateCriticalPercentage($userModel->user_id);
            echo json_encode(array('profilescore'=> $profilePercentage, 'steps'=>$steps));
        }else{
            echo json_encode(array('steps'=>$steps));
        }
    }

    public function actionConfirmChoice(){

        $choice = Yii::app()->request->getParam('choice', false);
        $date = date('Y-m-d H:i:s');
        $verificationModel = ProfileVerificationScore::model()->findByAttributes(array(
            'user_ref_id'=>$this->studentID));
        if(!$verificationModel){
            $verificationModel = new ProfileValidationScore;
            $verificationModel->user_ref_id = $this->studentID;
        }
        if($choice == 'country'){
            $verificationModel->pref_country = 1;
            $verificationModel->pref_country_score = 1;
            $verificationModel->pref_country_date = $date;
            $verificationModel->pref_country_score_date = $date;
        }else if($choice == 'major'){
            $verificationModel->pref_dept = 1;
            $verificationModel->pref_dept_score = 1;
            $verificationModel->pref_dept_date = $date;
            $verificationModel->pref_dept_score_date = $date;
        }
        $verificationModel->save(false);
    }

    public function actionCountryPreferences(){

        $studentID =  $this->studentID;
        $countryInterests = StudentPreferredCountry::model()->findAllByAttributes(array('user_ref_id'=> $studentID, 'not_sure'=>'0'), array('order'=>'preference_order ASC'));
        $countryNames = array();
        $validCountries = false;
        if($countryInterests){
            foreach($countryInterests as $countryInterest){
                $countryNames[] = array('name'=>$countryInterest->countryRef->country_name);
            }
            $careerPlan = new CustomCareerPlan($studentID);
            $validCountries = $careerPlan->hasValidCountryChoices();

        }
        echo CJSON::encode(array('validCountries'=> $validCountries, 'countryNames'=>$countryNames));
    }

    public function actionMajorPreferences(){

        $studentID =  $this->studentID;
        $majorInterests = StudentPreferredDepartment::model()->findAllByAttributes(array('user_ref_id'=> $studentID, 'not_sure'=>'0'), array('order'=>'preference_order ASC'));
        $majorNames = array();
        $validMajors = false;
        if($majorInterests){
            foreach($majorInterests as $majorInterest){
                $majorNames[] = array(
                    'name'=>$majorInterest->mainDeptRef->department_name,
                    'sub_dept_name'=>$majorInterest->subDeptRef->department_name,
                );
            }
            $careerPlan = new CustomCareerPlan($studentID);
            $validMajors = $careerPlan->hasValidMajorChoices();

        }
        echo CJSON::encode(array('validMajors'=> $validMajors, 'majorNames'=>$majorNames));
    }

    public function actionUpdateCountryPreferences(){

        $formModel = new CareerPlanFormModel;
        $studentID =  $this->studentID;

        if(isset($_POST['ajax'])){
            echo CActiveForm::validate($formModel);
            Yii::app()->end();
        }

        if (isset($_POST['CareerPlanFormModel'])) {
            $formModel->attributes = $_POST['CareerPlanFormModel'];
            $formModel->saveCountryPreferencesInfo($studentID);
            echo json_encode(array('msg_cls' => 'success_notify', 'msg_notification' => 'profile_info_updated', 'replaceKeys' => array('NAME' => 'country preferences')));
            OfflineF2fCounsellor::localChange($studentID);
            Yii::app()->end();
        }

        $this->renderPartial('update_country_preferences', compact('studentID', 'formModel'), false, true);
    }

    public function actionUpdateMajorPreferences(){

        $formModel = new CareerPlanFormModel;
        $studentID =  $this->studentID;

        if(isset($_POST['ajax'])){
            echo CActiveForm::validate($formModel);
            Yii::app()->end();
        }

        if (isset($_POST['CareerPlanFormModel'])) {
            $formModel->attributes = $_POST['CareerPlanFormModel'];
            $formModel->saveMajorPreferencesInfo($studentID);
            echo json_encode(array('msg_cls' => 'success_notify', 'msg_notification' => 'profile_info_updated', 'replaceKeys' => array('NAME' => 'major preferences')));
            OfflineF2fCounsellor::localChange($studentID);
            Yii::app()->end();
        }

        $this->renderPartial('update_major_preferences', compact('studentID', 'formModel'), false, true);
    }

    public function actionPartialForm(){

        $requestFor = Yii::app()->request->getParam('requestFor', false);
        $model      = new CareerPlanFormModel;
        switch($requestFor){

            case 'majorOfInterest':
                $this->renderPartial('_major_of_interest', array(
                    'model'=> $model,
                ), true);

                echo $this->clips['majorOfInterest'];
                break;

            case 'countryOfInterest':
                $this->renderPartial('_country_of_interest', array(
                    'model'=> $model,
                ), true);

                echo $this->clips['countryOfInterest'];
                break;

        }
    }

    public function actionSearchTestsByTerm(){

        $term = Yii::app()->request->getParam('term', false);
        $exams = EntranceExam::getEntranceFullnameListAuto($term);
        $options = array();
        if($exams){
            foreach($exams as $exam){
                $shortName = $exam->entrance_short_name;
                $fullName  = $exam->entrance_full_name;
                $options[] = array(
                    'value' => strpos($fullName, $shortName) !== false ? $fullName : $fullName.' ('.$shortName.')',
                    'id'    => $exam->entrance_id,
                     'shortname'=>$shortName,
                );
            }
        }
        echo CJSON::encode($options);
    }

    public function actionShortlistedTests(){

        $studentID =  $this->studentID;
        $shortlistedTests = UserEntranceExam::model()->with('entranceExamRef')->findAll(array(
            'condition'=>"t.user_ref_id=:userID AND t.shortlist_status = '1' AND entranceExamRef.is_active='1'",
            'params'=>array(':userID'=>$studentID),
            'order'=>'t.added_on DESC'
        ));
        $testsInfo = array();
        if($shortlistedTests){
            foreach($shortlistedTests as $shortlistedTest){
                $shortName = $shortlistedTest->entranceExamRef->entrance_short_name;
                $fullName  = $shortlistedTest->entranceExamRef->entrance_full_name;
                $testsInfo[] = array(
                    'id'   => $shortlistedTest->entrance_exam_ref_id,
                    'name' => strpos($fullName, $shortName) !== false ? $fullName : $fullName.' ('.$shortName.')',
                );
            }
        }
        echo CJSON::encode($testsInfo);
    }

    public function actionViewRequiredTestsTmpl(){

        $studentID =  $this->studentID;
        $countryInterests = StudentPreferredCountry::model()->findAllByAttributes(array('user_ref_id'=> $studentID, 'not_sure'=>'0'), array('order'=>'preference_order ASC'));
        $prefCountries = $allCountries = array();
        if($countryInterests){
            $prefCountries = CHtml::listData($countryInterests, 'country_ref_id', 'countryRef.country_name');
            $allCountries['Finalised Countries'] = $prefCountries;
        }

        $topCountries = TblCountryMaster::getUnivarietyCountries();
        $topCountriesArr = CHtml::listData($topCountries,'country_id', 'country_name');
        $allCountries['Top Countries'] = array_diff($topCountriesArr, $prefCountries);
        $otherCountryList = TblCountryMaster::getCountryList();
        $allCountries['Others'] = array_diff($otherCountryList, array_diff($topCountriesArr, $prefCountries));

        $majorInterests = StudentPreferredDepartment::model()->findAllByAttributes(array('user_ref_id'=> $studentID, 'not_sure'=>'0'), array('order'=>'preference_order ASC'));
        $prefDepts = $allMajors = array();
        if($majorInterests){
            $prefDepts = CHtml::listData($majorInterests, 'main_dept_ref_id', 'mainDeptRef.department_name');
            $allMajors['Finalised Majors'] = $prefDepts;
        }
        $otherDepts = LookupDepartment::getMainDepartmentList();
        $allMajors['Top Majors'] = array_diff($otherDepts, $prefDepts);

        $this->renderPartial('cp_view_required_tests',compact('allCountries', 'allMajors'));
    }

    public function actionFindRequiredTests(){

        $studentID =  $this->studentID;
        $countryID = Yii::app()->request->getParam('cid', false);
        $deptID    = Yii::app()->request->getParam('did', false);
        $testsInfo = array();
        if($countryID && $deptID){
            if($countryID == 100){
                $Sql = "Select t.* FROM entrance_exam t
                LEFT JOIN entrance_exam_ranking eer ON eer.entrance_exam_ref_id = t.entrance_id
                LEFT JOIN entrance_exam_ranking_department erd ON erd.entrance_exam_ranking_ref_id = eer.entrance_exam_ranking_id
                WHERE erd.main_department_ref_id = '".$deptID."' AND eer.country_ref_id = '".$countryID."'
                 AND t.type_of_exam IN ('National', 'State', 'College') AND t.is_active=1 GROUP BY t.entrance_full_name
                  ORDER BY (CASE t.type_of_exam WHEN 'National' THEN 1 WHEN 'State' THEN 2 ELSE 3 END), ISNULL(erd.rank), erd.rank ASC";
                $tests =Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
            }else{
                $tests = EntranceExam::getTestListByType($countryID,$deptID,0,'International',0,10);
            }

            if($tests){

                $shortlistedSql = "SELECT GROUP_CONCAT(DISTINCT entrance_exam_ref_id) AS tests FROM user_entrance_exam WHERE user_ref_id='".$studentID."' AND shortlist_status=1";
                $shortlistedRes = Yii::app()->db->createCommand($shortlistedSql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
                $shortlistedTests = $shortlistedRes && $shortlistedRes->tests ? explode(',', $shortlistedRes->tests) : array();

                foreach($tests as $test){
                    $test = (object) $test;
                    $testsInfo[] = array(
                        'id'   => $test->entrance_id,
                        'name' => $test->entrance_short_name,
                        'link' => UniversityHelper::getTestUrl($test->entrance_id),
                        'full_name' => $test->entrance_full_name,
                        'shortlisted' => in_array($test->entrance_id, $shortlistedTests),
                        'category' => $test->category,
                        'type' => $test->type_of_exam,
                        'need_coaching' => $test->coaching_required1,
                        'last_year_students' => $test->students_appeared_last_year,
                    );
                }
            }
        }
        echo CJSON::encode($testsInfo);

    }

    public function actionAddTestToShortlist(){

        $studentID =  $this->studentID;
        $testID = Yii::app()->request->getParam('testID', false);
        if($testID){
            $testModel = UserEntranceExam::model()->findByAttributes(array(
                'user_ref_id'=> $studentID, 'entrance_exam_ref_id'=>$testID));
            if($testModel){
                $testModel->shortlist_status = '1';
                $testModel->added_on = date('Y-m-d H:i:s');
            }else{
                $testModel = new UserEntranceExam();
                $testModel->setAttributes(array(
                    'user_ref_id'=> $studentID,
                    'entrance_exam_ref_id'=>$testID,
                    'shortlist_status'=>1,
                    'added_by'=>Yii::app()->user->id,
                    'added_on'=> date('Y-m-d H:i:s'),
                ));
            }
            $testModel->save(false);
            OfflineF2fCounsellor::localChange($studentID);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'UserEntranceExam');
        }
    }

    public function actionRemoveTestFromShortlist(){

        $studentID =  $this->studentID;
        $testID = Yii::app()->request->getParam('testID', false);
        if($testID){
            $testModel = UserEntranceExam::model()->findByAttributes(array(
                'user_ref_id'=> $studentID, 'entrance_exam_ref_id'=>$testID));
            if($testModel){
                $testModel->shortlist_status = '0';
                $testModel->save(false);
                OfflineF2fCounsellor::localChange($studentID);
                OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'UserEntranceExam');
            }
        }
    }

    public function actionViewCoachingCentersTmpl(){
        $this->renderPartial('cp_view_coaching_centers');
    }

    public function actionShortlistedCenters(){

        Yii::import('application.modules.vendor.models.VendorCentre');

        $studentID =  $this->studentID;
        $shortlistedCenters = StudentShortlistVendor::model()->with('vendorCentreRef')->findAllByAttributes(array('user_ref_id'=> $studentID), array('order'=>'t.added_on DESC'));
        $centersInfo = array();
        if($shortlistedCenters){
            foreach($shortlistedCenters as $shortlistedCenter){
                $centersInfo[] = array(
                    'id'   => $shortlistedCenter->vendor_centre_ref_id,
                    'name' => $shortlistedCenter->vendorCentreRef->centre_name,
                );
            }
        }
        $Sql = "SELECT need_coaching FROM tbl_user_master WHERE user_id='".$studentID."'";
        $coaching_needed = Yii::app()->db->createCommand($Sql)->queryScalar();

        echo CJSON::encode(array('centers'=>$centersInfo, 'coaching_needed'=>$coaching_needed));
    }

    public function actionAddCenterToShortlist(){

        $studentID =  $this->studentID;
        $centerID = Yii::app()->request->getParam('centerID', false);
        if($centerID){
            $centerModel = StudentShortlistVendor::model()->findAllByAttributes(array(
                'user_ref_id'=> $studentID, 'vendor_centre_ref_id'=>$centerID));
            if(!$centerModel){
                $centerModel = new StudentShortlistVendor;
                $centerModel->setAttributes(array(
                    'user_ref_id'=> $studentID,
                    'vendor_centre_ref_id'=>$centerID
                ), false);
                $centerModel->save(false);
                OfflineF2fCounsellor::localChange($studentID);
                OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'UserEntranceExam');
            }
        }
    }

    public function actionRemoveCenterFromShortlist(){

        $studentID =  $this->studentID;
        $centerID = Yii::app()->request->getParam('centerID', false);
        if($centerID){
            $centerModel = StudentShortlistVendor::model()->findAllByAttributes(array(
                'user_ref_id'=> $studentID, 'vendor_centre_ref_id'=>$centerID));
            if($centerModel){
                foreach($centerModel as $model){
                    $model->delete();
                }
                OfflineF2fCounsellor::localChange($studentID);
                OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'UserEntranceExam');
            }
        }
    }

    public function actionUpdateCoachingNeeded(){

        $studentID =  $this->studentID;
        $status = Yii::app()->request->getParam('status', false);
        if($status){
            $userModel = TblUserMaster::model()->findByPk($studentID);
            $userModel->need_coaching = $status;
            $userModel->save();
        }
    }

    public function actionFindCoachingCenters(){

        $data = Yii::app()->request->getParam('formdata', array());
        $studentID =  $this->studentID;
        $CentersInfo = array();
        if($data['lat'] && $data['lat'] && $data['test_id']){

        $Sql = "SELECT vc.vendor_centre_id, vc.centre_name, tcm.city_name, vc.address2,
         ll.locality_name, IF(ssv.student_shortlist_vendor_id, 1, 0) AS shortlisted,
          vc.establishment_year, vc.is_registered,
         ( 6371 * acos( cos( radians(".$data['lat'].") ) * cos( radians( vc.latitude ) ) * cos( radians( vc.longitude ) - radians(".$data['lng'].") ) + sin( radians(".$data['lat'].") ) * sin( radians( vc.latitude ) ) ) ) AS distance
        FROM vendor_centre_course_test vcct
        JOIN vendor_centre_course vcc ON vcc.vendor_centre_course_id = vcct.vendor_centre_course_ref_id
        JOIN vendor_centre vc ON vc.vendor_centre_id = vcc.vendor_centre_ref_id
        JOIN entrance_exam ee ON ee.entrance_id = vcct.entrance_ref_id
        LEFT JOIN lookup_locality ll ON ll.locality_id = vc.locality_ref_id
        LEFT JOIN student_shortlist_vendor ssv ON ssv.vendor_centre_ref_id = vc.vendor_centre_id
        AND ssv.user_ref_id = '".$studentID."'
        LEFT JOIN tbl_city_master tcm ON tcm.city_id = vc.city_ref_id
        WHERE 1=1 AND vc.is_active=1 AND entrance_id = '".$data['test_id']."'
        GROUP BY vc.vendor_centre_id HAVING distance < 20
        ORDER BY (CASE vc.is_registered WHEN 'Y' THEN '1' ELSE '0' END)  DESC, distance  LIMIT 10";
            $Centers =Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
            if($Centers){
                foreach($Centers as $Center){

                    $address = implode(', ', array_filter(array($Center->locality_name ? $Center->locality_name : $Center->address2, $Center->city_name), 'strlen'));

                    $CentersInfo[] = array(
                        'id'   => $Center->vendor_centre_id,
                        'name' => $Center->centre_name,
                        'link' => $this->createUrl('/testexperts/expert',array('center' => $Center->vendor_centre_id)),
                        'address'=>$address,
                        'verified'=>$Center->is_registered,
                        'shortlisted' => $Center->shortlisted ? true : false,
                        'establishment_year' => $Center->establishment_year,
                        'distance'=> round($Center->distance)
                    );
                }
            }
        }

        echo CJSON::encode($CentersInfo);
    }

    public function actionSearchCollegesByTerm(){

        $term = Yii::app()->request->getParam('term', false);
        $sql ="SELECT tum.uni_id, tum.uni_name FROM tbl_university_master tum WHERE tum.is_active = 'Y'
        AND tum.is_user_entered ='0' AND tum.uni_name LIKE :qterm1 ORDER BY ( CASE WHEN tum.uni_name LIKE :qterm2 THEN 0 ELSE 1 END ),
        tum.uni_name LIMIT 10";
        $command =Yii::app()->db->createCommand($sql);
        $command->bindValue(":qterm1", '%'.$term.'%', PDO::PARAM_STR);
        $command->bindValue(":qterm2", $term.'%', PDO::PARAM_STR);
        $colleges =$command->setFetchMode(PDO::FETCH_OBJ)->queryAll();

        $options = array();
        if($colleges){
            foreach($colleges as $college){
                $options[] = array('value'=>$college->uni_name, 'id'=>$college->uni_id);
            }
        }
        echo CJSON::encode($options);
    }

    public function actionShortlistedColleges(){

        $studentID =  $this->studentID;
        $shortlistedColleges = StudentShortlistUniversity::model()->with('uniRef')->findAll(array(
            'condition'=>"t.user_ref_id=:userID AND t.shortlist_status != 'Reject' AND uniRef.is_active='Y'",
            'params'=>array(':userID'=>$studentID),
            'order'=>'t.added_on ASC'
        ));
        $collegesInfo = array();
        if($shortlistedColleges){
            foreach($shortlistedColleges as $shortlistedCollege){
                $collegesInfo[] = array(
                    'id'   => $shortlistedCollege->uni_ref_id,
                    'name' => $shortlistedCollege->uniRef->uni_name,
                );
            }
        }
        $careerPlan = new CustomCareerPlan($studentID);
        $countries = $careerPlan->getStudentPrefCountries();
        $majors    = $careerPlan->getStudentPrefDepartments();

        echo CJSON::encode(array('colleges'=>$collegesInfo, 'hascountrynmajor'=> $countries && $majors));
    }

    public function actionAddCollegeToShortlist(){

        $studentID =  $this->studentID;
        $uniID = Yii::app()->request->getParam('collegeID', false);
        $uniName = Yii::app()->request->getParam('collegeName', false);
        if($uniName){
            $uniModel = TblUniversityMaster::model()->findByPk($uniID);
            if(!$uniModel){
                $uniModel = TblUniversityMaster::model()->findByAttributes(array('uni_name' => $uniName));
            }
            if(!$uniModel){
                // create univ
                $uniModel=new TblUniversityMaster();
                $uniModel->setAttributes(array(
                    'uni_name'=> $uniName,
                    'is_user_entered'=> 1,
                    'is_active' => 'Y',
                    'added_by'=>Yii::app()->user->id,
                    'added_on'=> date('Y-m-d H:i:s'),
                ), false);
                $uniModel->save(false);
            }
            $model = StudentShortlistUniversity::model()->findByAttributes(array(
                'user_ref_id'=> $studentID, 'uni_ref_id'=>$uniModel->uni_id));
            if($model){
                $model->shortlist_status = 'MightApply';
                $model->modified_by = Yii::app()->user->id;
                $model->modified_on = date('Y-m-d H:i:s');
            }else{
                $model = new StudentShortlistUniversity();
                $model->setAttributes(array(
                    'user_ref_id'=> $studentID,
                    'uni_ref_id'=>$uniModel->uni_id,
                    'shortlist_status'=>'MightApply',
                    'added_by'=>Yii::app()->user->id,
                    'added_on'=> date('Y-m-d H:i:s'),
                ), false);
            }
            $model->save(false);
            OfflineF2fCounsellor::localChange($studentID);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'UserEntranceExam');
        }

        echo CJSON::encode(array('id'=>$uniModel->uni_id, 'name'=>$uniModel->uni_name));

    }

    public function actionRemoveCollegeFromShortlist(){

        $studentID = $this->studentID;
        $collegeID = Yii::app()->request->getParam('collegeID', false);
        if($collegeID){
            $model = StudentShortlistUniversity::model()->findByAttributes(array(
                'user_ref_id'=> $studentID, 'uni_ref_id'=>$collegeID));
            if($model){
                $model->delete();
            }
            OfflineF2fCounsellor::localChange($studentID);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'UserEntranceExam');
        }
    }

    public function actionViewSuggestedCollegesTmpl(){

        $studentID =  $this->studentID;
        $countryInterests = StudentPreferredCountry::model()->findAllByAttributes(array('user_ref_id'=> $studentID, 'not_sure'=>'0'), array('order'=>'preference_order ASC'));
        $prefCountries = array();
        if($countryInterests){
            $prefCountries = CHtml::listData($countryInterests, 'country_ref_id', 'countryRef.country_name');
        }

        $majorInterests = StudentPreferredDepartment::model()->findAllByAttributes(array('user_ref_id'=> $studentID, 'not_sure'=>'0'), array('order'=>'preference_order ASC'));
        $prefMajors = array();
        if($majorInterests){
            $prefMajors = CHtml::listData($majorInterests, 'main_dept_ref_id', 'mainDeptRef.department_name');
        }

        $this->renderPartial('cp_view_suggested_colleges',compact('prefCountries', 'prefMajors'));
    }

    public function actionFindSuggestedColleges(){

        $studentID =  $this->studentID;
        $countryID = Yii::app()->request->getParam('cid', false);
        $deptID    = Yii::app()->request->getParam('did', false);
        $collegesInfo = array();
        if($countryID && $deptID){

            $countryModel = TblCountryMaster::model()->findByPk($countryID);
            $currencyModel = LookupCurrency::model()->find("country_name='".$countryModel->country_name."'");

            $Sql = "SELECT uilu.*, tum.uni_name, tcm.city_name, ts.name AS state_name, tcym.country_name
             FROM user_ideal_list uil
            JOIN user_ideal_list_university uilu ON uilu.user_ideal_list_ref_id = uil.user_ideal_list_id
            JOIN tbl_university_master tum ON tum.uni_id = uilu.uni_ref_id
            LEFT JOIN tbl_city_master tcm ON tcm.city_id = tum.city_ref_id
            LEFT JOIN tbl_state ts ON ts.id = tum.state_ref_id
            LEFT JOIN tbl_country_master tcym ON tcym.country_id = tum.country_ref_id
            WHERE uil.user_ref_id='".$studentID."' AND uil.country_ref_id='".$countryID."' AND
            uil.department_ref_id='".$deptID."' AND tum.is_active='Y' AND uil.is_active=1
            ORDER BY (CASE uilu.university_type WHEN 'BestFit' THEN 1 WHEN 'Aspirational' THEN 2 ELSE 3 END) LIMIT 10";
            $colleges =Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();

            if($colleges){

                $shortlistedSql = "SELECT GROUP_CONCAT(DISTINCT uni_ref_id) AS colleges FROM student_shortlist_university WHERE user_ref_id='".$studentID."' AND shortlist_status != 'Reject'";
                $shortlistedRes = Yii::app()->db->createCommand($shortlistedSql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
                $shortlistedColleges = $shortlistedRes && $shortlistedRes->colleges ? explode(',', $shortlistedRes->colleges) : array();

                foreach($colleges as $college){

                    if($countryID == 100){
                        $feeData = UniversityCostSummary::getAvgUniFeesByUniIdAndMainDeptId($college->uni_ref_id,$deptID);
                        $averageFee = LookupCurrencyConversion::convertCurrency($feeData->currency_ref_id, $currencyModel->currency_id, $feeData->fees_per_year);
                    }else{
                        $data = TblUniCourses::getAvgFeeOfCollegeByIdAndDept($college->uni_ref_id,$deptID);
                        $averageFee = LookupCurrencyConversion::convertCurrency($data[0]['currency_ref_id'], $currencyModel->currency_id, $data[0]['fees_per_year']);
                    }

                    $address = implode(', ',array_filter(array($college->city_name, $college->state_name, $college->country_name), 'strlen'));

                    $collegesInfo[] = array(
                        'id'   => $college->uni_ref_id,
                        'name' => $college->uni_name,
                        'link' => UniversityHelper::getUniversityUrl($college->uni_ref_id),
                        'shortlisted' => in_array($college->uni_ref_id, $shortlistedColleges),
                        'avgfee' => number_format($averageFee),
                        'currency'=> $currencyModel->html_entity,
                        'address'=> $address,
                    );
                }
            }
        }
        echo CJSON::encode($collegesInfo);
    }

    public function actionApplicationColleges(){

        $studentID =  $this->studentID;
        $shortlistedColleges = StudentShortlistUniversity::model()->with('uniRef')->findAll(array(
            'condition'=>"t.user_ref_id=:userID AND t.shortlist_status != 'Reject' AND uniRef.is_active='Y'",
            'params'=>array(':userID'=>$studentID),
            'order'=>'t.added_on DESC'
        ));
        $collegesInfo = array();
        if($shortlistedColleges){
            $uniImagePath = Yii::getPathOfAlias('webroot').'/../uploads/university/images/logo/';
            $appUrl = Yii::app()->getBaseUrl(true);
            foreach($shortlistedColleges as $shortlistedCollege){

                $uniDetails = $shortlistedCollege->uniRef;
                if($uniDetails->url_primary_key && file_exists($uniImagePath.$uniDetails->url_primary_key.'_logo.jpg')){
                    $logo = $appUrl."/../uploads/university/images/logo/" . $uniDetails->url_primary_key . "_logo.jpg";
                }else{
                    $logo = null;
                }

                $collegesInfo[] = array(
                    'id'   => $shortlistedCollege->uni_ref_id,
                    'link' => $uniDetails->url_primary_key ? UniversityHelper::getUniversityUrl($shortlistedCollege->uni_ref_id) : '',
                    'status' => str_replace(' ', '', $shortlistedCollege->shortlist_status),
                    'name' => $uniDetails->uni_name,
                    'logo' => $logo,
                );
            }
        }
        echo CJSON::encode($collegesInfo);
    }

    public function actionUpdateApplicationStatus(){

        $studentID =  $this->studentID;
        $uniID = Yii::app()->request->getParam('id', false);
        $status = Yii::app()->request->getParam('status', false);
        if($uniID && $status){
            $model = StudentShortlistUniversity::model()->findByAttributes(array(
                'user_ref_id'=> $studentID, 'uni_ref_id'=>$uniID));
            if($model){
                $model->shortlist_status = $status;
                $model->modified_by = Yii::app()->user->id;
                $model->modified_on = date('Y-m-d H:i:s');
            }
            $model->save(false);
            if($status == 'MightApply'){
                $outPlacementModel = StudentOutplacementUniversity::model()->findAll("user_ref_id=$studentID AND uni_ref_id=$uniID");
                if($outPlacementModel){
                    foreach($outPlacementModel as $outPlacement){
                        $outPlacement->delete();
                    }
                }
            }
            OfflineF2fCounsellor::localChange($studentID);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'StudentShortlistUniversity');
            OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'StudentOutplacementUniversity');
        }

        echo CJSON::encode(array('success'=>1));
    }

    public function actionAdmissionColleges(){

        $studentID =  $this->studentID;
        $admissionColleges = StudentShortlistUniversity::model()->with('uniRef')->findAll(array(
            'condition'=>"t.user_ref_id=:userID AND t.shortlist_status IN ('Applied', 'WillApply') AND uniRef.is_active='Y'",
            'params'=>array(':userID'=>$studentID),
            'order'=>'t.added_on DESC'
        ));
        $collegesInfo = array();
        if($admissionColleges){
            $uniImagePath = Yii::getPathOfAlias('webroot').'/../uploads/university/images/logo/';
            $appUrl = Yii::app()->getBaseUrl(true);
            foreach($admissionColleges as $admissionCollege){

                $uniDetails = $admissionCollege->uniRef;
                if($uniDetails->url_primary_key && file_exists($uniImagePath.$uniDetails->url_primary_key.'_logo.jpg')){
                    $logo = $appUrl."/../uploads/university/images/logo/" . $uniDetails->url_primary_key . "_logo.jpg";
                }else{
                    $logo = null;
                }
                $model = StudentOutplacementUniversity::model()->findByAttributes(array(
                    'uni_ref_id'=>$admissionCollege->uni_ref_id,
                    'user_ref_id'=>$studentID,
                    'status'=>'0'
                ));
                $collegesInfo[] = array(
                    'id'   => $admissionCollege->uni_ref_id,
                    'link' => $uniDetails->url_primary_key ? UniversityHelper::getUniversityUrl($admissionCollege->uni_ref_id) : '',
                    'status' => $model && $model->uni_type ? $model->uni_type:'0' ,
                    'name' => $uniDetails->uni_name,
                    'logo' => $logo,
                );
            }
        }
        echo CJSON::encode($collegesInfo);

    }

    public function actionUpdateAdmissionStatus(){

        $studentID =  $this->studentID;
        $uniID = Yii::app()->request->getParam('id', false);
        $status = Yii::app()->request->getParam('status', false);
        if($uniID){
            $model = StudentOutplacementUniversity::model()->findByAttributes(array(
                'user_ref_id'=> $studentID, 'uni_ref_id'=>$uniID));
            if($model){
                if(!$status){
                    $model->delete();
                }else{
                    $model->uni_type = $status;
                    $model->status = '0';
                    $model->save(false);
                }
            }else{
                $model = new StudentOutplacementUniversity;
                $model->setAttributes(array(
                    'user_ref_id'=> $studentID,
                    'uni_ref_id'=>$uniID,
                    'status' => '0',
                    'uni_type'=> $status,
                    'added_on'=> date('Y-m-d H:i:s'),
                    'added_by'=> Yii::app()->user->id,
                ), false);
                $model->save(false);
            }
            OfflineF2fCounsellor::localChange($studentID);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'StudentOutplacementUniversity');
        }
    }

    public function actionAddCollegeToAdmissionList(){

        $studentID =  $this->studentID;
        $uniID = Yii::app()->request->getParam('collegeID', false);
        $uniName = Yii::app()->request->getParam('collegeName', false);
        if($uniName){
            $uniModel = TblUniversityMaster::model()->findByPk($uniID);
            if(!$uniModel){
                // create univ
                $uniModel=new TblUniversityMaster();
                $uniModel->setAttributes(array(
                    'uni_name'=> $uniName,
                    'is_user_entered'=> 1,
                    'is_active' => 'Y',
                    'added_by'=>Yii::app()->user->id,
                    'added_on'=> date('Y-m-d H:i:s'),
                ), false);
                $uniModel->save(false);
            }
            $model = StudentShortlistUniversity::model()->findByAttributes(array(
                'user_ref_id'=> $studentID, 'uni_ref_id'=>$uniModel->uni_id));
            if($model){
                $model->shortlist_status = 'WillApply';
                $model->modified_by = Yii::app()->user->id;
                $model->modified_on = date('Y-m-d H:i:s');
            }else{
                $model = new StudentShortlistUniversity();
                $model->setAttributes(array(
                    'user_ref_id'=> $studentID,
                    'uni_ref_id'=>$uniModel->uni_id,
                    'shortlist_status'=>'WillApply',
                    'added_by'=>Yii::app()->user->id,
                    'added_on'=> date('Y-m-d H:i:s'),
                ), false);
            }
            $model->save(false);
            OfflineF2fCounsellor::localChange($studentID);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'UserEntranceExam');
        }

        echo CJSON::encode(array('id'=>$uniModel->uni_id, 'name'=>$uniModel->uni_name));

    }

    public function actionShortlistedCareers(){

        $studentID =  $this->studentID;
        $Sql = "SELECT lc.career_name AS main_career_name, spc.* FROM student_preferred_career spc
        LEFT JOIN lookup_career lc ON lc.career_id = spc.career_ref_id
        WHERE spc.not_sure='0' AND spc.user_ref_id = '".$studentID."' AND spc.parent_choice= IF( EXISTS (
        SELECT 1 FROM student_preferred_career WHERE user_ref_id = spc.user_ref_id AND not_sure='0'
         AND parent_choice='N'), 'N', 'Y') AND (lc.career_name IS NULL OR lc.career_name != 'Others')
         ORDER BY spc.added_on DESC";
        $shortlistedCareers = Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        $careersInfo = array();
        if($shortlistedCareers){
            foreach($shortlistedCareers as $shortlistedCareer){
                $careersInfo[] = array(
                    'id'   => $shortlistedCareer->student_preferred_career_id,
                    'name' => $shortlistedCareer->career_ref_id ? $shortlistedCareer->main_career_name : $shortlistedCareer->career_name,
                );
            }
        }
        echo CJSON::encode($careersInfo);

    }

    public function actionSearchStreamsByTerm(){

        $term = Yii::app()->request->getParam('term', false);
        $userModel = TblUserMaster::model()->findByPk($this->studentID);
        $boardInfo = LookupBoardEquivalent::GetBoardDetail($userModel->present_class, $userModel->present_board_ref_id);
        $boardEquivalentID =  $boardInfo ? $boardInfo['board_equivalent_id'] : 0;
        $sql ="SELECT ls.student_subject_id, ls.subject_name FROM lookup_student_subject ls
        WHERE 1=1 ".($boardEquivalentID ? " AND ls.board_ref_id = $boardEquivalentID" : '')." AND ls.subject_name LIKE :qterm1
        GROUP BY ls.subject_name ORDER BY ( CASE WHEN ls.subject_name LIKE :qterm2 THEN 0 ELSE 1 END ),
        ls.subject_name LIMIT 10";
        $command =Yii::app()->db->createCommand($sql);
        $command->bindValue(":qterm1", '%'.$term.'%', PDO::PARAM_STR);
        $command->bindValue(":qterm2", $term.'%', PDO::PARAM_STR);
        $subjects =$command->setFetchMode(PDO::FETCH_OBJ)->queryAll();

        $options = array();
        if($subjects){
            foreach($subjects as $subject){
                $options[] = array(
                    'value' => $subject->subject_name,
                    'id'    => $subject->student_subject_id,
                );
            }
        }
        echo CJSON::encode($options);
    }

    public function actionShortlistedStreams(){

        $studentID =  $this->studentID;
        $shortlistedSubjects = StudentPreferredSubject::model()->with('studentSubjectRef')->findAll(array(
            'condition'=>"t.user_ref_id=:userID AND t.not_sure='0' AND type='Plan' AND student_subject_ref_id IS NOT NULL",
            'params'=>array(':userID'=>$studentID),
            'order'=>'t.added_on DESC'
        ));
        $streamsInfo = array();
        if($shortlistedSubjects){
            foreach($shortlistedSubjects as $shortlistedSubject){
                $streamsInfo[] = array(
                    'id'   => $shortlistedSubject->student_subject_ref_id,
                    'name' => $shortlistedSubject->studentSubjectRef->subject_name,
                );
            }
        }
        echo CJSON::encode($streamsInfo);
    }

    public function actionAddStreamToShortlist(){

        $studentID =  $this->studentID;
        $subjectID = Yii::app()->request->getParam('id', false);
        if($subjectID){

            $Sql = "DELETE FROM student_preferred_subject WHERE user_ref_id=$studentID AND not_sure=1";
            Yii::app()->db->createCommand($Sql)->execute();

            $model = new StudentPreferredSubject;
            $model->setAttributes(array(
                'user_ref_id'=> $studentID,
                'student_subject_ref_id'=>$subjectID,
                'not_sure'=>'0',
                'preference'=>'0',
                'type'=>'Plan',
                'added_on'=> date('Y-m-d H:i:s'),
            ), false);
            $model->save(false);
            OfflineF2fCounsellor::localChange($studentID);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'UserEntranceExam');
        }
    }

    public function actionRemoveStreamFromShortlist(){

        $studentID =  $this->studentID;
        $subjectID = Yii::app()->request->getParam('id', false);
        if($subjectID){
            $model = StudentPreferredSubject::model()->findByAttributes(array(
                'user_ref_id'=> $studentID, 'student_subject_ref_id'=>$subjectID, 'type'=>'Plan'));
            if($model){
                $model->delete();
            }
            OfflineF2fCounsellor::localChange($studentID);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($studentID,'UserEntranceExam');
        }
    }

}
