<?php
class CustomCareerPlanWidget extends CWidget{

    public $studentID = null;

    public function run() {
        if(!$this->studentID) return;

        $userModel = TblUserMaster::model()->findByPk($this->studentID);
        Yii::app()->session->add('studentID', $userModel->user_id);
        Yii::app()->session->add('classLevel', $userModel->present_class);
        $boardInfo = LookupBoardEquivalent::GetBoardDetail($userModel->present_class, $userModel->present_board_ref_id);
        Yii::app()->session->add('boardEquivalentID', $boardInfo ? $boardInfo['board_equivalent_id'] : false);

        $curMonth = date('m'); $curYear = date('Y'); $passoutYear = $userModel->passout_year;
        if(
            ($curMonth < 7 && in_array($passoutYear, [$curYear, $curYear+1])) ||
            ($curMonth > 6 && in_array($passoutYear, [$curYear+1, $curYear+2])) ||
            ($userModel->present_class > '10')
        ){
            Yii::app()->session->add('classLevel', 11);
            $this->render('career_plan_widget_11n12');
        }else{
            $this->render('career_plan_widget_9n10');
        }
    }
}