<?php

$depts=array();

?>

<div class="row visible clearfix" id="content">
    <h4 class="row gutter-left-35">
        Shortlist colleges based on your finalised preferences
    </h4>



    <form method="post" name="formIdealList">
        <div class="row multi_line gray gutter_vertical">
            <div class="left relative">
                <?php
                echo CHtml::dropDownList('country', $cId, $countryList, array('class' => 'grid_4 select'));
                ?>
            </div>
            <div class="left relative">
                <?php
                $deptIds=array_keys($deptList);
                $deptNames=array_values($deptList);
                echo CHtml::dropDownList('department', $dId, $deptList, array('class' => 'grid_4 select'));
                ?>
            </div>
            <div class="left">
                <button class="button-blue tny" id="idealListButton" type="submit">View Colleges</button>
            </div>
        </div>


    </form>

            <div class="row gutter_vertical visible">
                <ul class="portfolio-tabs clearfix">
                    <li class="border-bottom no-inner-gutter">&nbsp;</li>
                    <li class="no-inner-gutter active" id="aspirationList"><a href="#" class="gray">Aspirational Colleges</a></li>
                    <li class="border-bottom no-inner-gutter">&nbsp;</li>
                    <li class="no-inner-gutter no-inner-gutter" id="bestFit"><a href="#" class="gray">Best-Fit Colleges</a></li>
                    <li class="border-bottom no-inner-gutter">&nbsp;</li>
                    <li class="no-inner-gutter no-inner-gutter" id="safeList"><a href="#" class="gray">Safe Colleges</a></li>
                    <li class="border-bottom no-inner-gutter">&nbsp;</li>
                    <li class="no-inner-gutter no-inner-gutter" id="suggested"><a href="#" class="gray">Counselor-Suggested Colleges</a></li>
                    <li class="border-bottom no-inner-gutter">&nbsp;</li>
                </ul>
            </div>



            <div class="gutter_vertical" id="aspirationList">
                <?php $this->renderPartial('_list', array('bestFitList' => $aspirationList, 'deptList'=>$deptList,'blockId' => 'aspirationList', 'shortList' => $shortList, 'showList' => '1', 'depts'=>$deptIds, 'depts_name'=>$deptNames,'dId'=>$dId ,'cId'=>$cId)); ?>
            </div>
            <div id="bestFit" class="gutter_vertical">
                <?php
                    $this->renderPartial('_list', array('bestFitList' => $bestFitList,'deptList'=>$deptList,'blockId' => 'bestFit', 'shortList' => $shortList, 'showList' => '0', 'depts'=>$deptIds, 'depts_name'=>$deptNames,'dId'=>$dId,'cId'=>$cId)); ?>
            </div>
            <div id="safeList" class="gutter_vertical">
                <?php $this->renderPartial('_list', array('bestFitList' => $safeList,'deptList'=>$deptList, 'blockId' => 'safeList', 'shortList' => $shortList, 'showList' => '', 'depts'=>$deptIds, 'depts_name'=>$deptNames,'dId'=>$dId,'cId'=>$cId));?>
            </div>
            <div id="suggested" class="gutter_vertical">
                <?php $this->renderPartial('_list', array('bestFitList' => $suggestedList,'deptList'=>$deptList, 'blockId' => 'suggested', 'shortList' => $shortList, 'showList' => '', 'depts'=>$deptIds, 'depts_name'=>$deptNames,'dId'=>$dId,'cId'=>$cId));?>
            </div>






    <?php if($userId != Yii::app()->user->sub_id){ ?>
        <div class="row multi_line gray">

                <span class="small_gutter_r">Suggest college to the student?</span>
            <span><?php
                $sourceUrl = Yii::app()->createUrl('cssTracking/CollegeSuggest', array(
                        'country'=> $cId,'dept'=>$dId,
                    )
                );
                $this->widget('zii.widgets.jui.CJuiAutoComplete', array(
                    'name'=> 'exam',
                    'source' => 'js:function(request, response) {
                        $.ajax({
        					url: "' . $sourceUrl . '",
        					dataType: "json",
        					data: {
        						term: request.term
        					},
        					success: function(data) {
        						response(data);
        					}
        				});
                      }',
                    // additional javascript options for the autocomplete plugin
                    'options'=>array(
                        'minLength'=>'1',
                        'select' => 'js: function(event, div) { addCollege(div.item.id); }'
                    ),
                    'htmlOptions'=>array(
                        'class' => 'input',
                        'placeholder'=>'Enter college name',
                        'style'=>'width:355px;',
                    ),

                ));
                ?></span>
               <input type="hidden" name="coll_id" id="coll_id" value=""><input type="button" class="button-green tny" value="Suggest" onclick="saveCollege()">
        </div>
    <?php } ?>
</div>

<script>

    function addCollege(Id) {
        $('#coll_id').val(Id);
    }
    function saveCollege() {
        var coll_id = $('#coll_id').val();
        var userId = '<?php echo $userId; ?>';
        var iId = '<?php echo $idealListId; ?>';
        if (coll_id) {
            $.ajax({
                type:'POST',
                url:'/app/cssTracking/addToShortSuggestCollege',
                data:{collId:coll_id,userId:userId,iId:iId},
                success:function(msg){
                    if (msg == 0) {
                        $.notification({class:'error_notify', notification:'university_err'});
                    } else {
                        location = location.href;
                    }
                }
            });
        } else {
            alert('Select an college to suggest');
        }
    }
</script>



