
<ol class="pad_5 margin_l_10">
<?php
switch($model->status){
    case StudentIdealList::STATUS_STARTED:
        $universities = StudentIdealListCollege::model()->findAllByAttributes(array(
        	'student_ideal_list_ref_id' => $model->student_ideal_list_id,
            'suggest_type' => array(
                                StudentIdealListCollege::SUGGEST_TYPE_SPOC,
                                StudentIdealListCollege::SUGGEST_TYPE_STUDENT
                              ),
        ),
        array(
            'order' => 'preference_order',
        ));
        break;
    case StudentIdealList::STATUS_CONFIRMED:
        $universities = StudentIdealListCollege::model()->findAllByAttributes(array(
        	'student_ideal_list_ref_id' => $model->student_ideal_list_id,
            'status' => StudentIdealListCollege::STATUS_ACCEPTED,
        ),
        array(
            'order' => 'preference_order',
        ));
        break;
    default:
        $universities = $model->collegeList;
}

    


    foreach($universities as $university):
?>
<li class="pad_5 clear">
	<div class="left spacer350 strong"> 
		<a href="<?php echo $university->university->website_url; ?>" target="_blank" title="Opens <?php echo $university->university->uni_name; ?> website">
		<?php echo $university->university->uni_name; ?>
		</a>
	</div>
	<div class="left spacer60">
	    <?php 
	        switch($university->suggest_type){
	            case StudentIdealListCollege::SUGGEST_TYPE_ADVISOR: $icon = '../ico-manager.png'; $title = 'Univariety'; break;
	            case StudentIdealListCollege::SUGGEST_TYPE_SPOC: $icon = 'user_green.png'; $title = 'Spoc'; break;
	            case StudentIdealListCollege::SUGGEST_TYPE_STUDENT: $icon = 'user.png'; $title = 'Student'; break;
	        }
	    ?>
	    <img src="<?php echo Yii::app()->params['cbasepath']; ?>/images/small_icons/<?php echo $icon; ?>" alt="<?php echo $title; ?>" title="Added by <?php echo $title; ?>" style="width: 16px; height:16px;" />
	    	
	    	<?php 
	    if($university->status == StudentIdealListCollege::STATUS_REVIEWED && !empty($university->comment)):
    	        ?>
    	        <img src="<?php echo Yii::app()->params['cbasepath']; ?>/images/small_icons/comment.png" alt="has comment" title="<?php echo CHtml::encode($university->comment); ?>" />
    	        	
    	        <?php
    	    endif;
    	?>
	    </div>
	<div class="left spacer200">
	<div class="margin_l_10 left">
    		<?php
    if($model->status != StudentIdealList::STATUS_CONFIRMED):
    	    //Confirmed list can't be edited.
    	if($university->status == StudentIdealListCollege::STATUS_REVIEWED || $university->status == StudentIdealListCollege::STATUS_REJECTED):
    	    echo CHtml::ajaxButton('Accept', 
    	                      Yii::app()->createUrl('sms/milestone/acceptUniversity'),
    	                      array ( 
    	                          'type' => 'POST',
    	                          'data' => 'ajax=accept-university&list=' . $university->student_ideal_list_college_id,
    	                          'dataType' => 'json',
    	                          'success' => 'js: function(data){ addListAjaxResponse("'. $idealType .'", data); }',
    	                          'beforeSend' => 'js:  function(){ $("#ab-' . $university->student_ideal_list_college_id . ' ").next(".ajax-loader").show();}',
    	                          'complete' => 'js:  function(){ $("#ab-' . $university->student_ideal_list_college_id . ' ").next(".ajax-loader").hide();}',
    	                      ),
    	                      array(
    	                          'id' => 'ab-' . $university->student_ideal_list_college_id,
    	                          'live' => false,
    	                          'class' => 'green-button',
    	                          'style' => ''
    	                      )
    	                      
    	    );
    	endif;
    	?>
    	<div class="pad_5 left ajax-loader" style="display:none;">
	    	<img src="<?php echo Yii::app()->params['cbasepath']; ?>/images/9.gif" alt="loading" />
	    </div>
	</div>
	<div class="margin_l_10 left">
    	<?php
    	if($university->status == StudentIdealListCollege::STATUS_REVIEWED || $university->status == StudentIdealListCollege::STATUS_ACCEPTED):
    	    echo CHtml::ajaxButton('Reject', 
    	                      Yii::app()->createUrl('sms/milestone/rejectUniversity'),
    	                      array ( 
    	                          'type' => 'POST',
    	                          'data' => 'ajax=reject-university&list=' . $university->student_ideal_list_college_id,
    	                          'dataType' => 'json',
    	                          'success' => 'js: function(data){ addListAjaxResponse("'. $idealType .'", data); }',
    	                          'beforeSend' => 'js:  function(){ $("#ar-' . $university->student_ideal_list_college_id . ' ").next(".ajax-loader").show();}',
    	                          'complete' => 'js:  function(){ $("#ar-' . $university->student_ideal_list_college_id . ' ").next(".ajax-loader").hide();}',
    	                      ),
    	                      array(
    	                          'id' => 'ar-' . $university->student_ideal_list_college_id,
    	                          'live' => false,
    	                          'class' => 'green-button'
    	                      )
    	                      
    	    );
    	    ?>
    	    <div class="pad_5 left ajax-loader" style="display:none;">
    	    	<img src="<?php echo Yii::app()->params['cbasepath']; ?>/images/9.gif" alt="loading" />
    	    </div>
    	    <?php 
    	endif;
    ?>
    </div>
    <?php
    endif;
    	?>
	
	</div>
	<div class="left spacer250">
	
	</div>
</li>
		    <?php
		endforeach;
		?>
		</ol>

