<?php

class MilestonesController extends Controller
{
    public function init(){
        parent::init();
        Yii::app()->theme = 'uni_avada';
        $this->layout = "//layouts/inner_page";
		
		if (empty($_GET['studentId'])) {
		$this->breadcrumbs=array(
                    'Home'=>array('/dashboard'),
                    'My Progress',
                );
		}
    }

    public function filters(){
        return array(
        	'rights',
        );
    }

    public function actionMilestone1()
    {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $userId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];
        $user = TblUserMaster::model()->findByPk($userId);
        $model = new Milestone('ms1');
   
        if(isset($_POST['ajax']) && $_POST['ajax']==='hypothesis') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        $mileStoneNumber = 1;
        $ms1Status = UserMilestone::isConfirmed($user->user_id, $mileStoneNumber);
        $ms2Status = UserMilestone::isConfirmed($user->user_id, 2);

        if ($ms2Status) {
            $prefCountires = $user->getHypothesisCountries();
            $prefCourses = $user->getHypothesisCourses();
			
        } else {
            $prefCountires = $user->getPreferredCountries();
            $prefCourses = $user->getPreferredCourses();
        }		
        if($user->present_class == '9' || $user->present_class == '10'){
            $prefCourses = $user->getPreferredCourses();
            if(count($prefCourses)<1){
                $prefCourses = $user->getPreferredCareersRelatedDept();
            }
        }
      
        $keys = array();
        foreach($prefCountires as $pref=>$value) {
            $keys[] = $pref;
        }
        $model->countryPref1 = $keys[0];$model->countryPref2 = $keys[1];$model->countryPref3 = $keys[2];

        $keys = array();
        foreach($prefCourses as $prefCourse) {
            $keys[] = $prefCourse;
        }

        $model->deptPref1 = $keys[0]['main_dept_ref_id'];$model->deptPref2 = $keys[1]['main_dept_ref_id'];$model->deptPref3 = $keys[2]['main_dept_ref_id'];
        $model->coursePref1 = $keys[0]['sub_dept_ref_id'];$model->coursePref2 = $keys[1]['sub_dept_ref_id'];$model->coursePref3 = $keys[2]['sub_dept_ref_id'];

        if (!empty($_POST)) {
            $model->attributes = $postData = $_POST['Milestone'];
            $model->countryPref1 = $_POST['Milestone']['countryPref1'];
            $model->countryPref2 = $_POST['Milestone']['countryPref2'];
            $model->countryPref3 = $_POST['Milestone']['countryPref3'];
            $model->deptPref1 = $_POST['Milestone']['deptPref1'];
            $model->deptPref2 = $_POST['Milestone']['deptPref2'];
            $model->deptPref3 = $_POST['Milestone']['deptPref3'];
            $model->coursePref1 = $_POST['Milestone']['coursePref1'];
            $model->coursePref2 = $_POST['Milestone']['coursePref2'];
            $model->coursePref3 = $_POST['Milestone']['coursePref3'];
            if ($model->validate()) {
				$flag_pref = 0;
                $criteria = new CDbCriteria;
                $criteria->condition = "user_ref_id = '".$userId."'";
                if (!$ms2Status) {
                    StudentPreferredCountry::model()->deleteAll($criteria);
                }
                StudentHypothesisCountry::model()->deleteAll($criteria);

                for ($i = 1;$i <= 3;$i++) {
                    if($postData['countryPref'.$i]!= ""){
                        if (!$ms2Status) {
                            $obj = new StudentPreferredCountry();
                            $obj->{user_ref_id} = $userId;
                            $obj->{country_ref_id} = $postData['countryPref'.$i];
                            $obj->{preference_order} = $i;
                            $obj->save();
							
							$flag_pref = 1;
                        }

                        $obj = new StudentHypothesisCountry();
                        $obj->{user_ref_id} = $userId;
                        $obj->{country_ref_id} = $postData['countryPref'.$i];
                        $obj->{preference_order} = $i;
                        $obj->added_by = Yii::app()->user->id;
                        $obj->save();
                    }
                }

                $criteria = new CDbCriteria;
                $criteria->condition = "user_ref_id = '".$userId."'";
                if (!$ms2Status) {
                    StudentPreferredDepartment::model()->deleteAll($criteria);
                }
                StudentHypothesisDepartment::model()->deleteAll($criteria);

                for ($i = 1; $i<= 3; $i++) {
                    if($postData['deptPref'.$i]!= ""){
                        if (!$ms2Status) {
                            $obj = new StudentPreferredDepartment();
                            $obj->{user_ref_id} = $userId;
                            $obj->{main_dept_ref_id} = $postData['deptPref'.$i];
                            $obj->{sub_dept_ref_id} = $postData['coursePref'.$i];
                            $obj->{preference_order} = $i;
                            $obj->save();
							$flag_pref = 1;
                        }

                        $obj = new StudentHypothesisDepartment();
                        $obj->{user_ref_id} = $userId;
                        $obj->{main_dept_ref_id} = $postData['deptPref'.$i];
                        $obj->{sub_dept_ref_id} = $postData['coursePref'.$i];
                        $obj->{preference_order} = $i;
                        $obj->added_by = Yii::app()->user->id;
                        $obj->save();
                    }
                }
				/*if ($flag_pref == 1) {
                   $tblLoginMaster = LoginMaster::model()->findByPk($user->login_ref_id);
                    if ($userId == Yii::app()->user->sub_id) {
                        $tblLoginMaster->is_preference_confirmed = 0;
                    } else {
                        $tblLoginMaster->is_preference_confirmed = 1;
                    }
                    $tblLoginMaster->modified_on = date('Y-m-d H:i:s');
                    $tblLoginMaster->save(false);
                    StudentProfileValidationLog::saveLogData($userId, 'Preference', $tblLoginMaster->is_preference_confirmed, Yii::app()->user->id);
				}*/
				
                setFlashMessage('success_notify', 'sms_milestonescontroller.ms1_saved');
                $date = date('Y-m-d H:i:s');
                $this->sendEmail($userId, 1);
                UserMilestone::confirmMilestone($userId, 1, $date);
                if ($userId == Yii::app()->user->sub_id) {
                    $this->redirect('/app/sms/milestones/milestone2');
                } else {
                    $this->redirect('/app/sms/milestones/milestone2?studentId='.$userId);
                }
            }
        }
        $user->refresh();
        $this->render('milestone1', array('user' => $user, 'model'=>$model, 'ms1Status'=>$ms1Status, 'ms2Status'=>$ms2Status,
            'prefCountires'=>$prefCountires, 'prefCourses'=>$prefCourses, 'mileStoneNumber'=>$mileStoneNumber, 'userId'=>$userId));
    }

    public function sendEmail($userId, $milestoneId) {
        if ($userId && $milestoneId) {
            $criteria = new CDbCriteria();
            $criteria->select = "t.user_id,t.login_ref_id, t.first_name, t.last_name, t.passout_year, t.present_board_ref_id, tss.inst_ref_id as school_ref_id, t.login_ref_id, tsd.inst_name as school_name, tsd.subdomain_slug_name as uni_name";
            $criteria->join = " INNER JOIN tbl_si_students AS tss ON tss.user_ref_id = t.user_id ";
            $criteria->join .= " INNER JOIN tbl_si_di AS tsd ON tsd.inst_id = tss.inst_ref_id AND tsd.css_access = 1";
            $criteria->condition = "t.user_id = ".$userId;
            $criteria->order = " t.user_id asc";
            $criteria->with = array(
                'loginRef'=>array('select'=>'loginRef.username', 'joinType'=>'INNER JOIN'),
            );

            $student = TblUserMaster::model()->find($criteria);

            $criteria_mail = new CDbCriteria();
            $criteria_mail->select = " emailer_cron_milestone_id, template_text ";
            $criteria_mail->condition = " template_key = 'SMS".$milestoneId."TY' ";
            $mail_data = EmailerCronMilestone::model()->find($criteria_mail);

            if ($mail_data) {
                $BASEURL = PROTOCOL . ACTUALHOST;
                $mailTrackValues = 'milestones==='.$student->login_ref_id.'==='.$mail_data->emailer_cron_milestone_id;
                $trackingLink = $BASEURL."/MailTrack/index?ref=".base64_encode($mailTrackValues);

                $old_track_html = '<div style="display: none"><a href="#" style="display: none">email track</a></div>';
                $new_track_html = '<div style="display: none"><img src="'.$trackingLink.'" style="display: none" /></div>';

                $loginValues = $student->login_ref_id.'==='.PROTOCOL.$student->uni_name.'.'.ACTUALHOST.'/app/student/profile/EditBasicInfo';
                $autoLoginUrl = $BASEURL."/app/Login/loginRedirect?ref=".base64_encode($loginValues);

                $old_milestone_url = '<a href="#" style="color: #49A7FC; text-decoration: none;">click here</a>';
                $new_milestone_url = '<a href="'.$autoLoginUrl.'" style="color: #49A7FC; text-decoration: none;">click here</a>';

                $EmailMessage = array();
                $EmailMessage['subject'] = 'Thank You, you are all set';
                $EmailMessage['body']    =  str_replace($old_track_html, $new_track_html, str_replace($old_milestone_url, $new_milestone_url, str_replace('[StudentName]', ucfirst($student->first_name).' '.ucfirst($student->last_name),$mail_data->template_text)));
                $EmailMessage['type']    = 'MilestoneEmails';
                $EmailMessage['siteUrl'] = '';
                $EmailMessage['cc']      = '';
                $EmailMessage['toName']  = ucfirst($student->first_name).' '.ucfirst($student->last_name);
                $EmailMessage['toEmail'] =  $student->loginRef->username;
                $EmailMessage['apiKey']  =  Yii::app()->params['curlKey'];

                $EmailMessage['siteUrl'] = Yii::app()->createAbsoluteUrl('/');
                $email  = new EmailMessage;

                $result = $email->addEmailMessage($EmailMessage);

                $emailer_track = new EmailerMilestoneTracker();
                $emailer_track->login_ref_id = $student->login_ref_id;
                $emailer_track->emailer_cron_milestone_ref_id = $mail_data->emailer_cron_milestone_id;
                $emailer_track->sent_on = date('Y-m-d H:i:s');
                $emailer_track->save();
            }
        }
    }

    public function actionGetSubDeptList(){
        $deptId = Yii::app()->request->getQuery('deptId');
        $modelSubDept = LookupDepartment::getSubDepartmentsList($deptId);
        $subDeptList = CHtml::listData($modelSubDept,'department_id', 'department_name');
        echo json_encode($subDeptList);
    }

    public function actionEdit1() {
        if (!empty($_GET['id'])) {
            $obj = new UserMilestone();
            $obj->user_ref_id = $_GET['id'];
            $obj->milestone_id = 1;
            $obj->invalidateMilestone();
            if ($_GET['id'] == Yii::app()->user->sub_id) {
                $this->redirect('/app/sms/milestones/milestone1');
            } else {
                $this->redirect('/app/sms/milestones/milestone1?studentId='.$_GET['id']);
            }
        }
    }

    public function actionEdit2() {
        if (!empty($_GET['id'])) {
            $obj = new UserMilestone();
            $obj->user_ref_id = $_GET['id'];
            $obj->milestone_id = 2;
            $obj->invalidateMilestone();
            if ($_GET['id'] == Yii::app()->user->sub_id) {
                $this->redirect('/app/sms/milestones/milestone2');
            } else {
                $this->redirect('/app/sms/milestones/milestone2?studentId='.$_GET['id']);
            }
        }
    }

    public function actionComment() {
       $comments_model = new StudentMilestoneComment();
        if (!empty($_POST)) {

            $comments_model->attributes = $_POST['StudentMilestoneComment'];
            $comments_model->added_on = date('Y-m-d H:i:s');
            if ($comments_model->validate()) {
                if ($comments_model->save()) {
                    setFlashMessage('success_notify', 'sms_milestonescontroller.comment_saved');
                }
            } else {
                echo CActiveForm::validate(array($comments_model));
                Yii::app()->end();
            }

        }
    }

    public function actionMilestone2()
    {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $userId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];
        $user = TblUserMaster::model()->findByPk($userId);
        $mileStoneNumber = 2;
        $model = new Milestone('ms1');

        if(isset($_POST['ajax']) && $_POST['ajax']==='finalisation') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
        $prefCountires = $user->getPreferredCountries();
        $prefCourses = $user->getPreferredCourses();
	
        $keys = array();
        foreach($prefCountires as $pref=>$value) {
            $keys[] = $pref;
        }
        $model->countryPref1 = $keys[0];$model->countryPref2 = $keys[1];$model->countryPref3= $keys[2];

        $keys = array();
        foreach($prefCourses as $prefCourse) {
            $keys[] = $prefCourse;
        }

        $model->deptPref1 = $keys[0]['main_dept_ref_id'];$model->deptPref2 = $keys[1]['main_dept_ref_id'];$model->deptPref3 = $keys[2]['main_dept_ref_id'];
        $model->coursePref1 = $keys[0]['sub_dept_ref_id'];$model->coursePref2 = $keys[1]['sub_dept_ref_id'];$model->coursePref3 = $keys[2]['sub_dept_ref_id'];
        $ms2Status = UserMilestone::isConfirmed($user->user_id, 2);
        $prefCountires = $user->getPreferredCountries();
        $prefCourses = $user->getPreferredCourses();

        if (!empty($_POST)) {
            $model->attributes = $postData = $_POST['Milestone'];
            $model->countryPref1 = $_POST['Milestone']['countryPref1'];
            $model->countryPref2 = $_POST['Milestone']['countryPref2'];
            $model->countryPref3 = $_POST['Milestone']['countryPref3'];
            $model->deptPref1 = $_POST['Milestone']['deptPref1'];
            $model->deptPref2 = $_POST['Milestone']['deptPref2'];
            $model->deptPref3 = $_POST['Milestone']['deptPref3'];
            $model->coursePref1 = $_POST['Milestone']['coursePref1'];
            $model->coursePref2 = $_POST['Milestone']['coursePref2'];
            $model->coursePref3 = $_POST['Milestone']['coursePref3'];

            if ($model->validate()) {

                $criteria = new CDbCriteria;
                $criteria->condition = "user_ref_id = '".$userId."'";
                StudentPreferredCountry::model()->deleteAll($criteria);

                for ($i = 1;$i <= 3;$i++) {
                    if($postData['countryPref'.$i]!= ""){
                        $obj = new StudentPreferredCountry();
                        $obj->{user_ref_id} = $userId;
                        $obj->{country_ref_id} = $postData['countryPref'.$i];
                        $obj->{preference_order} = $i;
                        $obj->save();
                    }
                }

                $criteria = new CDbCriteria;
                $criteria->condition = "user_ref_id = '".$userId."'";
                StudentPreferredDepartment::model()->deleteAll($criteria);

                for ($i = 1; $i<= 3; $i++) {
                    if($postData['deptPref'.$i]!= ""){
                        $obj = new StudentPreferredDepartment();
                        $obj->{user_ref_id} = $userId;
                        $obj->{main_dept_ref_id} = $postData['deptPref'.$i];
                        $obj->{sub_dept_ref_id} = $postData['coursePref'.$i];
                        $obj->{preference_order} = $i;
                        $obj->save();
                    }
                }
				
				/*$tblLoginMaster = LoginMaster::model()->findByPk($user->login_ref_id);
				if ($userId == Yii::app()->user->sub_id) {
					$tblLoginMaster->is_preference_confirmed = 0;
				} else {
					$tblLoginMaster->is_preference_confirmed = 1;
				}
				$tblLoginMaster->modified_on = date('Y-m-d H:i:s');
				$tblLoginMaster->save(false);
				StudentProfileValidationLog::saveLogData($userId, 'Preference', $tblLoginMaster->is_preference_confirmed, Yii::app()->user->id);*/
				
                setFlashMessage('success_notify', 'sms_milestonescontroller.ms2_saved');
                $date = date('Y-m-d H:i:s');
                UserMilestone::confirmMilestone($userId, 2, $date);
                if ($userId == Yii::app()->user->sub_id) {
                    $this->redirect('/app/sms/milestones/milestone3');
                } else {
                    $this->redirect('/app/sms/milestones/milestone3?studentId='.$userId);
                }
            }
        }

        $this->render('milestone2', array('user' => $user, 'ms2Status'=>$ms2Status, 'prefCountires'=>$prefCountires, 'prefCourses'=>$prefCourses,
            'mileStoneNumber'=>$mileStoneNumber, 'userId'=>$userId, 'model'=>$model));
    }

    public function actionMilestone3()
    {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $userId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];

        $user = TblUserMaster::model()->findByPk($userId);
        $mileStoneNumber = 3;
        $ms3Status = UserMilestone::isConfirmed($user->user_id, $mileStoneNumber);

        if ($_POST['submit'] == 'Save Changes') {
            if ($ms3Status) {
                setFlashMessage('success_notify', 'sms_milestonescontroller.ms3_saved_second_time');
            } else {
                setFlashMessage('success_notify', 'sms_milestonescontroller.ms3_saved');
            }
            $date = date('Y-m-d H:i:s');
            UserMilestone::confirmMilestone($userId, 3, $date);
            if ($userId == Yii::app()->user->sub_id) {
                $this->redirect('/app/sms/milestones/milestone4');
            } else {
                $this->redirect('/app/sms/milestones/milestone4?studentId='.$userId);
            }
        }

        $limit=10;
        $offset = isset($_GET['offset']) ? $_GET['offset'] : 0;
		$count_index=$offset+1;
        $prefCountires = $user->getPreferredCountries();
        $prefCourses = $user->getPreferredCourses();
        if(!$prefCourses){
            $this->redirect('/app/sms/milestones/TenthMilestone3',array('studentId'=>$userId));
        }
        $country_id = $_GET['country'];
        $course_id = $_GET['course'];

        $userEntranceExams = UserEntranceExam::fetchUserExams($userId);

        if (!$country_id) {
            foreach ($prefCountires as $key=>$value) {
                $country_id = $key;
                break;
            }
        }

        if (!$course_id) {
            foreach($prefCourses as $value) {
                $course_id = $value['main_dept_ref_id'];
                break;
            }
        }
        $exams = array();
        if ($course_id && $country_id) {
            $exams = EntranceExam::getTestDetailsByCountryDepartment($country_id, $course_id,$offset,$limit);
        }

        $totalExamCount=EntranceExam::getTestDetailsByCountryDepartment($country_id, $course_id,0,500);
      
        $suggested_exams = CounselorSuggestedEntranceExam::fetchUserExams($userId);

        if ($_GET['sub_view'] == 'sub_view') {

            $this->renderPartial('_ms4', array('currentMilestone' => $mileStoneNumber, 'user'=>$user, 'prefCountries'=>$prefCountires, 'suggested_exams'=>$suggested_exams,
                'prefCourses'=>$prefCourses, 'userId'=>$userId, 'ms3Status'=>$ms3Status, 'exams'=>$exams, 'course_id'=>$course_id, 'country_id'=>$country_id, 'userEntranceExams'=>$userEntranceExams,'totalExamCount'=>$totalExamCount,'count_index'=>$count_index));
        }
        else{
        $this->render('milestone3', array('user' => $user, 'ms3Status'=>$ms3Status,'prefCountires'=>$prefCountires,'prefCourses'=>$prefCourses, 'suggested_exams'=>$suggested_exams,
            'mileStoneNumber'=>$mileStoneNumber, 'userId'=>$userId, 'course_id'=>$course_id, 'country_id'=>$country_id, 'exams'=>$exams, 'userEntranceExams'=>$userEntranceExams,'totalExamCount'=>$totalExamCount));
        }
}

    public function actionAddToShortList()
    {
        $userId = empty($_GET['studentId']) ? Yii::app()->user->sub_id : $_GET['studentId'];
        $examId = Yii::app()->request->getParam('examId');
        $status = Yii::app()->request->getParam('status');

        if ($status) {
            $student_entrance_exam = new UserEntranceExam();
            $student_entrance_exam->user_ref_id = $userId;
            $student_entrance_exam->entrance_exam_ref_id = $examId;
            $student_entrance_exam->exam_status = 'Planned';
            $student_entrance_exam->added_by = Yii::app()->user->id;
            $student_entrance_exam->save(false);
        } else {
            $res = UserEntranceExam::fetchUserEnteredExam($userId, 'entrance_exam_ref_id', $examId);
            $user_entrance_exam = UserEntranceExam::model()->findByPk($res);
            $user_entrance_exam->delete();
            print 'remove from list';
        }
    }
   
    public function actionMilestone4() {


        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $mileStoneNumber = 4;
        $userId = empty($_GET['studentId']) ? Yii::app()->user->sub_id : $_GET['studentId'];
        $user = TblUserMaster::model()->findByPk($userId);
        if($user->present_class == 11 || $user->present_class == 12) {

        $selected_country = $selected_dept = '';
        $prefCountries = $user->getPreferredCountries();
        $prefCourses = $user->getPreferredCourses();


        if(isset($_POST['save'])) {
            UserMilestone::confirmMilestone($userId, $mileStoneNumber, date("Y-m-d H:i:s"));
            setFlashMessage('success_notify', 'sms_milestonescontroller.ms4_saved');
            if ($userId == Yii::app()->user->sub_id) {
                $this->redirect('/app/sms/milestones/milestone5');
            } else {
                $this->redirect('/app/sms/milestones/milestone5?studentId='.$userId);
            }
        }
        
        $this->pageTitle = Yii::app()->name . ' - Milestone Ideal List';
        $firstTimeDeptId = $firstTimeCountryId = 0;
        $bestFitList = $safeList = $aspirationList = array();

        $idealListObj = new UserIdealList();
        $idealListObj->generateIdealList($userId);

        $objShortList = new ShortListEngine();
        if ($userId != Yii::app()->user->sub_id) {
            $objShortList->studentId = $userId;
            $objShortList->studentLoginId = $user->login_ref_id;
        }
        $objShortList->hotLeadEligibleCriteria = array(
            'VALID_COUNTRY_CHECK' => true,
            'VALID_DEPT/COURSE_CHECK' => true,
            'OVERALL_12TH_MARKS_CHECK' => true,
            'STUDY_LEVEL_UG_CHECK' => true,
        );

        if ($objShortList->isEligibleForHotLeads()) { // If student full filling all eligibility cirteria
            $preferredDeptListData = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($userId);
            foreach ($preferredDeptListData as $key => $value) {
                $deptList[$value->main_dept_ref_id] = $value->mainDeptRef->department_name;
                $preferredDeptIdArr[] = $value->main_dept_ref_id;
                if (!$firstTimeDeptId) {
                    $firstTimeDeptId = $value->main_dept_ref_id;
                }
            }

            $preferredDeptIdString = implode(", ", $preferredDeptIdArr);
            UserIdealList::updateStatusOnDepartmentId($userId, $preferredDeptIdString, Yii::app()->user->id);
                    
            $preferredCountryListData = StudentPreferredCountry::getStudentPreferredCountryDetails($userId);
            foreach ($preferredCountryListData as $key => $value) {
                $countryList[$value->country_ref_id] = $value->countryRef->country_name;
                $preferredCountryIdArr[] = $value->country_ref_id;
                if (!$firstTimeCountryId) {
                    $firstTimeCountryId = $value->country_ref_id;
                }
            }

            $preferredCountryIdString = implode(", ", $preferredCountryIdArr);
            UserIdealList::updateStatusOnCountryId($userId, $preferredCountryIdString, Yii::app()->user->id);

            $dId = Yii::app()->request->getParam('department');
            $cId = Yii::app()->request->getParam('country');

            if (!in_array($cId, $preferredCountryIdArr)) {
                $cId = $firstTimeCountryId;
            }

            if (!in_array($dId, $preferredDeptIdArr)) {
                $dId = $firstTimeDeptId;
            }

           //$dId = '74';
           //$cId = '223';

            if ($dId && $cId) {
                $idealListExist = UserIdealList::isIdealListExist($dId, $cId, $userId, 1);
                $idealListId = $idealListExist->user_ideal_list_id;

                if (!$idealListExist) { // List dose not exist
                    Yii::import('application.components.ideallist.*');

                    $idealListObj = new IdealList();
                    $idealListObj->countryId = $cId;
                    $idealListObj->departmentId = $dId;

                    $idealListObj->studentId = $userId;
					
                    $idealListObj->calcAdmissionChances();
                    $bestFitList = $idealListObj->getBestFitList();
                    $safeList = $idealListObj->getSafeList();
                    $aspirationList = $idealListObj->getAspirationList();

                    // Save record in ideal list
                    $idealListObj = new UserIdealList();
                    $idealListObj->user_ref_id = $userId;
                    $idealListObj->department_ref_id = $dId;
                    $idealListObj->country_ref_id = $cId;
                    $idealListObj->is_active = 1;
                    $idealListObj->added_on = date('Y-m-d H:i:s');
                    $idealListObj->added_by = Yii::app()->user->id;
                    $idealListObj->save();
                    $idealListId = $idealListObj->user_ideal_list_id;

                    // Creating Single query for all three list.
                    $idealListInsertQuery = 'INSERT INTO user_ideal_list_university (user_ideal_list_ref_id, uni_ref_id, score, university_type, suggest_by, suggested_by_ref_id, added_on, added_by) values ';
                    foreach ($bestFitList as $key => $value) {
                        $arr[] = "(" . $idealListId . ", " . $value['uni_id'] . ", " . $value['score'] . ", 'BestFit' ,'System', " . Yii::app()->user->id . ", '" . date('Y-m-d H:i:s') . "', " . Yii::app()->user->id . " )";
                    }
                    foreach ($safeList as $key => $value) {
                        $arr[] = "(" . $idealListId . ", " . $value['uni_id'] . ", " . $value['score'] . ", 'Safe' ,'System', " . Yii::app()->user->id . ", '" . date('Y-m-d H:i:s') . "', " . Yii::app()->user->id . " )";
                    }
                    foreach ($aspirationList as $key => $value) {
                        $arr[] = "(" . $idealListId . ", " . $value['uni_id'] . ", " . $value['score'] . ", 'Aspirational' ,'System', " . Yii::app()->user->id . ", '" . date('Y-m-d H:i:s') . "', " . Yii::app()->user->id . " )";
                    }

                    if (count($arr)) {
                        $queryPart = implode(", ", $arr);
                        $idealListCollegeQuery = $idealListInsertQuery . $queryPart;
                        Yii::app()->db->createCommand($idealListCollegeQuery)->query();
                    }
                }
            }

            $shortList = $objShortList->getShortList();

            $idealList = UserIdealListUniversity::getIdealList($idealListId, $dId);
			
            $suggestedIdealList = UserIdealListUniversity::getIdealListBySuggestion($idealListId, $dId, "School");

            $bestFitList = $idealList['bestfit'];
            $safeList = $idealList['safe'];
            $aspirationList = $idealList['aspirational'];
            $suggestedList = $suggestedIdealList['School'];
            
            
            $this->render('milestone4', array(
                'safeList' => $safeList,
                'aspirationList' => $aspirationList,
                'bestFitList' => $bestFitList,
                'suggestedList' => $suggestedList,
                'dId' => $dId,
                'deptList' => $deptList,
                'countryList' => $countryList,
                'cId' => $cId,
                'shortList' => $shortList,
                'mileStoneNumber' => $mileStoneNumber,
                'userId'=>$userId,
                'user' => $user,
                'idealListId'=>$idealListId,
                'prefCountries'=>$prefCountries,
                'prefCourses'=>$prefCourses
            ));
        } else {
            UserIdealList::updateStatusOnUserId($userId);
            //UserIdealList::model()->updateAll(array('is_active' => 0, 'modified_on' => date('Y-m-d H:i:s'), 'modified_by' => Yii::app()->user->id), "user_ref_id = '{$userId}'");
            $this->render('milestone4', array(
                'studentNotEligible' => true,
                'mileStoneNumber' => $mileStoneNumber,
                'userId'=>$userId,
                'user' => $user,
                'prefCountries'=>$prefCountries,
                'prefCourses'=>$prefCourses
            ));
        }
    }
    else{
        $this->render('_milestone_message_10th', array(
            'mileStoneNumber' => $mileStoneNumber,
            'userId'=>$userId,
        ));
    }

    }
    
    public function actionMilestone5() {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";


        Yii::import('application.modules.emailsForBoughtProfiles.models.*');

        $mileStoneNumber = 5;
        $userId = empty($_GET['studentId']) ? Yii::app()->user->sub_id : $_GET['studentId'];
        $user = TblUserMaster::model()->findByPk($userId);
        if($user->present_class == 11 || $user->present_class == 12) {
        if (isset($_POST['save'])) {
            UserMilestone::confirmMilestone($userId, $mileStoneNumber, date("Y-m-d H:i:s"));
            setFlashMessage('success_notify', 'sms_milestonescontroller.ms5_saved');
            if ($userId == Yii::app()->user->sub_id) {
                $this->redirect('/app/sms/milestones/milestone6');
            } else {
                $this->redirect('/app/sms/milestones/milestone6?studentId='.$userId);
            }
        }

        $uniqueKey = Yii::app()->request->getQuery('key');
        $action = Yii::app()->request->getQuery('action');
        $response = array();
        if($uniqueKey != '' && $action != ''){
            $response = DiBuyFollowupEmailStudent::updateStudentResponse($uniqueKey, $action);
            //die(print_r($response));
            if($response['status'] == 'success'){
                if($action == 'Reject'){
                    setFlashMessage('error_notify', 'globalnotifications.removefrom_shortlist', array('UNI_NAME' => $response['uni_name']));
                }else{
                    setFlashMessage('success_notify', 'sms_milestonescontroller.di_student_email_response_update_succeed', array('USER_RESPONSE'=>$action, 'UNI_NAME' => $response['uni_name']));
                }
            }else{
                setFlashMessage('error_notify', 'sms_milestonescontroller.di_student_email_response_update_failed');
            }
        }


        $this->pageTitle = Yii::app()->name . ' - Milestone Shortlist';

        $objShortList = new ShortListEngine();
        $objShortList->studentId = $userId;
        $shortListCountByCountry = $objShortList->getShortListCountByCountry();
		
		$this->render('milestone5', array(
            'userId'=>$userId,
            'user' => $user,
            'mileStoneNumber' => $mileStoneNumber,
            'shortListCountByCountry' => $shortListCountByCountry,
            'response' => $response,
            'universityData'=>$universityData,
            'offer_uni_ids'=>$offer_uni_ids,
            'offers_det'=>$offers_det,
        ));
    }
    else{
        $this->render('_milestone_message_10th', array(
            'userId'=>$userId,
            'mileStoneNumber' => $mileStoneNumber,
        ));
    }

    }
    
    public function intentList() {
        $intentArr = array(SHORTLIST_MIGHTAPPLY => 'Might Apply', SHORTLIST_WILLAPPLY => 'Will Apply', SHORTLIST_APPLIED => 'Applied');
        return $intentArr;
    }

    public function outplacementIntentList() {
       // $intentArr = array( 'Did not Apply' => 'DIDN\'T APPLY', 'Got Offer' => 'Got Offer', 'Did not Get Offer' => 'DIDN\'T GET OFFER', 'Joining' => 'Joining');
        $intentArr = array( 'Did not Apply' => 'Didn\'t Apply', 'Got Offer' => 'Got Offer', 'Did not Get Offer' => 'Didn\'t Get Offer', 'Joining' => 'Joining');
        return $intentArr;
    }
    
    public function getBestAdmissionChance($cId, $uniId, $onlyHighChance = 1, $userId = 0) {
        if ($userId == 0) {
            $userId = Yii::app()->user->sub_id;
        }
        $preferredDeptListData = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($userId);

        if(!$preferredDeptListData) {
            return "<h3>No major chosen</h3><span>Best admission chances</span>";
        }
        
        Yii::import('application.components.admissionchances.drivers.*');

        $obj = new TestDriver();
        $obj->studentID = $userId;
        $obj->countryID = $cId;
        $obj->universityID = $uniId;
        foreach($preferredDeptListData as $data){
            $obj->departmentID = $data->main_dept_ref_id;
            if($onlyHighChance) {
                $result[$data->main_dept_ref_id] = json_decode($obj->getAdmissionChances())->score;
            } else {
                $result[] = array(
                            'score' => json_decode($obj->getAdmissionChances())->score,
                            'dept_name' => $data->mainDeptRef->department_name,
                            'dept_id' => $data->main_dept_ref_id
                        );
            }

        }
        if ($onlyHighChance) {
            $highestScore = max($result);
            return UniversityHelper::displayAdmissionChanceShortList($highestScore);
        } else {
            return $result;
        }
    }
    
    public function actionGetCollegeList() {
        $userId = empty($_GET['studentId']) ? Yii::app()->user->sub_id : $_GET['studentId'];
        $cId = Yii::app()->request->getParam('cId');

        $offers_obj = new studentOffers;
        $offers_obj->user_id = $userId;
        $offers = $offers_obj->getAllOffers(true);

        $offer_uni_ids = $offers_det = array();
        foreach ($offers as $offer) {
            $offers_det[$offer->uni_id] = $offer;
            $offer_uni_ids[$offer->uni_id] = $offer->uni_id;
        }

        $objShortList = new ShortListEngine();
        $objShortList->studentId = $userId;
        $universityData = $objShortList->getShortListByCountry($cId);

        $this->renderPartial('_collegeList', array('offer_uni_ids'=>$offer_uni_ids, 'offers_det'=>$offers_det,'universityData' => $universityData, 'cId' => $cId, 'userId'=>$userId, 'intentList' => $this->intentList()));
    }

    public function actionAddToShortListOnly() {
        $userId = empty($_GET['studentId']) ? Yii::app()->user->sub_id : $_GET['studentId'];
        $uniId = Yii::app()->request->getParam('uniId');
        $status = Yii::app()->request->getParam('status');
        $uniName = Yii::app()->request->getParam('uniName');

        $obj = new ShortListEngine();
        $obj->studentId = $userId;
        $obj->saveToShortList($uniId, $status);
    }

    public function actionAddToShortListCollege()
    {
        $userId = empty($_GET['studentId']) ? Yii::app()->user->sub_id : $_GET['studentId'];
        $uniId = Yii::app()->request->getParam('uniId');
        $idealListUniId = Yii::app()->request->getParam('idealListUniId');
        $status = Yii::app()->request->getParam('status');

        $obj = new ShortListEngine();
        $obj->studentId = $userId;
        $obj->saveToShortList($uniId, $status ? SHORTLIST_MIGHTAPPLY : SHORTLIST_REJECT);

        // Creating log
        $idealListLog = new UserIdealListUniversityLog();
        $idealListLog->user_ideal_list_university_ref_id = $idealListUniId;
        if($status) {
            $idealListLog->action_status = 'Shortlist';
        } else {
            $idealListLog->action_status = 'Reject';
        }
        $idealListLog->added_on = date('Y-m-d H:i:s');
        $idealListLog->added_by = Yii::app()->user->id;
        $idealListLog->save();
    }
    
    public function actionUniversityPopup() {
        $uniId = Yii::app()->request->getParam('uniId');
        $userId = Yii::app()->request->getParam('userId');
        if (!$userId) {
            $userId = Yii::app()->user->sub_id;
        }

        $objShortList = new ShortListEngine();
        $objShortList->studentId = $userId;
        $universityData = $objShortList->getShortListByUniId($uniId);

        $admChanceDept = $this->getBestAdmissionChance($universityData['country_ref_id'], $uniId, 0, $userId);

        $universityDateSections = UniversityDateSection::getUniversityDateIntakeNames(0, $universityData['uni_id']);

        $relatedScholarships = ScholarshipHostInstitute::getScholarshipCountByUniId($uniId, '', '', '1');
        
        $shortlistScholarshipIds = $relatedScholarshipIds = array();
        foreach($relatedScholarships as $relatedScholarship){
            $relatedScholarshipIds[] = $relatedScholarship['scholarship_ref_id'];
        }
        
        $shortListScholarships = UserScholarship::userAllScholarshipList($userId);
        foreach($shortListScholarships as $shortListScholarship) {
            $shortlistScholarshipIds[] = $shortListScholarship->scholarship_ref_id;
        }
        $noOfMatchedShortlistedScholarship = count(array_intersect($shortlistScholarshipIds, $relatedScholarshipIds));

        $this->renderPartial('_shortlist_university_popup', array('resUniversityDateSections' => $universityDateSections, 'admChanceDept' => $admChanceDept,
            'universityData' => $universityData, 'intentList' => $this->intentList(), 'noOfMatchedShortlistedScholarship' => $noOfMatchedShortlistedScholarship, 'userId'=>$userId));
    }
    
    public function actionGetDepartmentDropDown()
    {
        $userId = Yii::app()->user->sub_id;
        $preferredDeptListData = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($userId);
        $preferredDeptList = array();
        foreach($preferredDeptListData as $data){
            $preferredDeptList[$data->main_dept_ref_id] = $data->mainDeptRef->department_name;
        }

        $departmentList = LookupDepartment::getMainDepartmentList();
        $finalDeptList = array_diff($departmentList, $preferredDeptList);

        $this->renderPartial('_preferredDepartment', array('finalDeptList' => $finalDeptList));
    }
    
    public function actionSaveStudentPreferredDept()
    {
        $userId = Yii::app()->user->sub_id;
        $dId = Yii::app()->request->getParam('dId');
        $uId = Yii::app()->request->getParam('uId');
        $cId = Yii::app()->request->getParam('cId');

        Yii::import('application.components.admissionchances.drivers.*');

        $obj = new TestDriver();
        $obj->studentID = $userId;
        $obj->countryID = $cId;
        $obj->universityID = $uId;
        $obj->departmentID = $dId;

        $score = json_decode($obj->getAdmissionChances())->score;

        $averageFee = UniversityCostSummary::getAvgUniFeesByUniIdAndMainDeptId($uId, $dId)->fees_per_year;

        $data = LookupDepartment::model()->findByPk($dId);

        // Save in student preferred department list
        $studentPrefDeptObj = new StudentPreferredDepartment();
        $studentPrefDeptObj->user_ref_id = $userId;
        $studentPrefDeptObj->main_dept_ref_id = $dId;
        $studentPrefDeptObj->added_on = date('Y-m-d H:i:s');
        $studentPrefDeptObj->save();

        $this->renderPartial('_departmentChance', array('dept_name' => $data->department_name, 'score' => $score, 'averageFee' => $averageFee));

    }
    
    public function actionMilestone6() {


        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $mileStoneNumber = 6;
        $userId = empty($_GET['studentId']) ? Yii::app()->user->sub_id : $_GET['studentId'];
        $user = TblUserMaster::model()->findByPk($userId);
        if($user->present_class == 11 || $user->present_class == 12) {
        $objShortList = new ShortListEngine();
        $objShortList->studentId = $userId;

        if (isset($_POST['save'])) {
            $appliedShortList = $objShortList->getShortList(array(SHORTLIST_APPLIED)); // display only applied status college

            
            $uniIds = array_keys($appliedShortList);
            $uniId = implode(",", $uniIds);

            if(count($uniIds)) {
                StudentOutplacementUniversity::model()->updateAll(array('status' => 1), 'uni_ref_id IN ('.$uniId.') AND user_ref_id = '. $userId );
            }
            UserMilestone::confirmMilestone($userId, $mileStoneNumber, date("Y-m-d H:i:s"));
            
            setFlashMessage('success_notify', 'sms_milestonescontroller.ms6_saved');
        }


        $this->pageTitle = Yii::app()->name . ' - Milestone Outplacement';
        $joiningData = StudentOutplacementUniversity::getJoiningUniversityByUserId($userId);

        $shortListCountByCountry = $objShortList->getShortListCountByCountry(array(SHORTLIST_APPLIED)); // display only applied status college

        $this->render('milestone6', array(
            'userId'=>$userId,
            'user' => $user,
            'mileStoneNumber' => $mileStoneNumber,
            'shortListCountByCountry' => $shortListCountByCountry,
            'joiningData' => $joiningData,
        ));
    }
    else{
        $this->render('_milestone_message_10th', array(
            'userId'=>$userId,
            'mileStoneNumber' => $mileStoneNumber

        ));
    }
    }
    
    public function actionGetOutplacementCollegeList() {
        $cId = Yii::app()->request->getParam('cId');
        $userId = empty($_GET['studentId']) ? Yii::app()->user->sub_id : $_GET['studentId'];
        $objShortList = new ShortListEngine();
        $objShortList->studentId = $userId;
        $universityData = $objShortList->getShortListByCountry($cId, array(SHORTLIST_APPLIED));

        $outplacemntResults = StudentOutplacementUniversity::getOutplacementUniversityByUserId($userId);
        $outplacementData = array();
        foreach ($outplacemntResults as $value) {
            $outplacementData[$value->uni_ref_id]['uni_type'] = $value->uni_type;
            $outplacementData[$value->uni_ref_id]['sub_dept_name'] = $value->sub_dept_name;
            $outplacementData[$value->uni_ref_id]['sub_dept_ref_id'] = $value->sub_dept_ref_id;
            $outplacementData[$value->uni_ref_id]['status'] = $value->status;
        }

        $this->renderPartial('_outplacementCollegeList', array('universityData' => $universityData, 'cId' => $cId, 'intentList' => $this->outplacementIntentList(), 'outplacementData' => $outplacementData));
    }

    public function getDeptDropDown($uniId) {
        $mainDepartment = TblUniCourses::getUniverstityMainDepartmentWithCourseCount($uniId, 'ug');

        $i = 0;
        $finalArr[$i]['group'] = "";
        $finalArr[$i]['id'] = "";
        $finalArr[$i]['text'] = "Please select major of sutdy";
        $i++;
        foreach ($mainDepartment as $key => $values) {
            $subDepts = LookupDepartment::getSubDepartmentsList($values['department_id']);
            foreach ($subDepts as $subDept) {
                $finalArr[$i]['group'] = $values['department_name'];
                $finalArr[$i]['id'] = $subDept->department_id;
                $finalArr[$i]['text'] = $subDept->department_name;
                $i++;
            }
        }
        $finalArr[$i]['group'] = "Other";
        $finalArr[$i]['id'] = "other";
        $finalArr[$i]['text'] = "Other";
        
        return $deptGroupList = CHtml::listData($finalArr,'id','text','group');
    }
    
    public function actionGetOutplacementDeptDropDown()
    {
        $uniId = Yii::app()->request->getParam('uniId');
        
        $deptGroupList = $this->getDeptDropDown($uniId);
        
        echo CHtml::dropDownList('department_'.$uniId, '', $deptGroupList, array('class' => 'large', 'onchange' => 'return changeOutplacementDepartment(this.value, ' . $uniId . ');'));
        
        echo CHtml::textField('intent_text_' . $uniId, '',  array('style' => 'display: none;', 'class' => 'fixed_input', 'placeholder' => 'Enter the name of the course you choose' ));
        echo CHtml::button('Add', array('id' => 'intent_button_' . $uniId, 'style' => 'margin:10px 0 0 0; display: none;', 'class' => 'button blue small', 'onclick' => 'return changeOtherOutplacementStatus(' . $uniId . ');'));
    }
    
    public function actionAddToOutplacement() {
        $userId = empty($_GET['studentId']) ? Yii::app()->user->sub_id : $_GET['studentId'];
        
        $uniId = Yii::app()->request->getParam('uniId');
        $status = Yii::app()->request->getParam('status');
        
        $subDeptId = Yii::app()->request->getParam('subDeptId', null);
        $otherDeptName = Yii::app()->request->getParam('otherDeptName', null);

        $outpalcementObj = StudentOutplacementUniversity::model()->findByAttributes(array('uni_ref_id' => $uniId));
        
        if(!$outpalcementObj) {
            $outpalcementObj = new StudentOutplacementUniversity();
        }
        
        $outpalcementObj->user_ref_id = $userId; 
        $outpalcementObj->uni_ref_id = $uniId; 
        $outpalcementObj->uni_type = $status;
        $outpalcementObj->added_by = Yii::app()->user->id;
        $outpalcementObj->status = false;
        
        $outpalcementObj->sub_dept_ref_id = $subDeptId; 
        $outpalcementObj->sub_dept_name = $otherDeptName; 
        
        $outpalcementObj->save(false);
    }
	public function actionAskQuestion(){  
	      
		Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/themes/uni_avada/views/layouts/css/all.css");
		
		  $model = new AskQuestions();		 
		  if(!empty($_POST)){	
		     $post =  $_POST['AskQuestions'];
			
		   	 $fldImageName	= $_POST['hidImageNames'];
		     $fldImageType	= $_POST['hidImageType'];
		     $fldoriginalFileName = $_POST['originalFileName'];
			 $userID = Yii::app()->user->sub_id;
			 $studentType = TblUserMaster::getUserDetails($userID);	 
			 $prospectResult = Prospect::getProspectDetails($userID);
						   
			if(!empty($prospectResult))	{
				$fldRecipientType = 2;
				$fldRecipientId =$prospectResult->attributes['advisor_ref_id'] ;		
			}
			else if(!empty($studentType) && ($studentType->attributes['membership_ref_id'] == 3 || $studentType->attributes['membership_ref_id'] == 4)){
				$fldRecipientType = 2;
				$siAdvisorId = StudentAssignedAdvisor::getStudentAssignedAdvisor($userID);
				if($siAdvisorId)
				  $fldRecipientId   = $siAdvisorId[0]['advisor_id'];
			 }							
			 else{
                             $adminRes = TblAdmin::model()->find(array("condition"=>"admin_name = 'Unassigned'"));
                             $result = TblAdmin::getSIAdminDetailsFromUser($userID);
				//if($result > 0)                                
				  $fldRecipientId = (isset($result[0]['admin_id'])) ? $result[0]['admin_id'] : $adminRes['admin_id'];
				  $fldRecipientType = (isset($result[0]['si_ref_id'])) ? 4 : 2;
			 }
			    $param['guidemeRecipientId'] = $fldRecipientId;
				$type = 'New';
				$param['recipientType'] = $fldRecipientType;
		        $headerID    = UmailHeader::insertUmailHeader($param,$userID,$type);							  
				$UmailLimit  = 3;
				$countExists = UmailMessage::getumailCount($userID,1);	
				
				if($countExists >= $UmailLimit)							   
					 $day = 4;						  
				else							  
					 $day = 2;												 
													
				$last_date = UmailHeader::getWorkingDays2(date("Y-m-d H:i"),$day);
				$last_val = $last_date['next'];	
				$expectedDate = end($last_val);
							  
				$param['guidemesenderType'] = 1;
				$param['currentAdvisorId'] = $userID;
				$param['subject'] = $post['subject'];
				$param['message'] = $post['message'];
				$param['fldRecipientType'] = $fldRecipientType;	
				$param['expectedReplyDate'] = $expectedDate;		
							  
				$messageId  = UmailMessage::insertUmailMessage($param,$headerID,$fldRecipientId);
							
				$param['currentAdvisorId'] = $fldRecipientId;
				$param['senderId'] = $userID;
				$param['logStatus'] = 'New';
				$param['senderType'] = '1';	
										  
				UmailLog::insertUmailLog($headerID,$messageId ,$param);				
					
				if($fldImageName != "")
				{						
					$arImgName		= @array_values(array_filter(explode(",",$fldImageName)));
					$arImgType		= @array_values(array_filter(explode(",",$fldImageType)));
					$arOriginalname = @array_values(array_filter(explode(",",$fldoriginalFileName)));															
					
					if(sizeof($arImgName) > 0)
					{
						for($i=0;$i<count($arImgName);$i++)
						{
							if(strlen(trim($arImgName[$i])) > 1){
								$tFileName = explode('|', $arOriginalname[$i]);									
								$param['messageId'] = $messageId; 
								$param['fileName'] = $arImgName[$i];
								$param['originalFileName'] = $tFileName[1];
								UmailAttachment::insertGuidemeUmailAttachment($param);
							}
						}
					}					
				}				
					$emailRes = TblAdmin::getAdminDetails($fldRecipientId);

                    // Update the flag when user usk a query used in profile validation
                    LoginMaster::model()->updateByPk(Yii::app()->user->id,array("new_umail"=>'1'));

					$msg   = $this->renderPartial('umailtoadvisorTemplate',array('firstName'=>$emailRes->attributes['admin_full_name'],$studentName=>$studentType->attributes['first_name'],'subject'=>$param['subject'],'message'=>$param['message'],'siteURL'=>Yii::app()->params['cbasepath']),true);	
							
					$params = array();				
					$params['EmailMessage']['subject'] = $param['subject'];
					$params['EmailMessage']['body']    =  $msg;
					$params['EmailMessage']['type']    = 'PasswordRequest';
					$params['EmailMessage']['siteUrl'] = '';
					$params['EmailMessage']['cc']      = '';
					$params['EmailMessage']['toName']  = '';
					$params['EmailMessage']['toEmail'] =  $emailRes->loginRef['username'];
					$params['EmailMessage']['apiKey']  =  Yii::app()->params['emailCron']['curlKey'];	
													 
					$_POST = $params;									
					$status = Yii::app()->runController("sms/email/addMessage");
                    setFlashMessage('success_notify', 'sms_milestonescontroller.askquestion_added');
                    echo '<script language="javascript">parent.location.href=parent.location.href; parent.tb_remove();</script>';
          }
        $this->renderPartial("askquestion",array('model'=>$model),false,true);
    }
	public function actionUploadAttachment(){        
        $fldUserDocTName  = $_FILES['uploadfile']['tmp_name'];
		$fldUserDocName   = $_FILES['uploadfile']['name'];
		$fldUserDocType   = $_FILES['uploadfile']['type'];
		$fldExt			  = end(explode(".",$_FILES['uploadfile']['name']));
		
		$fldUserDocIDName = uniqid("U_");
		
		$fldUserDoceDesti = Yii::app()->params['docRootPath']."/uploads/umail_attahment/".$fldUserDocIDName.".".$fldExt;
		
		
		if (move_uploaded_file($fldUserDocTName, $fldUserDoceDesti)) { 
		    echo "success~".$fldUserDocIDName.".".$fldExt."~".$fldUserDocType."~".$fldUserDocName;
		} else {
			echo "error";
		}
    }	
	public function actiondeleteUploadedFile(){        
       $fldFileName	= $_POST['fileName'];
		unlink($fldUserDoceDesti = Yii::app()->params['docRootPath']."/uploads/umail_attahment/".$fldFileName);		
		echo 1;
    }

    public function actionAddTestToShortlist1(){

        $entranceId = Yii::app()->request->getParam('entranceId',null);
        $intent = Yii::app()->request->getParam('intent',null);
        $exam = EntranceExam::getTestName($entranceId);
        $flag = false;
        if ($entranceId != '') {
            $flag = true;
            $obj=new ShortListTestEngine();

            try{
                if($intent!=''){
                    $obj->saveToShortList($entranceId,constant($intent));
                }else{
                    $obj->saveToShortList($entranceId);
                }
            }catch(Exception $e){
                $flag = false;
            }

        }
        $shortListData=array();
        $obj=new ShortListTestEngine();
        $shortListData = $obj->getTestShortList();
        $shortlistCount = 0;
        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject'){
                $shortlistCount++;
            }
        }
        $val = '';
        switch ($intent) {
            case 'SHORTLIST_PLANNED':
                $val = str_replace('Planned', ' Planned', SHORTLIST_PLANNED);break;
            case 'DELETED':
                $val = SHORTLIST_COMPLETED;break;
        }
        echo json_encode(array("count" => "$shortlistCount", "flag" => "$flag","entrance_full_name"=>"$exam", 'status'=>$val));
    }


    public function displayUmailTime($dateVal) {

        $dateFormat =  date("F j, Y, g:i a",strtotime($dateVal));
        $dateFormatDisplay = explode(',',$dateFormat);

        $t1 = StrToTime ( $dateVal );
        $t2 = StrToTime ( date('Y-m-d H:i:s') );
        $diff = $t2 - $t1;

        $hours = $diff / ( 60 * 60 );

        if($hours>24) {
            $days =	(strtotime(date('F j, Y')) - strtotime(date("F j, Y",strtotime($dateVal)) )) / (60 * 60 * 24);
            $displayTime = "( ".$days." days ago"." )";
        } else if($hours>1) {
            $displayTime =  "( ".floor($hours). " hours ago"." )";
        } else {
            $displayTime = "( ".(floor($hours*60)). " minutes ago"." )";
        }
        return $displayTime;
    }
    public function actionTenthMilestone3()
    {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        $mileStoneNumber = 3 ;
        $this->render('_milestone_message_10th', array(
            'mileStoneNumber' => $mileStoneNumber,
            'userId'=>Yii::app()->user->sub_id,
        ));
    }
}