<?php

class EventController extends Controller
{  
    
    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights', // perform access control for CRUD operations
        );
    }
    
   /**
	 * Declares class-based actions.
	 */
 public function accessRules()
 {
   return array(
   array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions'=>array('create','update','getboards'),
                'users'=>array('@'),
            ),

  );
 }
 public function actionGetBoards()
  {
   $data=TblSiBoard::model()->findAll('si_ref_id=:siRefId',array(':siRefId'=>(int) $_POST['WorkshopSi']['si_ref_id']));	 
   $data=CHtml::listData($data,'board_ref_id','board_ref_id');
   echo CHtml::tag('option',array('value'=>''),'Select Board',true);
   foreach($data as $value=>$name)
   {
     $boardName=LookupBoard::model()->findbypk($name);
     echo CHtml::tag('option',
     array('value'=>$value),CHtml::encode($boardName->attributes['board_desc']),true);
    }
 }
	 
 	
 public function actionWorkshopsi()
 {
   $model  = new WorkshopSi;
   $model2 = new EventSi;
	
   $allWorkshops = WorkshopMaster::model()->findAll();
   $allSchools   = TblSiDi::model()->findAll(array('order'=>'inst_name'));
   $allBoards    = LookupBoard::model()->findAll();

    // uncomment the following code to enable ajax-based validation
    /*
    if(isset($_POST['ajax']) && $_POST['ajax']==='workshop-si-workshopsi-form')
    {
        echo CActiveForm::validate($model);
        Yii::app()->end();
    }
    */  

   if(isset($_POST['WorkshopSi'],$_POST['EventSi']))
   {		
     $model->attributes  = $_POST['WorkshopSi'];
	 $model2->attributes = $_POST['EventSi'];
		
	 $valid=$model->validate();	 
	 
	 $workshop_validate = $model->workshopValidate($model->attributes); 
    
     if($valid && $workshop_validate)
     {	
	   $model->workshop_date    = date('Y-m-d',strtotime($model->workshop_date));		
	   $model->workshop_si_name = $_POST['WorkshopSi']['workshop_si_name'];
	   $model->save();	  
	   $workshopSiId = $model->workshop_si_id;
	   $results =  LookupEvent::model()->findWorkshopEvents($model->workshop_master_ref_id);
	   if($results)
	   {
	     foreach($results as $result)
	     {	
		   $_model = New EventSi;		
           $_model->si_ref_id             = $model->si_ref_id;
           $_model->event_ref_id          = $result->event_id;
		   $_model->workshop_si_ref_Id    = $workshopSiId;
		   $_model->name                  = $result->event_name;
		   $_model->alert_duration        = $result->alert_duration;
		   $_model->type                  = $result->type;
		   $_model->graduation_year       = $model2->graduation_year;
		 
		   if($_model->type == 'pre')
	       {
		     $alertDate = strtotime ( '-'.$_model->alert_duration.'day' , strtotime($model->workshop_date)) ;		   
     	   }
		   else if($_model->type == 'post')
		   {
		     $alertDate = strtotime ( '+'.$_model->alert_duration.'day' , strtotime($model->workshop_date)) ;		   
		   }
		   $_model->alert_date = date ('Y-m-d' , $alertDate );
		  
		   $_model->save();
		  }
		  echo "<script>window.parent.location = 'workshopevents?wid=".$model->workshop_master_ref_id."&sid=".$model->si_ref_id."'</script>";
		 }
		 else
		 {
		  /** echo "<script>window.parent.location = 'workshopsi.php'</script>";**/	 
		 }
		 
        
      }
    }
    $this->renderPartial('workshopsi',array(
				'model'=>$model,
				'allWorkshops'=>$allWorkshops,
				'allSchools'=>$allSchools,
				'allBoards'=>$allBoards,
				'model2'=>$model2
				), false, true
				);
 }
 
 public function actionWorkshopEvents($wid,$sid)
 {		
   $workshopEventsResults =  WorkshopSi::model()->allWorkshopEvents($wid,$sid);   
   $this->renderPartial('siEvents',array('workshopEventsResults'=>$workshopEventsResults));	
	
 }
 public function actionAllWorkshopEvents()
 {		
   $workshopEventsResults =  WorkshopSi::model()->allWorkshopEvents();   
  
   $this->renderPartial('siEvents',array('workshopEventsResults'=>$workshopEventsResults),false);	
	
 }
 public function actionEventUpdateForm($eId)
 {	    
   $workshopSiEventsResults =  EventSi::model()->getSiWorkshopEvent($eId);	
   $this->renderPartial('eventupdate',array('workshopSiEventsResults'=>$workshopSiEventsResults));	
 }
  
 public function actionEventUpdate()
 {    
   if($_POST['Eventupdate'])
   {
	 if($_POST['Eventupdate']['alertDuration'])
	 {	
	   if($_POST['Eventupdate']['type'] == 'pre')
	    {
		   $alertDate = strtotime ( '-'.$_POST['Eventupdate']['alertDuration'].'day' , strtotime($_POST['Eventupdate']['workshopDate'])) ;		   
		}
		else if($_POST['Eventupdate']['type'] == 'post')
		{
		   $alertDate = strtotime ( '+'.$_POST['Eventupdate']['alertDuration'].'day' , strtotime($_POST['Eventupdate']['workshopDate'])) ;		   
		}
		$modifiedAlertDate = date ('Y-m-d' , $alertDate );
		 
	    EventSi::model()->updateByPk($_POST['Eventupdate']['eventId'],array('alert_duration'=> $_POST['Eventupdate']['alertDuration'],'alert_date'=>$modifiedAlertDate));
		 	 
	    echo "<script>window.parent.location = 'WorkshopEvents?wid=".$_POST['Eventupdate']['wId']."&sid=".$_POST['Eventupdate']['sId']."'</script>";	 
	  }     
	 }
	 
    } 
} 