<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'PhoneData',
    'enableAjaxValidation' => true,
    'htmlOptions' => array('class'=>'PhoneData'),
    'action' => array('myProfile/contactValidate'),
    'enableClientValidation' => false,
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => true,
        'afterValidate' => 'js:function(form, data, hasError){
                            if(!$.isEmptyObject(data)){
                                for(var i in data) {
                                    var id = i, message = data[i][0];
                                   $("#"+i+"_em_").html(message).show();
                                }
                                $("html, body").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 100 }, 1000);
                                return false;
                            }else{
                                post_contact_data();
                            }
                        }',
    ),
));
echo $form->hiddenField($model,'user_id',array('value'=>$user_id));

$contactModel = StudentContactNumber::model()->find(array("condition" => "user_ref_id = '" . $user_id . "' AND  contact_type_ref_id = 1 AND is_primary = 1"));
$model->country_code = $contactModel->country_code ? $contactModel->country_code : TblCountryMaster::model()->findByPk(Yii::app()->user->visitorCountry)->phone_code;
$model->phone = $contactModel->number ? $contactModel->number : '';
$model->city_id = $user->city_ref_id;
$model->city = $user->cityRef->city_name;
//$model->address2 = $user->address2;
?>
<div class="row multi_line small-gutter visible ContactInfo">
    <div id="no-leftd" class="row pull grid_10 aqua-light small_gutter_t multi_line small_gutter" style="margin-bottom: 20px;">
        <div class="row multi_line clearfix no-gutter"><strong> How would you like to connect with Universities? </strong></div>
        <?php if($user->is_visited_school == 'N' || empty($user->city_ref_id)) { ?>
            <div class="row multi_line no-gutter visible rwd_w relative clearfix">
            <?php
            $this->widget('zii.widgets.jui.CJuiAutoComplete', array(
                'model' =>$model,
                'attribute' => 'city',
                'source' => $this->createUrl('/student/createProfile/getPopulateAllCities'),
                'options' => array(
                    'minLength' => '2',
                    'select' => "js:function(event, ui) {
                                        $('#ProfileData_city_id').val(ui.item.id)
                                     }",
                    'change' => "js:function(event, ui) {
                                        if(ui.item == null){
                                            $('.cityName').val('');
                                            $('#ProfileData_city_id').val('')
                                         }
                                    }",
                ),
                'htmlOptions' => array(
                    'placeholder' => 'Enter your city of residence',
                    'class' => 'input grid_3 cityName'
                ),
            ));
            echo $form->error($model, 'city', array("class" => "errorMessage popup"));
            echo CHtml::hiddenField('ProfileData[city_id]', $user->city_ref_id);
            ?>
        </div>
        <?php } ?>
        <div class="left rwd_w small-right small_gutter_t relative">
            <?php
            $countryData = TblCountryMaster::getCountryCodes();
            $country_list = array();
            foreach ($countryData as $country) {
                $phone_code = $country['phone_code'];
                $country_list[$phone_code] = $country['country_name']." (+$phone_code)";
            }
            asort($country_list);

            echo $form->dropDownList($model, 'country_code',$country_list, array('empty'=>'Country Code', 'class'=>'input rwd_w','style'=>'width:238px;'));
            echo $form->error($model, 'country_code', array("class" => "errorMessage popup")); ?>
        </div>
        <div class="left small-right small_gutter_t relative">
            <?php
            echo $form->textField($model, 'phone', array('placeholder'=>"Enter mobile number", "maxlength"=>"12","class"=>"input rwd_w",'style'=>'width:260px;'));
            echo $form->error($model, 'phone', array("class" => "errorMessage popup"));
            ?>
        </div>

    </div>
    <div class="pull rwd_w  grid_0"><div  class="left rwd_w rwd_sm_rf small-right">
        <?php echo CHtml::submitButton('submit', array('value' => 'SUBMIT', 'class' => "button-blue rwd_w right button tny btn_rwd")); ?>
    </div></div>
</div>
<?php $this->endWidget(); ?>
<script>
    function post_contact_data() {
        var datastring = $("#PhoneData").serialize();
        $.ajax({
            type: "POST",
            url: "myProfile/saveContactInfo",
            data: datastring,
            dataType: "json",
            success: function(data) {
                $('.ContactInfo').hide();
                $('.main_content').html('<div class="center" style="padding-top:200px;height:620px;"><h3 class="normal">Congrats! Your profile is complete.<br /><i class="fa fa-circle-o-notch fa-2x fa-spin"></i></h3></div>');
                setTimeout(
                        function() {
                            window.location = '/app/myProfile/thankyou';
                        }, 500);
            },
            error: function(){
                alert('error handing here');
            }
        });
    }
</script>