
<section id="section1" class="section">
    <div class="div-inner-gutter-space">
        <div class="row border-bottom gutter_vertical">
            <div class="titles">
                <h2 class="center uppercase gutter_vertical">Country Specific Admission Test</h2>
                <h4 class="center normal gutter_vertical">Different countries like US, UK, Canada, India and so on have specific entrance test requirements for admission to various departments. Finalize your application by finding out which admission tests you need to prepare for</h4>
            </div>
        </div>


        <div id="div1">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'test-search',
            'method'=>'get',
            'enableAjaxValidation' => false,
            'enableClientValidation' => true,
        ));
        ?>
        <div class="row multi_line gutter-left-35 border-bottom gutter_vertical visible" >
            <div class="row visible clearfix gutter_vertical">
                <div class="grid_3 left">Country</div>
                <div class="left grid_7 relative">
                    <?php echo CHtml::dropDownList('country', '', array('0'=>'Choose a Country','12'=>'Australia','36'=>'Canada','100'=>'India','154'=>'New Zealand','190'=>'Singapore','222'=>'United Arab Emirates','223'=>'United Kingdom','224'=>'United States of America'), array('id'=>'country','class'=>'grid_7','onchange'=>'if($(this.val)!=0){$("#error-country").hide();$("#country").removeClass("error_border");}',
					'ajax' => array(
						'type'=>'POST', //request type
						'url'=>CController::createUrl('tools/getDeptList'), 
						'update'=>'#department', //selector to update
					)
					));?>
                    <div id="error-country" class="errorMessage popup" style="display: none;">
                        <div class="holder">
                            <p> Please select a country</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row visible clearfix gutter_vertical">
                <div class="grid_3 left">Department</div>
                <div class="left grid_7 relative">
                    <?php  $departmentList = LookupDepartment::getMainDepartmentList();?>
                    <?php echo CHtml::dropDownList('department','',$departmentList,array('empty'=>'Choose a Major','class'=>'grid_7','department'=>'department', 'onchange' => 'if($(this.val)!=""){$("#error-country1").hide();$("#department").removeClass("error_border");}'));?>
                    <div id="error-country1" class="errorMessage popup" style="display: none;">
                        <div class="holder">
                            <p> Please select a department</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row gutter_vertical center">
            <button class="button-green tny " id="findTest" type="button" onclick="findResults();">Find Tests</button>
            <input type="button" value="Cancel" id="cancel" class="button-blue tny" style="display: none" onclick="showresult();" >
            <div id='loadingimg' class='center row' style='display:none'>
                <img src='<?php echo Yii::app()->params['cbasepath']?>/app/themes/new_grid_theme/views/layouts/images/icons/ajax_loading_bar.gif'/>
            </div>
        </div>
    </div>
    <?php $this->endWidget(); ?>
    <div id="result"></div>
        <div id="last" class="row multi_line gutter_vertical gutter-left-35  border-top">
            <?php if($loginFlag){ ?>
                <div class="form-row" id="shortlisttest" style="display:none">
                    <h4 class="left row">We would like to recommend an ideal list of tests that would be best fit for your profile</h4>
                    <button class="button-green tny right" type="button" id="shortlist" onclick="window.location = '/app/testsforyou/mytests'">
                        View Tests</button>
                </div>
            <?php }
            if (Yii::app()->user->isGuest || Yii::app()->user->user_type_ref_id == 1 && Yii::app()->user->sub_id != ''){ ?>
                <div class="form-row" id="shortlisttest" style="display:none">
                    <h4 class="left row">We would like to recommend an ideal list of tests that would be best fit for your profile</h4>
                    <button class="button-green tny right" type="button" id="shortlist" onclick="trigger_signup();">View Tests</button>
                </div>
            <?php  } ?>
        </div>
 </div>
</section>
<script>
    function addToTestShortList(testId){
        $.ajax({
            url: '<?php echo $this->createUrl('AddTestToShortlist1'); ?>',
            type: "POST",
            dataType: "json",
            data: {"entranceId": testId,"intent":"SHORTLIST_PLANNED"},
            success: function(data){
                if(data.flag){
                    $("#tag-"+testId).html("<div class=\"tag-image addedtag missedContent\" onclick='removeFromShortList("+testId+")'>&nbsp;<div class=\"popup\" style=\"display:none;\"><div class=\"holder\"><p>Remove from Shortlist</p></div></div></div>");
                    $.notification({ class:"success_notify", notification:"addedto_shortlist", replaceKeys:{ UNI_NAME : data.entrance_full_name}});
                }else{
                    $("#tag-"+testId).html("<div class=\"tag-image addtag missedContent\" onclick='addToTestShortList("+testId+")'>&nbsp;<div class=\"popup\" style=\"display: none;\"><div class=\"holder\"><p>Add to Shortlist</p></div></div></div>");
                    $.notification({ class:"error_notify", notification:"error_addedto_shortlist", replaceKeys:{ UNI_NAME : data.entrance_full_name}});
                }
            }
        });
    }
    function removeFromShortList(testId){
        $.ajax({
            url: '<?php echo $this->createUrl("AddTestToShortlist1"); ?>',
            type: "POST",
            dataType: "json",
            data: {"entranceId": testId,"intent":"SHORTLIST_REJECT"},
            success: function(data) {
                if(data.flag){
                    $("#tag-"+testId).html("<div class=\"tag-image addtag missedContent\" onclick='addToTestShortList("+testId+")'>&nbsp;<div class=\"popup\" style=\"display: none;\"><div class=\"holder\"><p>Add to Shortlist</p></div></div></div>");

                    $.notification({ class:"error_notify", notification:"removefrom_shortlist", replaceKeys:{ UNI_NAME : data.entrance_full_name}});
                }else{
                    $("#tag-"+testId).html("<div class=\"tag-image addedtag missedContent\" onclick='removeFromShortList("+testId+")'>&nbsp;<div class=\"popup\" style=\"display: none;\"><div class=\"holder\"><p>Remove from Shortlist</p></div></div></div>");
                    $.notification({ class:"error_notify", notification:"error_removefrom_shortlist", replaceKeys:{ UNI_NAME : data.entrance_full_name}});
                }
            }
        });
    }
    $(function(){
        $(".addtag, .addedtag").live("mouseenter",function(){
            $(this).find(".popup").show();
        });
        $(".addtag, .addedtag").live("mouseleave",function(){
            $(this).find(".popup").hide();
        });
        $(".heading h2").live("mouseenter",function(){
            $(this).find(".popup").show();
        });
        $(".heading h2").live("mouseleave",function(){
            $(this).find(".popup").hide();
        });
    });
    function showresult(){
        $("#div1").hide();
        $("#modifylink").show();
    }
    function findResults(){
        var country=$("#country").val();
        var department=$("#department").val();
        $.ajax({
            type:'GET',
            url:'/app/onlineCounselling/tools/countrySpecificTestsbydept?sub_view=sub_view&countryId='+country+'&departmentId='+department+'',
            success:function(data){
                document.title = "Country Specific Test in " +$("#country option:selected").text()+ " for "+$("#department option:selected").text();
                $("#loadingimg").hide();
                $("#result").html(data);
                $("#div1").hide();
                if($("#count").text()!="0 Tests found"){
                    $("#shortlisttest").show();
                }
                if($("#count1").text()=="0 Tests"){
                    $("#shortlisttest").hide();
                }
            },
            beforeSend:function()
            {
                if($("#country").val()==0 || $("#department").val()=="")
                {
                    if($("#country").val()==0)
                    {
                        $("#error-country").show();
                        $("#country").addClass("error_border");
                    }
                    if($("#department").val()=="")
                    {
                        $("#error-country1").show();
                        $("#department").addClass("error_border");
                    }
                    return false;
                }
                else
                {
                    $("#loadingimg").show();
                }
            }
        });
    }
    function trigger_signup() {
		<?php Yii::app()->session['login_track']="Test page";?>
        setcookie();		
        window.location="/app/student/createProfile/signUp";
    }
    function setcookie() {
        //var pathname = window.location.pathname;
        var pathname = '/app/testsforyou/mytests';
        $.cookie("url", pathname, {
            expires : 1,
            path    : '/'
        });
    }
    $(".events_accordian").live("click",function(){
        //if($(this).parent().hasClass("active")) return false;
        //$(".toggle-contents").each(function(){$(this).prev().removeClass("active");$(this).hide(250);});
        $(this).parent().toggleClass("active");             
        $(this).parent().next().toggle(250);
        var divid=$(this).parent('div').attr('id');  
        if(divid=="nat")
        {
            $('#state').removeClass('active');	
            $('#inst').removeClass('active');	
            $('#stateList').hide();
            $('#instituteList').hide();
        }
        else if(divid=="state"){
            $('#nat').removeClass('active');	
            $('#inst').removeClass('active');	
            $('#nationalList').hide();
            $('#instituteList').hide();
        }
        else {
            $('#nat').removeClass('active');	
            $('#state').removeClass('active');	
            $('#nationalList').hide();
            $('#stateList').hide();
        }
    });

</script>
<script>
    $(function(){
        $('#findTest').on('click', function() {
            ga('send', 'event', 'button', 'click', 'find_Country_Specific_Tests');
        });
        $('#shortlist').on('click', function() {
			<?php Yii::app()->session['login_track']="Test page";?>			
            ga('send', 'event', 'button', 'click', 'View_Country_Specific_Tests');
        });
    });	
</script>