<?php
$userType = CommonUtils::getRbacUserRole(Yii::app()->user->id);
if(isset($_GET['bypass'])) {
    $cs = Yii::app()->clientScript;
    $cs->scriptMap['*.js'] = false;
    $cs->registerCss('milestoneSection', "
        .mheader{
            text-align:center;
        }
    ");
}else{
    $cs = Yii::app()->clientScript;
    $cs->registerScript('_milestone', "
        var milestoneStudentID = '".$uid."';
        var milestoneAdminRoleID = '".Yii::app()->session->get('admin_role_type_id', 0)."';"
        , 0);

    $cs->registerCoreScript('yiiactiveform');
    $cs->registerCoreScript('bbq');
    $cs->registerScriptFile($this->module->assetsUrl . "/js/actions.js", CClientScript::POS_END);

    $cs->registerCssFile(Yii::app()->baseUrl . "/css/token-input-facebook.css");
    $cs->registerCssFile($this->module->assetsUrl . "/css/slider.css");
    $cs->registerScriptFile(Yii::app()->baseUrl . "/js/jquery.tokeninput.js", CClientScript::POS_END);
    $cs->registerScriptFile(Yii::app()->theme->baseUrl . "/views/layouts/javascript/slides.min.jquery.js", CClientScript::POS_END);

    $cs->registerScriptFile(Yii::app()->baseUrl . '/js/fancybox/latest/jquery.mousewheel-3.0.6.pack.js', CClientScript::POS_END);
    $cs->registerScriptFile(Yii::app()->baseUrl . '/js/fancybox/latest/jquery.fancybox.pack.js', CClientScript::POS_END);
    $cs->registerCssFile(Yii::app()->baseUrl . '/js/fancybox/latest/jquery.fancybox.css');
    $cs->registerScriptFile('//maps.googleapis.com/maps/api/js?libraries=places&sensor=false', CClientScript::POS_END);
    $cs->registerScript('sliderMenu', "
        $('.sliderMP').slides({
            preload: true,
            generateNextPrev: true,
        });
    ", CClientScript::POS_END);
    $cs->registerCss('milestoneSection', "
        .milestoneSection{
           display: none;
        }
        .mheader{
            float:left;
        }
    ");
}
?>

<section id="section1" class="section responsive">
    <style>
        div.sliderMP{
            width: 407px;
        }
        div.slides_container{
            height: 35px !important;
        }
    </style>
    <div class="div-inner-gutter-space relative row ranking-page-fix">
        <div class="row multi_line no-gutter white gutter_vertical"
             style="border:none;border-bottom: 1px solid #ececec">
            <h2 class="uppercase clearfix mheader">Milestone Progress</h2>
            <div class="right actionable">
                <button type="button" onclick="goHash('countrySection');" class="button-default tny">Home</button>
                <?php if(in_array($userType, ['SI', 'Advisor'])){ ?>
                    <button type="button" onclick="goHash('umailSection');" class="button-blue tny">Umail</button>
                    <button type="button" onclick="goHash('noteSection');" class="button-green tny">Notes</button>
                <?php } ?>
                <a href="<?php echo Yii::app()->createUrl('/myProfile?uid='.$userModel->user_id); ?>" target="_profile" class="button button-default tny">Profile</a>
            </div>
        </div>
        <?php
        $studentDetail = array_filter(
            array(
            $userModel->present_class ? $userModel->present_class.'th Class' : '',
            $userModel->gender == 'M' ? 'Male' : 'Female',
            $userModel->schoolRef->school_name,
            ), 'strlen');
        ?>
        <div class="left">
            <?php echo ucwords($userModel->first_name.' '.$userModel->last_name). ' ( '.implode(', ',
                    $studentDetail).' )'; ?>
        </div>
        <?php
        $incompleteCount = count(array_filter($this->milestoneData, function($step){ return $step['milestoneid'] !=6 && $step['complete'] == '0'; }));
        ?>
        <div class="right">
            <span>Milestones <span class="color-pink"><?php echo $incompleteCount; ?> pending</span></span>
        </div>

        <?php if(!isset($_GET['bypass'])) { ?>
            <div id="loaderImage" class="center row" style="padding:100px 0;">
                <img src="<?php echo Yii::app()->theme->baseUrl . '/views/layouts/images/icons/loading.gif'; ?>" />
            </div>
        <?php } ?>

        <div class="milestoneSection" id="countrySection">
            <?php $this->renderPartial('country_preferences', compact('uid')); ?>
        </div>
        <div class="milestoneSection" id="majorSection">
            <?php $this->renderPartial('major_preferences', compact('uid')); ?>
        </div>
        <div class="milestoneSection" id="testSection">
            <?php $this->renderPartial('test_preferences', compact('uid')); ?>
        </div>
        <div class="milestoneSection" id="instituteSection">
            <?php $this->renderPartial('institute_preferences', compact('uid')); ?>
        </div>
        <div class="milestoneSection" id="collegeSection">
            <?php $this->renderPartial('college_preferences', compact('uid')); ?>
        </div>
        <div class="milestoneSection" id="admissionSection">
            <?php $this->renderPartial('admission_preferences', compact('uid')); ?>
        </div>

        <?php
        if(!isset($_GET['bypass'])){
            if(in_array($userType, ['SI', 'Advisor'])){
                ?>
                <div class="milestoneSection" id="noteSection"><?php $this->renderPartial('counsellor_notes', compact('uid')); ?></div>
                <div class="milestoneSection" id="umailSection"><?php $this->renderPartial('umail_counsellor', compact('uid'));  ?></div>
                <?php
                $userType == 'Advisor' && $this->renderPartial( 'products_floater', compact('uid'));
            }
        }

        ?>

    </div>
    <script>
    	function startTracking(milestone){
            if(milestoneAdminRoleID == '19'){
                $.post(ibase_url+'milestoneprogress/default/tracktime', {section:milestone, uid:milestoneStudentID});
            }
            milestone == 'sessionComplete' && alert('All done');
        }
	
        $(function(){
            window.goHash = function(hashTag, form){
                location.hash = hashTag ? '#!'+ hashTag : '';
                form && form.reset();
                return false;
            };
            $(window).on('hashchange', function (e) {
                $('#loaderImage').hide();
                var hash = location.hash.replace( /^#!/, '') || 'countrySection';
                startTracking(hash);
                $('#'+hash).siblings('.milestoneSection').hide().end().fadeIn();
                hash == 'countrySection' && initTokenInput();
            }).trigger('hashchange');
        });
    </script>
</section>	
	