<?php
$userID = $uid;
$milestoneData = UserMilestoneTracking::model()->find(
    sprintf("user_ref_id = %d AND milestone_ref_id=7", $userID));
$admissionColleges = StudentShortlistUniversity::model()->with('uniRef')->findAll(array(
    'condition'=>"t.user_ref_id=:userID AND t.shortlist_status IN ('Applied', 'WillApply') AND uniRef.is_active='Y'",
    'params'=>array(':userID'=>$userID),
    'order'=>'t.added_on DESC'
));
$statusOptions = array('0'=>'Choose Status','Joining'=>'Joining', 'Did not Get Offer'=>'Did not Get Offer', 'Got Offer'=>'Got Offer', 'Did not Apply'=>'Did not Apply');
?>
<div>
    <div class="row multi_line small-gutter white gutter_vertical">
        <div class="clearfix gutter_vertical">
            <div class="gutter_vertical left grid_6 small-right">
                <h4 class="left grid_3 small-right"><span class="link-button button-green small_gutter_r">6</span> Admission Status</h4>
                <?php if($milestoneData && $milestoneData->completion_date){ ?>
                    <span class="color-green"><strong>
                            Completed ( <?php echo (new DateTime($milestoneData->completion_date))->format('jS M Y'); ?> )
                        </strong></span>
                <?php }else{ ?>
                    <span class="color-gray"><strong>
                            Pending ( <?php echo $milestoneData->deadline_date ?
                                (new DateTime($milestoneData->deadline_date))->format('jS M Y') : 'N/A'; ?> )
                        </strong></span>
                <?php } ?>
            </div>
            <div class="left actionable">
                <div class="left relative small-right sliderMP" style="overflow: hidden;">
                    <div class="left small_gutter_t small-right">Tools: </div>
                    <div class="row multi_line no-clear light-gray bordered pull slides_container" style="border-radius: 50px; padding: 4px 28px !important; width: 360px;">
                        <div class="small">
                            <a target="_blank" href="/app/index.php/scholarshipprofile/scholarshipsearch/search">
                                <img src="/app/themes/new_grid_theme/views/layouts/images/scholarship-icon.png"> Scholarship Search</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="gutter-left-35">
            <div class="row multi_line no-gutter small gutter_vertical">
                <div class="grid_7 pull">Colleges</div>
                <div class="grid_2 pull">Status</div>
            </div>
            <?php
            if($admissionColleges){
                foreach($admissionColleges as $admissionCollege){

                    $uniID = $admissionCollege->uni_ref_id;
                    $uniName = $admissionCollege->uniRef->uni_name;
                    $uniLink    = $uniName;
                    //$uniLink    = $admissionCollege->uniRef->url_primary_key ?
                        //CHtml::link($uniName, Yii::app()->getbaseUrl(true).UniversityHelper::getUniversityUrl($uniID), array('target'=>'_blank')) : $uniName;

                    $model = StudentOutplacementUniversity::model()->findByAttributes(array(
                        'uni_ref_id'=>$admissionCollege->uni_ref_id,
                        'user_ref_id'=>$userID,
                        'status'=>'0'
                    ));
                    $status = $model && $model->uni_type ? $model->uni_type:'0';
                    ?>
                    <div class="row multi_line border-top admissionRow" data-college-id="<?php echo $uniID; ?>" data-college-name="<?php echo $uniName; ?>"
                         style="padding: 7px 0px !important">
                        <div class="grid_7 pull"><?php echo $uniLink; ?></div>
                        <div class="grid_2 pull">
                            <?php
                            echo CHtml::dropDownList('admission_status', $status, $statusOptions,
                                array('class'=>'left small-right admission_status'));
                            ?>
                        </div>
                        <div class="right actionable">
                            <a href="#" class="deleteAdmission"><i class="fa fa-times"></i></a>
                        </div>
                    </div>
                    <?php
                }
            }else{
                echo '<div class="center row gutter_vertical dark-pink gutter-left-35">No Colleges found.</div>';
            }
            ?>
        </div>
        <div class="center actionable">
            <button type="button" onclick="startTracking('sessionComplete');" class="button-default tny small_gutter_r">Done</button>
        </div>
    </div>
</div>